/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPaymentSentMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessPaymentSentMessage.class);

    public ProcessPaymentSentMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            String counterCurrencyExtraData;
            this.runInterceptHook();
            log.debug("current trade state " + String.valueOf((Object)this.trade.getState()));
            PaymentSentMessage message = (PaymentSentMessage)this.processModel.getTradeMessage();
            Preconditions.checkNotNull(message);
            Validator.checkTradeId(this.processModel.getOfferId(), message);
            HavenoUtils.verifyPaymentSentMessage(this.trade, message);
            this.trade.getBuyer().setNodeAddress(this.processModel.getTempTradePeerNodeAddress());
            this.trade.requestPersistence();
            if (!this.trade.isDepositsConfirmed()) {
                this.trade.syncAndPollWallet();
                if (!this.trade.isDepositsConfirmed()) {
                    throw new RuntimeException("Cannot process PaymentSentMessage until wallet sees that deposits are confirmed for " + this.trade.getClass().getSimpleName() + " " + this.trade.getId());
                }
            }
            this.trade.getBuyer().setUpdatedMultisigHex(message.getUpdatedMultisigHex());
            this.trade.getSeller().setAccountAgeWitness(message.getSellerAccountAgeWitness());
            String counterCurrencyTxId = message.getCounterCurrencyTxId();
            if (counterCurrencyTxId != null && counterCurrencyTxId.length() < 100) {
                this.trade.setCounterCurrencyTxId(counterCurrencyTxId);
            }
            if ((counterCurrencyExtraData = message.getCounterCurrencyExtraData()) != null && counterCurrencyExtraData.length() < 100) {
                this.trade.setCounterCurrencyExtraData(counterCurrencyExtraData);
            }
            if (this.trade.isSeller()) {
                this.trade.decryptPeerPaymentAccountPayload(message.getPaymentAccountKey());
            }
            this.trade.advanceState(Trade.State.BUYER_SENT_PAYMENT_SENT_MSG);
            this.trade.requestPersistence();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

