/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.Dispute;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.util.Iterator;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerPreparePaymentReceivedMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(SellerPreparePaymentReceivedMessage.class);

    public SellerPreparePaymentReceivedMessage(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            this.trade.verifyDaemonConnection();
            if (this.trade.getArbitrator().getPaymentReceivedMessage() == null) {
                Iterator<Dispute> iterator2 = this.trade.getWalletLock();
                synchronized (iterator2) {
                    Object object = HavenoUtils.getWalletFunctionLock();
                    synchronized (object) {
                        if (this.trade.getPayoutTxHex() == null) {
                            this.trade.importMultisigHex();
                        }
                        if (this.trade.getBuyer().getPaymentSentMessage().getPayoutTxHex() != null) {
                            try {
                                if (this.trade.getPayoutTxHex() == null) {
                                    log.info("Seller verifying, signing, and publishing payout tx for trade {}", (Object)this.trade.getId());
                                    this.trade.processPayoutTx(this.trade.getBuyer().getPaymentSentMessage().getPayoutTxHex(), true, true);
                                }
                                log.warn("Seller publishing previously signed payout tx for trade {}", (Object)this.trade.getId());
                                this.trade.processPayoutTx(this.trade.getPayoutTxHex(), false, true);
                            }
                            catch (IllegalArgumentException | IllegalStateException e) {
                                log.warn("Illegal state or argument verifying, signing, and publishing payout tx for {} {}. Creating new unsigned payout tx. error={}. ", this.trade.getClass().getSimpleName(), this.trade.getId(), e.getMessage(), e);
                                this.createUnsignedPayoutTx();
                            }
                            catch (Exception e) {
                                log.warn("Error verifying, signing, and publishing payout tx for trade {}: {}", this.trade.getId(), e.getMessage(), e);
                                throw e;
                            }
                        } else if (this.trade.getSelf().getUnsignedPayoutTxHex() == null) {
                            this.createUnsignedPayoutTx();
                        }
                    }
                }
            }
            if (this.trade.getArbitrator().getPaymentReceivedMessage().getSignedPayoutTxHex() != null && !this.trade.isPayoutPublished()) {
                log.info("Seller re-verifying and publishing signed payout tx for trade {}", (Object)this.trade.getId());
                this.trade.processPayoutTx(this.trade.getArbitrator().getPaymentReceivedMessage().getSignedPayoutTxHex(), false, true);
            }
            if (this.trade.isPayoutPublished() && this.trade.getDisputeState().ordinal() >= Trade.DisputeState.DISPUTE_REQUESTED.ordinal()) {
                this.trade.advanceDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
                for (Dispute dispute : this.trade.getDisputes()) {
                    dispute.setIsClosed();
                }
            }
            this.trade.requestPersistence();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    private void createUnsignedPayoutTx() {
        log.info("Seller creating unsigned payout tx for trade {}", (Object)this.trade.getId());
        MoneroTxWallet payoutTx = this.trade.createPayoutTx();
        this.trade.updatePayout(payoutTx);
        this.trade.getSelf().setUnsignedPayoutTxHex(payoutTx.getTxSet().getMultisigTxHex());
    }
}

