/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.Sig;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.network.MessageState;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.SendMailboxMessageTask;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.NodeAddress;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SellerSendPaymentReceivedMessage
extends SendMailboxMessageTask {
    private static final Logger log = LoggerFactory.getLogger(SellerSendPaymentReceivedMessage.class);
    private SignedWitness signedWitness = null;
    private ChangeListener<MessageState> listener;
    private Timer timer;
    private static final int MAX_RESEND_ATTEMPTS = 20;
    private int delayInMin = 10;
    private int resendCounter = 0;

    public SellerSendPaymentReceivedMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected abstract TradePeer getReceiver();

    @Override
    protected NodeAddress getReceiverNodeAddress() {
        return this.getReceiver().getNodeAddress();
    }

    @Override
    protected PubKeyRing getReceiverPubKeyRing() {
        return this.getReceiver().getPubKeyRing();
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.stopSending()) {
                if (!this.isCompleted()) {
                    this.complete();
                }
                return;
            }
            super.run();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    @Override
    protected TradeMailboxMessage getTradeMailboxMessage(String tradeId) {
        if (this.getReceiver().getPaymentReceivedMessage() == null) {
            AccountAgeWitnessService accountAgeWitnessService = this.processModel.getAccountAgeWitnessService();
            if (accountAgeWitnessService.isSignWitnessTrade(this.trade)) {
                try {
                    accountAgeWitnessService.traderSignAndPublishPeersAccountAgeWitness(this.trade).ifPresent(witness -> {
                        this.signedWitness = witness;
                    });
                    log.info("{} {} signed and published peers account age witness", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getId());
                }
                catch (Exception e) {
                    log.warn("Failed to sign and publish peer's account age witness for {} {}, error={}\n", this.getClass().getSimpleName(), this.trade.getId(), e.getMessage(), e);
                }
            }
            String deterministicId = HavenoUtils.getDeterministicId(this.trade, PaymentReceivedMessage.class, this.getReceiverNodeAddress());
            boolean deferPublishPayout = this.trade.isPayoutPublished() || this.trade.getState().ordinal() >= Trade.State.SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG.ordinal();
            PaymentReceivedMessage message = new PaymentReceivedMessage(tradeId, this.processModel.getMyNodeAddress(), deterministicId, this.trade.getPayoutTxHex() == null ? this.trade.getSelf().getUnsignedPayoutTxHex() : null, this.trade.getPayoutTxHex() == null ? null : this.trade.getPayoutTxHex(), this.trade.getSelf().getUpdatedMultisigHex(), deferPublishPayout, this.trade.getTradePeer().getAccountAgeWitness(), this.signedWitness, this.getReceiver() == this.trade.getArbitrator() ? this.trade.getBuyer().getPaymentSentMessage() : null);
            Preconditions.checkArgument(message.getUnsignedPayoutTxHex() != null || message.getSignedPayoutTxHex() != null, "PaymentReceivedMessage does not include payout tx hex");
            try {
                String messageAsJson = JsonUtil.objectToJson(message);
                byte[] sig = Sig.sign(this.processModel.getP2PService().getKeyRing().getSignatureKeyPair().getPrivate(), messageAsJson.getBytes(Charsets.UTF_8));
                message.setSellerSignature(sig);
                this.getReceiver().setPaymentReceivedMessage(message);
                this.trade.requestPersistence();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.getReceiver().getPaymentReceivedMessage();
    }

    @Override
    protected void setStateSent() {
        log.info("{} sent: tradeId={} at peer {} SignedWitness {}", this.getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness);
        this.getReceiver().setPaymentReceivedMessageState(MessageState.SENT);
        this.tryToSendAgainLater();
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateFault() {
        log.error("{} failed: tradeId={} at peer {} SignedWitness {}", this.getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness);
        this.getReceiver().setPaymentReceivedMessageState(MessageState.FAILED);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateStoredInMailbox() {
        log.info("{} stored in mailbox: tradeId={} at peer {} SignedWitness {}", this.getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness);
        this.getReceiver().setPaymentReceivedMessageState(MessageState.STORED_IN_MAILBOX);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateArrived() {
        log.info("{} arrived: tradeId={} at peer {} SignedWitness {}", this.getClass().getSimpleName(), this.trade.getId(), this.getReceiverNodeAddress(), this.signedWitness);
        this.getReceiver().setPaymentReceivedMessageState(MessageState.ARRIVED);
        this.processModel.getTradeManager().requestPersistence();
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.listener != null) {
            this.trade.getBuyer().getPaymentReceivedMessageStateProperty().removeListener(this.listener);
        }
    }

    private void tryToSendAgainLater() {
        if (this.stopSending()) {
            return;
        }
        if (this.resendCounter >= 20) {
            this.cleanup();
            log.warn("We never received an ACK message when sending the PaymentReceivedMessage to the peer. We stop trying to send the message.");
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = UserThread.runAfter(this::run, this.delayInMin, TimeUnit.MINUTES);
        if (this.resendCounter == 0) {
            this.listener = (observable2, oldValue, newValue) -> this.onMessageStateChange((MessageState)((Object)newValue));
            this.getReceiver().getPaymentReceivedMessageStateProperty().addListener(this.listener);
            this.onMessageStateChange((MessageState)((Object)this.getReceiver().getPaymentReceivedMessageStateProperty().get()));
        }
        if (this.resendCounter == 0) {
            int shortDelay = 2;
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)shortDelay);
            this.timer = UserThread.runAfter(this::run, shortDelay, TimeUnit.MINUTES);
        } else {
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)this.delayInMin);
            this.timer = UserThread.runAfter(this::run, this.delayInMin, TimeUnit.MINUTES);
            this.delayInMin = (int)((double)this.delayInMin * 1.5);
        }
        ++this.resendCounter;
    }

    private void onMessageStateChange(MessageState newValue) {
        if (this.isMessageReceived()) {
            this.cleanup();
        }
    }

    protected boolean isMessageReceived() {
        return this.getReceiver().isPaymentReceivedMessageReceived();
    }

    protected boolean stopSending() {
        return this.isMessageReceived() || !this.trade.isPaymentReceived();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SellerSendPaymentReceivedMessage)) {
            return false;
        }
        SellerSendPaymentReceivedMessage other = (SellerSendPaymentReceivedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.delayInMin != other.delayInMin) {
            return false;
        }
        if (this.resendCounter != other.resendCounter) {
            return false;
        }
        SignedWitness this$signedWitness = this.signedWitness;
        SignedWitness other$signedWitness = other.signedWitness;
        if (this$signedWitness == null ? other$signedWitness != null : !((Object)this$signedWitness).equals(other$signedWitness)) {
            return false;
        }
        ChangeListener<MessageState> this$listener = this.listener;
        ChangeListener<MessageState> other$listener = other.listener;
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        Timer this$timer = this.timer;
        Timer other$timer = other.timer;
        return !(this$timer == null ? other$timer != null : !this$timer.equals(other$timer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SellerSendPaymentReceivedMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.delayInMin;
        result = result * 59 + this.resendCounter;
        SignedWitness $signedWitness = this.signedWitness;
        result = result * 59 + ($signedWitness == null ? 43 : ((Object)$signedWitness).hashCode());
        ChangeListener<MessageState> $listener = this.listener;
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        Timer $timer = this.timer;
        result = result * 59 + ($timer == null ? 43 : $timer.hashCode());
        return result;
    }
}

