/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.app.Version;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDepositRequest
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(SendDepositRequest.class);

    public SendDepositRequest(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            String contractAsJson = this.trade.getContractAsJson();
            SignContractResponse response = (SignContractResponse)this.processModel.getTradeMessage();
            if (!contractAsJson.equals(response.getContractAsJson())) {
                this.trade.getContract().printDiff(response.getContractAsJson());
                this.failed("Contracts are not matching");
                return;
            }
            TradePeer peer = this.trade.getTradePeer(this.processModel.getTempTradePeerNodeAddress());
            PubKeyRing peerPubKeyRing = peer.getPubKeyRing();
            peer.setEncryptedPaymentAccountPayload(response.getEncryptedPaymentAccountPayload());
            if (peer.getEncryptedPaymentAccountPayload() == null) {
                throw new RuntimeException("Peer did not send encrypted payment account payload");
            }
            byte[] signature = response.getContractSignature();
            if (!HavenoUtils.isSignatureValid(peerPubKeyRing, contractAsJson, signature)) {
                throw new RuntimeException("Peer's contract signature is invalid");
            }
            peer.setContractSignature(signature);
            if (this.processModel.getArbitrator().getContractSignature() != null && this.processModel.getMaker().getContractSignature() != null && this.processModel.getTaker().getContractSignature() != null) {
                final DepositRequest request = new DepositRequest(this.trade.getOffer().getId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), new Date().getTime(), this.trade.getSelf().getContractSignature(), this.trade.getSelf().getDepositTx() == null ? null : this.trade.getSelf().getDepositTx().getFullHex(), this.trade.getSelf().getDepositTx() == null ? null : this.trade.getSelf().getDepositTx().getKey(), this.trade.getSelf().getPaymentAccountKey());
                this.trade.setState(Trade.State.SENT_PUBLISH_DEPOSIT_TX_REQUEST);
                this.processModel.getTradeManager().requestPersistence();
                log.info("Sending {} to arbitrator {}; offerId={}; uid={}", request.getClass().getSimpleName(), this.trade.getArbitrator().getNodeAddress(), this.trade.getId(), request.getUid());
                this.processModel.getP2PService().sendEncryptedDirectMessage(this.trade.getArbitrator().getNodeAddress(), this.trade.getArbitrator().getPubKeyRing(), request, new SendDirectMessageListener(){

                    @Override
                    public void onArrived() {
                        log.info("{} arrived: arbitrator={}; offerId={}; uid={}", request.getClass().getSimpleName(), SendDepositRequest.this.trade.getArbitrator().getNodeAddress(), SendDepositRequest.this.trade.getId(), request.getUid());
                        SendDepositRequest.this.trade.setStateIfValidTransitionTo(Trade.State.SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST);
                        SendDepositRequest.this.processModel.getTradeManager().requestPersistence();
                        SendDepositRequest.this.trade.addInitProgressStep();
                        SendDepositRequest.this.complete();
                    }

                    @Override
                    public void onFault(String errorMessage) {
                        log.error("Sending {} failed: uid={}; peer={}; error={}", request.getClass().getSimpleName(), SendDepositRequest.this.trade.getArbitrator().getNodeAddress(), SendDepositRequest.this.trade.getId(), errorMessage);
                        SendDepositRequest.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(request) + "\nerrorMessage=" + errorMessage);
                        SendDepositRequest.this.failed();
                    }
                });
            } else {
                ArrayList<String> awaitingSignaturesFrom = new ArrayList<String>();
                if (this.processModel.getArbitrator().getContractSignature() == null) {
                    awaitingSignaturesFrom.add("arbitrator");
                }
                if (this.processModel.getMaker().getContractSignature() == null) {
                    awaitingSignaturesFrom.add("maker");
                }
                if (this.processModel.getTaker().getContractSignature() == null) {
                    awaitingSignaturesFrom.add("taker");
                }
                log.info("Waiting for contract signature from {} to send deposit request", (Object)awaitingSignaturesFrom);
                this.complete();
            }
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

