/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.network.MessageState;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.SendMailboxMessageTask;
import haveno.network.p2p.NodeAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendDepositsConfirmedMessage
extends SendMailboxMessageTask {
    private static final Logger log = LoggerFactory.getLogger(SendDepositsConfirmedMessage.class);
    private Timer timer;
    private static final int MAX_RESEND_ATTEMPTS = 20;
    private int delayInMin = 10;
    private int resendCounter = 0;
    private DepositsConfirmedMessage message;

    public SendDepositsConfirmedMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.isAckedByReceiver() || this.trade.isPayoutPublished()) {
                if (!this.isCompleted()) {
                    this.complete();
                }
                return;
            }
            super.run();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    protected abstract TradePeer getReceiver();

    @Override
    protected NodeAddress getReceiverNodeAddress() {
        return this.getReceiver().getNodeAddress();
    }

    @Override
    protected PubKeyRing getReceiverPubKeyRing() {
        return this.getReceiver().getPubKeyRing();
    }

    @Override
    protected TradeMailboxMessage getTradeMailboxMessage(String tradeId) {
        if (this.message == null) {
            if (this.trade.getSelf().getUpdatedMultisigHex() == null) {
                this.trade.exportMultisigHex();
            }
            String deterministicId = HavenoUtils.getDeterministicId(this.trade, DepositsConfirmedMessage.class, this.getReceiverNodeAddress());
            this.message = new DepositsConfirmedMessage(this.trade.getOffer().getId(), this.processModel.getMyNodeAddress(), this.processModel.getPubKeyRing(), deterministicId, this.trade.getBuyer() == this.trade.getTradePeer(this.getReceiverNodeAddress()) ? this.trade.getSeller().getPaymentAccountKey() : null, this.trade.getSelf().getUpdatedMultisigHex());
        }
        return this.message;
    }

    @Override
    protected void setStateSent() {
        this.getReceiver().setDepositsConfirmedMessageState(MessageState.SENT);
        this.tryToSendAgainLater();
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateArrived() {
        this.getReceiver().setDepositsConfirmedMessageState(MessageState.ARRIVED);
    }

    @Override
    protected void setStateStoredInMailbox() {
        this.getReceiver().setDepositsConfirmedMessageState(MessageState.STORED_IN_MAILBOX);
    }

    @Override
    protected void setStateFault() {
        this.getReceiver().setDepositsConfirmedMessageState(MessageState.FAILED);
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void tryToSendAgainLater() {
        if (this.isAckedByReceiver() || this.trade.isPayoutPublished()) {
            return;
        }
        if (this.resendCounter >= 20) {
            this.cleanup();
            log.warn("We never received an ACK message when sending the DepositsConfirmedMessage to the peer. We stop trying to send the message.");
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.resendCounter == 0) {
            int shortDelay = 2;
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)shortDelay);
            this.timer = UserThread.runAfter(this::run, shortDelay, TimeUnit.MINUTES);
        } else {
            log.info("We will send the message again to the peer after a delay of {} min.", (Object)this.delayInMin);
            this.timer = UserThread.runAfter(this::run, this.delayInMin, TimeUnit.MINUTES);
            this.delayInMin = (int)((double)this.delayInMin * 1.5);
        }
        ++this.resendCounter;
    }

    private boolean isAckedByReceiver() {
        return this.getReceiver().isDepositsConfirmedMessageAcked();
    }
}

