/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendMailboxMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendMailboxMessageTask
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(SendMailboxMessageTask.class);

    public SendMailboxMessageTask(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    protected NodeAddress getReceiverNodeAddress() {
        return this.trade.getTradePeer().getNodeAddress();
    }

    protected PubKeyRing getReceiverPubKeyRing() {
        return this.trade.getTradePeer().getPubKeyRing();
    }

    protected abstract TradeMailboxMessage getTradeMailboxMessage(String var1);

    protected abstract void setStateSent();

    protected abstract void setStateArrived();

    protected abstract void setStateStoredInMailbox();

    protected abstract void setStateFault();

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            String id = this.processModel.getOfferId();
            final TradeMailboxMessage message = this.getTradeMailboxMessage(id);
            this.setStateSent();
            final NodeAddress peersNodeAddress = this.getReceiverNodeAddress();
            log.info("Send {} to peer {} for {} {}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, this.trade.getClass().getSimpleName(), this.trade.getId(), message.getUid());
            final SendMailboxMessageTask task = this;
            this.processModel.getP2PService().getMailboxMessageService().sendEncryptedMailboxMessage(peersNodeAddress, this.getReceiverPubKeyRing(), message, new SendMailboxMessageListener(){

                @Override
                public void onArrived() {
                    log.info("{} arrived at peer {}. tradeId={}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid());
                    SendMailboxMessageTask.this.setStateArrived();
                    if (!task.isCompleted()) {
                        SendMailboxMessageTask.this.complete();
                    }
                }

                @Override
                public void onStoredInMailbox() {
                    log.info("{} stored in mailbox for peer {}. tradeId={}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid());
                    SendMailboxMessageTask.this.onStoredInMailbox();
                }

                @Override
                public void onFault(String errorMessage) {
                    if (SendMailboxMessageTask.this.processModel.getP2PService().isShutDownStarted()) {
                        return;
                    }
                    log.error("{} failed: Peer {}. tradeId={}, uid={}, errorMessage={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid(), errorMessage);
                    SendMailboxMessageTask.this.onFault(errorMessage, message);
                }
            });
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }

    protected void onStoredInMailbox() {
        this.setStateStoredInMailbox();
        if (!this.isCompleted()) {
            this.complete();
        }
    }

    protected void onFault(String errorMessage, TradeMessage message) {
        this.setStateFault();
        this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(message) + "\nerrorMessage=" + errorMessage);
        this.failed(errorMessage);
    }
}

