/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.xmr.model.XmrAddressEntry;
import java.math.BigInteger;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakerReserveTradeFunds
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(TakerReserveTradeFunds.class);

    public TakerReserveTradeFunds(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (!(this.trade instanceof TakerTrade)) {
                throw new RuntimeException("Expected taker trade but was " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId() + ". That should never happen.");
            }
            MoneroTx reserveTx = null;
            if (!this.trade.isBuyerAsTakerWithoutDeposit()) {
                Object object = HavenoUtils.xmrWalletService.getWalletLock();
                synchronized (object) {
                    if (this.isTimedOut()) {
                        throw new RuntimeException("Trade protocol has timed out while getting lock to create reserve tx, tradeId=" + this.trade.getShortId());
                    }
                    this.trade.startProtocolTimeout();
                    BigInteger penaltyFee = HavenoUtils.multiply(this.trade.getAmount(), this.trade.getOffer().getPenaltyFeePct());
                    BigInteger takerFee = this.trade.getTakerFee();
                    BigInteger sendAmount = this.trade.getOffer().getDirection() == OfferDirection.BUY ? this.trade.getAmount() : BigInteger.ZERO;
                    BigInteger securityDeposit = this.trade.getSecurityDepositBeforeMiningFee();
                    String returnAddress = this.trade.getXmrWalletService().getOrCreateAddressEntry(this.trade.getOffer().getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString();
                    try {
                        Object object2 = HavenoUtils.getWalletFunctionLock();
                        synchronized (object2) {
                            for (int i = 0; i < 5; ++i) {
                                MoneroRpcConnection sourceConnection = this.trade.getXmrConnectionService().getConnection();
                                try {
                                    reserveTx = ((Trade)this.model).getXmrWalletService().createReserveTx(penaltyFee, takerFee, sendAmount, securityDeposit, returnAddress, false, null);
                                }
                                catch (IllegalStateException e) {
                                    log.warn("Illegal state creating reserve tx, offerId={}, error={}", this.trade.getShortId(), i + 1, e.getMessage());
                                    throw e;
                                }
                                catch (Exception e) {
                                    log.warn("Error creating reserve tx, tradeId={}, attempt={}/{}, error={}", this.trade.getShortId(), i + 1, 5, e.getMessage());
                                    this.trade.getXmrWalletService().handleWalletError(e, sourceConnection);
                                    if (this.isTimedOut()) {
                                        throw new RuntimeException("Trade protocol has timed out while creating reserve tx, tradeId=" + this.trade.getShortId());
                                    }
                                    if (i == 4) {
                                        throw e;
                                    }
                                    HavenoUtils.waitFor(5000L);
                                }
                                if (this.isTimedOut()) {
                                    throw new RuntimeException("Trade protocol has timed out while creating reserve tx, tradeId=" + this.trade.getShortId());
                                }
                                if (reserveTx != null) break;
                            }
                        }
                    }
                    catch (Exception e) {
                        ((Trade)this.model).getXmrWalletService().swapPayoutAddressEntryToAvailable(this.trade.getId());
                        if (reserveTx != null) {
                            ((Trade)this.model).getXmrWalletService().thawOutputs(HavenoUtils.getInputKeyImages(reserveTx));
                            this.trade.getSelf().setReserveTxKeyImages(null);
                        }
                        throw e;
                    }
                    this.trade.startProtocolTimeout();
                    this.trade.getTaker().setReserveTxHash(reserveTx.getHash());
                    this.trade.getTaker().setReserveTxHex(reserveTx.getFullHex());
                    this.trade.getTaker().setReserveTxKey(reserveTx.getKey());
                    this.trade.getTaker().setReserveTxKeyImages(HavenoUtils.getInputKeyImages((MoneroTxWallet)reserveTx));
                }
            }
            this.processModel.setReserveTx((MoneroTxWallet)reserveTx);
            this.processModel.getTradeManager().requestPersistence();
            this.trade.addInitProgressStep();
            this.complete();
        }
        catch (Throwable t2) {
            this.trade.setErrorMessage("An error occurred.\nError message:\n" + t2.getMessage());
            this.failed(t2);
        }
    }

    private boolean isTimedOut() {
        return !this.processModel.getTradeManager().hasOpenTrade(this.trade);
    }
}

