/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPeersAccountAgeWitness
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(VerifyPeersAccountAgeWitness.class);

    public VerifyPeersAccountAgeWitness(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            Offer offer = Preconditions.checkNotNull(this.trade.getOffer());
            if (CurrencyUtil.isCryptoCurrency(offer.getCurrencyCode())) {
                this.complete();
                return;
            }
            if (this.trade instanceof ArbitratorTrade) {
                this.complete();
                return;
            }
            TradePeer tradePeer = this.trade.getTradePeer();
            if (tradePeer.getPaymentAccountPayload() == null) {
                this.complete();
                return;
            }
            AccountAgeWitnessService accountAgeWitnessService = this.processModel.getAccountAgeWitnessService();
            PaymentAccountPayload peersPaymentAccountPayload = Preconditions.checkNotNull(tradePeer.getPaymentAccountPayload(), "Peers peersPaymentAccountPayload must not be null");
            PubKeyRing peersPubKeyRing = Preconditions.checkNotNull(tradePeer.getPubKeyRing(), "peersPubKeyRing must not be null");
            byte[] nonce = Preconditions.checkNotNull(tradePeer.getAccountAgeWitnessNonce());
            byte[] signature = Preconditions.checkNotNull(tradePeer.getAccountAgeWitnessSignature());
            AtomicReference errorMsg = new AtomicReference();
            boolean isValid = accountAgeWitnessService.verifyAccountAgeWitness(this.trade, peersPaymentAccountPayload, peersPubKeyRing, nonce, signature, errorMsg::set);
            if (isValid) {
                this.trade.getTradePeer().setAccountAgeWitness(this.processModel.getAccountAgeWitnessService().findWitness(this.trade.getTradePeer().getPaymentAccountPayload(), this.trade.getTradePeer().getPubKeyRing()).orElse(null));
                log.info("{} {} verified witness data of peer {}", this.trade.getClass().getSimpleName(), this.trade.getId(), tradePeer.getNodeAddress());
                this.complete();
            } else {
                this.failed((String)errorMsg.get());
            }
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

