/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks.mediation;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.MediatedPayoutTxSignatureMessage;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMediatedPayoutSignatureMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(ProcessMediatedPayoutSignatureMessage.class);

    public ProcessMediatedPayoutSignatureMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            log.debug("current trade state " + String.valueOf((Object)this.trade.getState()));
            MediatedPayoutTxSignatureMessage message = (MediatedPayoutTxSignatureMessage)this.processModel.getTradeMessage();
            Validator.checkTradeId(this.processModel.getOfferId(), message);
            Preconditions.checkNotNull(message);
            this.trade.getTradePeer().setMediatedPayoutTxSignature(Preconditions.checkNotNull(message.getTxSignature()));
            this.trade.getTradePeer().setNodeAddress(this.processModel.getTempTradePeerNodeAddress());
            this.trade.setMediationResultState(MediationResultState.RECEIVED_SIG_MSG);
            this.processModel.getTradeManager().requestPersistence();
            this.complete();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

