/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks.mediation;

import com.google.common.base.Preconditions;
import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.trade.Contract;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.MediatedPayoutTxSignatureMessage;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendMailboxMessageListener;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMediatedPayoutSignatureMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(SendMediatedPayoutSignatureMessage.class);

    public SendMediatedPayoutSignatureMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            PubKeyRing pubKeyRing = this.processModel.getPubKeyRing();
            Contract contract = Preconditions.checkNotNull(this.trade.getContract(), "contract must not be null");
            PubKeyRing peersPubKeyRing = contract.getPeersPubKeyRing(pubKeyRing);
            final NodeAddress peersNodeAddress = contract.getPeersNodeAddress(pubKeyRing);
            P2PService p2PService = this.processModel.getP2PService();
            final MediatedPayoutTxSignatureMessage message = new MediatedPayoutTxSignatureMessage(this.processModel.getMediatedPayoutTxSignature(), this.trade.getId(), p2PService.getAddress(), UUID.randomUUID().toString());
            log.info("Send {} to peer {}. offerId={}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid());
            this.trade.setMediationResultState(MediationResultState.SIG_MSG_SENT);
            this.processModel.getTradeManager().requestPersistence();
            p2PService.getMailboxMessageService().sendEncryptedMailboxMessage(peersNodeAddress, peersPubKeyRing, message, new SendMailboxMessageListener(){

                @Override
                public void onArrived() {
                    log.info("{} arrived at peer {}. offerId={}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid());
                    SendMediatedPayoutSignatureMessage.this.trade.setMediationResultState(MediationResultState.SIG_MSG_ARRIVED);
                    SendMediatedPayoutSignatureMessage.this.processModel.getTradeManager().requestPersistence();
                    SendMediatedPayoutSignatureMessage.this.complete();
                }

                @Override
                public void onStoredInMailbox() {
                    log.info("{} stored in mailbox for peer {}. offerId={}, uid={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid());
                    SendMediatedPayoutSignatureMessage.this.trade.setMediationResultState(MediationResultState.SIG_MSG_IN_MAILBOX);
                    SendMediatedPayoutSignatureMessage.this.processModel.getTradeManager().requestPersistence();
                    SendMediatedPayoutSignatureMessage.this.complete();
                }

                @Override
                public void onFault(String errorMessage) {
                    log.error("{} failed: Peer {}. offerId={}, uid={}, errorMessage={}", message.getClass().getSimpleName(), peersNodeAddress, message.getOfferId(), message.getUid(), errorMessage);
                    SendMediatedPayoutSignatureMessage.this.trade.setMediationResultState(MediationResultState.SIG_MSG_SEND_FAILED);
                    SendMediatedPayoutSignatureMessage.this.appendToErrorMessage("Sending message failed: message=" + String.valueOf(message) + "\nerrorMessage=" + errorMessage);
                    SendMediatedPayoutSignatureMessage.this.processModel.getTradeManager().requestPersistence();
                    SendMediatedPayoutSignatureMessage.this.failed(errorMessage);
                }
            });
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

