/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks.mediation;

import haveno.common.taskrunner.TaskRunner;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMailboxMessage;
import haveno.core.trade.protocol.tasks.SendMailboxMessageTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMediatedPayoutTxPublishedMessage
extends SendMailboxMessageTask {
    private static final Logger log = LoggerFactory.getLogger(SendMediatedPayoutTxPublishedMessage.class);

    public SendMediatedPayoutTxPublishedMessage(TaskRunner<Trade> taskHandler, Trade trade) {
        super(taskHandler, trade);
    }

    @Override
    protected TradeMailboxMessage getTradeMailboxMessage(String id) {
        throw new RuntimeException("SendMediatedPayoutTxPublishedMessage.getMessage(id) not implemented for xmr");
    }

    @Override
    protected void setStateSent() {
        this.trade.setMediationResultState(MediationResultState.PAYOUT_TX_PUBLISHED_MSG_SENT);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateArrived() {
        this.trade.setMediationResultState(MediationResultState.PAYOUT_TX_PUBLISHED_MSG_ARRIVED);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateStoredInMailbox() {
        this.trade.setMediationResultState(MediationResultState.PAYOUT_TX_PUBLISHED_MSG_IN_MAILBOX);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void setStateFault() {
        this.trade.setMediationResultState(MediationResultState.PAYOUT_TX_PUBLISHED_MSG_SEND_FAILED);
        this.processModel.getTradeManager().requestPersistence();
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.trade.getPayoutTx() == null) {
                log.error("PayoutTx is null");
                this.failed("PayoutTx is null");
                return;
            }
            super.run();
        }
        catch (Throwable t2) {
            this.failed(t2);
        }
    }
}

