/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import com.google.inject.Inject;
import haveno.core.trade.statistics.ReferralId;
import haveno.core.user.Preferences;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;

public class ReferralIdService {
    private final Preferences preferences;
    private Optional<String> optionalReferralId = Optional.empty();

    @Inject
    public ReferralIdService(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean verify(String referralId) {
        return Arrays.stream(ReferralId.values()).anyMatch(e -> e.name().equals(referralId));
    }

    public Optional<String> getOptionalReferralId() {
        String referralId = this.preferences.getReferralId();
        this.optionalReferralId = referralId != null && !referralId.isEmpty() && this.verify(referralId) ? Optional.of(referralId) : Optional.empty();
        return this.optionalReferralId;
    }

    public void setReferralId(@Nullable String referralId) {
        if (referralId == null || referralId.isEmpty() || this.verify(referralId)) {
            this.optionalReferralId = Optional.ofNullable(referralId);
            this.preferences.setReferralId(referralId);
        }
    }
}

