/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.crypto.Hash;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.common.util.ExtraDataMapValidator;
import haveno.common.util.JsonExclude;
import haveno.common.util.Utilities;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.util.JsonUtil;
import haveno.core.util.VolumeUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import haveno.network.p2p.storage.payload.DateSortedTruncatablePayload;
import haveno.network.p2p.storage.payload.ProcessOncePersistableNetworkPayload;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PersistableNetworkPayload;
import protobuf.TradeStatistics3;

public final class TradeStatistics3
implements ProcessOncePersistableNetworkPayload,
haveno.network.p2p.storage.payload.PersistableNetworkPayload,
CapabilityRequiringPayload,
DateSortedTruncatablePayload {
    private static final Logger log = LoggerFactory.getLogger(TradeStatistics3.class);
    @JsonExclude
    private static final transient ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final double FUZZ_AMOUNT_PCT = 0.05;
    private static final int FUZZ_DATE_HOURS = 24;
    private final String currency;
    private final long price;
    private final long amount;
    private final String paymentMethod;
    private final long date;
    @Nullable
    @JsonExclude
    private String arbitrator;
    @JsonExclude
    private final byte[] hash;
    @Nullable
    @JsonExclude
    private final Map<String, String> extraDataMap;
    @JsonExclude
    private final transient Date dateObj;
    @JsonExclude
    private transient Volume volume = null;
    @JsonExclude
    private transient LocalDateTime localDateTime;
    private transient Price priceObj;

    public static TradeStatistics3 from(Trade trade, @Nullable String referralId, boolean isTorNetworkNode, boolean isFuzzed) {
        HashMap<String, String> extraDataMap = new HashMap<String, String>();
        if (referralId != null) {
            extraDataMap.put("referralId", referralId);
        }
        NodeAddress arbitratorNodeAddress = Preconditions.checkNotNull(trade.getArbitrator().getNodeAddress(), "Arbitrator address is null", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
        String truncatedArbitratorNodeAddress = isTorNetworkNode ? arbitratorNodeAddress.getFullAddress().substring(0, 4) : arbitratorNodeAddress.getFullAddress();
        Offer offer = Preconditions.checkNotNull(trade.getOffer());
        return new TradeStatistics3(offer.getCurrencyCode(), trade.getPrice().getValue(), isFuzzed ? TradeStatistics3.fuzzTradeAmountReproducibly(trade) : trade.getAmount().longValueExact(), offer.getPaymentMethod().getId(), isFuzzed ? TradeStatistics3.fuzzTradeDateReproducibly(trade) : trade.getTakeOfferDate().getTime(), truncatedArbitratorNodeAddress, extraDataMap);
    }

    private static long fuzzTradeAmountReproducibly(Trade trade) {
        long originalTimestamp = trade.getTakeOfferDate().getTime();
        long exactAmount = trade.getAmount().longValueExact();
        Random random = new Random(originalTimestamp);
        long adjustedAmount = (long)random.nextDouble((double)exactAmount * 0.95, (double)exactAmount * 1.05);
        log.debug("trade {} fuzzed trade amount for tradeStatistics is {}", (Object)trade.getShortId(), (Object)adjustedAmount);
        return adjustedAmount;
    }

    private static long fuzzTradeDateReproducibly(Trade trade) {
        long originalTimestamp = trade.getTakeOfferDate().getTime();
        Random random = new Random(originalTimestamp);
        long adjustedTimestamp = random.nextLong(originalTimestamp - TimeUnit.HOURS.toMillis(24L), originalTimestamp);
        log.debug("trade {} fuzzed trade datestamp for tradeStatistics is {}", (Object)trade.getShortId(), (Object)new Date(adjustedTimestamp));
        return adjustedTimestamp;
    }

    public TradeStatistics3(String currency, long price, long amount, String paymentMethod, long date, String arbitrator, @Nullable Map<String, String> extraDataMap) {
        this(currency, price, amount, paymentMethod, date, arbitrator, extraDataMap, null);
    }

    public TradeStatistics3(String currency, long price, long amount, String paymentMethod, long date, String arbitrator, @Nullable byte[] hash) {
        this(currency, price, amount, paymentMethod, date, arbitrator, null, hash);
    }

    @VisibleForTesting
    public TradeStatistics3(String currency, long price, long amount, String paymentMethod, long date, @Nullable String arbitrator, @Nullable Map<String, String> extraDataMap, @Nullable byte[] hash) {
        String tempPaymentMethod;
        this.currency = currency;
        this.price = price;
        this.amount = amount;
        try {
            tempPaymentMethod = String.valueOf(PaymentMethodMapper.valueOf(paymentMethod).ordinal());
        }
        catch (Throwable t2) {
            tempPaymentMethod = paymentMethod;
        }
        this.paymentMethod = tempPaymentMethod;
        this.date = date;
        this.arbitrator = arbitrator;
        this.extraDataMap = ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap);
        this.hash = hash == null ? this.createHash() : hash;
        this.dateObj = new Date(date);
    }

    public byte[] createHash() {
        return Hash.getSha256Ripemd160hash(JsonUtil.objectToJson(this).getBytes(Charsets.UTF_8));
    }

    private TradeStatistics3.Builder getBuilder() {
        TradeStatistics3.Builder builder = protobuf.TradeStatistics3.newBuilder().setCurrency(this.currency).setPrice(this.price).setAmount(this.amount).setPaymentMethod(this.paymentMethod).setDate(this.date).setHash(ByteString.copyFrom(this.hash));
        Optional.ofNullable(this.arbitrator).ifPresent(builder::setArbitrator);
        Optional.ofNullable(this.extraDataMap).ifPresent(builder::putAllExtraData);
        return builder;
    }

    public protobuf.TradeStatistics3 toProtoTradeStatistics3() {
        return this.getBuilder().build();
    }

    @Override
    public PersistableNetworkPayload toProtoMessage() {
        return PersistableNetworkPayload.newBuilder().setTradeStatistics3(this.getBuilder()).build();
    }

    public static TradeStatistics3 fromProto(protobuf.TradeStatistics3 proto) {
        return new TradeStatistics3(proto.getCurrency(), proto.getPrice(), proto.getAmount(), proto.getPaymentMethod(), proto.getDate(), ProtoUtil.stringOrNullFromProto(proto.getArbitrator()), CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : proto.getExtraDataMap(), proto.getHash().toByteArray());
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public boolean verifyHashSize() {
        Preconditions.checkNotNull(this.hash, "hash must not be null");
        return this.hash.length == 20;
    }

    @Override
    public Capabilities getRequiredCapabilities() {
        return new Capabilities(Capability.TRADE_STATISTICS_3);
    }

    @Override
    public Date getDate() {
        return this.dateObj;
    }

    public LocalDateTime getLocalDateTime() {
        if (this.localDateTime == null) {
            this.localDateTime = this.dateObj.toInstant().atZone(ZONE_ID).toLocalDateTime();
        }
        return this.localDateTime;
    }

    public long getDateAsLong() {
        return this.date;
    }

    @Override
    public int maxItems() {
        return 3000;
    }

    public void pruneOptionalData() {
        this.arbitrator = null;
    }

    public String getPaymentMethodId() {
        try {
            return PaymentMethodMapper.values()[Integer.parseInt(this.paymentMethod)].name();
        }
        catch (Throwable ignore) {
            return this.paymentMethod;
        }
    }

    public Price getTradePrice() {
        if (this.priceObj == null) {
            this.priceObj = Price.valueOf(this.currency, this.price);
        }
        return this.priceObj;
    }

    public BigInteger getTradeAmount() {
        return BigInteger.valueOf(this.amount);
    }

    public Volume getTradeVolume() {
        Volume volume = this.volume;
        if (volume == null) {
            Price price = this.getTradePrice();
            volume = price.getMonetary() instanceof CryptoMoney ? price.getVolumeByAmount(this.getTradeAmount()) : VolumeUtil.getAdjustedVolume(price.getVolumeByAmount(this.getTradeAmount()), this.paymentMethod);
            this.volume = volume;
        }
        return volume;
    }

    public boolean isValid() {
        return this.amount > 0L && this.price > 0L && this.date > 0L && this.paymentMethod != null && !this.paymentMethod.isEmpty() && this.currency != null && !this.currency.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TradeStatistics3)) {
            return false;
        }
        TradeStatistics3 that = (TradeStatistics3)o;
        if (this.price != that.price) {
            return false;
        }
        if (this.amount != that.amount) {
            return false;
        }
        if (this.date != that.date) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.paymentMethod != null ? !this.paymentMethod.equals(that.paymentMethod) : that.paymentMethod != null) {
            return false;
        }
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        int result = this.currency != null ? this.currency.hashCode() : 0;
        result = 31 * result + (int)(this.price ^ this.price >>> 32);
        result = 31 * result + (int)(this.amount ^ this.amount >>> 32);
        result = 31 * result + (this.paymentMethod != null ? this.paymentMethod.hashCode() : 0);
        result = 31 * result + (int)(this.date ^ this.date >>> 32);
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    public String toString() {
        return "TradeStatistics3{\n     currency='" + this.currency + "',\n     price=" + this.price + ",\n     amount=" + this.amount + ",\n     paymentMethod='" + this.paymentMethod + "',\n     date=" + this.date + ",\n     arbitrator='" + this.arbitrator + "',\n     hash=" + Utilities.bytesAsHexString(this.hash) + ",\n     extraDataMap=" + String.valueOf(this.extraDataMap) + "\n}";
    }

    public String getCurrency() {
        return this.currency;
    }

    public long getPrice() {
        return this.price;
    }

    public long getAmount() {
        return this.amount;
    }

    @Nullable
    public String getArbitrator() {
        return this.arbitrator;
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    private static enum PaymentMethodMapper {
        OK_PAY,
        CASH_APP,
        VENMO,
        AUSTRALIA_PAYID,
        UPHOLD,
        MONEY_BEAM,
        POPMONEY,
        REVOLUT,
        PERFECT_MONEY,
        SEPA,
        SEPA_INSTANT,
        FASTER_PAYMENTS,
        NATIONAL_BANK,
        JAPAN_BANK,
        SAME_BANK,
        SPECIFIC_BANKS,
        SWISH,
        ALI_PAY,
        WECHAT_PAY,
        ZELLE,
        CHASE_QUICK_PAY,
        INTERAC_E_TRANSFER,
        US_POSTAL_MONEY_ORDER,
        CASH_DEPOSIT,
        MONEY_GRAM,
        WESTERN_UNION,
        HAL_CASH,
        F2F,
        BLOCK_CHAINS,
        PROMPT_PAY,
        ADVANCED_CASH,
        BLOCK_CHAINS_INSTANT,
        TRANSFERWISE,
        AMAZON_GIFT_CARD,
        PAY_BY_MAIL,
        CAPITUAL,
        PAYSERA,
        PAXUM,
        SWIFT,
        NEFT,
        RTGS,
        IMPS,
        UPI,
        PAYTM,
        CELPAY,
        NEQUI,
        BIZUM,
        PIX,
        MONESE,
        SATISPAY,
        VERSE,
        STRIKE,
        TIKKIE,
        TRANSFERWISE_USD,
        ACH_TRANSFER,
        DOMESTIC_WIRE_TRANSFER,
        PAYPAL;

    }
}

