/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.persistence.PersistenceManager;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatistics3Store;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.HistoricalDataStoreService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeStatistics3StorageService
extends HistoricalDataStoreService<TradeStatistics3Store> {
    private static final Logger log = LoggerFactory.getLogger(TradeStatistics3StorageService.class);
    private static final String FILE_NAME = "TradeStatistics3Store";

    @Inject
    public TradeStatistics3StorageService(@Named(value="storageDir") File storageDir, PersistenceManager<TradeStatistics3Store> persistenceManager) {
        super(storageDir, persistenceManager);
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    protected void initializePersistenceManager() {
        this.persistenceManager.initialize((TradeStatistics3Store)this.store, PersistenceManager.Source.NETWORK);
    }

    @Override
    public boolean canHandle(PersistableNetworkPayload payload) {
        return payload instanceof TradeStatistics3;
    }

    @Override
    protected TradeStatistics3Store createStore() {
        return new TradeStatistics3Store();
    }

    public void persistNow() {
        this.persistenceManager.persistNow(() -> {});
    }
}

