/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.statistics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.file.JsonFileManager;
import haveno.core.locale.CurrencyTuple;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.Trade;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatistics3StorageService;
import haveno.core.trade.statistics.TradeStatisticsForJson;
import haveno.core.util.JsonUtil;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeStatisticsManager {
    private static final Logger log = LoggerFactory.getLogger(TradeStatisticsManager.class);
    private final P2PService p2PService;
    private final PriceFeedService priceFeedService;
    private final TradeStatistics3StorageService tradeStatistics3StorageService;
    private final File storageDir;
    private final boolean dumpStatistics;
    private final ObservableSet<TradeStatistics3> observableTradeStatisticsSet = FXCollections.observableSet(new TradeStatistics3[0]);
    private JsonFileManager jsonFileManager;
    private static final double FUZZ_AMOUNT_PCT = 0.05;
    private static final int FUZZ_DATE_HOURS = 24;

    @Inject
    public TradeStatisticsManager(P2PService p2PService, PriceFeedService priceFeedService, TradeStatistics3StorageService tradeStatistics3StorageService, AppendOnlyDataStoreService appendOnlyDataStoreService, @Named(value="storageDir") File storageDir, @Named(value="dumpStatistics") boolean dumpStatistics) {
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.tradeStatistics3StorageService = tradeStatistics3StorageService;
        this.storageDir = storageDir;
        this.dumpStatistics = dumpStatistics;
        appendOnlyDataStoreService.addService(tradeStatistics3StorageService);
    }

    public void shutDown() {
        if (this.jsonFileManager != null) {
            this.jsonFileManager.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAllServicesInitialized() {
        this.p2PService.getP2PDataStorage().addAppendOnlyDataStoreListener(payload -> {
            if (payload instanceof TradeStatistics3) {
                TradeStatistics3 tradeStatistics = (TradeStatistics3)payload;
                if (!tradeStatistics.isValid()) {
                    return;
                }
                ObservableSet<TradeStatistics3> observableSet = this.observableTradeStatisticsSet;
                synchronized (observableSet) {
                    this.observableTradeStatisticsSet.add(tradeStatistics);
                    this.priceFeedService.applyLatestHavenoMarketPrice(this.observableTradeStatisticsSet);
                }
                this.maybeDumpStatistics();
            }
        });
        Set<TradeStatistics3> set = this.tradeStatistics3StorageService.getMapOfAllData().values().stream().filter(e -> e instanceof TradeStatistics3).map(e -> (TradeStatistics3)e).filter(TradeStatistics3::isValid).collect(Collectors.toSet());
        this.deduplicateEarlyTradeStatistics(set);
        ObservableSet<TradeStatistics3> observableSet = this.observableTradeStatisticsSet;
        synchronized (observableSet) {
            this.observableTradeStatisticsSet.addAll(set);
            this.priceFeedService.applyLatestHavenoMarketPrice(this.observableTradeStatisticsSet);
        }
        this.maybeDumpStatistics();
    }

    private void deduplicateEarlyTradeStatistics(Set<TradeStatistics3> tradeStats) {
        Set earlyTrades = tradeStats.stream().filter(e -> e.getDate().toInstant().isBefore(Instant.parse("2024-08-07T00:00:00Z"))).collect(Collectors.toSet());
        HashSet<TradeStatistics3> duplicates = new HashSet<TradeStatistics3>();
        HashSet<TradeStatistics3> deduplicates = new HashSet<TradeStatistics3>();
        for (TradeStatistics3 tradeStatistic : earlyTrades) {
            TradeStatistics3 fuzzyDuplicate = this.findFuzzyDuplicate(tradeStatistic, deduplicates);
            if (fuzzyDuplicate == null) {
                deduplicates.add(tradeStatistic);
                continue;
            }
            duplicates.add(tradeStatistic);
        }
        tradeStats.removeAll(duplicates);
    }

    private TradeStatistics3 findFuzzyDuplicate(TradeStatistics3 tradeStatistics, Set<TradeStatistics3> set) {
        return set.stream().filter(e -> this.isFuzzyDuplicate(tradeStatistics, (TradeStatistics3)e)).findFirst().orElse(null);
    }

    private boolean isFuzzyDuplicate(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        if (!tradeStatistics1.getPaymentMethodId().equals(tradeStatistics2.getPaymentMethodId())) {
            return false;
        }
        if (!tradeStatistics1.getCurrency().equals(tradeStatistics2.getCurrency())) {
            return false;
        }
        if (tradeStatistics1.getPrice() != tradeStatistics2.getPrice()) {
            return false;
        }
        return this.isFuzzyDuplicateV1(tradeStatistics1, tradeStatistics2) || this.isFuzzyDuplicateV2(tradeStatistics1, tradeStatistics2);
    }

    private boolean isFuzzyDuplicateV1(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        boolean isWithin2Minutes = Math.abs(tradeStatistics1.getDate().getTime() - tradeStatistics2.getDate().getTime()) <= TimeUnit.MINUTES.toMillis(2L);
        return isWithin2Minutes;
    }

    private boolean isFuzzyDuplicateV2(TradeStatistics3 tradeStatistics1, TradeStatistics3 tradeStatistics2) {
        boolean isWithinFuzzedHours = Math.abs(tradeStatistics1.getDate().getTime() - tradeStatistics2.getDate().getTime()) <= TimeUnit.HOURS.toMillis(24L);
        boolean isWithinFuzzedAmount = (double)Math.abs(tradeStatistics1.getAmount() - tradeStatistics2.getAmount()) <= 0.05 * (double)tradeStatistics1.getAmount();
        return isWithinFuzzedHours && isWithinFuzzedAmount;
    }

    public ObservableSet<TradeStatistics3> getObservableTradeStatisticsSet() {
        return this.observableTradeStatisticsSet;
    }

    private void maybeDumpStatistics() {
        if (!this.dumpStatistics) {
            return;
        }
        if (this.jsonFileManager == null) {
            this.jsonFileManager = new JsonFileManager(this.storageDir);
            ArrayList traditionalCurrencyList = CurrencyUtil.getAllSortedTraditionalCurrencies().stream().map(e -> new CurrencyTuple(e.getCode(), e.getName(), 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(traditionalCurrencyList), "traditional_currency_list");
            ArrayList cryptoCurrencyList = CurrencyUtil.getAllSortedCryptoCurrencies().stream().map(e -> new CurrencyTuple(e.getCode(), e.getName(), 8)).collect(Collectors.toCollection(ArrayList::new));
            cryptoCurrencyList.add(0, new CurrencyTuple(Res.getBaseCurrencyCode(), Res.getBaseCurrencyName(), 8));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(cryptoCurrencyList), "crypto_currency_list");
            Instant yearAgo = Instant.ofEpochSecond(Instant.now().getEpochSecond() - TimeUnit.DAYS.toSeconds(365L));
            Set activeCurrencies = this.observableTradeStatisticsSet.stream().filter(e -> e.getDate().toInstant().isAfter(yearAgo)).map(p -> p.getCurrency()).collect(Collectors.toSet());
            ArrayList activeTraditionalCurrencyList = traditionalCurrencyList.stream().filter(e -> activeCurrencies.contains(e.code)).map(e -> new CurrencyTuple(e.code, e.name, 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(activeTraditionalCurrencyList), "active_traditional_currency_list");
            ArrayList activeCryptoCurrencyList = cryptoCurrencyList.stream().filter(e -> activeCurrencies.contains(e.code)).map(e -> new CurrencyTuple(e.code, e.name, 8)).collect(Collectors.toCollection(ArrayList::new));
            this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(activeCryptoCurrencyList), "active_crypto_currency_list");
        }
        List<TradeStatisticsForJson> list = this.observableTradeStatisticsSet.stream().map(TradeStatisticsForJson::new).sorted((o1, o2) -> Long.compare(o2.tradeDate, o1.tradeDate)).collect(Collectors.toList());
        TradeStatisticsForJson[] array = new TradeStatisticsForJson[list.size()];
        list.toArray(array);
        this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(array), "trade_statistics");
    }

    public void maybeRepublishTradeStatistics(Set<Trade> trades, @Nullable String referralId, boolean isTorNetworkNode) {
        long ts = System.currentTimeMillis();
        Set<P2PDataStorage.ByteArray> hashes = this.tradeStatistics3StorageService.getMapOfAllData().keySet();
        trades.forEach(trade -> {
            if (!trade.shouldPublishTradeStatistics()) {
                log.debug("Trade: {} should not publish trade statistics", (Object)trade.getShortId());
                return;
            }
            TradeStatistics3 tradeStatistics3 = null;
            try {
                tradeStatistics3 = TradeStatistics3.from(trade, referralId, isTorNetworkNode, false);
            }
            catch (Exception e) {
                log.warn("Error getting trade statistic for {} {}: {}", trade.getClass().getName(), trade.getId(), e.getMessage());
                return;
            }
            TradeStatistics3 tradeStatistics3Fuzzed = null;
            try {
                tradeStatistics3Fuzzed = TradeStatistics3.from(trade, referralId, isTorNetworkNode, true);
            }
            catch (Exception e) {
                log.warn("Error getting trade statistic for {} {}: {}", trade.getClass().getName(), trade.getId(), e.getMessage());
                return;
            }
            boolean hasTradeStatistics3 = hashes.contains(new P2PDataStorage.ByteArray(tradeStatistics3.getHash()));
            boolean hasTradeStatistics3Fuzzed = hashes.contains(new P2PDataStorage.ByteArray(tradeStatistics3Fuzzed.getHash()));
            if (hasTradeStatistics3 || hasTradeStatistics3Fuzzed) {
                log.debug("Trade: {}. We have already a tradeStatistics matching the hash of tradeStatistics3.", (Object)trade.getShortId());
                return;
            }
            if (!tradeStatistics3.isValid()) {
                log.warn("Trade: {}. Trade statistics is invalid. We do not publish it.", (Object)tradeStatistics3);
                return;
            }
            log.info("Trade: {}. We republish tradeStatistics3 as we did not find it in the existing trade statistics. ", (Object)trade.getShortId());
            this.p2PService.addPersistableNetworkPayload(tradeStatistics3, true);
        });
        log.info("maybeRepublishTradeStatistics took {} ms. Number of tradeStatistics: {}. Number of own trades: {}", System.currentTimeMillis() - ts, hashes.size(), trades.size());
    }
}

