/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.user;

import com.google.protobuf.Message;
import haveno.common.proto.persistable.PersistablePayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoConfirmSettings
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(AutoConfirmSettings.class);
    private boolean enabled;
    private int requiredConfirmations;
    private long tradeLimit;
    private List<String> serviceAddresses;
    private String currencyCode;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    static Optional<AutoConfirmSettings> getDefault(List<String> serviceAddresses, String currencyCode) {
        switch (currencyCode) {
            case "XMR": {
                return Optional.of(new AutoConfirmSettings(false, 5, Coin.COIN.value, serviceAddresses, "XMR"));
            }
        }
        log.error("No AutoConfirmSettings supported yet for currency {}", (Object)currencyCode);
        return Optional.empty();
    }

    public AutoConfirmSettings(boolean enabled, int requiredConfirmations, long tradeLimit, List<String> serviceAddresses, String currencyCode) {
        this.enabled = enabled;
        this.requiredConfirmations = requiredConfirmations;
        this.tradeLimit = tradeLimit;
        this.serviceAddresses = serviceAddresses;
        this.currencyCode = currencyCode;
    }

    @Override
    public Message toProtoMessage() {
        return protobuf.AutoConfirmSettings.newBuilder().setEnabled(this.enabled).setRequiredConfirmations(this.requiredConfirmations).setTradeLimit(this.tradeLimit).addAllServiceAddresses(this.serviceAddresses).setCurrencyCode(this.currencyCode).build();
    }

    public static AutoConfirmSettings fromProto(protobuf.AutoConfirmSettings proto) {
        ArrayList<String> serviceAddresses = proto.getServiceAddressesList().isEmpty() ? new ArrayList<String>() : new ArrayList<String>(proto.getServiceAddressesList());
        return new AutoConfirmSettings(proto.getEnabled(), proto.getRequiredConfirmations(), proto.getTradeLimit(), serviceAddresses, proto.getCurrencyCode());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(Listener::onChange);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.notifyListeners();
    }

    public void setRequiredConfirmations(int requiredConfirmations) {
        this.requiredConfirmations = requiredConfirmations;
        this.notifyListeners();
    }

    public void setTradeLimit(long tradeLimit) {
        this.tradeLimit = tradeLimit;
        this.notifyListeners();
    }

    public void setServiceAddresses(List<String> serviceAddresses) {
        this.serviceAddresses = serviceAddresses;
        this.notifyListeners();
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        this.notifyListeners();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getRequiredConfirmations() {
        return this.requiredConfirmations;
    }

    public long getTradeLimit() {
        return this.tradeLimit;
    }

    public List<String> getServiceAddresses() {
        return this.serviceAddresses;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public List<Listener> getListeners() {
        return this.listeners;
    }

    public static interface Listener {
        public void onChange();
    }
}

