/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.user;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.protobuf.Message;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Utilities;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.AutoConfirmSettings;
import haveno.core.user.BlockChainExplorer;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.PreferencesPayload;
import haveno.core.xmr.XmrNodeSettings;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.nodes.XmrNodesSetupPreferences;
import haveno.core.xmr.wallet.Restrictions;
import haveno.network.p2p.network.BridgeAddressProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class Preferences
implements PersistedDataHost,
BridgeAddressProvider {
    private static final Logger log = LoggerFactory.getLogger(Preferences.class);
    private static final ArrayList<BlockChainExplorer> XMR_MAIN_NET_EXPLORERS = new ArrayList<BlockChainExplorer>(Arrays.asList(new BlockChainExplorer("xmrchain.net", "https://xmrchain.net/tx/")));
    private static final ArrayList<BlockChainExplorer> XMR_STAGE_NET_EXPLORERS = new ArrayList<BlockChainExplorer>(Arrays.asList(new BlockChainExplorer("stagenet.xmrchain.net", "https://stagenet.xmrchain.net/tx/")));
    private static final ArrayList<String> XMR_TX_PROOF_SERVICES_CLEAR_NET = new ArrayList<String>(Arrays.asList("xmrblocks.monero.emzy.de", "xmrblocks.bisq.services"));
    private static final ArrayList<String> XMR_TX_PROOF_SERVICES = new ArrayList<String>(Arrays.asList("monero3bec7m26vx6si6qo7q7imlaoz45ot5m2b5z2ppgoooo6jx2rqd.onion", "devinxmrwu4jrfq2zmq5kqjpxb44hx7i7didebkwrtvmvygj4uuop2ad.onion"));
    private static final ArrayList<String> TX_BROADCAST_SERVICES_CLEAR_NET = new ArrayList<String>(Arrays.asList("https://mempool.space/api/tx", "https://mempool.emzy.de/api/tx", "https://mempool.haveno.services/api/tx"));
    private static final ArrayList<String> TX_BROADCAST_SERVICES = new ArrayList<String>(Arrays.asList("http://mempoolhqx4isw62xs7abwphsq7ldayuidyx2v2oethdhhj6mlo2r6ad.onion/api/tx", "http://mempool4t6mypeemozyterviq3i5de4kpoua65r3qkn5i3kknu5l2cad.onion/api/tx", "http://mempoolusb2f67qi7mz2it7n5e77a6komdzx6wftobcduxszkdfun2yd.onion/api/tx"));
    public static final boolean USE_SYMMETRIC_SECURITY_DEPOSIT = true;
    public static final int CLEAR_DATA_AFTER_DAYS_INITIAL = 99999;
    public static final int CLEAR_DATA_AFTER_DAYS_DEFAULT = 60;
    private PreferencesPayload prefPayload = new PreferencesPayload();
    private boolean initialReadDone = false;
    private final BooleanProperty useAnimationsProperty = new SimpleBooleanProperty(this.prefPayload.isUseAnimations());
    private final IntegerProperty cssThemeProperty = new SimpleIntegerProperty(this.prefPayload.getCssTheme());
    private final ObservableList<TraditionalCurrency> traditionalCurrenciesAsObservable = FXCollections.observableArrayList();
    private final ObservableList<CryptoCurrency> cryptoCurrenciesAsObservable = FXCollections.observableArrayList();
    private final ObservableList<TradeCurrency> tradeCurrenciesAsObservable = FXCollections.observableArrayList();
    private final ObservableMap<String, Boolean> dontShowAgainMapAsObservable = FXCollections.observableHashMap();
    private final PersistenceManager<PreferencesPayload> persistenceManager;
    private final Config config;
    private final String xmrNodesFromOptions;
    private final XmrNodes xmrNodes;
    private final BooleanProperty useStandbyModeProperty = new SimpleBooleanProperty(this.prefPayload.isUseStandbyMode());
    private final BooleanProperty useSoundForNotificationsProperty = new SimpleBooleanProperty(this.prefPayload.isUseSoundForNotifications());

    @Inject
    public Preferences(PersistenceManager<PreferencesPayload> persistenceManager, Config config, @Named(value="xmrNodes") String xmrNodesFromOptions, XmrNodes xmrNodes) {
        this.persistenceManager = persistenceManager;
        this.config = config;
        this.xmrNodesFromOptions = xmrNodesFromOptions;
        this.xmrNodes = xmrNodes;
        this.useAnimationsProperty.addListener(ov -> {
            this.prefPayload.setUseAnimations(this.useAnimationsProperty.get());
            GlobalSettings.setUseAnimations(this.prefPayload.isUseAnimations());
            this.requestPersistence();
        });
        this.cssThemeProperty.addListener(ov -> {
            this.prefPayload.setCssTheme(this.cssThemeProperty.get());
            this.requestPersistence();
        });
        this.useStandbyModeProperty.addListener(ov -> {
            this.prefPayload.setUseStandbyMode(this.useStandbyModeProperty.get());
            this.requestPersistence();
        });
        this.useSoundForNotificationsProperty.addListener(ov -> {
            this.prefPayload.setUseSoundForNotifications(this.useSoundForNotificationsProperty.get());
            this.requestPersistence();
        });
        this.traditionalCurrenciesAsObservable.addListener(ov -> {
            this.prefPayload.getTraditionalCurrencies().clear();
            this.prefPayload.getTraditionalCurrencies().addAll(this.traditionalCurrenciesAsObservable);
            this.prefPayload.getTraditionalCurrencies().sort(TradeCurrency::compareTo);
            this.requestPersistence();
        });
        this.cryptoCurrenciesAsObservable.addListener(ov -> {
            this.prefPayload.getCryptoCurrencies().clear();
            this.prefPayload.getCryptoCurrencies().addAll(this.cryptoCurrenciesAsObservable);
            this.prefPayload.getCryptoCurrencies().sort(TradeCurrency::compareTo);
            this.requestPersistence();
        });
        this.traditionalCurrenciesAsObservable.addListener(this::updateTradeCurrencies);
        this.cryptoCurrenciesAsObservable.addListener(this::updateTradeCurrencies);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted("PreferencesPayload", persisted -> {
            this.initFromPersistedPreferences((PreferencesPayload)persisted);
            completeHandler.run();
        }, () -> {
            this.initNewPreferences();
            completeHandler.run();
        });
    }

    private void initFromPersistedPreferences(PreferencesPayload persisted) {
        this.prefPayload = persisted;
        GlobalSettings.setLocale(new Locale(this.prefPayload.getUserLanguage(), this.prefPayload.getUserCountry().code));
        GlobalSettings.setUseAnimations(this.prefPayload.isUseAnimations());
        TradeCurrency preferredTradeCurrency = Preconditions.checkNotNull(this.prefPayload.getPreferredTradeCurrency(), "preferredTradeCurrency must not be null");
        this.setPreferredTradeCurrency(preferredTradeCurrency);
        this.setTraditionalCurrencies(this.prefPayload.getTraditionalCurrencies());
        this.setCryptoCurrencies(this.prefPayload.getCryptoCurrencies());
        GlobalSettings.setDefaultTradeCurrency(preferredTradeCurrency);
        if (this.prefPayload.getBsqAverageTrimThreshold() == 0.0) {
            this.prefPayload.setBsqAverageTrimThreshold(0.05);
        }
        this.setupPreferences();
    }

    private void initNewPreferences() {
        this.prefPayload = new PreferencesPayload();
        this.prefPayload.setUserLanguage(GlobalSettings.getLocale().getLanguage());
        this.prefPayload.setUserCountry(CountryUtil.getDefaultCountry());
        GlobalSettings.setLocale(new Locale(this.prefPayload.getUserLanguage(), this.prefPayload.getUserCountry().code));
        TraditionalCurrency preferredTradeCurrency = CurrencyUtil.getCurrencyByCountryCode("US");
        try {
            preferredTradeCurrency = CurrencyUtil.getCurrencyByCountryCode(this.prefPayload.getUserCountry().code);
        }
        catch (IllegalArgumentException ia) {
            log.warn("Could not determine currency for country {} [{}]", (Object)this.prefPayload.getUserCountry().code, (Object)ia.toString());
        }
        this.prefPayload.setPreferredTradeCurrency(preferredTradeCurrency);
        this.setTraditionalCurrencies(CurrencyUtil.getMainFiatCurrencies());
        this.setCryptoCurrencies(CurrencyUtil.getMainCryptoCurrencies());
        BaseCurrencyNetwork baseCurrencyNetwork = Config.baseCurrencyNetwork();
        if (!"XMR".equals(baseCurrencyNetwork.getCurrencyCode())) {
            throw new RuntimeException("BaseCurrencyNetwork not defined. BaseCurrencyNetwork=" + String.valueOf((Object)baseCurrencyNetwork));
        }
        this.setBlockChainExplorerMainNet(XMR_MAIN_NET_EXPLORERS.get(0));
        this.setBlockChainExplorerStageNet(XMR_STAGE_NET_EXPLORERS.get(0));
        this.prefPayload.setDirectoryChooserPath(Utilities.getSystemHomeDirectory());
        this.prefPayload.setOfferBookChartScreenCurrencyCode(preferredTradeCurrency.getCode());
        this.prefPayload.setTradeChartsScreenCurrencyCode(preferredTradeCurrency.getCode());
        this.prefPayload.setBuyScreenCurrencyCode(preferredTradeCurrency.getCode());
        this.prefPayload.setSellScreenCurrencyCode(preferredTradeCurrency.getCode());
        GlobalSettings.setDefaultTradeCurrency(preferredTradeCurrency);
        this.setupPreferences();
    }

    private void setupPreferences() {
        boolean isFixedConnection;
        this.persistenceManager.initialize(this.prefPayload, PersistenceManager.Source.PRIVATE);
        DontShowAgainLookup.setPreferences(this);
        this.useAnimationsProperty.set(this.prefPayload.isUseAnimations());
        this.useStandbyModeProperty.set(this.prefPayload.isUseStandbyMode());
        this.useSoundForNotificationsProperty.set(this.prefPayload.isUseSoundForNotifications());
        this.cssThemeProperty.set(this.prefPayload.getCssTheme());
        ArrayList<BlockChainExplorer> xmrExplorers = this.getBlockChainExplorers();
        if (this.getBlockChainExplorer() == null || this.getBlockChainExplorer().name.length() == 0) {
            this.setBlockChainExplorer(xmrExplorers.get(0));
        }
        this.tradeCurrenciesAsObservable.addAll((Collection<TradeCurrency>)this.prefPayload.getTraditionalCurrencies());
        this.tradeCurrenciesAsObservable.addAll((Collection<TradeCurrency>)this.prefPayload.getCryptoCurrencies());
        this.dontShowAgainMapAsObservable.putAll(this.getDontShowAgainMap());
        if (this.config.useTorForXmrOptionSetExplicitly) {
            this.setUseTorForXmr(this.config.useTorForXmr);
        }
        boolean bl = isFixedConnection = !"".equals(this.config.xmrNode) && (!HavenoUtils.isLocalHost(this.config.xmrNode) || !this.config.ignoreLocalXmrNode);
        if (!isFixedConnection && this.getMoneroNodesOptionOrdinal() == XmrNodes.MoneroNodesOption.PROVIDED.ordinal() && this.xmrNodes.selectPreferredNodes(new XmrNodesSetupPreferences(this)).isEmpty()) {
            log.warn("No provided nodes available, switching to public nodes");
            this.setMoneroNodesOptionOrdinal(XmrNodes.MoneroNodesOption.PUBLIC.ordinal());
        }
        if (this.xmrNodesFromOptions != null && !this.xmrNodesFromOptions.isEmpty()) {
            if (this.getMoneroNodes() != null && !this.getMoneroNodes().equals(this.xmrNodesFromOptions)) {
                log.warn("The Monero node(s) from the program argument and the one(s) persisted in the UI are different. The Monero node(s) {} from the program argument will be used.", (Object)this.xmrNodesFromOptions);
            }
            this.setMoneroNodes(this.xmrNodesFromOptions);
            this.setMoneroNodesOptionOrdinal(XmrNodes.MoneroNodesOption.CUSTOM.ordinal());
        }
        if ((long)this.prefPayload.getIgnoreDustThreshold() < Restrictions.getMinNonDustOutput().value) {
            this.setIgnoreDustThreshold(600);
        }
        if (this.prefPayload.getPhoneKeyAndToken() == null) {
            this.setUseSoundForMobileNotifications(true);
            this.setUseTradeNotifications(true);
            this.setUseMarketNotifications(true);
            this.setUsePriceNotifications(true);
        }
        if (this.prefPayload.getAutoConfirmSettingsList().isEmpty()) {
            List<String> defaultXmrTxProofServices = this.getDefaultXmrTxProofServices();
            AutoConfirmSettings.getDefault(defaultXmrTxProofServices, "XMR").ifPresent(xmrAutoConfirmSettings -> this.getAutoConfirmSettingsList().add((AutoConfirmSettings)xmrAutoConfirmSettings));
        }
        if (!this.prefPayload.isUseSoundForNotificationsInitialized()) {
            this.prefPayload.setUseSoundForNotificationsInitialized(true);
            this.setUseSoundForNotifications(true);
        }
        this.initialReadDone = true;
        this.requestPersistence();
    }

    public XmrNodes.MoneroNodesOption getMoneroNodesOption() {
        return XmrNodes.MoneroNodesOption.values()[this.getMoneroNodesOptionOrdinal()];
    }

    public void dontShowAgain(String key, boolean dontShowAgain) {
        this.prefPayload.getDontShowAgainMap().put(key, dontShowAgain);
        this.requestPersistence();
        this.dontShowAgainMapAsObservable.put(key, dontShowAgain);
    }

    public void resetDontShowAgain() {
        this.prefPayload.getDontShowAgainMap().clear();
        this.dontShowAgainMapAsObservable.clear();
        this.requestPersistence();
    }

    public void setUseAnimations(boolean useAnimations) {
        this.useAnimationsProperty.set(useAnimations);
    }

    public void setCssTheme(boolean useDarkMode) {
        this.cssThemeProperty.set(useDarkMode ? 1 : 0);
    }

    public void addTraditionalCurrency(TraditionalCurrency tradeCurrency) {
        if (!this.traditionalCurrenciesAsObservable.contains(tradeCurrency)) {
            this.traditionalCurrenciesAsObservable.add(tradeCurrency);
        }
    }

    public void removeTraditionalCurrency(TraditionalCurrency tradeCurrency) {
        if (this.tradeCurrenciesAsObservable.size() > 1) {
            this.traditionalCurrenciesAsObservable.remove(tradeCurrency);
            if (this.prefPayload.getPreferredTradeCurrency() != null && this.prefPayload.getPreferredTradeCurrency().equals(tradeCurrency)) {
                this.setPreferredTradeCurrency((TradeCurrency)this.tradeCurrenciesAsObservable.get(0));
            }
        } else {
            log.error("you cannot remove the last currency");
        }
    }

    public void addCryptoCurrency(CryptoCurrency tradeCurrency) {
        if (!this.cryptoCurrenciesAsObservable.contains(tradeCurrency)) {
            this.cryptoCurrenciesAsObservable.add(tradeCurrency);
        }
    }

    public void removeCryptoCurrency(CryptoCurrency tradeCurrency) {
        if (this.tradeCurrenciesAsObservable.size() > 1) {
            this.cryptoCurrenciesAsObservable.remove(tradeCurrency);
            if (this.prefPayload.getPreferredTradeCurrency() != null && this.prefPayload.getPreferredTradeCurrency().equals(tradeCurrency)) {
                this.setPreferredTradeCurrency((TradeCurrency)this.tradeCurrenciesAsObservable.get(0));
            }
        } else {
            log.error("you cannot remove the last currency");
        }
    }

    public void setBlockChainExplorer(BlockChainExplorer blockChainExplorer) {
        if (Config.baseCurrencyNetwork().isMainnet()) {
            this.setBlockChainExplorerMainNet(blockChainExplorer);
        } else {
            this.setBlockChainExplorerStageNet(blockChainExplorer);
        }
    }

    public void setTacAccepted(boolean tacAccepted) {
        this.prefPayload.setTacAccepted(tacAccepted);
        this.requestPersistence();
    }

    public void setTacAcceptedV120(boolean tacAccepted) {
        this.prefPayload.setTacAcceptedV120(tacAccepted);
        this.requestPersistence();
    }

    public void setBsqAverageTrimThreshold(double bsqAverageTrimThreshold) {
        this.prefPayload.setBsqAverageTrimThreshold(bsqAverageTrimThreshold);
        this.requestPersistence();
    }

    public Optional<AutoConfirmSettings> findAutoConfirmSettings(String currencyCode) {
        return this.prefPayload.getAutoConfirmSettingsList().stream().filter(e -> e.getCurrencyCode().equals(currencyCode)).findAny();
    }

    public void setAutoConfServiceAddresses(String currencyCode, List<String> serviceAddresses) {
        this.findAutoConfirmSettings(currencyCode).ifPresent(e -> {
            e.setServiceAddresses(serviceAddresses);
            this.requestPersistence();
        });
    }

    public void setAutoConfEnabled(String currencyCode, boolean enabled) {
        this.findAutoConfirmSettings(currencyCode).ifPresent(e -> {
            e.setEnabled(enabled);
            this.requestPersistence();
        });
    }

    public void setAutoConfRequiredConfirmations(String currencyCode, int requiredConfirmations) {
        this.findAutoConfirmSettings(currencyCode).ifPresent(e -> {
            e.setRequiredConfirmations(requiredConfirmations);
            this.requestPersistence();
        });
    }

    public void setAutoConfTradeLimit(String currencyCode, long tradeLimit) {
        this.findAutoConfirmSettings(currencyCode).ifPresent(e -> {
            e.setTradeLimit(tradeLimit);
            this.requestPersistence();
        });
    }

    public void setHideNonAccountPaymentMethods(boolean hideNonAccountPaymentMethods) {
        this.prefPayload.setHideNonAccountPaymentMethods(hideNonAccountPaymentMethods);
        this.requestPersistence();
    }

    private void requestPersistence() {
        if (this.initialReadDone) {
            this.persistenceManager.requestPersistence();
        }
    }

    public void setUserLanguage(@NotNull String userLanguageCode) {
        this.prefPayload.setUserLanguage(userLanguageCode);
        if (this.prefPayload.getUserCountry() != null && this.prefPayload.getUserLanguage() != null) {
            GlobalSettings.setLocale(new Locale(this.prefPayload.getUserLanguage(), this.prefPayload.getUserCountry().code));
        }
        this.requestPersistence();
    }

    public void setUserCountry(@NotNull Country userCountry) {
        this.prefPayload.setUserCountry(userCountry);
        if (this.prefPayload.getUserLanguage() != null) {
            GlobalSettings.setLocale(new Locale(this.prefPayload.getUserLanguage(), userCountry.code));
        }
        this.requestPersistence();
    }

    public void setPreferredTradeCurrency(TradeCurrency preferredTradeCurrency) {
        if (preferredTradeCurrency != null) {
            this.prefPayload.setPreferredTradeCurrency(preferredTradeCurrency);
            GlobalSettings.setDefaultTradeCurrency(preferredTradeCurrency);
            this.requestPersistence();
        }
    }

    public void setUseTorForXmr(Config.UseTorForXmr useTorForXmr) {
        switch (useTorForXmr) {
            case AFTER_SYNC: {
                this.setUseTorForXmrOrdinal(UseTorForXmr.AFTER_SYNC.ordinal());
                break;
            }
            case OFF: {
                this.setUseTorForXmrOrdinal(UseTorForXmr.OFF.ordinal());
                break;
            }
            case ON: {
                this.setUseTorForXmrOrdinal(UseTorForXmr.ON.ordinal());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected case: " + String.valueOf((Object)useTorForXmr));
            }
        }
    }

    public void setSplitOfferOutput(boolean splitOfferOutput) {
        this.prefPayload.setSplitOfferOutput(splitOfferOutput);
        this.requestPersistence();
    }

    public void setShowOwnOffersInOfferBook(boolean showOwnOffersInOfferBook) {
        this.prefPayload.setShowOwnOffersInOfferBook(showOwnOffersInOfferBook);
        this.requestPersistence();
    }

    public void setMaxPriceDistanceInPercent(double maxPriceDistanceInPercent) {
        this.prefPayload.setMaxPriceDistanceInPercent(maxPriceDistanceInPercent);
        this.requestPersistence();
    }

    public void setBackupDirectory(String backupDirectory) {
        this.prefPayload.setBackupDirectory(backupDirectory);
        this.requestPersistence();
    }

    public void setAutoSelectArbitrators(boolean autoSelectArbitrators) {
        this.prefPayload.setAutoSelectArbitrators(autoSelectArbitrators);
        this.requestPersistence();
    }

    public void setUsePercentageBasedPrice(boolean usePercentageBasedPrice) {
        this.prefPayload.setUsePercentageBasedPrice(usePercentageBasedPrice);
        this.requestPersistence();
    }

    public void setTagForPeer(String fullAddress, String tag) {
        this.prefPayload.getPeerTagMap().put(fullAddress, tag);
        this.requestPersistence();
    }

    public void setOfferBookChartScreenCurrencyCode(String offerBookChartScreenCurrencyCode) {
        this.prefPayload.setOfferBookChartScreenCurrencyCode(offerBookChartScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setBuyScreenCurrencyCode(String buyScreenCurrencyCode) {
        this.prefPayload.setBuyScreenCurrencyCode(buyScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setSellScreenCurrencyCode(String sellScreenCurrencyCode) {
        this.prefPayload.setSellScreenCurrencyCode(sellScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setBuyScreenCryptoCurrencyCode(String buyScreenCurrencyCode) {
        this.prefPayload.setBuyScreenCryptoCurrencyCode(buyScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setSellScreenCryptoCurrencyCode(String sellScreenCurrencyCode) {
        this.prefPayload.setSellScreenCryptoCurrencyCode(sellScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setBuyScreenOtherCurrencyCode(String buyScreenCurrencyCode) {
        this.prefPayload.setBuyScreenOtherCurrencyCode(buyScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setSellScreenOtherCurrencyCode(String sellScreenCurrencyCode) {
        this.prefPayload.setSellScreenOtherCurrencyCode(sellScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setIgnoreTradersList(List<String> ignoreTradersList) {
        this.prefPayload.setIgnoreTradersList(ignoreTradersList);
        this.requestPersistence();
    }

    public void setDirectoryChooserPath(String directoryChooserPath) {
        this.prefPayload.setDirectoryChooserPath(directoryChooserPath);
        this.requestPersistence();
    }

    public void setTradeChartsScreenCurrencyCode(String tradeChartsScreenCurrencyCode) {
        this.prefPayload.setTradeChartsScreenCurrencyCode(tradeChartsScreenCurrencyCode);
        this.requestPersistence();
    }

    public void setTradeStatisticsTickUnitIndex(int tradeStatisticsTickUnitIndex) {
        this.prefPayload.setTradeStatisticsTickUnitIndex(tradeStatisticsTickUnitIndex);
        this.requestPersistence();
    }

    public void setSortMarketCurrenciesNumerically(boolean sortMarketCurrenciesNumerically) {
        this.prefPayload.setSortMarketCurrenciesNumerically(sortMarketCurrenciesNumerically);
        this.requestPersistence();
    }

    public void setMoneroNodes(String moneroNodes) {
        this.prefPayload.setMoneroNodes(moneroNodes);
        this.requestPersistence();
    }

    public void setUseCustomWithdrawalTxFee(boolean useCustomWithdrawalTxFee) {
        this.prefPayload.setUseCustomWithdrawalTxFee(useCustomWithdrawalTxFee);
        this.requestPersistence();
    }

    public void setWithdrawalTxFeeInVbytes(long withdrawalTxFeeInVbytes) {
        this.prefPayload.setWithdrawalTxFeeInVbytes(withdrawalTxFeeInVbytes);
        this.requestPersistence();
    }

    public void setSecurityDepositAsPercent(double securityDepositAsPercent, PaymentAccount paymentAccount) {
        double max = Restrictions.getMaxSecurityDepositAsPercent();
        double min2 = Restrictions.getMinSecurityDepositAsPercent();
        if (PaymentAccountUtil.isCryptoCurrencyAccount(paymentAccount)) {
            this.prefPayload.setSecurityDepositAsPercentForCrypto(Math.min(max, Math.max(min2, securityDepositAsPercent)));
        } else {
            this.prefPayload.setSecurityDepositAsPercent(Math.min(max, Math.max(min2, securityDepositAsPercent)));
        }
        this.requestPersistence();
    }

    public void setSelectedPaymentAccountForCreateOffer(@Nullable PaymentAccount paymentAccount) {
        this.prefPayload.setSelectedPaymentAccountForCreateOffer(paymentAccount);
        this.requestPersistence();
    }

    public void setTraditionalCurrencies(List<TraditionalCurrency> currencies) {
        this.traditionalCurrenciesAsObservable.setAll(currencies.stream().map(traditionalCurrency -> new TraditionalCurrency((TraditionalCurrency)traditionalCurrency)).distinct().collect(Collectors.toList()));
        this.requestPersistence();
    }

    private void setCryptoCurrencies(List<CryptoCurrency> currencies) {
        this.cryptoCurrenciesAsObservable.setAll(currencies.stream().distinct().collect(Collectors.toList()));
        this.requestPersistence();
    }

    private void setBlockChainExplorerStageNet(BlockChainExplorer blockChainExplorerTestNet) {
        this.prefPayload.setBlockChainExplorerTestNet(blockChainExplorerTestNet);
        this.requestPersistence();
    }

    private void setBlockChainExplorerMainNet(BlockChainExplorer blockChainExplorerMainNet) {
        this.prefPayload.setBlockChainExplorerMainNet(blockChainExplorerMainNet);
        this.requestPersistence();
    }

    public void setResyncSpvRequested(boolean resyncSpvRequested) {
        this.prefPayload.setResyncSpvRequested(resyncSpvRequested);
        this.requestPersistence();
    }

    public void setBridgeAddresses(List<String> bridgeAddresses) {
        this.prefPayload.setBridgeAddresses(bridgeAddresses);
        this.persistenceManager.forcePersistNow();
    }

    public void setPeerTagMap(Map<String, String> peerTagMap) {
        this.prefPayload.setPeerTagMap(peerTagMap);
        this.requestPersistence();
    }

    public void setBridgeOptionOrdinal(int bridgeOptionOrdinal) {
        this.prefPayload.setBridgeOptionOrdinal(bridgeOptionOrdinal);
        this.persistenceManager.forcePersistNow();
    }

    public void setTorTransportOrdinal(int torTransportOrdinal) {
        this.prefPayload.setTorTransportOrdinal(torTransportOrdinal);
        this.persistenceManager.forcePersistNow();
    }

    public void setCustomBridges(String customBridges) {
        this.prefPayload.setCustomBridges(customBridges);
        this.persistenceManager.forcePersistNow();
    }

    public void setUseTorForXmrOrdinal(int useTorForXmrOrdinal) {
        this.prefPayload.setUseTorForXmrOrdinal(useTorForXmrOrdinal);
        this.requestPersistence();
    }

    public void setMoneroNodesOptionOrdinal(int moneroNodesOptionOrdinal) {
        this.prefPayload.setMoneroNodesOptionOrdinal(moneroNodesOptionOrdinal);
        this.requestPersistence();
    }

    public void setReferralId(String referralId) {
        this.prefPayload.setReferralId(referralId);
        this.requestPersistence();
    }

    public void setPhoneKeyAndToken(String phoneKeyAndToken) {
        this.prefPayload.setPhoneKeyAndToken(phoneKeyAndToken);
        this.requestPersistence();
    }

    public void setUseSoundForMobileNotifications(boolean value) {
        this.prefPayload.setUseSoundForMobileNotifications(value);
        this.requestPersistence();
    }

    public void setUseTradeNotifications(boolean value) {
        this.prefPayload.setUseTradeNotifications(value);
        this.requestPersistence();
    }

    public void setUseMarketNotifications(boolean value) {
        this.prefPayload.setUseMarketNotifications(value);
        this.requestPersistence();
    }

    public void setUsePriceNotifications(boolean value) {
        this.prefPayload.setUsePriceNotifications(value);
        this.requestPersistence();
    }

    public void setUseStandbyMode(boolean useStandbyMode) {
        this.useStandbyModeProperty.set(useStandbyMode);
    }

    public void setUseSoundForNotifications(boolean useSoundForNotifications) {
        this.useSoundForNotificationsProperty.set(useSoundForNotifications);
    }

    public void setTakeOfferSelectedPaymentAccountId(String value) {
        this.prefPayload.setTakeOfferSelectedPaymentAccountId(value);
        this.requestPersistence();
    }

    public void setIgnoreDustThreshold(int value) {
        this.prefPayload.setIgnoreDustThreshold(value);
        this.requestPersistence();
    }

    public void setClearDataAfterDays(int value) {
        this.prefPayload.setClearDataAfterDays(value);
        this.requestPersistence();
    }

    public void setShowOffersMatchingMyAccounts(boolean value) {
        this.prefPayload.setShowOffersMatchingMyAccounts(value);
        this.requestPersistence();
    }

    public void setShowPrivateOffers(boolean value) {
        this.prefPayload.setShowPrivateOffers(value);
        this.requestPersistence();
    }

    public void setDenyApiTaker(boolean value) {
        this.prefPayload.setDenyApiTaker(value);
        this.requestPersistence();
    }

    public void setNotifyOnPreRelease(boolean value) {
        this.prefPayload.setNotifyOnPreRelease(value);
        this.requestPersistence();
    }

    public void setXmrNodeSettings(XmrNodeSettings settings) {
        this.prefPayload.setXmrNodeSettings(settings);
        this.requestPersistence();
    }

    public BooleanProperty useAnimationsProperty() {
        return this.useAnimationsProperty;
    }

    public ObservableList<TraditionalCurrency> getTraditionalCurrenciesAsObservable() {
        return this.traditionalCurrenciesAsObservable;
    }

    public ObservableList<CryptoCurrency> getCryptoCurrenciesAsObservable() {
        return this.cryptoCurrenciesAsObservable;
    }

    public ObservableList<TradeCurrency> getTradeCurrenciesAsObservable() {
        return this.tradeCurrenciesAsObservable;
    }

    public ObservableMap<String, Boolean> getDontShowAgainMapAsObservable() {
        return this.dontShowAgainMapAsObservable;
    }

    public BlockChainExplorer getBlockChainExplorer() {
        BaseCurrencyNetwork baseCurrencyNetwork = Config.baseCurrencyNetwork();
        switch (baseCurrencyNetwork) {
            case XMR_MAINNET: {
                return this.prefPayload.getBlockChainExplorerMainNet();
            }
            case XMR_STAGENET: {
                return this.prefPayload.getBlockChainExplorerTestNet();
            }
            case XMR_LOCAL: {
                return this.prefPayload.getBlockChainExplorerTestNet();
            }
        }
        throw new RuntimeException("BaseCurrencyNetwork not defined. BaseCurrencyNetwork=" + String.valueOf((Object)baseCurrencyNetwork));
    }

    public ArrayList<BlockChainExplorer> getBlockChainExplorers() {
        BaseCurrencyNetwork baseCurrencyNetwork = Config.baseCurrencyNetwork();
        switch (baseCurrencyNetwork) {
            case XMR_MAINNET: {
                return XMR_MAIN_NET_EXPLORERS;
            }
            case XMR_STAGENET: {
                return XMR_STAGE_NET_EXPLORERS;
            }
            case XMR_LOCAL: {
                return XMR_STAGE_NET_EXPLORERS;
            }
        }
        throw new RuntimeException("BaseCurrencyNetwork not defined. BaseCurrencyNetwork=" + String.valueOf((Object)baseCurrencyNetwork));
    }

    public boolean showAgain(String key) {
        return !this.prefPayload.getDontShowAgainMap().containsKey(key) || this.prefPayload.getDontShowAgainMap().get(key) == false;
    }

    public UseTorForXmr getUseTorForXmr() {
        return ((UseTorForXmr[])UseTorForXmr.class.getEnumConstants())[this.prefPayload.getUseTorForXmrOrdinal()];
    }

    public boolean isProxyApplied(boolean wasWalletSynced) {
        return this.getUseTorForXmr() == UseTorForXmr.ON || this.getUseTorForXmr() == UseTorForXmr.AFTER_SYNC && wasWalletSynced;
    }

    public boolean getSplitOfferOutput() {
        return this.prefPayload.isSplitOfferOutput();
    }

    public double getSecurityDepositAsPercent(PaymentAccount paymentAccount) {
        double value;
        double d = value = PaymentAccountUtil.isCryptoCurrencyAccount(paymentAccount) ? this.prefPayload.getSecurityDepositAsPercentForCrypto() : this.prefPayload.getSecurityDepositAsPercent();
        if (value < Restrictions.getMinSecurityDepositAsPercent()) {
            value = Restrictions.getMinSecurityDepositAsPercent();
            this.setSecurityDepositAsPercent(value, paymentAccount);
        }
        return value == 0.0 ? Restrictions.getDefaultSecurityDepositAsPercent() : value;
    }

    @Override
    @Nullable
    public List<String> getBridgeAddresses() {
        return this.prefPayload.getBridgeAddresses();
    }

    public List<String> getDefaultXmrTxProofServices() {
        if (this.config.useLocalhostForP2P) {
            return XMR_TX_PROOF_SERVICES_CLEAR_NET;
        }
        return XMR_TX_PROOF_SERVICES;
    }

    public List<String> getDefaultTxBroadcastServices() {
        if (this.config.useLocalhostForP2P) {
            return TX_BROADCAST_SERVICES_CLEAR_NET;
        }
        return TX_BROADCAST_SERVICES;
    }

    private void updateTradeCurrencies(ListChangeListener.Change<? extends TradeCurrency> change) {
        change.next();
        if (change.wasAdded() && change.getAddedSize() == 1 && this.initialReadDone) {
            this.tradeCurrenciesAsObservable.add(change.getAddedSubList().get(0));
        } else if (change.wasRemoved() && change.getRemovedSize() == 1 && this.initialReadDone) {
            this.tradeCurrenciesAsObservable.remove(change.getRemoved().get(0));
        }
        this.requestPersistence();
    }

    public void setPrefPayload(PreferencesPayload prefPayload) {
        this.prefPayload = prefPayload;
    }

    public BooleanProperty getUseAnimationsProperty() {
        return this.useAnimationsProperty;
    }

    public IntegerProperty getCssThemeProperty() {
        return this.cssThemeProperty;
    }

    public BooleanProperty getUseStandbyModeProperty() {
        return this.useStandbyModeProperty;
    }

    public BooleanProperty getUseSoundForNotificationsProperty() {
        return this.useSoundForNotificationsProperty;
    }

    public Message toProtoMessage() {
        return this.prefPayload.toProtoMessage();
    }

    public String getUserLanguage() {
        return this.prefPayload.getUserLanguage();
    }

    public Country getUserCountry() {
        return this.prefPayload.getUserCountry();
    }

    public List<TraditionalCurrency> getTraditionalCurrencies() {
        return this.prefPayload.getTraditionalCurrencies();
    }

    public List<CryptoCurrency> getCryptoCurrencies() {
        return this.prefPayload.getCryptoCurrencies();
    }

    public BlockChainExplorer getBlockChainExplorerMainNet() {
        return this.prefPayload.getBlockChainExplorerMainNet();
    }

    public BlockChainExplorer getBlockChainExplorerTestNet() {
        return this.prefPayload.getBlockChainExplorerTestNet();
    }

    public String getBackupDirectory() {
        return this.prefPayload.getBackupDirectory();
    }

    public boolean isAutoSelectArbitrators() {
        return this.prefPayload.isAutoSelectArbitrators();
    }

    public Map<String, Boolean> getDontShowAgainMap() {
        return this.prefPayload.getDontShowAgainMap();
    }

    public boolean isTacAccepted() {
        return this.prefPayload.isTacAccepted();
    }

    public boolean isSplitOfferOutput() {
        return this.prefPayload.isSplitOfferOutput();
    }

    public boolean isShowOwnOffersInOfferBook() {
        return this.prefPayload.isShowOwnOffersInOfferBook();
    }

    public TradeCurrency getPreferredTradeCurrency() {
        return this.prefPayload.getPreferredTradeCurrency();
    }

    public boolean isUseCustomWithdrawalTxFee() {
        return this.prefPayload.isUseCustomWithdrawalTxFee();
    }

    public double getMaxPriceDistanceInPercent() {
        return this.prefPayload.getMaxPriceDistanceInPercent();
    }

    public String getOfferBookChartScreenCurrencyCode() {
        return this.prefPayload.getOfferBookChartScreenCurrencyCode();
    }

    public String getTradeChartsScreenCurrencyCode() {
        return this.prefPayload.getTradeChartsScreenCurrencyCode();
    }

    public String getBuyScreenCurrencyCode() {
        return this.prefPayload.getBuyScreenCurrencyCode();
    }

    public String getSellScreenCurrencyCode() {
        return this.prefPayload.getSellScreenCurrencyCode();
    }

    public String getBuyScreenCryptoCurrencyCode() {
        return this.prefPayload.getBuyScreenCryptoCurrencyCode();
    }

    public String getSellScreenCryptoCurrencyCode() {
        return this.prefPayload.getSellScreenCryptoCurrencyCode();
    }

    public String getBuyScreenOtherCurrencyCode() {
        return this.prefPayload.getBuyScreenOtherCurrencyCode();
    }

    public String getSellScreenOtherCurrencyCode() {
        return this.prefPayload.getSellScreenOtherCurrencyCode();
    }

    public int getTradeStatisticsTickUnitIndex() {
        return this.prefPayload.getTradeStatisticsTickUnitIndex();
    }

    public boolean isResyncSpvRequested() {
        return this.prefPayload.isResyncSpvRequested();
    }

    public boolean isSortMarketCurrenciesNumerically() {
        return this.prefPayload.isSortMarketCurrenciesNumerically();
    }

    public boolean isUsePercentageBasedPrice() {
        return this.prefPayload.isUsePercentageBasedPrice();
    }

    public Map<String, String> getPeerTagMap() {
        return this.prefPayload.getPeerTagMap();
    }

    public String getMoneroNodes() {
        return this.prefPayload.getMoneroNodes();
    }

    public List<String> getIgnoreTradersList() {
        return this.prefPayload.getIgnoreTradersList();
    }

    public String getDirectoryChooserPath() {
        return this.prefPayload.getDirectoryChooserPath();
    }

    public boolean isUseAnimations() {
        return this.prefPayload.isUseAnimations();
    }

    public int getCssTheme() {
        return this.prefPayload.getCssTheme();
    }

    public PaymentAccount getSelectedPaymentAccountForCreateOffer() {
        return this.prefPayload.getSelectedPaymentAccountForCreateOffer();
    }

    public int getBridgeOptionOrdinal() {
        return this.prefPayload.getBridgeOptionOrdinal();
    }

    public int getTorTransportOrdinal() {
        return this.prefPayload.getTorTransportOrdinal();
    }

    public String getCustomBridges() {
        return this.prefPayload.getCustomBridges();
    }

    public int getUseTorForXmrOrdinal() {
        return this.prefPayload.getUseTorForXmrOrdinal();
    }

    public int getMoneroNodesOptionOrdinal() {
        return this.prefPayload.getMoneroNodesOptionOrdinal();
    }

    public String getReferralId() {
        return this.prefPayload.getReferralId();
    }

    public String getPhoneKeyAndToken() {
        return this.prefPayload.getPhoneKeyAndToken();
    }

    public boolean isUseSoundForMobileNotifications() {
        return this.prefPayload.isUseSoundForMobileNotifications();
    }

    public boolean isUseTradeNotifications() {
        return this.prefPayload.isUseTradeNotifications();
    }

    public boolean isUseMarketNotifications() {
        return this.prefPayload.isUseMarketNotifications();
    }

    public boolean isUsePriceNotifications() {
        return this.prefPayload.isUsePriceNotifications();
    }

    public boolean isUseStandbyMode() {
        return this.prefPayload.isUseStandbyMode();
    }

    public boolean isUseSoundForNotifications() {
        return this.prefPayload.isUseSoundForNotifications();
    }

    public boolean isUseSoundForNotificationsInitialized() {
        return this.prefPayload.isUseSoundForNotificationsInitialized();
    }

    public String getTakeOfferSelectedPaymentAccountId() {
        return this.prefPayload.getTakeOfferSelectedPaymentAccountId();
    }

    public double getSecurityDepositAsPercent() {
        return this.prefPayload.getSecurityDepositAsPercent();
    }

    public int getIgnoreDustThreshold() {
        return this.prefPayload.getIgnoreDustThreshold();
    }

    public int getClearDataAfterDays() {
        return this.prefPayload.getClearDataAfterDays();
    }

    public double getSecurityDepositAsPercentForCrypto() {
        return this.prefPayload.getSecurityDepositAsPercentForCrypto();
    }

    public boolean isTacAcceptedV120() {
        return this.prefPayload.isTacAcceptedV120();
    }

    public double getBsqAverageTrimThreshold() {
        return this.prefPayload.getBsqAverageTrimThreshold();
    }

    public List<AutoConfirmSettings> getAutoConfirmSettingsList() {
        return this.prefPayload.getAutoConfirmSettingsList();
    }

    public boolean isHideNonAccountPaymentMethods() {
        return this.prefPayload.isHideNonAccountPaymentMethods();
    }

    public boolean isShowOffersMatchingMyAccounts() {
        return this.prefPayload.isShowOffersMatchingMyAccounts();
    }

    public boolean isShowPrivateOffers() {
        return this.prefPayload.isShowPrivateOffers();
    }

    public boolean isDenyApiTaker() {
        return this.prefPayload.isDenyApiTaker();
    }

    public boolean isNotifyOnPreRelease() {
        return this.prefPayload.isNotifyOnPreRelease();
    }

    public XmrNodeSettings getXmrNodeSettings() {
        return this.prefPayload.getXmrNodeSettings();
    }

    public void setUseSoundForNotificationsInitialized(boolean useSoundForNotificationsInitialized) {
        this.prefPayload.setUseSoundForNotificationsInitialized(useSoundForNotificationsInitialized);
    }

    public void setSecurityDepositAsPercent(double securityDepositAsPercent) {
        this.prefPayload.setSecurityDepositAsPercent(securityDepositAsPercent);
    }

    public void setSecurityDepositAsPercentForCrypto(double securityDepositAsPercentForCrypto) {
        this.prefPayload.setSecurityDepositAsPercentForCrypto(securityDepositAsPercentForCrypto);
    }

    public void setAutoConfirmSettingsList(List<AutoConfirmSettings> autoConfirmSettingsList) {
        this.prefPayload.setAutoConfirmSettingsList(autoConfirmSettingsList);
    }

    public Message toPersistableMessage() {
        return this.prefPayload.toPersistableMessage();
    }

    public String getDefaultStorageFileName() {
        return this.prefPayload.getDefaultStorageFileName();
    }

    public static enum UseTorForXmr {
        AFTER_SYNC,
        OFF,
        ON;


        public boolean isUseTorForXmr() {
            return this != OFF;
        }
    }

    private static interface ExcludesDelegateMethods {
        public void setTacAccepted(boolean var1);

        public void setUseAnimations(boolean var1);

        public void setCssTheme(int var1);

        public void setUserLanguage(@NotNull String var1);

        public void setUserCountry(@NotNull Country var1);

        public void setPreferredTradeCurrency(TradeCurrency var1);

        public void setSplitOfferOutput(boolean var1);

        public void setShowOwnOffersInOfferBook(boolean var1);

        public void setMaxPriceDistanceInPercent(double var1);

        public void setBackupDirectory(String var1);

        public void setAutoSelectArbitrators(boolean var1);

        public void setUsePercentageBasedPrice(boolean var1);

        public void setTagForPeer(String var1, String var2);

        public void setOfferBookChartScreenCurrencyCode(String var1);

        public void setBuyScreenCurrencyCode(String var1);

        public void setSellScreenCurrencyCode(String var1);

        public void setIgnoreTradersList(List<String> var1);

        public void setDirectoryChooserPath(String var1);

        public void setTradeChartsScreenCurrencyCode(String var1);

        public void setTradeStatisticsTickUnitIndex(int var1);

        public void setSortMarketCurrenciesNumerically(boolean var1);

        public void setMoneroNodes(String var1);

        public void setUseCustomWithdrawalTxFee(boolean var1);

        public void setWithdrawalTxFeeInVbytes(long var1);

        public void setSelectedPaymentAccountForCreateOffer(@Nullable PaymentAccount var1);

        public void setPayFeeInXmr(boolean var1);

        public void setTraditionalCurrencies(List<TraditionalCurrency> var1);

        public void setCryptoCurrencies(List<CryptoCurrency> var1);

        public void setBlockChainExplorerTestNet(BlockChainExplorer var1);

        public void setBlockChainExplorerMainNet(BlockChainExplorer var1);

        public void setResyncSpvRequested(boolean var1);

        public void setDontShowAgainMap(Map<String, Boolean> var1);

        public void setPeerTagMap(Map<String, String> var1);

        public void setBridgeAddresses(List<String> var1);

        public void setBridgeOptionOrdinal(int var1);

        public void setTorTransportOrdinal(int var1);

        public void setCustomBridges(String var1);

        public void setUseTorForXmrOrdinal(int var1);

        public void setMoneroNodesOptionOrdinal(int var1);

        public void setReferralId(String var1);

        public void setPhoneKeyAndToken(String var1);

        public void setUseSoundForMobileNotifications(boolean var1);

        public void setUseTradeNotifications(boolean var1);

        public void setUseMarketNotifications(boolean var1);

        public void setUsePriceNotifications(boolean var1);

        public List<String> getBridgeAddresses();

        public long getWithdrawalTxFeeInVbytes();

        public void setUseStandbyMode(boolean var1);

        public void setUseSoundForNotifications(boolean var1);

        public void setTakeOfferSelectedPaymentAccountId(String var1);

        public void setIgnoreDustThreshold(int var1);

        public void setBuyerSecurityDepositAsPercent(double var1);

        public double getBuyerSecurityDepositAsPercent();

        public void setRpcUser(String var1);

        public void setRpcPw(String var1);

        public void setBlockNotifyPort(int var1);

        public String getRpcUser();

        public String getRpcPw();

        public int getBlockNotifyPort();

        public void setTacAcceptedV120(boolean var1);

        public void setBsqAverageTrimThreshold(double var1);

        public void setAutoConfirmSettings(AutoConfirmSettings var1);

        public void setHideNonAccountPaymentMethods(boolean var1);

        public void setShowOffersMatchingMyAccounts(boolean var1);

        public void setDenyApiTaker(boolean var1);

        public void setNotifyOnPreRelease(boolean var1);

        public void setXmrNodeSettings(XmrNodeSettings var1);
    }
}

