/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.user;

import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.user.AutoConfirmSettings;
import haveno.core.user.BlockChainExplorer;
import haveno.core.xmr.XmrNodeSettings;
import haveno.core.xmr.wallet.Restrictions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Country;
import protobuf.PreferencesPayload;
import protobuf.TradeCurrency;

public final class PreferencesPayload
implements PersistableEnvelope {
    private static final Logger log = LoggerFactory.getLogger(PreferencesPayload.class);
    private String userLanguage;
    private haveno.core.locale.Country userCountry;
    private List<TraditionalCurrency> traditionalCurrencies = new ArrayList<TraditionalCurrency>();
    private List<CryptoCurrency> cryptoCurrencies = new ArrayList<CryptoCurrency>();
    private BlockChainExplorer blockChainExplorerMainNet;
    private BlockChainExplorer blockChainExplorerTestNet;
    @Nullable
    private String backupDirectory;
    private boolean autoSelectArbitrators = true;
    private Map<String, Boolean> dontShowAgainMap = new HashMap<String, Boolean>();
    private boolean tacAccepted;
    private boolean splitOfferOutput = false;
    private boolean showOwnOffersInOfferBook = true;
    @Nullable
    private haveno.core.locale.TradeCurrency preferredTradeCurrency;
    private long withdrawalTxFeeInVbytes = 100L;
    private boolean useCustomWithdrawalTxFee = false;
    private double maxPriceDistanceInPercent = 0.3;
    @Nullable
    private String offerBookChartScreenCurrencyCode;
    @Nullable
    private String tradeChartsScreenCurrencyCode;
    @Nullable
    private String buyScreenCurrencyCode;
    @Nullable
    private String sellScreenCurrencyCode;
    @Nullable
    private String buyScreenCryptoCurrencyCode;
    @Nullable
    private String sellScreenCryptoCurrencyCode;
    @Nullable
    private String buyScreenOtherCurrencyCode;
    @Nullable
    private String sellScreenOtherCurrencyCode;
    private int tradeStatisticsTickUnitIndex = 3;
    private boolean resyncSpvRequested;
    private boolean sortMarketCurrenciesNumerically = true;
    private boolean usePercentageBasedPrice = true;
    private Map<String, String> peerTagMap = new HashMap<String, String>();
    private String moneroNodes = "";
    private List<String> ignoreTradersList = new ArrayList<String>();
    private String directoryChooserPath;
    private boolean useAnimations;
    private int cssTheme;
    @Nullable
    private PaymentAccount selectedPaymentAccountForCreateOffer;
    @Nullable
    private List<String> bridgeAddresses;
    private int bridgeOptionOrdinal;
    private int torTransportOrdinal;
    @Nullable
    private String customBridges;
    private int useTorForXmrOrdinal;
    private int moneroNodesOptionOrdinal;
    @Nullable
    private String referralId;
    @Nullable
    private String phoneKeyAndToken;
    private boolean useSoundForMobileNotifications = true;
    private boolean useTradeNotifications = true;
    private boolean useMarketNotifications = true;
    private boolean usePriceNotifications = true;
    private boolean useStandbyMode = false;
    private boolean useSoundForNotifications = true;
    private boolean useSoundForNotificationsInitialized = false;
    @Nullable
    private String rpcUser;
    @Nullable
    private String rpcPw;
    @Nullable
    private String takeOfferSelectedPaymentAccountId;
    private double securityDepositAsPercent = Restrictions.getDefaultSecurityDepositAsPercent();
    private int ignoreDustThreshold = 600;
    private int clearDataAfterDays = 99999;
    private double securityDepositAsPercentForCrypto = Restrictions.getDefaultSecurityDepositAsPercent();
    private int blockNotifyPort;
    private boolean tacAcceptedV120;
    private double bsqAverageTrimThreshold = 0.05;
    private List<AutoConfirmSettings> autoConfirmSettingsList = new ArrayList<AutoConfirmSettings>();
    private boolean hideNonAccountPaymentMethods;
    private boolean showOffersMatchingMyAccounts;
    private boolean showPrivateOffers;
    private boolean denyApiTaker;
    private boolean notifyOnPreRelease;
    private XmrNodeSettings xmrNodeSettings = new XmrNodeSettings();

    PreferencesPayload() {
    }

    @Override
    public Message toProtoMessage() {
        PreferencesPayload.Builder builder = protobuf.PreferencesPayload.newBuilder().setUserLanguage(this.userLanguage).setUserCountry((Country)this.userCountry.toProtoMessage()).addAllTraditionalCurrencies(this.traditionalCurrencies.stream().map(traditionalCurrency -> (TradeCurrency)traditionalCurrency.toProtoMessage()).collect(Collectors.toList())).addAllCryptoCurrencies(this.cryptoCurrencies.stream().map(cryptoCurrency -> (TradeCurrency)cryptoCurrency.toProtoMessage()).collect(Collectors.toList())).setBlockChainExplorerMainNet((protobuf.BlockChainExplorer)this.blockChainExplorerMainNet.toProtoMessage()).setBlockChainExplorerTestNet((protobuf.BlockChainExplorer)this.blockChainExplorerTestNet.toProtoMessage()).setAutoSelectArbitrators(this.autoSelectArbitrators).putAllDontShowAgainMap(this.dontShowAgainMap).setTacAccepted(this.tacAccepted).setSplitOfferOutput(this.splitOfferOutput).setShowOwnOffersInOfferBook(this.showOwnOffersInOfferBook).setWithdrawalTxFeeInVbytes(this.withdrawalTxFeeInVbytes).setUseCustomWithdrawalTxFee(this.useCustomWithdrawalTxFee).setMaxPriceDistanceInPercent(this.maxPriceDistanceInPercent).setTradeStatisticsTickUnitIndex(this.tradeStatisticsTickUnitIndex).setResyncSpvRequested(this.resyncSpvRequested).setSortMarketCurrenciesNumerically(this.sortMarketCurrenciesNumerically).setUsePercentageBasedPrice(this.usePercentageBasedPrice).putAllPeerTagMap(this.peerTagMap).setMoneroNodes(this.moneroNodes).addAllIgnoreTradersList(this.ignoreTradersList).setDirectoryChooserPath(this.directoryChooserPath).setUseAnimations(this.useAnimations).setCssTheme(this.cssTheme).setBridgeOptionOrdinal(this.bridgeOptionOrdinal).setTorTransportOrdinal(this.torTransportOrdinal).setUseTorForXmrOrdinal(this.useTorForXmrOrdinal).setMoneroNodesOptionOrdinal(this.moneroNodesOptionOrdinal).setUseSoundForMobileNotifications(this.useSoundForMobileNotifications).setUseTradeNotifications(this.useTradeNotifications).setUseMarketNotifications(this.useMarketNotifications).setUsePriceNotifications(this.usePriceNotifications).setUseStandbyMode(this.useStandbyMode).setUseSoundForNotifications(this.useSoundForNotifications).setUseSoundForNotificationsInitialized(this.useSoundForNotificationsInitialized).setSecurityDepositAsPercent(this.securityDepositAsPercent).setIgnoreDustThreshold(this.ignoreDustThreshold).setClearDataAfterDays(this.clearDataAfterDays).setSecurityDepositAsPercentForCrypto(this.securityDepositAsPercentForCrypto).setBlockNotifyPort(this.blockNotifyPort).setTacAcceptedV120(this.tacAcceptedV120).setBsqAverageTrimThreshold(this.bsqAverageTrimThreshold).addAllAutoConfirmSettings(this.autoConfirmSettingsList.stream().map(autoConfirmSettings -> (protobuf.AutoConfirmSettings)autoConfirmSettings.toProtoMessage()).collect(Collectors.toList())).setHideNonAccountPaymentMethods(this.hideNonAccountPaymentMethods).setShowOffersMatchingMyAccounts(this.showOffersMatchingMyAccounts).setShowPrivateOffers(this.showPrivateOffers).setDenyApiTaker(this.denyApiTaker).setNotifyOnPreRelease(this.notifyOnPreRelease);
        Optional.ofNullable(this.backupDirectory).ifPresent(builder::setBackupDirectory);
        Optional.ofNullable(this.preferredTradeCurrency).ifPresent(e -> builder.setPreferredTradeCurrency((TradeCurrency)e.toProtoMessage()));
        Optional.ofNullable(this.offerBookChartScreenCurrencyCode).ifPresent(builder::setOfferBookChartScreenCurrencyCode);
        Optional.ofNullable(this.tradeChartsScreenCurrencyCode).ifPresent(builder::setTradeChartsScreenCurrencyCode);
        Optional.ofNullable(this.buyScreenCurrencyCode).ifPresent(builder::setBuyScreenCurrencyCode);
        Optional.ofNullable(this.sellScreenCurrencyCode).ifPresent(builder::setSellScreenCurrencyCode);
        Optional.ofNullable(this.buyScreenCryptoCurrencyCode).ifPresent(builder::setBuyScreenCryptoCurrencyCode);
        Optional.ofNullable(this.sellScreenCryptoCurrencyCode).ifPresent(builder::setSellScreenCryptoCurrencyCode);
        Optional.ofNullable(this.buyScreenOtherCurrencyCode).ifPresent(builder::setBuyScreenOtherCurrencyCode);
        Optional.ofNullable(this.sellScreenOtherCurrencyCode).ifPresent(builder::setSellScreenOtherCurrencyCode);
        Optional.ofNullable(this.selectedPaymentAccountForCreateOffer).ifPresent(account -> builder.setSelectedPaymentAccountForCreateOffer(this.selectedPaymentAccountForCreateOffer.toProtoMessage()));
        Optional.ofNullable(this.bridgeAddresses).ifPresent(builder::addAllBridgeAddresses);
        Optional.ofNullable(this.customBridges).ifPresent(builder::setCustomBridges);
        Optional.ofNullable(this.referralId).ifPresent(builder::setReferralId);
        Optional.ofNullable(this.phoneKeyAndToken).ifPresent(builder::setPhoneKeyAndToken);
        Optional.ofNullable(this.rpcUser).ifPresent(builder::setRpcUser);
        Optional.ofNullable(this.rpcPw).ifPresent(builder::setRpcPw);
        Optional.ofNullable(this.takeOfferSelectedPaymentAccountId).ifPresent(builder::setTakeOfferSelectedPaymentAccountId);
        Optional.ofNullable(this.xmrNodeSettings).ifPresent(settings -> builder.setXmrNodeSettings(settings.toProtoMessage()));
        return protobuf.PersistableEnvelope.newBuilder().setPreferencesPayload(builder).build();
    }

    public static PreferencesPayload fromProto(protobuf.PreferencesPayload proto, CoreProtoResolver coreProtoResolver) {
        Country userCountry = proto.getUserCountry();
        PaymentAccount paymentAccount = null;
        if (proto.hasSelectedPaymentAccountForCreateOffer() && proto.getSelectedPaymentAccountForCreateOffer().hasPaymentMethod()) {
            paymentAccount = PaymentAccount.fromProto(proto.getSelectedPaymentAccountForCreateOffer(), coreProtoResolver);
        }
        return new PreferencesPayload(proto.getUserLanguage(), haveno.core.locale.Country.fromProto(userCountry), proto.getTraditionalCurrenciesList().isEmpty() ? new ArrayList<TraditionalCurrency>() : new ArrayList(proto.getTraditionalCurrenciesList().stream().map(TraditionalCurrency::fromProto).collect(Collectors.toList())), proto.getCryptoCurrenciesList().isEmpty() ? new ArrayList<CryptoCurrency>() : new ArrayList(proto.getCryptoCurrenciesList().stream().map(CryptoCurrency::fromProto).collect(Collectors.toList())), BlockChainExplorer.fromProto(proto.getBlockChainExplorerMainNet()), BlockChainExplorer.fromProto(proto.getBlockChainExplorerTestNet()), ProtoUtil.stringOrNullFromProto(proto.getBackupDirectory()), proto.getAutoSelectArbitrators(), Maps.newHashMap(proto.getDontShowAgainMapMap()), proto.getTacAccepted(), proto.getSplitOfferOutput(), proto.getShowOwnOffersInOfferBook(), proto.hasPreferredTradeCurrency() ? haveno.core.locale.TradeCurrency.fromProto(proto.getPreferredTradeCurrency()) : null, proto.getWithdrawalTxFeeInVbytes(), proto.getUseCustomWithdrawalTxFee(), proto.getMaxPriceDistanceInPercent(), ProtoUtil.stringOrNullFromProto(proto.getOfferBookChartScreenCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getTradeChartsScreenCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getBuyScreenCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getSellScreenCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getBuyScreenCryptoCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getSellScreenCryptoCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getBuyScreenOtherCurrencyCode()), ProtoUtil.stringOrNullFromProto(proto.getSellScreenOtherCurrencyCode()), proto.getTradeStatisticsTickUnitIndex(), proto.getResyncSpvRequested(), proto.getSortMarketCurrenciesNumerically(), proto.getUsePercentageBasedPrice(), Maps.newHashMap(proto.getPeerTagMapMap()), proto.getMoneroNodes(), proto.getIgnoreTradersListList(), proto.getDirectoryChooserPath(), proto.getUseAnimations(), proto.getCssTheme(), paymentAccount, proto.getBridgeAddressesList().isEmpty() ? null : new ArrayList<String>(proto.getBridgeAddressesList()), proto.getBridgeOptionOrdinal(), proto.getTorTransportOrdinal(), ProtoUtil.stringOrNullFromProto(proto.getCustomBridges()), proto.getUseTorForXmrOrdinal(), proto.getMoneroNodesOptionOrdinal(), proto.getReferralId().isEmpty() ? null : proto.getReferralId(), proto.getPhoneKeyAndToken().isEmpty() ? null : proto.getPhoneKeyAndToken(), proto.getUseSoundForMobileNotifications(), proto.getUseTradeNotifications(), proto.getUseMarketNotifications(), proto.getUsePriceNotifications(), proto.getUseStandbyMode(), proto.getUseSoundForNotifications(), proto.getUseSoundForNotificationsInitialized(), proto.getRpcUser().isEmpty() ? null : proto.getRpcUser(), proto.getRpcPw().isEmpty() ? null : proto.getRpcPw(), proto.getTakeOfferSelectedPaymentAccountId().isEmpty() ? null : proto.getTakeOfferSelectedPaymentAccountId(), proto.getSecurityDepositAsPercent(), proto.getIgnoreDustThreshold(), proto.getClearDataAfterDays(), proto.getSecurityDepositAsPercentForCrypto(), proto.getBlockNotifyPort(), proto.getTacAcceptedV120(), proto.getBsqAverageTrimThreshold(), proto.getAutoConfirmSettingsList().isEmpty() ? new ArrayList<AutoConfirmSettings>() : new ArrayList(proto.getAutoConfirmSettingsList().stream().map(AutoConfirmSettings::fromProto).collect(Collectors.toList())), proto.getHideNonAccountPaymentMethods(), proto.getShowOffersMatchingMyAccounts(), proto.getShowPrivateOffers(), proto.getDenyApiTaker(), proto.getNotifyOnPreRelease(), XmrNodeSettings.fromProto(proto.getXmrNodeSettings()));
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public haveno.core.locale.Country getUserCountry() {
        return this.userCountry;
    }

    public List<TraditionalCurrency> getTraditionalCurrencies() {
        return this.traditionalCurrencies;
    }

    public List<CryptoCurrency> getCryptoCurrencies() {
        return this.cryptoCurrencies;
    }

    public BlockChainExplorer getBlockChainExplorerMainNet() {
        return this.blockChainExplorerMainNet;
    }

    public BlockChainExplorer getBlockChainExplorerTestNet() {
        return this.blockChainExplorerTestNet;
    }

    @Nullable
    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    public boolean isAutoSelectArbitrators() {
        return this.autoSelectArbitrators;
    }

    public Map<String, Boolean> getDontShowAgainMap() {
        return this.dontShowAgainMap;
    }

    public boolean isTacAccepted() {
        return this.tacAccepted;
    }

    public boolean isSplitOfferOutput() {
        return this.splitOfferOutput;
    }

    public boolean isShowOwnOffersInOfferBook() {
        return this.showOwnOffersInOfferBook;
    }

    @Nullable
    public haveno.core.locale.TradeCurrency getPreferredTradeCurrency() {
        return this.preferredTradeCurrency;
    }

    public long getWithdrawalTxFeeInVbytes() {
        return this.withdrawalTxFeeInVbytes;
    }

    public boolean isUseCustomWithdrawalTxFee() {
        return this.useCustomWithdrawalTxFee;
    }

    public double getMaxPriceDistanceInPercent() {
        return this.maxPriceDistanceInPercent;
    }

    @Nullable
    public String getOfferBookChartScreenCurrencyCode() {
        return this.offerBookChartScreenCurrencyCode;
    }

    @Nullable
    public String getTradeChartsScreenCurrencyCode() {
        return this.tradeChartsScreenCurrencyCode;
    }

    @Nullable
    public String getBuyScreenCurrencyCode() {
        return this.buyScreenCurrencyCode;
    }

    @Nullable
    public String getSellScreenCurrencyCode() {
        return this.sellScreenCurrencyCode;
    }

    @Nullable
    public String getBuyScreenCryptoCurrencyCode() {
        return this.buyScreenCryptoCurrencyCode;
    }

    @Nullable
    public String getSellScreenCryptoCurrencyCode() {
        return this.sellScreenCryptoCurrencyCode;
    }

    @Nullable
    public String getBuyScreenOtherCurrencyCode() {
        return this.buyScreenOtherCurrencyCode;
    }

    @Nullable
    public String getSellScreenOtherCurrencyCode() {
        return this.sellScreenOtherCurrencyCode;
    }

    public int getTradeStatisticsTickUnitIndex() {
        return this.tradeStatisticsTickUnitIndex;
    }

    public boolean isResyncSpvRequested() {
        return this.resyncSpvRequested;
    }

    public boolean isSortMarketCurrenciesNumerically() {
        return this.sortMarketCurrenciesNumerically;
    }

    public boolean isUsePercentageBasedPrice() {
        return this.usePercentageBasedPrice;
    }

    public Map<String, String> getPeerTagMap() {
        return this.peerTagMap;
    }

    public String getMoneroNodes() {
        return this.moneroNodes;
    }

    public List<String> getIgnoreTradersList() {
        return this.ignoreTradersList;
    }

    public String getDirectoryChooserPath() {
        return this.directoryChooserPath;
    }

    public boolean isUseAnimations() {
        return this.useAnimations;
    }

    public int getCssTheme() {
        return this.cssTheme;
    }

    @Nullable
    public PaymentAccount getSelectedPaymentAccountForCreateOffer() {
        return this.selectedPaymentAccountForCreateOffer;
    }

    @Nullable
    public List<String> getBridgeAddresses() {
        return this.bridgeAddresses;
    }

    public int getBridgeOptionOrdinal() {
        return this.bridgeOptionOrdinal;
    }

    public int getTorTransportOrdinal() {
        return this.torTransportOrdinal;
    }

    @Nullable
    public String getCustomBridges() {
        return this.customBridges;
    }

    public int getUseTorForXmrOrdinal() {
        return this.useTorForXmrOrdinal;
    }

    public int getMoneroNodesOptionOrdinal() {
        return this.moneroNodesOptionOrdinal;
    }

    @Nullable
    public String getReferralId() {
        return this.referralId;
    }

    @Nullable
    public String getPhoneKeyAndToken() {
        return this.phoneKeyAndToken;
    }

    public boolean isUseSoundForMobileNotifications() {
        return this.useSoundForMobileNotifications;
    }

    public boolean isUseTradeNotifications() {
        return this.useTradeNotifications;
    }

    public boolean isUseMarketNotifications() {
        return this.useMarketNotifications;
    }

    public boolean isUsePriceNotifications() {
        return this.usePriceNotifications;
    }

    public boolean isUseStandbyMode() {
        return this.useStandbyMode;
    }

    public boolean isUseSoundForNotifications() {
        return this.useSoundForNotifications;
    }

    public boolean isUseSoundForNotificationsInitialized() {
        return this.useSoundForNotificationsInitialized;
    }

    @Nullable
    public String getRpcUser() {
        return this.rpcUser;
    }

    @Nullable
    public String getRpcPw() {
        return this.rpcPw;
    }

    @Nullable
    public String getTakeOfferSelectedPaymentAccountId() {
        return this.takeOfferSelectedPaymentAccountId;
    }

    public double getSecurityDepositAsPercent() {
        return this.securityDepositAsPercent;
    }

    public int getIgnoreDustThreshold() {
        return this.ignoreDustThreshold;
    }

    public int getClearDataAfterDays() {
        return this.clearDataAfterDays;
    }

    public double getSecurityDepositAsPercentForCrypto() {
        return this.securityDepositAsPercentForCrypto;
    }

    public int getBlockNotifyPort() {
        return this.blockNotifyPort;
    }

    public boolean isTacAcceptedV120() {
        return this.tacAcceptedV120;
    }

    public double getBsqAverageTrimThreshold() {
        return this.bsqAverageTrimThreshold;
    }

    public List<AutoConfirmSettings> getAutoConfirmSettingsList() {
        return this.autoConfirmSettingsList;
    }

    public boolean isHideNonAccountPaymentMethods() {
        return this.hideNonAccountPaymentMethods;
    }

    public boolean isShowOffersMatchingMyAccounts() {
        return this.showOffersMatchingMyAccounts;
    }

    public boolean isShowPrivateOffers() {
        return this.showPrivateOffers;
    }

    public boolean isDenyApiTaker() {
        return this.denyApiTaker;
    }

    public boolean isNotifyOnPreRelease() {
        return this.notifyOnPreRelease;
    }

    public XmrNodeSettings getXmrNodeSettings() {
        return this.xmrNodeSettings;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage = userLanguage;
    }

    public void setUserCountry(haveno.core.locale.Country userCountry) {
        this.userCountry = userCountry;
    }

    public void setTraditionalCurrencies(List<TraditionalCurrency> traditionalCurrencies) {
        this.traditionalCurrencies = traditionalCurrencies;
    }

    public void setCryptoCurrencies(List<CryptoCurrency> cryptoCurrencies) {
        this.cryptoCurrencies = cryptoCurrencies;
    }

    public void setBlockChainExplorerMainNet(BlockChainExplorer blockChainExplorerMainNet) {
        this.blockChainExplorerMainNet = blockChainExplorerMainNet;
    }

    public void setBlockChainExplorerTestNet(BlockChainExplorer blockChainExplorerTestNet) {
        this.blockChainExplorerTestNet = blockChainExplorerTestNet;
    }

    public void setBackupDirectory(@Nullable String backupDirectory) {
        this.backupDirectory = backupDirectory;
    }

    public void setAutoSelectArbitrators(boolean autoSelectArbitrators) {
        this.autoSelectArbitrators = autoSelectArbitrators;
    }

    public void setDontShowAgainMap(Map<String, Boolean> dontShowAgainMap) {
        this.dontShowAgainMap = dontShowAgainMap;
    }

    public void setTacAccepted(boolean tacAccepted) {
        this.tacAccepted = tacAccepted;
    }

    public void setSplitOfferOutput(boolean splitOfferOutput) {
        this.splitOfferOutput = splitOfferOutput;
    }

    public void setShowOwnOffersInOfferBook(boolean showOwnOffersInOfferBook) {
        this.showOwnOffersInOfferBook = showOwnOffersInOfferBook;
    }

    public void setPreferredTradeCurrency(@Nullable haveno.core.locale.TradeCurrency preferredTradeCurrency) {
        this.preferredTradeCurrency = preferredTradeCurrency;
    }

    public void setWithdrawalTxFeeInVbytes(long withdrawalTxFeeInVbytes) {
        this.withdrawalTxFeeInVbytes = withdrawalTxFeeInVbytes;
    }

    public void setUseCustomWithdrawalTxFee(boolean useCustomWithdrawalTxFee) {
        this.useCustomWithdrawalTxFee = useCustomWithdrawalTxFee;
    }

    public void setMaxPriceDistanceInPercent(double maxPriceDistanceInPercent) {
        this.maxPriceDistanceInPercent = maxPriceDistanceInPercent;
    }

    public void setOfferBookChartScreenCurrencyCode(@Nullable String offerBookChartScreenCurrencyCode) {
        this.offerBookChartScreenCurrencyCode = offerBookChartScreenCurrencyCode;
    }

    public void setTradeChartsScreenCurrencyCode(@Nullable String tradeChartsScreenCurrencyCode) {
        this.tradeChartsScreenCurrencyCode = tradeChartsScreenCurrencyCode;
    }

    public void setBuyScreenCurrencyCode(@Nullable String buyScreenCurrencyCode) {
        this.buyScreenCurrencyCode = buyScreenCurrencyCode;
    }

    public void setSellScreenCurrencyCode(@Nullable String sellScreenCurrencyCode) {
        this.sellScreenCurrencyCode = sellScreenCurrencyCode;
    }

    public void setBuyScreenCryptoCurrencyCode(@Nullable String buyScreenCryptoCurrencyCode) {
        this.buyScreenCryptoCurrencyCode = buyScreenCryptoCurrencyCode;
    }

    public void setSellScreenCryptoCurrencyCode(@Nullable String sellScreenCryptoCurrencyCode) {
        this.sellScreenCryptoCurrencyCode = sellScreenCryptoCurrencyCode;
    }

    public void setBuyScreenOtherCurrencyCode(@Nullable String buyScreenOtherCurrencyCode) {
        this.buyScreenOtherCurrencyCode = buyScreenOtherCurrencyCode;
    }

    public void setSellScreenOtherCurrencyCode(@Nullable String sellScreenOtherCurrencyCode) {
        this.sellScreenOtherCurrencyCode = sellScreenOtherCurrencyCode;
    }

    public void setTradeStatisticsTickUnitIndex(int tradeStatisticsTickUnitIndex) {
        this.tradeStatisticsTickUnitIndex = tradeStatisticsTickUnitIndex;
    }

    public void setResyncSpvRequested(boolean resyncSpvRequested) {
        this.resyncSpvRequested = resyncSpvRequested;
    }

    public void setSortMarketCurrenciesNumerically(boolean sortMarketCurrenciesNumerically) {
        this.sortMarketCurrenciesNumerically = sortMarketCurrenciesNumerically;
    }

    public void setUsePercentageBasedPrice(boolean usePercentageBasedPrice) {
        this.usePercentageBasedPrice = usePercentageBasedPrice;
    }

    public void setPeerTagMap(Map<String, String> peerTagMap) {
        this.peerTagMap = peerTagMap;
    }

    public void setMoneroNodes(String moneroNodes) {
        this.moneroNodes = moneroNodes;
    }

    public void setIgnoreTradersList(List<String> ignoreTradersList) {
        this.ignoreTradersList = ignoreTradersList;
    }

    public void setDirectoryChooserPath(String directoryChooserPath) {
        this.directoryChooserPath = directoryChooserPath;
    }

    public void setUseAnimations(boolean useAnimations) {
        this.useAnimations = useAnimations;
    }

    public void setCssTheme(int cssTheme) {
        this.cssTheme = cssTheme;
    }

    public void setSelectedPaymentAccountForCreateOffer(@Nullable PaymentAccount selectedPaymentAccountForCreateOffer) {
        this.selectedPaymentAccountForCreateOffer = selectedPaymentAccountForCreateOffer;
    }

    public void setBridgeAddresses(@Nullable List<String> bridgeAddresses) {
        this.bridgeAddresses = bridgeAddresses;
    }

    public void setBridgeOptionOrdinal(int bridgeOptionOrdinal) {
        this.bridgeOptionOrdinal = bridgeOptionOrdinal;
    }

    public void setTorTransportOrdinal(int torTransportOrdinal) {
        this.torTransportOrdinal = torTransportOrdinal;
    }

    public void setCustomBridges(@Nullable String customBridges) {
        this.customBridges = customBridges;
    }

    public void setUseTorForXmrOrdinal(int useTorForXmrOrdinal) {
        this.useTorForXmrOrdinal = useTorForXmrOrdinal;
    }

    public void setMoneroNodesOptionOrdinal(int moneroNodesOptionOrdinal) {
        this.moneroNodesOptionOrdinal = moneroNodesOptionOrdinal;
    }

    public void setReferralId(@Nullable String referralId) {
        this.referralId = referralId;
    }

    public void setPhoneKeyAndToken(@Nullable String phoneKeyAndToken) {
        this.phoneKeyAndToken = phoneKeyAndToken;
    }

    public void setUseSoundForMobileNotifications(boolean useSoundForMobileNotifications) {
        this.useSoundForMobileNotifications = useSoundForMobileNotifications;
    }

    public void setUseTradeNotifications(boolean useTradeNotifications) {
        this.useTradeNotifications = useTradeNotifications;
    }

    public void setUseMarketNotifications(boolean useMarketNotifications) {
        this.useMarketNotifications = useMarketNotifications;
    }

    public void setUsePriceNotifications(boolean usePriceNotifications) {
        this.usePriceNotifications = usePriceNotifications;
    }

    public void setUseStandbyMode(boolean useStandbyMode) {
        this.useStandbyMode = useStandbyMode;
    }

    public void setUseSoundForNotifications(boolean useSoundForNotifications) {
        this.useSoundForNotifications = useSoundForNotifications;
    }

    public void setUseSoundForNotificationsInitialized(boolean useSoundForNotificationsInitialized) {
        this.useSoundForNotificationsInitialized = useSoundForNotificationsInitialized;
    }

    public void setRpcUser(@Nullable String rpcUser) {
        this.rpcUser = rpcUser;
    }

    public void setRpcPw(@Nullable String rpcPw) {
        this.rpcPw = rpcPw;
    }

    public void setTakeOfferSelectedPaymentAccountId(@Nullable String takeOfferSelectedPaymentAccountId) {
        this.takeOfferSelectedPaymentAccountId = takeOfferSelectedPaymentAccountId;
    }

    public void setSecurityDepositAsPercent(double securityDepositAsPercent) {
        this.securityDepositAsPercent = securityDepositAsPercent;
    }

    public void setIgnoreDustThreshold(int ignoreDustThreshold) {
        this.ignoreDustThreshold = ignoreDustThreshold;
    }

    public void setClearDataAfterDays(int clearDataAfterDays) {
        this.clearDataAfterDays = clearDataAfterDays;
    }

    public void setSecurityDepositAsPercentForCrypto(double securityDepositAsPercentForCrypto) {
        this.securityDepositAsPercentForCrypto = securityDepositAsPercentForCrypto;
    }

    public void setBlockNotifyPort(int blockNotifyPort) {
        this.blockNotifyPort = blockNotifyPort;
    }

    public void setTacAcceptedV120(boolean tacAcceptedV120) {
        this.tacAcceptedV120 = tacAcceptedV120;
    }

    public void setBsqAverageTrimThreshold(double bsqAverageTrimThreshold) {
        this.bsqAverageTrimThreshold = bsqAverageTrimThreshold;
    }

    public void setAutoConfirmSettingsList(List<AutoConfirmSettings> autoConfirmSettingsList) {
        this.autoConfirmSettingsList = autoConfirmSettingsList;
    }

    public void setHideNonAccountPaymentMethods(boolean hideNonAccountPaymentMethods) {
        this.hideNonAccountPaymentMethods = hideNonAccountPaymentMethods;
    }

    public void setShowOffersMatchingMyAccounts(boolean showOffersMatchingMyAccounts) {
        this.showOffersMatchingMyAccounts = showOffersMatchingMyAccounts;
    }

    public void setShowPrivateOffers(boolean showPrivateOffers) {
        this.showPrivateOffers = showPrivateOffers;
    }

    public void setDenyApiTaker(boolean denyApiTaker) {
        this.denyApiTaker = denyApiTaker;
    }

    public void setNotifyOnPreRelease(boolean notifyOnPreRelease) {
        this.notifyOnPreRelease = notifyOnPreRelease;
    }

    public void setXmrNodeSettings(XmrNodeSettings xmrNodeSettings) {
        this.xmrNodeSettings = xmrNodeSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreferencesPayload)) {
            return false;
        }
        PreferencesPayload other = (PreferencesPayload)o;
        if (this.isAutoSelectArbitrators() != other.isAutoSelectArbitrators()) {
            return false;
        }
        if (this.isTacAccepted() != other.isTacAccepted()) {
            return false;
        }
        if (this.isSplitOfferOutput() != other.isSplitOfferOutput()) {
            return false;
        }
        if (this.isShowOwnOffersInOfferBook() != other.isShowOwnOffersInOfferBook()) {
            return false;
        }
        if (this.getWithdrawalTxFeeInVbytes() != other.getWithdrawalTxFeeInVbytes()) {
            return false;
        }
        if (this.isUseCustomWithdrawalTxFee() != other.isUseCustomWithdrawalTxFee()) {
            return false;
        }
        if (Double.compare(this.getMaxPriceDistanceInPercent(), other.getMaxPriceDistanceInPercent()) != 0) {
            return false;
        }
        if (this.getTradeStatisticsTickUnitIndex() != other.getTradeStatisticsTickUnitIndex()) {
            return false;
        }
        if (this.isResyncSpvRequested() != other.isResyncSpvRequested()) {
            return false;
        }
        if (this.isSortMarketCurrenciesNumerically() != other.isSortMarketCurrenciesNumerically()) {
            return false;
        }
        if (this.isUsePercentageBasedPrice() != other.isUsePercentageBasedPrice()) {
            return false;
        }
        if (this.isUseAnimations() != other.isUseAnimations()) {
            return false;
        }
        if (this.getCssTheme() != other.getCssTheme()) {
            return false;
        }
        if (this.getBridgeOptionOrdinal() != other.getBridgeOptionOrdinal()) {
            return false;
        }
        if (this.getTorTransportOrdinal() != other.getTorTransportOrdinal()) {
            return false;
        }
        if (this.getUseTorForXmrOrdinal() != other.getUseTorForXmrOrdinal()) {
            return false;
        }
        if (this.getMoneroNodesOptionOrdinal() != other.getMoneroNodesOptionOrdinal()) {
            return false;
        }
        if (this.isUseSoundForMobileNotifications() != other.isUseSoundForMobileNotifications()) {
            return false;
        }
        if (this.isUseTradeNotifications() != other.isUseTradeNotifications()) {
            return false;
        }
        if (this.isUseMarketNotifications() != other.isUseMarketNotifications()) {
            return false;
        }
        if (this.isUsePriceNotifications() != other.isUsePriceNotifications()) {
            return false;
        }
        if (this.isUseStandbyMode() != other.isUseStandbyMode()) {
            return false;
        }
        if (this.isUseSoundForNotifications() != other.isUseSoundForNotifications()) {
            return false;
        }
        if (this.isUseSoundForNotificationsInitialized() != other.isUseSoundForNotificationsInitialized()) {
            return false;
        }
        if (Double.compare(this.getSecurityDepositAsPercent(), other.getSecurityDepositAsPercent()) != 0) {
            return false;
        }
        if (this.getIgnoreDustThreshold() != other.getIgnoreDustThreshold()) {
            return false;
        }
        if (this.getClearDataAfterDays() != other.getClearDataAfterDays()) {
            return false;
        }
        if (Double.compare(this.getSecurityDepositAsPercentForCrypto(), other.getSecurityDepositAsPercentForCrypto()) != 0) {
            return false;
        }
        if (this.getBlockNotifyPort() != other.getBlockNotifyPort()) {
            return false;
        }
        if (this.isTacAcceptedV120() != other.isTacAcceptedV120()) {
            return false;
        }
        if (Double.compare(this.getBsqAverageTrimThreshold(), other.getBsqAverageTrimThreshold()) != 0) {
            return false;
        }
        if (this.isHideNonAccountPaymentMethods() != other.isHideNonAccountPaymentMethods()) {
            return false;
        }
        if (this.isShowOffersMatchingMyAccounts() != other.isShowOffersMatchingMyAccounts()) {
            return false;
        }
        if (this.isShowPrivateOffers() != other.isShowPrivateOffers()) {
            return false;
        }
        if (this.isDenyApiTaker() != other.isDenyApiTaker()) {
            return false;
        }
        if (this.isNotifyOnPreRelease() != other.isNotifyOnPreRelease()) {
            return false;
        }
        String this$userLanguage = this.getUserLanguage();
        String other$userLanguage = other.getUserLanguage();
        if (this$userLanguage == null ? other$userLanguage != null : !this$userLanguage.equals(other$userLanguage)) {
            return false;
        }
        haveno.core.locale.Country this$userCountry = this.getUserCountry();
        haveno.core.locale.Country other$userCountry = other.getUserCountry();
        if (this$userCountry == null ? other$userCountry != null : !((Object)this$userCountry).equals(other$userCountry)) {
            return false;
        }
        List<TraditionalCurrency> this$traditionalCurrencies = this.getTraditionalCurrencies();
        List<TraditionalCurrency> other$traditionalCurrencies = other.getTraditionalCurrencies();
        if (this$traditionalCurrencies == null ? other$traditionalCurrencies != null : !((Object)this$traditionalCurrencies).equals(other$traditionalCurrencies)) {
            return false;
        }
        List<CryptoCurrency> this$cryptoCurrencies = this.getCryptoCurrencies();
        List<CryptoCurrency> other$cryptoCurrencies = other.getCryptoCurrencies();
        if (this$cryptoCurrencies == null ? other$cryptoCurrencies != null : !((Object)this$cryptoCurrencies).equals(other$cryptoCurrencies)) {
            return false;
        }
        BlockChainExplorer this$blockChainExplorerMainNet = this.getBlockChainExplorerMainNet();
        BlockChainExplorer other$blockChainExplorerMainNet = other.getBlockChainExplorerMainNet();
        if (this$blockChainExplorerMainNet == null ? other$blockChainExplorerMainNet != null : !this$blockChainExplorerMainNet.equals(other$blockChainExplorerMainNet)) {
            return false;
        }
        BlockChainExplorer this$blockChainExplorerTestNet = this.getBlockChainExplorerTestNet();
        BlockChainExplorer other$blockChainExplorerTestNet = other.getBlockChainExplorerTestNet();
        if (this$blockChainExplorerTestNet == null ? other$blockChainExplorerTestNet != null : !this$blockChainExplorerTestNet.equals(other$blockChainExplorerTestNet)) {
            return false;
        }
        String this$backupDirectory = this.getBackupDirectory();
        String other$backupDirectory = other.getBackupDirectory();
        if (this$backupDirectory == null ? other$backupDirectory != null : !this$backupDirectory.equals(other$backupDirectory)) {
            return false;
        }
        Map<String, Boolean> this$dontShowAgainMap = this.getDontShowAgainMap();
        Map<String, Boolean> other$dontShowAgainMap = other.getDontShowAgainMap();
        if (this$dontShowAgainMap == null ? other$dontShowAgainMap != null : !((Object)this$dontShowAgainMap).equals(other$dontShowAgainMap)) {
            return false;
        }
        haveno.core.locale.TradeCurrency this$preferredTradeCurrency = this.getPreferredTradeCurrency();
        haveno.core.locale.TradeCurrency other$preferredTradeCurrency = other.getPreferredTradeCurrency();
        if (this$preferredTradeCurrency == null ? other$preferredTradeCurrency != null : !((Object)this$preferredTradeCurrency).equals(other$preferredTradeCurrency)) {
            return false;
        }
        String this$offerBookChartScreenCurrencyCode = this.getOfferBookChartScreenCurrencyCode();
        String other$offerBookChartScreenCurrencyCode = other.getOfferBookChartScreenCurrencyCode();
        if (this$offerBookChartScreenCurrencyCode == null ? other$offerBookChartScreenCurrencyCode != null : !this$offerBookChartScreenCurrencyCode.equals(other$offerBookChartScreenCurrencyCode)) {
            return false;
        }
        String this$tradeChartsScreenCurrencyCode = this.getTradeChartsScreenCurrencyCode();
        String other$tradeChartsScreenCurrencyCode = other.getTradeChartsScreenCurrencyCode();
        if (this$tradeChartsScreenCurrencyCode == null ? other$tradeChartsScreenCurrencyCode != null : !this$tradeChartsScreenCurrencyCode.equals(other$tradeChartsScreenCurrencyCode)) {
            return false;
        }
        String this$buyScreenCurrencyCode = this.getBuyScreenCurrencyCode();
        String other$buyScreenCurrencyCode = other.getBuyScreenCurrencyCode();
        if (this$buyScreenCurrencyCode == null ? other$buyScreenCurrencyCode != null : !this$buyScreenCurrencyCode.equals(other$buyScreenCurrencyCode)) {
            return false;
        }
        String this$sellScreenCurrencyCode = this.getSellScreenCurrencyCode();
        String other$sellScreenCurrencyCode = other.getSellScreenCurrencyCode();
        if (this$sellScreenCurrencyCode == null ? other$sellScreenCurrencyCode != null : !this$sellScreenCurrencyCode.equals(other$sellScreenCurrencyCode)) {
            return false;
        }
        String this$buyScreenCryptoCurrencyCode = this.getBuyScreenCryptoCurrencyCode();
        String other$buyScreenCryptoCurrencyCode = other.getBuyScreenCryptoCurrencyCode();
        if (this$buyScreenCryptoCurrencyCode == null ? other$buyScreenCryptoCurrencyCode != null : !this$buyScreenCryptoCurrencyCode.equals(other$buyScreenCryptoCurrencyCode)) {
            return false;
        }
        String this$sellScreenCryptoCurrencyCode = this.getSellScreenCryptoCurrencyCode();
        String other$sellScreenCryptoCurrencyCode = other.getSellScreenCryptoCurrencyCode();
        if (this$sellScreenCryptoCurrencyCode == null ? other$sellScreenCryptoCurrencyCode != null : !this$sellScreenCryptoCurrencyCode.equals(other$sellScreenCryptoCurrencyCode)) {
            return false;
        }
        String this$buyScreenOtherCurrencyCode = this.getBuyScreenOtherCurrencyCode();
        String other$buyScreenOtherCurrencyCode = other.getBuyScreenOtherCurrencyCode();
        if (this$buyScreenOtherCurrencyCode == null ? other$buyScreenOtherCurrencyCode != null : !this$buyScreenOtherCurrencyCode.equals(other$buyScreenOtherCurrencyCode)) {
            return false;
        }
        String this$sellScreenOtherCurrencyCode = this.getSellScreenOtherCurrencyCode();
        String other$sellScreenOtherCurrencyCode = other.getSellScreenOtherCurrencyCode();
        if (this$sellScreenOtherCurrencyCode == null ? other$sellScreenOtherCurrencyCode != null : !this$sellScreenOtherCurrencyCode.equals(other$sellScreenOtherCurrencyCode)) {
            return false;
        }
        Map<String, String> this$peerTagMap = this.getPeerTagMap();
        Map<String, String> other$peerTagMap = other.getPeerTagMap();
        if (this$peerTagMap == null ? other$peerTagMap != null : !((Object)this$peerTagMap).equals(other$peerTagMap)) {
            return false;
        }
        String this$moneroNodes = this.getMoneroNodes();
        String other$moneroNodes = other.getMoneroNodes();
        if (this$moneroNodes == null ? other$moneroNodes != null : !this$moneroNodes.equals(other$moneroNodes)) {
            return false;
        }
        List<String> this$ignoreTradersList = this.getIgnoreTradersList();
        List<String> other$ignoreTradersList = other.getIgnoreTradersList();
        if (this$ignoreTradersList == null ? other$ignoreTradersList != null : !((Object)this$ignoreTradersList).equals(other$ignoreTradersList)) {
            return false;
        }
        String this$directoryChooserPath = this.getDirectoryChooserPath();
        String other$directoryChooserPath = other.getDirectoryChooserPath();
        if (this$directoryChooserPath == null ? other$directoryChooserPath != null : !this$directoryChooserPath.equals(other$directoryChooserPath)) {
            return false;
        }
        PaymentAccount this$selectedPaymentAccountForCreateOffer = this.getSelectedPaymentAccountForCreateOffer();
        PaymentAccount other$selectedPaymentAccountForCreateOffer = other.getSelectedPaymentAccountForCreateOffer();
        if (this$selectedPaymentAccountForCreateOffer == null ? other$selectedPaymentAccountForCreateOffer != null : !((Object)this$selectedPaymentAccountForCreateOffer).equals(other$selectedPaymentAccountForCreateOffer)) {
            return false;
        }
        List<String> this$bridgeAddresses = this.getBridgeAddresses();
        List<String> other$bridgeAddresses = other.getBridgeAddresses();
        if (this$bridgeAddresses == null ? other$bridgeAddresses != null : !((Object)this$bridgeAddresses).equals(other$bridgeAddresses)) {
            return false;
        }
        String this$customBridges = this.getCustomBridges();
        String other$customBridges = other.getCustomBridges();
        if (this$customBridges == null ? other$customBridges != null : !this$customBridges.equals(other$customBridges)) {
            return false;
        }
        String this$referralId = this.getReferralId();
        String other$referralId = other.getReferralId();
        if (this$referralId == null ? other$referralId != null : !this$referralId.equals(other$referralId)) {
            return false;
        }
        String this$phoneKeyAndToken = this.getPhoneKeyAndToken();
        String other$phoneKeyAndToken = other.getPhoneKeyAndToken();
        if (this$phoneKeyAndToken == null ? other$phoneKeyAndToken != null : !this$phoneKeyAndToken.equals(other$phoneKeyAndToken)) {
            return false;
        }
        String this$rpcUser = this.getRpcUser();
        String other$rpcUser = other.getRpcUser();
        if (this$rpcUser == null ? other$rpcUser != null : !this$rpcUser.equals(other$rpcUser)) {
            return false;
        }
        String this$rpcPw = this.getRpcPw();
        String other$rpcPw = other.getRpcPw();
        if (this$rpcPw == null ? other$rpcPw != null : !this$rpcPw.equals(other$rpcPw)) {
            return false;
        }
        String this$takeOfferSelectedPaymentAccountId = this.getTakeOfferSelectedPaymentAccountId();
        String other$takeOfferSelectedPaymentAccountId = other.getTakeOfferSelectedPaymentAccountId();
        if (this$takeOfferSelectedPaymentAccountId == null ? other$takeOfferSelectedPaymentAccountId != null : !this$takeOfferSelectedPaymentAccountId.equals(other$takeOfferSelectedPaymentAccountId)) {
            return false;
        }
        List<AutoConfirmSettings> this$autoConfirmSettingsList = this.getAutoConfirmSettingsList();
        List<AutoConfirmSettings> other$autoConfirmSettingsList = other.getAutoConfirmSettingsList();
        if (this$autoConfirmSettingsList == null ? other$autoConfirmSettingsList != null : !((Object)this$autoConfirmSettingsList).equals(other$autoConfirmSettingsList)) {
            return false;
        }
        XmrNodeSettings this$xmrNodeSettings = this.getXmrNodeSettings();
        XmrNodeSettings other$xmrNodeSettings = other.getXmrNodeSettings();
        return !(this$xmrNodeSettings == null ? other$xmrNodeSettings != null : !((Object)this$xmrNodeSettings).equals(other$xmrNodeSettings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoSelectArbitrators() ? 79 : 97);
        result = result * 59 + (this.isTacAccepted() ? 79 : 97);
        result = result * 59 + (this.isSplitOfferOutput() ? 79 : 97);
        result = result * 59 + (this.isShowOwnOffersInOfferBook() ? 79 : 97);
        long $withdrawalTxFeeInVbytes = this.getWithdrawalTxFeeInVbytes();
        result = result * 59 + (int)($withdrawalTxFeeInVbytes >>> 32 ^ $withdrawalTxFeeInVbytes);
        result = result * 59 + (this.isUseCustomWithdrawalTxFee() ? 79 : 97);
        long $maxPriceDistanceInPercent = Double.doubleToLongBits(this.getMaxPriceDistanceInPercent());
        result = result * 59 + (int)($maxPriceDistanceInPercent >>> 32 ^ $maxPriceDistanceInPercent);
        result = result * 59 + this.getTradeStatisticsTickUnitIndex();
        result = result * 59 + (this.isResyncSpvRequested() ? 79 : 97);
        result = result * 59 + (this.isSortMarketCurrenciesNumerically() ? 79 : 97);
        result = result * 59 + (this.isUsePercentageBasedPrice() ? 79 : 97);
        result = result * 59 + (this.isUseAnimations() ? 79 : 97);
        result = result * 59 + this.getCssTheme();
        result = result * 59 + this.getBridgeOptionOrdinal();
        result = result * 59 + this.getTorTransportOrdinal();
        result = result * 59 + this.getUseTorForXmrOrdinal();
        result = result * 59 + this.getMoneroNodesOptionOrdinal();
        result = result * 59 + (this.isUseSoundForMobileNotifications() ? 79 : 97);
        result = result * 59 + (this.isUseTradeNotifications() ? 79 : 97);
        result = result * 59 + (this.isUseMarketNotifications() ? 79 : 97);
        result = result * 59 + (this.isUsePriceNotifications() ? 79 : 97);
        result = result * 59 + (this.isUseStandbyMode() ? 79 : 97);
        result = result * 59 + (this.isUseSoundForNotifications() ? 79 : 97);
        result = result * 59 + (this.isUseSoundForNotificationsInitialized() ? 79 : 97);
        long $securityDepositAsPercent = Double.doubleToLongBits(this.getSecurityDepositAsPercent());
        result = result * 59 + (int)($securityDepositAsPercent >>> 32 ^ $securityDepositAsPercent);
        result = result * 59 + this.getIgnoreDustThreshold();
        result = result * 59 + this.getClearDataAfterDays();
        long $securityDepositAsPercentForCrypto = Double.doubleToLongBits(this.getSecurityDepositAsPercentForCrypto());
        result = result * 59 + (int)($securityDepositAsPercentForCrypto >>> 32 ^ $securityDepositAsPercentForCrypto);
        result = result * 59 + this.getBlockNotifyPort();
        result = result * 59 + (this.isTacAcceptedV120() ? 79 : 97);
        long $bsqAverageTrimThreshold = Double.doubleToLongBits(this.getBsqAverageTrimThreshold());
        result = result * 59 + (int)($bsqAverageTrimThreshold >>> 32 ^ $bsqAverageTrimThreshold);
        result = result * 59 + (this.isHideNonAccountPaymentMethods() ? 79 : 97);
        result = result * 59 + (this.isShowOffersMatchingMyAccounts() ? 79 : 97);
        result = result * 59 + (this.isShowPrivateOffers() ? 79 : 97);
        result = result * 59 + (this.isDenyApiTaker() ? 79 : 97);
        result = result * 59 + (this.isNotifyOnPreRelease() ? 79 : 97);
        String $userLanguage = this.getUserLanguage();
        result = result * 59 + ($userLanguage == null ? 43 : $userLanguage.hashCode());
        haveno.core.locale.Country $userCountry = this.getUserCountry();
        result = result * 59 + ($userCountry == null ? 43 : ((Object)$userCountry).hashCode());
        List<TraditionalCurrency> $traditionalCurrencies = this.getTraditionalCurrencies();
        result = result * 59 + ($traditionalCurrencies == null ? 43 : ((Object)$traditionalCurrencies).hashCode());
        List<CryptoCurrency> $cryptoCurrencies = this.getCryptoCurrencies();
        result = result * 59 + ($cryptoCurrencies == null ? 43 : ((Object)$cryptoCurrencies).hashCode());
        BlockChainExplorer $blockChainExplorerMainNet = this.getBlockChainExplorerMainNet();
        result = result * 59 + ($blockChainExplorerMainNet == null ? 43 : $blockChainExplorerMainNet.hashCode());
        BlockChainExplorer $blockChainExplorerTestNet = this.getBlockChainExplorerTestNet();
        result = result * 59 + ($blockChainExplorerTestNet == null ? 43 : $blockChainExplorerTestNet.hashCode());
        String $backupDirectory = this.getBackupDirectory();
        result = result * 59 + ($backupDirectory == null ? 43 : $backupDirectory.hashCode());
        Map<String, Boolean> $dontShowAgainMap = this.getDontShowAgainMap();
        result = result * 59 + ($dontShowAgainMap == null ? 43 : ((Object)$dontShowAgainMap).hashCode());
        haveno.core.locale.TradeCurrency $preferredTradeCurrency = this.getPreferredTradeCurrency();
        result = result * 59 + ($preferredTradeCurrency == null ? 43 : ((Object)$preferredTradeCurrency).hashCode());
        String $offerBookChartScreenCurrencyCode = this.getOfferBookChartScreenCurrencyCode();
        result = result * 59 + ($offerBookChartScreenCurrencyCode == null ? 43 : $offerBookChartScreenCurrencyCode.hashCode());
        String $tradeChartsScreenCurrencyCode = this.getTradeChartsScreenCurrencyCode();
        result = result * 59 + ($tradeChartsScreenCurrencyCode == null ? 43 : $tradeChartsScreenCurrencyCode.hashCode());
        String $buyScreenCurrencyCode = this.getBuyScreenCurrencyCode();
        result = result * 59 + ($buyScreenCurrencyCode == null ? 43 : $buyScreenCurrencyCode.hashCode());
        String $sellScreenCurrencyCode = this.getSellScreenCurrencyCode();
        result = result * 59 + ($sellScreenCurrencyCode == null ? 43 : $sellScreenCurrencyCode.hashCode());
        String $buyScreenCryptoCurrencyCode = this.getBuyScreenCryptoCurrencyCode();
        result = result * 59 + ($buyScreenCryptoCurrencyCode == null ? 43 : $buyScreenCryptoCurrencyCode.hashCode());
        String $sellScreenCryptoCurrencyCode = this.getSellScreenCryptoCurrencyCode();
        result = result * 59 + ($sellScreenCryptoCurrencyCode == null ? 43 : $sellScreenCryptoCurrencyCode.hashCode());
        String $buyScreenOtherCurrencyCode = this.getBuyScreenOtherCurrencyCode();
        result = result * 59 + ($buyScreenOtherCurrencyCode == null ? 43 : $buyScreenOtherCurrencyCode.hashCode());
        String $sellScreenOtherCurrencyCode = this.getSellScreenOtherCurrencyCode();
        result = result * 59 + ($sellScreenOtherCurrencyCode == null ? 43 : $sellScreenOtherCurrencyCode.hashCode());
        Map<String, String> $peerTagMap = this.getPeerTagMap();
        result = result * 59 + ($peerTagMap == null ? 43 : ((Object)$peerTagMap).hashCode());
        String $moneroNodes = this.getMoneroNodes();
        result = result * 59 + ($moneroNodes == null ? 43 : $moneroNodes.hashCode());
        List<String> $ignoreTradersList = this.getIgnoreTradersList();
        result = result * 59 + ($ignoreTradersList == null ? 43 : ((Object)$ignoreTradersList).hashCode());
        String $directoryChooserPath = this.getDirectoryChooserPath();
        result = result * 59 + ($directoryChooserPath == null ? 43 : $directoryChooserPath.hashCode());
        PaymentAccount $selectedPaymentAccountForCreateOffer = this.getSelectedPaymentAccountForCreateOffer();
        result = result * 59 + ($selectedPaymentAccountForCreateOffer == null ? 43 : ((Object)$selectedPaymentAccountForCreateOffer).hashCode());
        List<String> $bridgeAddresses = this.getBridgeAddresses();
        result = result * 59 + ($bridgeAddresses == null ? 43 : ((Object)$bridgeAddresses).hashCode());
        String $customBridges = this.getCustomBridges();
        result = result * 59 + ($customBridges == null ? 43 : $customBridges.hashCode());
        String $referralId = this.getReferralId();
        result = result * 59 + ($referralId == null ? 43 : $referralId.hashCode());
        String $phoneKeyAndToken = this.getPhoneKeyAndToken();
        result = result * 59 + ($phoneKeyAndToken == null ? 43 : $phoneKeyAndToken.hashCode());
        String $rpcUser = this.getRpcUser();
        result = result * 59 + ($rpcUser == null ? 43 : $rpcUser.hashCode());
        String $rpcPw = this.getRpcPw();
        result = result * 59 + ($rpcPw == null ? 43 : $rpcPw.hashCode());
        String $takeOfferSelectedPaymentAccountId = this.getTakeOfferSelectedPaymentAccountId();
        result = result * 59 + ($takeOfferSelectedPaymentAccountId == null ? 43 : $takeOfferSelectedPaymentAccountId.hashCode());
        List<AutoConfirmSettings> $autoConfirmSettingsList = this.getAutoConfirmSettingsList();
        result = result * 59 + ($autoConfirmSettingsList == null ? 43 : ((Object)$autoConfirmSettingsList).hashCode());
        XmrNodeSettings $xmrNodeSettings = this.getXmrNodeSettings();
        result = result * 59 + ($xmrNodeSettings == null ? 43 : ((Object)$xmrNodeSettings).hashCode());
        return result;
    }

    public String toString() {
        return "PreferencesPayload(userLanguage=" + this.getUserLanguage() + ", userCountry=" + String.valueOf(this.getUserCountry()) + ", traditionalCurrencies=" + String.valueOf(this.getTraditionalCurrencies()) + ", cryptoCurrencies=" + String.valueOf(this.getCryptoCurrencies()) + ", blockChainExplorerMainNet=" + String.valueOf(this.getBlockChainExplorerMainNet()) + ", blockChainExplorerTestNet=" + String.valueOf(this.getBlockChainExplorerTestNet()) + ", backupDirectory=" + this.getBackupDirectory() + ", autoSelectArbitrators=" + this.isAutoSelectArbitrators() + ", dontShowAgainMap=" + String.valueOf(this.getDontShowAgainMap()) + ", tacAccepted=" + this.isTacAccepted() + ", splitOfferOutput=" + this.isSplitOfferOutput() + ", showOwnOffersInOfferBook=" + this.isShowOwnOffersInOfferBook() + ", preferredTradeCurrency=" + String.valueOf(this.getPreferredTradeCurrency()) + ", withdrawalTxFeeInVbytes=" + this.getWithdrawalTxFeeInVbytes() + ", useCustomWithdrawalTxFee=" + this.isUseCustomWithdrawalTxFee() + ", maxPriceDistanceInPercent=" + this.getMaxPriceDistanceInPercent() + ", offerBookChartScreenCurrencyCode=" + this.getOfferBookChartScreenCurrencyCode() + ", tradeChartsScreenCurrencyCode=" + this.getTradeChartsScreenCurrencyCode() + ", buyScreenCurrencyCode=" + this.getBuyScreenCurrencyCode() + ", sellScreenCurrencyCode=" + this.getSellScreenCurrencyCode() + ", buyScreenCryptoCurrencyCode=" + this.getBuyScreenCryptoCurrencyCode() + ", sellScreenCryptoCurrencyCode=" + this.getSellScreenCryptoCurrencyCode() + ", buyScreenOtherCurrencyCode=" + this.getBuyScreenOtherCurrencyCode() + ", sellScreenOtherCurrencyCode=" + this.getSellScreenOtherCurrencyCode() + ", tradeStatisticsTickUnitIndex=" + this.getTradeStatisticsTickUnitIndex() + ", resyncSpvRequested=" + this.isResyncSpvRequested() + ", sortMarketCurrenciesNumerically=" + this.isSortMarketCurrenciesNumerically() + ", usePercentageBasedPrice=" + this.isUsePercentageBasedPrice() + ", peerTagMap=" + String.valueOf(this.getPeerTagMap()) + ", moneroNodes=" + this.getMoneroNodes() + ", ignoreTradersList=" + String.valueOf(this.getIgnoreTradersList()) + ", directoryChooserPath=" + this.getDirectoryChooserPath() + ", useAnimations=" + this.isUseAnimations() + ", cssTheme=" + this.getCssTheme() + ", selectedPaymentAccountForCreateOffer=" + String.valueOf(this.getSelectedPaymentAccountForCreateOffer()) + ", bridgeAddresses=" + String.valueOf(this.getBridgeAddresses()) + ", bridgeOptionOrdinal=" + this.getBridgeOptionOrdinal() + ", torTransportOrdinal=" + this.getTorTransportOrdinal() + ", customBridges=" + this.getCustomBridges() + ", useTorForXmrOrdinal=" + this.getUseTorForXmrOrdinal() + ", moneroNodesOptionOrdinal=" + this.getMoneroNodesOptionOrdinal() + ", referralId=" + this.getReferralId() + ", phoneKeyAndToken=" + this.getPhoneKeyAndToken() + ", useSoundForMobileNotifications=" + this.isUseSoundForMobileNotifications() + ", useTradeNotifications=" + this.isUseTradeNotifications() + ", useMarketNotifications=" + this.isUseMarketNotifications() + ", usePriceNotifications=" + this.isUsePriceNotifications() + ", useStandbyMode=" + this.isUseStandbyMode() + ", useSoundForNotifications=" + this.isUseSoundForNotifications() + ", useSoundForNotificationsInitialized=" + this.isUseSoundForNotificationsInitialized() + ", rpcUser=" + this.getRpcUser() + ", rpcPw=" + this.getRpcPw() + ", takeOfferSelectedPaymentAccountId=" + this.getTakeOfferSelectedPaymentAccountId() + ", securityDepositAsPercent=" + this.getSecurityDepositAsPercent() + ", ignoreDustThreshold=" + this.getIgnoreDustThreshold() + ", clearDataAfterDays=" + this.getClearDataAfterDays() + ", securityDepositAsPercentForCrypto=" + this.getSecurityDepositAsPercentForCrypto() + ", blockNotifyPort=" + this.getBlockNotifyPort() + ", tacAcceptedV120=" + this.isTacAcceptedV120() + ", bsqAverageTrimThreshold=" + this.getBsqAverageTrimThreshold() + ", autoConfirmSettingsList=" + String.valueOf(this.getAutoConfirmSettingsList()) + ", hideNonAccountPaymentMethods=" + this.isHideNonAccountPaymentMethods() + ", showOffersMatchingMyAccounts=" + this.isShowOffersMatchingMyAccounts() + ", showPrivateOffers=" + this.isShowPrivateOffers() + ", denyApiTaker=" + this.isDenyApiTaker() + ", notifyOnPreRelease=" + this.isNotifyOnPreRelease() + ", xmrNodeSettings=" + String.valueOf(this.getXmrNodeSettings()) + ")";
    }

    public PreferencesPayload(String userLanguage, haveno.core.locale.Country userCountry, List<TraditionalCurrency> traditionalCurrencies, List<CryptoCurrency> cryptoCurrencies, BlockChainExplorer blockChainExplorerMainNet, BlockChainExplorer blockChainExplorerTestNet, @Nullable String backupDirectory, boolean autoSelectArbitrators, Map<String, Boolean> dontShowAgainMap, boolean tacAccepted, boolean splitOfferOutput, boolean showOwnOffersInOfferBook, @Nullable haveno.core.locale.TradeCurrency preferredTradeCurrency, long withdrawalTxFeeInVbytes, boolean useCustomWithdrawalTxFee, double maxPriceDistanceInPercent, @Nullable String offerBookChartScreenCurrencyCode, @Nullable String tradeChartsScreenCurrencyCode, @Nullable String buyScreenCurrencyCode, @Nullable String sellScreenCurrencyCode, @Nullable String buyScreenCryptoCurrencyCode, @Nullable String sellScreenCryptoCurrencyCode, @Nullable String buyScreenOtherCurrencyCode, @Nullable String sellScreenOtherCurrencyCode, int tradeStatisticsTickUnitIndex, boolean resyncSpvRequested, boolean sortMarketCurrenciesNumerically, boolean usePercentageBasedPrice, Map<String, String> peerTagMap, String moneroNodes, List<String> ignoreTradersList, String directoryChooserPath, boolean useAnimations, int cssTheme, @Nullable PaymentAccount selectedPaymentAccountForCreateOffer, @Nullable List<String> bridgeAddresses, int bridgeOptionOrdinal, int torTransportOrdinal, @Nullable String customBridges, int useTorForXmrOrdinal, int moneroNodesOptionOrdinal, @Nullable String referralId, @Nullable String phoneKeyAndToken, boolean useSoundForMobileNotifications, boolean useTradeNotifications, boolean useMarketNotifications, boolean usePriceNotifications, boolean useStandbyMode, boolean useSoundForNotifications, boolean useSoundForNotificationsInitialized, @Nullable String rpcUser, @Nullable String rpcPw, @Nullable String takeOfferSelectedPaymentAccountId, double securityDepositAsPercent, int ignoreDustThreshold, int clearDataAfterDays, double securityDepositAsPercentForCrypto, int blockNotifyPort, boolean tacAcceptedV120, double bsqAverageTrimThreshold, List<AutoConfirmSettings> autoConfirmSettingsList, boolean hideNonAccountPaymentMethods, boolean showOffersMatchingMyAccounts, boolean showPrivateOffers, boolean denyApiTaker, boolean notifyOnPreRelease, XmrNodeSettings xmrNodeSettings) {
        this.userLanguage = userLanguage;
        this.userCountry = userCountry;
        this.traditionalCurrencies = traditionalCurrencies;
        this.cryptoCurrencies = cryptoCurrencies;
        this.blockChainExplorerMainNet = blockChainExplorerMainNet;
        this.blockChainExplorerTestNet = blockChainExplorerTestNet;
        this.backupDirectory = backupDirectory;
        this.autoSelectArbitrators = autoSelectArbitrators;
        this.dontShowAgainMap = dontShowAgainMap;
        this.tacAccepted = tacAccepted;
        this.splitOfferOutput = splitOfferOutput;
        this.showOwnOffersInOfferBook = showOwnOffersInOfferBook;
        this.preferredTradeCurrency = preferredTradeCurrency;
        this.withdrawalTxFeeInVbytes = withdrawalTxFeeInVbytes;
        this.useCustomWithdrawalTxFee = useCustomWithdrawalTxFee;
        this.maxPriceDistanceInPercent = maxPriceDistanceInPercent;
        this.offerBookChartScreenCurrencyCode = offerBookChartScreenCurrencyCode;
        this.tradeChartsScreenCurrencyCode = tradeChartsScreenCurrencyCode;
        this.buyScreenCurrencyCode = buyScreenCurrencyCode;
        this.sellScreenCurrencyCode = sellScreenCurrencyCode;
        this.buyScreenCryptoCurrencyCode = buyScreenCryptoCurrencyCode;
        this.sellScreenCryptoCurrencyCode = sellScreenCryptoCurrencyCode;
        this.buyScreenOtherCurrencyCode = buyScreenOtherCurrencyCode;
        this.sellScreenOtherCurrencyCode = sellScreenOtherCurrencyCode;
        this.tradeStatisticsTickUnitIndex = tradeStatisticsTickUnitIndex;
        this.resyncSpvRequested = resyncSpvRequested;
        this.sortMarketCurrenciesNumerically = sortMarketCurrenciesNumerically;
        this.usePercentageBasedPrice = usePercentageBasedPrice;
        this.peerTagMap = peerTagMap;
        this.moneroNodes = moneroNodes;
        this.ignoreTradersList = ignoreTradersList;
        this.directoryChooserPath = directoryChooserPath;
        this.useAnimations = useAnimations;
        this.cssTheme = cssTheme;
        this.selectedPaymentAccountForCreateOffer = selectedPaymentAccountForCreateOffer;
        this.bridgeAddresses = bridgeAddresses;
        this.bridgeOptionOrdinal = bridgeOptionOrdinal;
        this.torTransportOrdinal = torTransportOrdinal;
        this.customBridges = customBridges;
        this.useTorForXmrOrdinal = useTorForXmrOrdinal;
        this.moneroNodesOptionOrdinal = moneroNodesOptionOrdinal;
        this.referralId = referralId;
        this.phoneKeyAndToken = phoneKeyAndToken;
        this.useSoundForMobileNotifications = useSoundForMobileNotifications;
        this.useTradeNotifications = useTradeNotifications;
        this.useMarketNotifications = useMarketNotifications;
        this.usePriceNotifications = usePriceNotifications;
        this.useStandbyMode = useStandbyMode;
        this.useSoundForNotifications = useSoundForNotifications;
        this.useSoundForNotificationsInitialized = useSoundForNotificationsInitialized;
        this.rpcUser = rpcUser;
        this.rpcPw = rpcPw;
        this.takeOfferSelectedPaymentAccountId = takeOfferSelectedPaymentAccountId;
        this.securityDepositAsPercent = securityDepositAsPercent;
        this.ignoreDustThreshold = ignoreDustThreshold;
        this.clearDataAfterDays = clearDataAfterDays;
        this.securityDepositAsPercentForCrypto = securityDepositAsPercentForCrypto;
        this.blockNotifyPort = blockNotifyPort;
        this.tacAcceptedV120 = tacAcceptedV120;
        this.bsqAverageTrimThreshold = bsqAverageTrimThreshold;
        this.autoConfirmSettingsList = autoConfirmSettingsList;
        this.hideNonAccountPaymentMethods = hideNonAccountPaymentMethods;
        this.showOffersMatchingMyAccounts = showOffersMatchingMyAccounts;
        this.showPrivateOffers = showPrivateOffers;
        this.denyApiTaker = denyApiTaker;
        this.notifyOnPreRelease = notifyOnPreRelease;
        this.xmrNodeSettings = xmrNodeSettings;
    }
}

