/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.user;

import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.core.alert.Alert;
import haveno.core.filter.Filter;
import haveno.core.notifications.alerts.market.MarketAlertFilter;
import haveno.core.notifications.alerts.price.PriceAlertFilter;
import haveno.core.payment.PaymentAccount;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.core.user.Cookie;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.StoragePayload;
import protobuf.UserPayload;

public class UserPayload
implements PersistableEnvelope {
    private static final Logger log = LoggerFactory.getLogger(UserPayload.class);
    @Nullable
    private String accountId;
    @Nullable
    private Set<PaymentAccount> paymentAccounts = new HashSet<PaymentAccount>();
    @Nullable
    private PaymentAccount currentPaymentAccount;
    @Nullable
    private List<String> acceptedLanguageLocaleCodes = new ArrayList<String>();
    @Nullable
    private Alert developersAlert;
    @Nullable
    private Alert displayedAlert;
    @Nullable
    private Filter developersFilter;
    @Nullable
    private Arbitrator registeredArbitrator;
    @Nullable
    private Mediator registeredMediator;
    @Nullable
    private List<Arbitrator> acceptedArbitrators = new ArrayList<Arbitrator>();
    @Nullable
    private List<Mediator> acceptedMediators = new ArrayList<Mediator>();
    @Nullable
    private PriceAlertFilter priceAlertFilter;
    @Nullable
    private List<MarketAlertFilter> marketAlertFilters = new ArrayList<MarketAlertFilter>();
    @Nullable
    private RefundAgent registeredRefundAgent;
    @Nullable
    private List<RefundAgent> acceptedRefundAgents = new ArrayList<RefundAgent>();
    private Cookie cookie = new Cookie();
    private long walletCreationDate;

    public UserPayload() {
    }

    @Override
    public protobuf.PersistableEnvelope toProtoMessage() {
        UserPayload.Builder builder = protobuf.UserPayload.newBuilder();
        Optional.ofNullable(this.accountId).ifPresent(e -> builder.setAccountId(this.accountId));
        Optional.ofNullable(this.paymentAccounts).ifPresent(e -> builder.addAllPaymentAccounts(ProtoUtil.collectionToProto(this.paymentAccounts, protobuf.PaymentAccount.class)));
        Optional.ofNullable(this.currentPaymentAccount).ifPresent(e -> builder.setCurrentPaymentAccount(this.currentPaymentAccount.toProtoMessage()));
        Optional.ofNullable(this.acceptedLanguageLocaleCodes).ifPresent(e -> builder.addAllAcceptedLanguageLocaleCodes(this.acceptedLanguageLocaleCodes));
        Optional.ofNullable(this.developersAlert).ifPresent(developersAlert -> builder.setDevelopersAlert(developersAlert.toProtoMessage().getAlert()));
        Optional.ofNullable(this.displayedAlert).ifPresent(displayedAlert -> builder.setDisplayedAlert(displayedAlert.toProtoMessage().getAlert()));
        Optional.ofNullable(this.developersFilter).ifPresent(developersFilter -> builder.setDevelopersFilter(developersFilter.toProtoMessage().getFilter()));
        Optional.ofNullable(this.registeredArbitrator).ifPresent(registeredArbitrator -> builder.setRegisteredArbitrator(registeredArbitrator.toProtoMessage().getArbitrator()));
        Optional.ofNullable(this.registeredMediator).ifPresent(registeredMediator -> builder.setRegisteredMediator(registeredMediator.toProtoMessage().getMediator()));
        Optional.ofNullable(this.acceptedArbitrators).ifPresent(e -> builder.addAllAcceptedArbitrators(ProtoUtil.collectionToProto(this.acceptedArbitrators, message -> ((StoragePayload)message).getArbitrator())));
        Optional.ofNullable(this.acceptedMediators).ifPresent(e -> builder.addAllAcceptedMediators(ProtoUtil.collectionToProto(this.acceptedMediators, message -> ((StoragePayload)message).getMediator())));
        Optional.ofNullable(this.priceAlertFilter).ifPresent(priceAlertFilter -> builder.setPriceAlertFilter(priceAlertFilter.toProtoMessage()));
        Optional.ofNullable(this.marketAlertFilters).ifPresent(e -> builder.addAllMarketAlertFilters(ProtoUtil.collectionToProto(this.marketAlertFilters, protobuf.MarketAlertFilter.class)));
        Optional.ofNullable(this.registeredRefundAgent).ifPresent(registeredRefundAgent -> builder.setRegisteredRefundAgent(registeredRefundAgent.toProtoMessage().getRefundAgent()));
        Optional.ofNullable(this.acceptedRefundAgents).ifPresent(e -> builder.addAllAcceptedRefundAgents(ProtoUtil.collectionToProto(this.acceptedRefundAgents, message -> ((StoragePayload)message).getRefundAgent())));
        Optional.ofNullable(this.cookie).ifPresent(e -> builder.putAllCookie(this.cookie.toProtoMessage()));
        builder.setWalletCreationDate(this.walletCreationDate);
        return protobuf.PersistableEnvelope.newBuilder().setUserPayload(builder).build();
    }

    public static UserPayload fromProto(protobuf.UserPayload proto, CoreProtoResolver coreProtoResolver) {
        return new UserPayload(ProtoUtil.stringOrNullFromProto(proto.getAccountId()), proto.getPaymentAccountsList().isEmpty() ? new HashSet<PaymentAccount>() : new HashSet(proto.getPaymentAccountsList().stream().map(e -> PaymentAccount.fromProto(e, coreProtoResolver)).filter(Objects::nonNull).collect(Collectors.toSet())), proto.hasCurrentPaymentAccount() ? PaymentAccount.fromProto(proto.getCurrentPaymentAccount(), coreProtoResolver) : null, proto.getAcceptedLanguageLocaleCodesList().isEmpty() ? new ArrayList<String>() : new ArrayList<String>(proto.getAcceptedLanguageLocaleCodesList()), proto.hasDevelopersAlert() ? Alert.fromProto(proto.getDevelopersAlert()) : null, proto.hasDisplayedAlert() ? Alert.fromProto(proto.getDisplayedAlert()) : null, proto.hasDevelopersFilter() ? Filter.fromProto(proto.getDevelopersFilter()) : null, proto.hasRegisteredArbitrator() ? Arbitrator.fromProto(proto.getRegisteredArbitrator()) : null, proto.hasRegisteredMediator() ? Mediator.fromProto(proto.getRegisteredMediator()) : null, proto.getAcceptedArbitratorsList().isEmpty() ? new ArrayList<Arbitrator>() : new ArrayList(proto.getAcceptedArbitratorsList().stream().map(Arbitrator::fromProto).collect(Collectors.toList())), proto.getAcceptedMediatorsList().isEmpty() ? new ArrayList<Mediator>() : new ArrayList(proto.getAcceptedMediatorsList().stream().map(Mediator::fromProto).collect(Collectors.toList())), PriceAlertFilter.fromProto(proto.getPriceAlertFilter()), proto.getMarketAlertFiltersList().isEmpty() ? new ArrayList<MarketAlertFilter>() : new ArrayList(proto.getMarketAlertFiltersList().stream().map(e -> MarketAlertFilter.fromProto(e, coreProtoResolver)).collect(Collectors.toSet())), proto.hasRegisteredRefundAgent() ? RefundAgent.fromProto(proto.getRegisteredRefundAgent()) : null, proto.getAcceptedRefundAgentsList().isEmpty() ? new ArrayList<RefundAgent>() : new ArrayList(proto.getAcceptedRefundAgentsList().stream().map(RefundAgent::fromProto).collect(Collectors.toList())), Cookie.fromProto(proto.getCookieMap()), proto.getWalletCreationDate());
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public Set<PaymentAccount> getPaymentAccounts() {
        return this.paymentAccounts;
    }

    @Nullable
    public PaymentAccount getCurrentPaymentAccount() {
        return this.currentPaymentAccount;
    }

    @Nullable
    public List<String> getAcceptedLanguageLocaleCodes() {
        return this.acceptedLanguageLocaleCodes;
    }

    @Nullable
    public Alert getDevelopersAlert() {
        return this.developersAlert;
    }

    @Nullable
    public Alert getDisplayedAlert() {
        return this.displayedAlert;
    }

    @Nullable
    public Filter getDevelopersFilter() {
        return this.developersFilter;
    }

    @Nullable
    public Arbitrator getRegisteredArbitrator() {
        return this.registeredArbitrator;
    }

    @Nullable
    public Mediator getRegisteredMediator() {
        return this.registeredMediator;
    }

    @Nullable
    public List<Arbitrator> getAcceptedArbitrators() {
        return this.acceptedArbitrators;
    }

    @Nullable
    public List<Mediator> getAcceptedMediators() {
        return this.acceptedMediators;
    }

    @Nullable
    public PriceAlertFilter getPriceAlertFilter() {
        return this.priceAlertFilter;
    }

    @Nullable
    public List<MarketAlertFilter> getMarketAlertFilters() {
        return this.marketAlertFilters;
    }

    @Nullable
    public RefundAgent getRegisteredRefundAgent() {
        return this.registeredRefundAgent;
    }

    @Nullable
    public List<RefundAgent> getAcceptedRefundAgents() {
        return this.acceptedRefundAgents;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public long getWalletCreationDate() {
        return this.walletCreationDate;
    }

    public void setAccountId(@Nullable String accountId) {
        this.accountId = accountId;
    }

    public void setPaymentAccounts(@Nullable Set<PaymentAccount> paymentAccounts) {
        this.paymentAccounts = paymentAccounts;
    }

    public void setCurrentPaymentAccount(@Nullable PaymentAccount currentPaymentAccount) {
        this.currentPaymentAccount = currentPaymentAccount;
    }

    public void setAcceptedLanguageLocaleCodes(@Nullable List<String> acceptedLanguageLocaleCodes) {
        this.acceptedLanguageLocaleCodes = acceptedLanguageLocaleCodes;
    }

    public void setDevelopersAlert(@Nullable Alert developersAlert) {
        this.developersAlert = developersAlert;
    }

    public void setDisplayedAlert(@Nullable Alert displayedAlert) {
        this.displayedAlert = displayedAlert;
    }

    public void setDevelopersFilter(@Nullable Filter developersFilter) {
        this.developersFilter = developersFilter;
    }

    public void setRegisteredArbitrator(@Nullable Arbitrator registeredArbitrator) {
        this.registeredArbitrator = registeredArbitrator;
    }

    public void setRegisteredMediator(@Nullable Mediator registeredMediator) {
        this.registeredMediator = registeredMediator;
    }

    public void setAcceptedArbitrators(@Nullable List<Arbitrator> acceptedArbitrators) {
        this.acceptedArbitrators = acceptedArbitrators;
    }

    public void setAcceptedMediators(@Nullable List<Mediator> acceptedMediators) {
        this.acceptedMediators = acceptedMediators;
    }

    public void setPriceAlertFilter(@Nullable PriceAlertFilter priceAlertFilter) {
        this.priceAlertFilter = priceAlertFilter;
    }

    public void setMarketAlertFilters(@Nullable List<MarketAlertFilter> marketAlertFilters) {
        this.marketAlertFilters = marketAlertFilters;
    }

    public void setRegisteredRefundAgent(@Nullable RefundAgent registeredRefundAgent) {
        this.registeredRefundAgent = registeredRefundAgent;
    }

    public void setAcceptedRefundAgents(@Nullable List<RefundAgent> acceptedRefundAgents) {
        this.acceptedRefundAgents = acceptedRefundAgents;
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public void setWalletCreationDate(long walletCreationDate) {
        this.walletCreationDate = walletCreationDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPayload)) {
            return false;
        }
        UserPayload other = (UserPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWalletCreationDate() != other.getWalletCreationDate()) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        Set<PaymentAccount> this$paymentAccounts = this.getPaymentAccounts();
        Set<PaymentAccount> other$paymentAccounts = other.getPaymentAccounts();
        if (this$paymentAccounts == null ? other$paymentAccounts != null : !((Object)this$paymentAccounts).equals(other$paymentAccounts)) {
            return false;
        }
        PaymentAccount this$currentPaymentAccount = this.getCurrentPaymentAccount();
        PaymentAccount other$currentPaymentAccount = other.getCurrentPaymentAccount();
        if (this$currentPaymentAccount == null ? other$currentPaymentAccount != null : !((Object)this$currentPaymentAccount).equals(other$currentPaymentAccount)) {
            return false;
        }
        List<String> this$acceptedLanguageLocaleCodes = this.getAcceptedLanguageLocaleCodes();
        List<String> other$acceptedLanguageLocaleCodes = other.getAcceptedLanguageLocaleCodes();
        if (this$acceptedLanguageLocaleCodes == null ? other$acceptedLanguageLocaleCodes != null : !((Object)this$acceptedLanguageLocaleCodes).equals(other$acceptedLanguageLocaleCodes)) {
            return false;
        }
        Alert this$developersAlert = this.getDevelopersAlert();
        Alert other$developersAlert = other.getDevelopersAlert();
        if (this$developersAlert == null ? other$developersAlert != null : !((Object)this$developersAlert).equals(other$developersAlert)) {
            return false;
        }
        Alert this$displayedAlert = this.getDisplayedAlert();
        Alert other$displayedAlert = other.getDisplayedAlert();
        if (this$displayedAlert == null ? other$displayedAlert != null : !((Object)this$displayedAlert).equals(other$displayedAlert)) {
            return false;
        }
        Filter this$developersFilter = this.getDevelopersFilter();
        Filter other$developersFilter = other.getDevelopersFilter();
        if (this$developersFilter == null ? other$developersFilter != null : !((Object)this$developersFilter).equals(other$developersFilter)) {
            return false;
        }
        Arbitrator this$registeredArbitrator = this.getRegisteredArbitrator();
        Arbitrator other$registeredArbitrator = other.getRegisteredArbitrator();
        if (this$registeredArbitrator == null ? other$registeredArbitrator != null : !((Object)this$registeredArbitrator).equals(other$registeredArbitrator)) {
            return false;
        }
        Mediator this$registeredMediator = this.getRegisteredMediator();
        Mediator other$registeredMediator = other.getRegisteredMediator();
        if (this$registeredMediator == null ? other$registeredMediator != null : !((Object)this$registeredMediator).equals(other$registeredMediator)) {
            return false;
        }
        List<Arbitrator> this$acceptedArbitrators = this.getAcceptedArbitrators();
        List<Arbitrator> other$acceptedArbitrators = other.getAcceptedArbitrators();
        if (this$acceptedArbitrators == null ? other$acceptedArbitrators != null : !((Object)this$acceptedArbitrators).equals(other$acceptedArbitrators)) {
            return false;
        }
        List<Mediator> this$acceptedMediators = this.getAcceptedMediators();
        List<Mediator> other$acceptedMediators = other.getAcceptedMediators();
        if (this$acceptedMediators == null ? other$acceptedMediators != null : !((Object)this$acceptedMediators).equals(other$acceptedMediators)) {
            return false;
        }
        PriceAlertFilter this$priceAlertFilter = this.getPriceAlertFilter();
        PriceAlertFilter other$priceAlertFilter = other.getPriceAlertFilter();
        if (this$priceAlertFilter == null ? other$priceAlertFilter != null : !((Object)this$priceAlertFilter).equals(other$priceAlertFilter)) {
            return false;
        }
        List<MarketAlertFilter> this$marketAlertFilters = this.getMarketAlertFilters();
        List<MarketAlertFilter> other$marketAlertFilters = other.getMarketAlertFilters();
        if (this$marketAlertFilters == null ? other$marketAlertFilters != null : !((Object)this$marketAlertFilters).equals(other$marketAlertFilters)) {
            return false;
        }
        RefundAgent this$registeredRefundAgent = this.getRegisteredRefundAgent();
        RefundAgent other$registeredRefundAgent = other.getRegisteredRefundAgent();
        if (this$registeredRefundAgent == null ? other$registeredRefundAgent != null : !((Object)this$registeredRefundAgent).equals(other$registeredRefundAgent)) {
            return false;
        }
        List<RefundAgent> this$acceptedRefundAgents = this.getAcceptedRefundAgents();
        List<RefundAgent> other$acceptedRefundAgents = other.getAcceptedRefundAgents();
        if (this$acceptedRefundAgents == null ? other$acceptedRefundAgents != null : !((Object)this$acceptedRefundAgents).equals(other$acceptedRefundAgents)) {
            return false;
        }
        Cookie this$cookie = this.getCookie();
        Cookie other$cookie = other.getCookie();
        return !(this$cookie == null ? other$cookie != null : !((Object)this$cookie).equals(other$cookie));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $walletCreationDate = this.getWalletCreationDate();
        result = result * 59 + (int)($walletCreationDate >>> 32 ^ $walletCreationDate);
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        Set<PaymentAccount> $paymentAccounts = this.getPaymentAccounts();
        result = result * 59 + ($paymentAccounts == null ? 43 : ((Object)$paymentAccounts).hashCode());
        PaymentAccount $currentPaymentAccount = this.getCurrentPaymentAccount();
        result = result * 59 + ($currentPaymentAccount == null ? 43 : ((Object)$currentPaymentAccount).hashCode());
        List<String> $acceptedLanguageLocaleCodes = this.getAcceptedLanguageLocaleCodes();
        result = result * 59 + ($acceptedLanguageLocaleCodes == null ? 43 : ((Object)$acceptedLanguageLocaleCodes).hashCode());
        Alert $developersAlert = this.getDevelopersAlert();
        result = result * 59 + ($developersAlert == null ? 43 : ((Object)$developersAlert).hashCode());
        Alert $displayedAlert = this.getDisplayedAlert();
        result = result * 59 + ($displayedAlert == null ? 43 : ((Object)$displayedAlert).hashCode());
        Filter $developersFilter = this.getDevelopersFilter();
        result = result * 59 + ($developersFilter == null ? 43 : ((Object)$developersFilter).hashCode());
        Arbitrator $registeredArbitrator = this.getRegisteredArbitrator();
        result = result * 59 + ($registeredArbitrator == null ? 43 : ((Object)$registeredArbitrator).hashCode());
        Mediator $registeredMediator = this.getRegisteredMediator();
        result = result * 59 + ($registeredMediator == null ? 43 : ((Object)$registeredMediator).hashCode());
        List<Arbitrator> $acceptedArbitrators = this.getAcceptedArbitrators();
        result = result * 59 + ($acceptedArbitrators == null ? 43 : ((Object)$acceptedArbitrators).hashCode());
        List<Mediator> $acceptedMediators = this.getAcceptedMediators();
        result = result * 59 + ($acceptedMediators == null ? 43 : ((Object)$acceptedMediators).hashCode());
        PriceAlertFilter $priceAlertFilter = this.getPriceAlertFilter();
        result = result * 59 + ($priceAlertFilter == null ? 43 : ((Object)$priceAlertFilter).hashCode());
        List<MarketAlertFilter> $marketAlertFilters = this.getMarketAlertFilters();
        result = result * 59 + ($marketAlertFilters == null ? 43 : ((Object)$marketAlertFilters).hashCode());
        RefundAgent $registeredRefundAgent = this.getRegisteredRefundAgent();
        result = result * 59 + ($registeredRefundAgent == null ? 43 : ((Object)$registeredRefundAgent).hashCode());
        List<RefundAgent> $acceptedRefundAgents = this.getAcceptedRefundAgents();
        result = result * 59 + ($acceptedRefundAgents == null ? 43 : ((Object)$acceptedRefundAgents).hashCode());
        Cookie $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : ((Object)$cookie).hashCode());
        return result;
    }

    public String toString() {
        return "UserPayload(accountId=" + this.getAccountId() + ", paymentAccounts=" + String.valueOf(this.getPaymentAccounts()) + ", currentPaymentAccount=" + String.valueOf(this.getCurrentPaymentAccount()) + ", acceptedLanguageLocaleCodes=" + String.valueOf(this.getAcceptedLanguageLocaleCodes()) + ", developersAlert=" + String.valueOf(this.getDevelopersAlert()) + ", displayedAlert=" + String.valueOf(this.getDisplayedAlert()) + ", developersFilter=" + String.valueOf(this.getDevelopersFilter()) + ", registeredArbitrator=" + String.valueOf(this.getRegisteredArbitrator()) + ", registeredMediator=" + String.valueOf(this.getRegisteredMediator()) + ", acceptedArbitrators=" + String.valueOf(this.getAcceptedArbitrators()) + ", acceptedMediators=" + String.valueOf(this.getAcceptedMediators()) + ", priceAlertFilter=" + String.valueOf(this.getPriceAlertFilter()) + ", marketAlertFilters=" + String.valueOf(this.getMarketAlertFilters()) + ", registeredRefundAgent=" + String.valueOf(this.getRegisteredRefundAgent()) + ", acceptedRefundAgents=" + String.valueOf(this.getAcceptedRefundAgents()) + ", cookie=" + String.valueOf(this.getCookie()) + ", walletCreationDate=" + this.getWalletCreationDate() + ")";
    }

    public UserPayload(@Nullable String accountId, @Nullable Set<PaymentAccount> paymentAccounts, @Nullable PaymentAccount currentPaymentAccount, @Nullable List<String> acceptedLanguageLocaleCodes, @Nullable Alert developersAlert, @Nullable Alert displayedAlert, @Nullable Filter developersFilter, @Nullable Arbitrator registeredArbitrator, @Nullable Mediator registeredMediator, @Nullable List<Arbitrator> acceptedArbitrators, @Nullable List<Mediator> acceptedMediators, @Nullable PriceAlertFilter priceAlertFilter, @Nullable List<MarketAlertFilter> marketAlertFilters, @Nullable RefundAgent registeredRefundAgent, @Nullable List<RefundAgent> acceptedRefundAgents, Cookie cookie, long walletCreationDate) {
        this.accountId = accountId;
        this.paymentAccounts = paymentAccounts;
        this.currentPaymentAccount = currentPaymentAccount;
        this.acceptedLanguageLocaleCodes = acceptedLanguageLocaleCodes;
        this.developersAlert = developersAlert;
        this.displayedAlert = displayedAlert;
        this.developersFilter = developersFilter;
        this.registeredArbitrator = registeredArbitrator;
        this.registeredMediator = registeredMediator;
        this.acceptedArbitrators = acceptedArbitrators;
        this.acceptedMediators = acceptedMediators;
        this.priceAlertFilter = priceAlertFilter;
        this.marketAlertFilters = marketAlertFilters;
        this.registeredRefundAgent = registeredRefundAgent;
        this.acceptedRefundAgents = acceptedRefundAgents;
        this.cookie = cookie;
        this.walletCreationDate = walletCreationDate;
    }
}

