/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.Res;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.Price;
import haveno.core.monetary.TraditionalMoney;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattingUtils {
    private static final Logger log = LoggerFactory.getLogger(FormattingUtils.class);
    public static final String BTC_FORMATTER_KEY = "BTC";
    public static final String RANGE_SEPARATOR = " - ";
    private static final MonetaryFormat priceFormat4Decimals = new MonetaryFormat().shift(0).minDecimals(4).repeatOptionalDecimals(0, 0);
    private static final MonetaryFormat priceFormat8Decimals = new MonetaryFormat().shift(0).minDecimals(8).repeatOptionalDecimals(0, 0);
    private static final MonetaryFormat cryptoFormat = new MonetaryFormat().shift(0).minDecimals(8).repeatOptionalDecimals(0, 0);
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.#");

    public static String formatCoinWithCode(long value, MonetaryFormat coinFormat) {
        return FormattingUtils.formatCoinWithCode(Coin.valueOf(value), coinFormat);
    }

    public static String formatCoinWithCode(Coin coin, MonetaryFormat coinFormat) {
        if (coin != null) {
            try {
                return coinFormat.postfixCode().format(coin).toString();
            }
            catch (Throwable t2) {
                log.warn("Exception at formatCoinWithCode: " + t2.toString());
                return "";
            }
        }
        return "";
    }

    public static String formatCoin(long value, MonetaryFormat coinFormat) {
        return FormattingUtils.formatCoin(Coin.valueOf(value), -1, false, 0, coinFormat);
    }

    public static String formatCoin(Coin coin, int decimalPlaces, boolean decimalAligned, int maxNumberOfDigits, MonetaryFormat coinFormat) {
        String formattedCoin = "";
        if (coin != null) {
            try {
                formattedCoin = decimalPlaces < 0 || decimalPlaces > 4 ? coinFormat.noCode().format(coin).toString() : coinFormat.noCode().minDecimals(decimalPlaces).repeatOptionalDecimals(1, decimalPlaces).format(coin).toString();
            }
            catch (Throwable t2) {
                log.warn("Exception at formatBtc: " + t2.toString());
            }
        }
        if (decimalAligned) {
            formattedCoin = FormattingUtils.fillUpPlacesWithEmptyStrings(formattedCoin, maxNumberOfDigits);
        }
        return formattedCoin;
    }

    public static String formatTraditionalMoney(TraditionalMoney traditionalMoney, MonetaryFormat format, boolean appendCurrencyCode) {
        if (traditionalMoney != null) {
            try {
                String res = format.noCode().format(traditionalMoney).toString();
                if (appendCurrencyCode) {
                    return res + " " + traditionalMoney.getCurrencyCode();
                }
                return res;
            }
            catch (Throwable t2) {
                log.warn("Exception at formatTraditionalMoneyWithCode: " + t2.toString());
                return Res.get("shared.na") + " " + traditionalMoney.getCurrencyCode();
            }
        }
        return Res.get("shared.na");
    }

    private static String formatCrypto(CryptoMoney crypto, boolean appendCurrencyCode) {
        if (crypto != null) {
            try {
                String res = cryptoFormat.noCode().format(crypto).toString();
                if (appendCurrencyCode) {
                    return res + " " + crypto.getCurrencyCode();
                }
                return res;
            }
            catch (Throwable t2) {
                log.warn("Exception at formatCrypto: " + t2.toString());
                return Res.get("shared.na") + " " + crypto.getCurrencyCode();
            }
        }
        return Res.get("shared.na");
    }

    public static String formatCryptoVolume(CryptoMoney crypto, boolean appendCurrencyCode) {
        if (crypto != null) {
            try {
                String res = crypto.getCurrencyCode().equals("BSQ") ? cryptoFormat.noCode().minDecimals(2).repeatOptionalDecimals(0, 0).format(crypto).toString() : cryptoFormat.noCode().format(crypto).toString();
                if (appendCurrencyCode) {
                    return res + " " + crypto.getCurrencyCode();
                }
                return res;
            }
            catch (Throwable t2) {
                log.warn("Exception at formatCryptoVolume: " + t2.toString());
                return Res.get("shared.na") + " " + crypto.getCurrencyCode();
            }
        }
        return Res.get("shared.na");
    }

    public static String formatPrice(Price price, MonetaryFormat priceFormat, boolean appendCurrencyCode) {
        if (price != null) {
            Monetary monetary = price.getMonetary();
            if (monetary instanceof TraditionalMoney) {
                return FormattingUtils.formatTraditionalMoney((TraditionalMoney)monetary, priceFormat, appendCurrencyCode);
            }
            return FormattingUtils.formatCrypto((CryptoMoney)monetary, appendCurrencyCode);
        }
        return Res.get("shared.na");
    }

    public static String formatPrice(Price price, boolean appendCurrencyCode) {
        return FormattingUtils.formatPrice(price, FormattingUtils.getPriceMonetaryFormat(price.getCurrencyCode()), appendCurrencyCode);
    }

    public static String formatPrice(Price price) {
        return FormattingUtils.formatPrice(price, price == null ? null : FormattingUtils.getPriceMonetaryFormat(price.getCurrencyCode()), false);
    }

    public static String formatMarketPrice(double price, String currencyCode) {
        if (CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return FormattingUtils.formatMarketPrice(price, 2);
        }
        return FormattingUtils.formatMarketPrice(price, 8);
    }

    public static String formatMarketPrice(double price, int precision) {
        return FormattingUtils.formatRoundedDoubleWithPrecision(price, precision);
    }

    public static String formatRoundedDoubleWithPrecision(double value, int precision) {
        decimalFormat.setMinimumFractionDigits(precision);
        decimalFormat.setMaximumFractionDigits(precision);
        return decimalFormat.format(MathUtils.roundDouble(value, precision)).replace(",", ".");
    }

    public static String formatDateTime(Date date, boolean useLocaleAndLocalTimezone) {
        Locale locale = useLocaleAndLocalTimezone ? GlobalSettings.getLocale() : Locale.US;
        DateFormat dateInstance = DateFormat.getDateInstance(2, locale);
        DateFormat timeInstance = DateFormat.getTimeInstance(2, locale);
        if (!useLocaleAndLocalTimezone) {
            dateInstance.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeInstance.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return FormattingUtils.formatDateTime(date, dateInstance, timeInstance);
    }

    public static String formatDateTime(Date date, DateFormat dateFormatter, DateFormat timeFormatter) {
        if (date != null) {
            return dateFormatter.format(date) + " " + timeFormatter.format(date);
        }
        return "";
    }

    public static String getDateFromBlockHeight(long blockHeight) {
        long now = new Date().getTime();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM", Locale.getDefault());
        SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm", Locale.getDefault());
        return FormattingUtils.formatDateTime(new Date(now + blockHeight * 10L * 60L * 1000L), dateFormatter, timeFormatter);
    }

    public static String formatToPercentWithSymbol(double value) {
        return FormattingUtils.formatToPercent(value) + "%";
    }

    public static String formatToRoundedPercentWithSymbol(double value) {
        return FormattingUtils.formatToPercent(value, new DecimalFormat("#")) + "%";
    }

    public static String formatPercentagePrice(double value) {
        return FormattingUtils.formatToPercentWithSymbol(value);
    }

    public static String formatToPercent(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setMaximumFractionDigits(2);
        return FormattingUtils.formatToPercent(value, decimalFormat);
    }

    public static String formatToPercent(double value, DecimalFormat decimalFormat) {
        return decimalFormat.format(MathUtils.roundDouble(value * 100.0, 2)).replace(",", ".");
    }

    public static String formatDurationAsWords(long durationMillis) {
        return FormattingUtils.formatDurationAsWords(durationMillis, false, true);
    }

    public static String formatDurationAsWords(long durationMillis, boolean showSeconds, boolean showZeroValues) {
        Object format = "";
        String second = Res.get("time.second");
        String minute = Res.get("time.minute");
        String hour = Res.get("time.hour").toLowerCase();
        String day = Res.get("time.day").toLowerCase();
        String days = Res.get("time.days");
        String hours = Res.get("time.hours");
        String minutes = Res.get("time.minutes");
        String seconds = Res.get("time.seconds");
        if (durationMillis >= TimeUnit.DAYS.toMillis(1L)) {
            format = "d' " + days + ", '";
        }
        format = showSeconds ? (String)format + "H' " + hours + ", 'm' " + minutes + ", 's' " + seconds + "'" : (String)format + "H' " + hours + ", 'm' " + minutes + "'";
        String duration = durationMillis > 0L ? DurationFormatUtils.formatDuration(durationMillis, (String)format) : "";
        duration = StringUtils.replacePattern(duration, "^1 " + seconds + "|\\b1 " + seconds, "1 " + second);
        duration = StringUtils.replacePattern(duration, "^1 " + minutes + "|\\b1 " + minutes, "1 " + minute);
        duration = StringUtils.replacePattern(duration, "^1 " + hours + "|\\b1 " + hours, "1 " + hour);
        duration = StringUtils.replacePattern(duration, "^1 " + days + "|\\b1 " + days, "1 " + day);
        if (!showZeroValues) {
            duration = duration.replace(", 0 seconds", "");
            duration = duration.replace(", 0 minutes", "");
            duration = duration.replace(", 0 hours", "");
            duration = StringUtils.replacePattern(duration, "^0 days, ", "");
            duration = StringUtils.replacePattern(duration, "^0 hours, ", "");
            duration = StringUtils.replacePattern(duration, "^0 minutes, ", "");
            duration = StringUtils.replacePattern(duration, "^0 seconds, ", "");
        }
        return duration.trim();
    }

    public static String formatBytes(long bytes) {
        double kb = 1024.0;
        double mb = kb * kb;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        if ((double)bytes < kb) {
            return bytes + " bytes";
        }
        if ((double)bytes < mb) {
            return decimalFormat.format((double)bytes / kb) + " KB";
        }
        return decimalFormat.format((double)bytes / mb) + " MB";
    }

    @NotNull
    public static String fillUpPlacesWithEmptyStrings(String formattedNumber, int maxNumberOfDigits) {
        return formattedNumber;
    }

    public static MonetaryFormat getPriceMonetaryFormat(String currencyCode) {
        return CurrencyUtil.isPricePrecise(currencyCode) ? priceFormat8Decimals : priceFormat4Decimals;
    }
}

