/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import haveno.common.util.DoubleSummaryStatisticsWithStdDev;
import haveno.common.util.Tuple2;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;

public class InlierUtil {
    public static Tuple2<Double, Double> findInlierRange(List<Double> yValues, double percentToTrim, double howManyStdDevsConstituteOutlier) {
        Tuple2<Double, Double> inlierThreshold = InlierUtil.computeInlierThreshold(yValues, percentToTrim, howManyStdDevsConstituteOutlier);
        DoubleSummaryStatistics inlierStatistics = yValues.stream().filter(y -> InlierUtil.withinBounds(inlierThreshold, y)).mapToDouble(Double::doubleValue).summaryStatistics();
        double inlierMin = inlierStatistics.getMin();
        double inlierMax = inlierStatistics.getMax();
        return new Tuple2<Double, Double>(inlierMin, inlierMax);
    }

    private static boolean withinBounds(Tuple2<Double, Double> bounds, double number) {
        Double lowerBound = (Double)bounds.first;
        Double upperBound = (Double)bounds.second;
        return lowerBound <= number && number <= upperBound;
    }

    private static Tuple2<Double, Double> computeInlierThreshold(List<Double> numbers, double percentToTrim, double howManyStdDevsConstituteOutlier) {
        if (howManyStdDevsConstituteOutlier <= 0.0) {
            throw new IllegalArgumentException("howManyStdDevsConstituteOutlier should be a positive number");
        }
        List<Double> trimmed = InlierUtil.trim(percentToTrim, numbers);
        DoubleSummaryStatisticsWithStdDev summaryStatistics = trimmed.stream().collect(DoubleSummaryStatisticsWithStdDev::new, DoubleSummaryStatisticsWithStdDev::accept, DoubleSummaryStatisticsWithStdDev::combine);
        double mean = summaryStatistics.getAverage();
        double stdDev = summaryStatistics.getStandardDeviation();
        double inlierLowerThreshold = mean - stdDev * howManyStdDevsConstituteOutlier;
        double inlierUpperThreshold = mean + stdDev * howManyStdDevsConstituteOutlier;
        return new Tuple2<Double, Double>(inlierLowerThreshold, inlierUpperThreshold);
    }

    private static List<Double> trim(double percentToTrim, List<Double> numbers) {
        int minPercentToTrim = 0;
        int maxPercentToTrim = 50;
        if ((double)minPercentToTrim > percentToTrim || percentToTrim > (double)maxPercentToTrim) {
            throw new IllegalArgumentException(String.format("The percentage of data points to trim must be in the range [%d,%d].", minPercentToTrim, maxPercentToTrim));
        }
        double totalPercentTrim = percentToTrim * 2.0;
        if (totalPercentTrim == 0.0) {
            return numbers;
        }
        if (totalPercentTrim == 100.0) {
            return FXCollections.emptyObservableList();
        }
        if (numbers.isEmpty()) {
            return numbers;
        }
        int count = numbers.size();
        int countToDropFromEachSide = (int)Math.round((double)count / 100.0 * percentToTrim);
        if (countToDropFromEachSide == 0) {
            return numbers;
        }
        Stream sorted2 = numbers.stream().sorted();
        Stream oneSideTrimmed = sorted2.skip(countToDropFromEachSide);
        int countAfterTrim = count - countToDropFromEachSide * 2;
        Stream bothSidesTrimmed = oneSideTrimmed.limit(countAfterTrim);
        return bothSidesTrimmed.collect(Collectors.toList());
    }
}

