/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import com.google.common.base.Preconditions;
import haveno.core.trade.messages.TradeMessage;
import org.bitcoinj.core.Coin;

public class Validator {
    public static String nonEmptyStringOf(String value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.length() > 0);
        return value;
    }

    public static long nonNegativeLongOf(long value) {
        Preconditions.checkArgument(value >= 0L);
        return value;
    }

    public static Coin nonZeroCoinOf(Coin value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(!value.isZero());
        return value;
    }

    public static Coin positiveCoinOf(Coin value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.isPositive());
        return value;
    }

    public static void checkTradeId(String tradeId, TradeMessage tradeMessage) {
        Preconditions.checkArgument(Validator.isTradeIdValid(tradeId, tradeMessage));
    }

    public static boolean isTradeIdValid(String tradeId, TradeMessage tradeMessage) {
        return tradeId.equals(tradeMessage.getOfferId());
    }
}

