/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util;

import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.CryptoExchangeRate;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.Price;
import haveno.core.monetary.TraditionalExchangeRate;
import haveno.core.monetary.TraditionalMoney;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.FormattingUtils;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;

public class VolumeUtil {
    private static final MonetaryFormat VOLUME_FORMAT_UNIT = new MonetaryFormat().shift(0).minDecimals(0).repeatOptionalDecimals(0, 0);
    private static final MonetaryFormat VOLUME_FORMAT_PRECISE = new MonetaryFormat().shift(0).minDecimals(4).repeatOptionalDecimals(0, 0);
    private static double EXPONENT = Math.pow(10.0, 8.0);

    public static Volume getAdjustedVolume(Volume volumeByAmount, String paymentMethodId) {
        if (PaymentMethod.isRoundedForAtmCash(paymentMethodId)) {
            return VolumeUtil.getRoundedAtmCashVolume(volumeByAmount);
        }
        if (CurrencyUtil.isVolumeRoundedToNearestUnit(volumeByAmount.getCurrencyCode())) {
            return VolumeUtil.getRoundedVolumeUnit(volumeByAmount);
        }
        if (CurrencyUtil.isTraditionalCurrency(volumeByAmount.getCurrencyCode())) {
            return VolumeUtil.getRoundedVolumePrecise(volumeByAmount);
        }
        return volumeByAmount;
    }

    public static Volume getRoundedVolumeUnit(Volume volumeByAmount) {
        return VolumeUtil.getAdjustedVolumeUnit(volumeByAmount, 1);
    }

    private static Volume getRoundedAtmCashVolume(Volume volumeByAmount) {
        return VolumeUtil.getAdjustedVolumeUnit(volumeByAmount, 10);
    }

    public static Volume getRoundedVolumePrecise(Volume volumeByAmount) {
        DecimalFormat decimalFormat = new DecimalFormat("#.####", HavenoUtils.DECIMAL_FORMAT_SYMBOLS);
        double roundedVolume = Double.parseDouble(decimalFormat.format(Double.parseDouble(volumeByAmount.toString())));
        return Volume.parse(String.valueOf(roundedVolume), volumeByAmount.getCurrencyCode());
    }

    public static Volume getAdjustedVolumeUnit(Volume volumeByAmount, int factor) {
        long roundedVolume = Math.round((double)volumeByAmount.getValue() / (EXPONENT * (double)factor)) * (long)factor;
        roundedVolume = Math.max((long)factor, roundedVolume);
        return Volume.parse(String.valueOf(roundedVolume), volumeByAmount.getCurrencyCode());
    }

    public static Volume getVolume(BigInteger amount, Price price) {
        if (price.getMonetary() instanceof CryptoMoney) {
            return new Volume(new CryptoExchangeRate((CryptoMoney)price.getMonetary()).coinToCrypto(HavenoUtils.atomicUnitsToCoin(amount)));
        }
        return new Volume(new TraditionalExchangeRate((TraditionalMoney)price.getMonetary()).coinToTraditionalMoney(HavenoUtils.atomicUnitsToCoin(amount)));
    }

    public static String formatVolume(Offer offer, Boolean decimalAligned, int maxNumberOfDigits) {
        return VolumeUtil.formatVolume(offer, decimalAligned, maxNumberOfDigits, true);
    }

    public static String formatVolume(Offer offer, Boolean decimalAligned, int maxNumberOfDigits, boolean showRange) {
        String formattedVolume;
        String string = formattedVolume = offer.isRange() && showRange ? VolumeUtil.formatVolume(offer.getMinVolume()) + " - " + VolumeUtil.formatVolume(offer.getVolume()) : VolumeUtil.formatVolume(offer.getVolume());
        if (decimalAligned.booleanValue()) {
            formattedVolume = FormattingUtils.fillUpPlacesWithEmptyStrings(formattedVolume, maxNumberOfDigits);
        }
        return formattedVolume;
    }

    public static String formatLargeFiat(double value, String currency) {
        if (value <= 0.0) {
            return "0";
        }
        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(true);
        return numberFormat.format(value) + " " + currency;
    }

    public static String formatLargeFiatWithUnitPostFix(double value, String currency) {
        if (value <= 0.0) {
            return "0";
        }
        String[] units = new String[]{"", "K", "M", "B"};
        int digitGroups = (int)(Math.log10(value) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.###").format(value / Math.pow(1000.0, digitGroups)) + units[digitGroups] + " " + currency;
    }

    public static String formatVolume(Volume volume) {
        return volume == null ? "" : VolumeUtil.formatVolume(volume, VolumeUtil.getMonetaryFormat(volume.getCurrencyCode()), false);
    }

    private static String formatVolume(Volume volume, MonetaryFormat volumeFormat, boolean appendCurrencyCode) {
        if (volume != null) {
            Monetary monetary = volume.getMonetary();
            if (monetary instanceof TraditionalMoney) {
                return FormattingUtils.formatTraditionalMoney((TraditionalMoney)monetary, volumeFormat, appendCurrencyCode);
            }
            return FormattingUtils.formatCryptoVolume((CryptoMoney)monetary, appendCurrencyCode);
        }
        return "";
    }

    public static String formatVolumeWithCode(Volume volume) {
        return VolumeUtil.formatVolume(volume, true);
    }

    public static String formatVolume(Volume volume, boolean appendCode) {
        return VolumeUtil.formatVolume(volume, volume == null ? null : VolumeUtil.getMonetaryFormat(volume.getCurrencyCode()), appendCode);
    }

    public static String formatAverageVolumeWithCode(Volume volume) {
        return VolumeUtil.formatVolume(volume, volume == null ? null : VolumeUtil.getMonetaryFormat(volume.getCurrencyCode()).minDecimals(2), true);
    }

    public static String formatVolumeLabel(String currencyCode) {
        return VolumeUtil.formatVolumeLabel(currencyCode, "");
    }

    public static String formatVolumeLabel(String currencyCode, String postFix) {
        return Res.get("formatter.formatVolumeLabel", currencyCode, postFix);
    }

    private static MonetaryFormat getMonetaryFormat(String currencyCode) {
        return CurrencyUtil.isVolumeRoundedToNearestUnit(currencyCode) ? VOLUME_FORMAT_UNIT : VOLUME_FORMAT_PRECISE;
    }
}

