/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.coin;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.xmr.wallet.Restrictions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.bitcoinj.core.Coin;

public class CoinUtil {
    public static Coin minCoin(Coin a, Coin b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static Coin maxCoin(Coin a, Coin b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static double getAsPercentPerXmr(BigInteger value) {
        return CoinUtil.getAsPercentPerXmr(value, HavenoUtils.xmrToAtomicUnits(1.0));
    }

    public static double getAsPercentPerXmr(BigInteger part, BigInteger total) {
        return MathUtils.roundDouble(HavenoUtils.divide(part == null ? BigInteger.ZERO : part, total == null ? BigInteger.valueOf(1L) : total), 4);
    }

    public static BigInteger getPercentOfAmount(double percent, BigInteger amount) {
        if (amount == null) {
            amount = BigInteger.ZERO;
        }
        return BigDecimal.valueOf(percent).multiply(new BigDecimal(amount)).setScale(8, RoundingMode.DOWN).toBigInteger();
    }

    public static BigInteger getRoundedAmount(BigInteger amount, Price price, Long maxTradeLimit, String currencyCode, String paymentMethodId) {
        if (price != null) {
            if (PaymentMethod.isRoundedForAtmCash(paymentMethodId)) {
                return CoinUtil.getRoundedAtmCashAmount(amount, price, maxTradeLimit);
            }
            if (CurrencyUtil.isVolumeRoundedToNearestUnit(currencyCode)) {
                return CoinUtil.getRoundedAmountUnit(amount, price, maxTradeLimit);
            }
        }
        return CoinUtil.getRoundedAmount4Decimals(amount, maxTradeLimit);
    }

    public static BigInteger getRoundedAtmCashAmount(BigInteger amount, Price price, Long maxTradeLimit) {
        return CoinUtil.getAdjustedAmount(amount, price, maxTradeLimit, 10);
    }

    public static BigInteger getRoundedAmountUnit(BigInteger amount, Price price, Long maxTradeLimit) {
        return CoinUtil.getAdjustedAmount(amount, price, maxTradeLimit, 1);
    }

    public static BigInteger getRoundedAmount4Decimals(BigInteger amount, Long maxTradeLimit) {
        DecimalFormat decimalFormat = new DecimalFormat("#.####", HavenoUtils.DECIMAL_FORMAT_SYMBOLS);
        double roundedXmrAmount = Double.parseDouble(decimalFormat.format(HavenoUtils.atomicUnitsToXmr(amount)));
        return HavenoUtils.xmrToAtomicUnits(roundedXmrAmount);
    }

    @VisibleForTesting
    static BigInteger getAdjustedAmount(BigInteger amount, Price price, Long maxTradeLimit, int factor) {
        long adjustedAmount;
        Volume volume;
        Preconditions.checkArgument(amount.longValueExact() >= Restrictions.getMinTradeAmount().longValueExact(), "amount needs to be above minimum of " + HavenoUtils.atomicUnitsToXmr(Restrictions.getMinTradeAmount()) + " xmr");
        Preconditions.checkArgument(factor > 0, "factor needs to be positive");
        Volume smallestUnitForVolume = Volume.parse(String.valueOf(factor), price.getCurrencyCode());
        if (smallestUnitForVolume.getValue() <= 0L) {
            return BigInteger.ZERO;
        }
        BigInteger smallestUnitForAmount = price.getAmountByVolume(smallestUnitForVolume);
        long minTradeAmount = Restrictions.getMinTradeAmount().longValueExact();
        Preconditions.checkArgument(minTradeAmount >= Restrictions.getMinTradeAmount().longValueExact(), "MinTradeAmount must be at least " + HavenoUtils.atomicUnitsToXmr(Restrictions.getMinTradeAmount()) + " xmr");
        smallestUnitForAmount = BigInteger.valueOf(Math.max(minTradeAmount, smallestUnitForAmount.longValueExact()));
        boolean useSmallestUnitForAmount = amount.compareTo(smallestUnitForAmount) < 0;
        Volume volume2 = volume = useSmallestUnitForAmount ? VolumeUtil.getAdjustedVolumeUnit(price.getVolumeByAmount(smallestUnitForAmount), factor) : VolumeUtil.getAdjustedVolumeUnit(price.getVolumeByAmount(amount), factor);
        if (volume.getValue() <= 0L) {
            return BigInteger.ZERO;
        }
        BigInteger amountByVolume = price.getAmountByVolume(volume);
        BigInteger smallestUnitForAmountUnadjusted = price.getAmountByVolume(smallestUnitForVolume);
        if (maxTradeLimit != null) {
            for (adjustedAmount = HavenoUtils.centinerosToAtomicUnits(Math.round((double)HavenoUtils.atomicUnitsToCentineros(amountByVolume) / 10000.0) * 10000L).longValueExact(); adjustedAmount > maxTradeLimit; adjustedAmount -= smallestUnitForAmountUnadjusted.longValueExact()) {
            }
        }
        adjustedAmount = Math.max(minTradeAmount, adjustedAmount);
        if (maxTradeLimit != null) {
            adjustedAmount = Math.min(maxTradeLimit, adjustedAmount);
        }
        return BigInteger.valueOf(adjustedAmount);
    }
}

