/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.coin;

import com.google.inject.Inject;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import org.bitcoinj.core.Coin;
import org.bitcoinj.utils.MonetaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableCoinFormatter
implements CoinFormatter {
    private static final Logger log = LoggerFactory.getLogger(ImmutableCoinFormatter.class);
    private MonetaryFormat monetaryFormat;

    @Inject
    public ImmutableCoinFormatter(MonetaryFormat monetaryFormat) {
        this.monetaryFormat = monetaryFormat;
    }

    @Override
    public String formatCoin(Coin coin) {
        return this.formatCoin(coin, -1);
    }

    @Override
    public String formatCoin(Coin coin, boolean appendCode) {
        return appendCode ? this.formatCoinWithCode(coin) : this.formatCoin(coin);
    }

    @Override
    public String formatCoin(Coin coin, int decimalPlaces) {
        return this.formatCoin(coin, decimalPlaces, false, 0);
    }

    @Override
    public String formatCoin(Coin coin, int decimalPlaces, boolean decimalAligned, int maxNumberOfDigits) {
        return FormattingUtils.formatCoin(coin, decimalPlaces, decimalAligned, maxNumberOfDigits, this.monetaryFormat);
    }

    @Override
    public String formatCoinWithCode(Coin coin) {
        return FormattingUtils.formatCoinWithCode(coin, this.monetaryFormat);
    }

    @Override
    public String formatCoinWithCode(long value) {
        return FormattingUtils.formatCoinWithCode(Coin.valueOf(value), this.monetaryFormat);
    }

    @Override
    public MonetaryFormat getMonetaryFormat() {
        return this.monetaryFormat;
    }
}

