/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;

public class IntegerValidator
extends InputValidator {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private int intValue;

    public IntegerValidator() {
    }

    public IntegerValidator(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult validationResult = super.validate(input);
        if (!validationResult.isValid) {
            return validationResult;
        }
        if (!this.isInteger(input)) {
            return new InputValidator.ValidationResult(false, Res.get("validation.notAnInteger"));
        }
        if (this.isBelowMinValue(this.intValue)) {
            return new InputValidator.ValidationResult(false, Res.get("validation.xmr.tooSmall", this.minValue));
        }
        if (this.isAboveMaxValue(this.intValue)) {
            return new InputValidator.ValidationResult(false, Res.get("validation.xmr.tooLarge", this.maxValue));
        }
        return validationResult;
    }

    private boolean isBelowMinValue(int intValue) {
        return intValue < this.minValue;
    }

    private boolean isAboveMaxValue(int intValue) {
        return intValue > this.maxValue;
    }

    private boolean isInteger(String input) {
        try {
            this.intValue = Integer.parseInt(input);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerValidator)) {
            return false;
        }
        IntegerValidator other = (IntegerValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMinValue() != other.getMinValue()) {
            return false;
        }
        if (this.getMaxValue() != other.getMaxValue()) {
            return false;
        }
        return this.getIntValue() == other.getIntValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegerValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMinValue();
        result = result * 59 + this.getMaxValue();
        result = result * 59 + this.getIntValue();
        return result;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setIntValue(int intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return "IntegerValidator(minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ", intValue=" + this.getIntValue() + ")";
    }
}

