/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import haveno.core.locale.Res;
import haveno.core.util.ParsingUtils;
import haveno.core.util.validation.InputValidator;

public abstract class NumberValidator
extends InputValidator {
    protected String cleanInput(String input) {
        return ParsingUtils.convertCharsForNumber(input);
    }

    protected InputValidator.ValidationResult validateIfNumber(String input) {
        try {
            Double.parseDouble(input);
            return new InputValidator.ValidationResult(true);
        }
        catch (Exception e) {
            return new InputValidator.ValidationResult(false, Res.get("validation.NaN"));
        }
    }

    protected InputValidator.ValidationResult validateIfNotZero(String input) {
        if (Double.parseDouble(input) == 0.0) {
            return new InputValidator.ValidationResult(false, Res.get("validation.zero"));
        }
        return new InputValidator.ValidationResult(true);
    }

    protected InputValidator.ValidationResult validateIfNotNegative(String input) {
        if (Double.parseDouble(input) < 0.0) {
            return new InputValidator.ValidationResult(false, Res.get("validation.negative"));
        }
        return new InputValidator.ValidationResult(true);
    }
}

