/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.util.validation;

import com.google.common.base.Preconditions;
import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import java.net.URL;

public class UrlInputValidator
extends InputValidator {
    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult validationResult = super.validate(input);
        if (!validationResult.isValid) {
            return validationResult;
        }
        try {
            new URL(input);
            String regex = "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
            Preconditions.checkArgument(input.matches(regex), "URL does not match regex");
            return validationResult;
        }
        catch (Throwable t2) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidUrl"));
        }
    }
}

