/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr;

import com.google.inject.Inject;
import haveno.common.ThreadUtils;
import haveno.core.api.model.XmrBalanceInfo;
import haveno.core.offer.OpenOfferManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.wallet.XmrWalletService;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Balances {
    private static final Logger log = LoggerFactory.getLogger(Balances.class);
    private final TradeManager tradeManager;
    private final XmrWalletService xmrWalletService;
    private final OpenOfferManager openOfferManager;
    private final RefundManager refundManager;
    private BigInteger availableBalance;
    private BigInteger pendingBalance;
    private BigInteger reservedOfferBalance;
    private BigInteger reservedTradeBalance;
    private BigInteger reservedBalance;
    private final IntegerProperty updateCounter = new SimpleIntegerProperty(0);

    @Inject
    public Balances(TradeManager tradeManager, XmrWalletService xmrWalletService, OpenOfferManager openOfferManager, ClosedTradableManager closedTradableManager, FailedTradesManager failedTradesManager, RefundManager refundManager) {
        this.tradeManager = tradeManager;
        this.xmrWalletService = xmrWalletService;
        this.openOfferManager = openOfferManager;
        this.refundManager = refundManager;
    }

    public void onAllServicesInitialized() {
        this.openOfferManager.getObservableList().addListener(c -> this.updateBalances());
        this.tradeManager.getObservableList().addListener(change -> this.updateBalances());
        this.refundManager.getDisputesAsObservableList().addListener(c -> this.updateBalances());
        this.xmrWalletService.addBalanceListener(new XmrBalanceListener(){

            @Override
            public void onBalanceChanged(BigInteger balance) {
                Balances.this.updateBalances();
            }
        });
        this.doUpdateBalances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmrBalanceInfo getBalances() {
        Balances balances = this;
        synchronized (balances) {
            if (this.availableBalance == null) {
                return null;
            }
            return new XmrBalanceInfo(this.availableBalance.longValue() + this.pendingBalance.longValue(), this.availableBalance.longValue(), this.pendingBalance.longValue(), this.reservedOfferBalance.longValue(), this.reservedTradeBalance.longValue());
        }
    }

    private void updateBalances() {
        ThreadUtils.submitToPool(() -> this.doUpdateBalances());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateBalances() {
        Balances balances = this;
        synchronized (balances) {
            Object object = HavenoUtils.xmrWalletService.getWalletLock();
            synchronized (object) {
                boolean fundsReceived;
                BigInteger balanceSumBefore = this.getNonTradeBalanceSum();
                BigInteger balance = this.xmrWalletService.getWallet() == null ? BigInteger.ZERO : this.xmrWalletService.getBalance();
                this.availableBalance = this.xmrWalletService.getWallet() == null ? BigInteger.ZERO : this.xmrWalletService.getAvailableBalance();
                this.pendingBalance = balance.subtract(this.availableBalance);
                List trades = this.tradeManager.getTradesStreamWithFundsLockedIn().collect(Collectors.toList());
                for (Object trade : trades) {
                    if (((Trade)trade).getFrozenAmount().equals(new BigInteger("0"))) continue;
                    BigInteger tradeFee = trade instanceof MakerTrade ? ((Trade)trade).getMakerFee() : ((Trade)trade).getTakerFee();
                    this.pendingBalance = this.pendingBalance.add(((Trade)trade).getFrozenAmount()).subtract(((Trade)trade).getReservedAmount()).subtract(tradeFee).subtract(((Trade)trade).getSelf().getDepositTxFee());
                }
                this.reservedOfferBalance = BigInteger.ZERO;
                if (this.xmrWalletService.getWallet() != null) {
                    Object trade;
                    List<MoneroOutputWallet> frozenOutputs = this.xmrWalletService.getOutputs(new MoneroOutputQuery().setIsFrozen(true).setIsSpent(false));
                    trade = frozenOutputs.iterator();
                    while (trade.hasNext()) {
                        MoneroOutputWallet frozenOutput = (MoneroOutputWallet)trade.next();
                        this.reservedOfferBalance = this.reservedOfferBalance.add(frozenOutput.getAmount());
                    }
                }
                for (Object trade : trades) {
                    this.reservedOfferBalance = this.reservedOfferBalance.subtract(((Trade)trade).getFrozenAmount());
                }
                this.reservedTradeBalance = BigInteger.ZERO;
                for (Object trade : trades) {
                    this.reservedTradeBalance = this.reservedTradeBalance.add(((Trade)trade).getReservedAmount());
                }
                this.reservedBalance = this.reservedOfferBalance.add(this.reservedTradeBalance);
                boolean bl = fundsReceived = balanceSumBefore != null && this.getNonTradeBalanceSum().compareTo(balanceSumBefore) > 0;
                if (fundsReceived) {
                    HavenoUtils.playCashRegisterSound();
                }
                this.updateCounter.set(this.updateCounter.get() + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getNonTradeBalanceSum() {
        Balances balances = this;
        synchronized (balances) {
            if (this.availableBalance == null) {
                return null;
            }
            return this.availableBalance.add(this.pendingBalance).add(this.reservedOfferBalance);
        }
    }

    public BigInteger getAvailableBalance() {
        return this.availableBalance;
    }

    public BigInteger getPendingBalance() {
        return this.pendingBalance;
    }

    public BigInteger getReservedOfferBalance() {
        return this.reservedOfferBalance;
    }

    public BigInteger getReservedTradeBalance() {
        return this.reservedTradeBalance;
    }

    public BigInteger getReservedBalance() {
        return this.reservedBalance;
    }

    public IntegerProperty getUpdateCounter() {
        return this.updateCounter;
    }
}

