/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr;

import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.core.provider.ProvidersRepository;
import haveno.core.provider.fee.FeeProvider;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.xmr.Balances;
import haveno.core.xmr.model.AddressEntryList;
import haveno.core.xmr.model.EncryptedConnectionList;
import haveno.core.xmr.model.XmrAddressEntryList;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.setup.RegTestHost;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.NonBsqCoinSelector;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class XmrModule
extends AppModule {
    public XmrModule(Config config) {
        super(config);
    }

    @Override
    protected void configure() {
        String regTestHost = this.config.bitcoinRegtestHost;
        if (regTestHost.isEmpty()) {
            regTestHost = "none";
        }
        RegTestHost.HOST = regTestHost;
        if (Arrays.asList("localhost", "127.0.0.1").contains(regTestHost)) {
            this.bind(RegTestHost.class).toInstance(RegTestHost.LOCALHOST);
        } else if ("none".equals(regTestHost)) {
            this.bind(RegTestHost.class).toInstance(RegTestHost.NONE);
        } else {
            this.bind(RegTestHost.class).toInstance(RegTestHost.REMOTE_HOST);
        }
        this.bind(File.class).annotatedWith(Names.named("walletDir")).toInstance(this.config.walletDir);
        this.bind(Integer.TYPE).annotatedWith(Names.named("walletRpcBindPort")).toInstance(this.config.walletRpcBindPort);
        this.bindConstant().annotatedWith(Names.named("xmrNode")).to(this.config.xmrNode);
        this.bindConstant().annotatedWith(Names.named("xmrNodeUsername")).to(this.config.xmrNodeUsername);
        this.bindConstant().annotatedWith(Names.named("xmrNodePassword")).to(this.config.xmrNodePassword);
        this.bindConstant().annotatedWith(Names.named("xmrNodes")).to(this.config.xmrNodes);
        this.bindConstant().annotatedWith(Names.named("useNativeXmrWallet")).to(this.config.useNativeXmrWallet);
        this.bindConstant().annotatedWith(Names.named("userAgent")).to(this.config.userAgent);
        this.bindConstant().annotatedWith(Names.named("numConnectionsForBtc")).to(this.config.numConnectionsForBtc);
        this.bindConstant().annotatedWith(Names.named("useAllProvidedNodes")).to(this.config.useAllProvidedNodes);
        this.bindConstant().annotatedWith(Names.named("socks5DiscoverMode")).to(this.config.socks5DiscoverMode);
        this.bind(new TypeLiteral<List<String>>(){}).annotatedWith(Names.named("providers")).toInstance(this.config.providers);
        this.bind(AddressEntryList.class).in(Singleton.class);
        this.bind(XmrAddressEntryList.class).in(Singleton.class);
        this.bind(EncryptedConnectionList.class).in(Singleton.class);
        this.bind(WalletsSetup.class).in(Singleton.class);
        this.bind(XmrWalletService.class).in(Singleton.class);
        this.bind(BtcWalletService.class).in(Singleton.class);
        this.bind(TradeWalletService.class).in(Singleton.class);
        this.bind(NonBsqCoinSelector.class).in(Singleton.class);
        this.bind(XmrNodes.class).in(Singleton.class);
        this.bind(Balances.class).in(Singleton.class);
        this.bind(ProvidersRepository.class).in(Singleton.class);
        this.bind(FeeProvider.class).in(Singleton.class);
        this.bind(PriceFeedService.class).in(Singleton.class);
    }
}

