/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.config.Config;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.Utilities;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.script.Script;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AddressEntry;

public final class AddressEntry
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(AddressEntry.class);
    @Nullable
    private final String offerId;
    private final Context context;
    private final byte[] pubKey;
    private final byte[] pubKeyHash;
    private final long coinLockedInMultiSig;
    private final boolean segwit;
    @Nullable
    private transient DeterministicKey keyPair;
    @Nullable
    private transient Address address;
    @Nullable
    private transient String addressString;

    public AddressEntry(DeterministicKey keyPair, Context context, boolean segwit) {
        this(keyPair, context, null, segwit);
    }

    public AddressEntry(DeterministicKey keyPair, Context context, @Nullable String offerId, boolean segwit) {
        this(keyPair, context, offerId, 0L, segwit);
    }

    public AddressEntry(DeterministicKey keyPair, Context context, @Nullable String offerId, long coinLockedInMultiSig, boolean segwit) {
        this(keyPair.getPubKey(), keyPair.getPubKeyHash(), context, offerId, coinLockedInMultiSig, segwit);
        this.keyPair = keyPair;
    }

    private AddressEntry(byte[] pubKey, byte[] pubKeyHash, Context context, @Nullable String offerId, long coinLockedInMultiSig, boolean segwit) {
        this.pubKey = pubKey;
        this.pubKeyHash = pubKeyHash;
        this.context = context;
        this.offerId = offerId;
        this.coinLockedInMultiSig = coinLockedInMultiSig;
        this.segwit = segwit;
    }

    public static AddressEntry fromProto(protobuf.AddressEntry proto) {
        return new AddressEntry(proto.getPubKey().toByteArray(), proto.getPubKeyHash().toByteArray(), ProtoUtil.enumFromProto(Context.class, proto.getContext().name()), ProtoUtil.stringOrNullFromProto(proto.getOfferId()), proto.getCoinLockedInMultiSig(), proto.getSegwit());
    }

    @Override
    public protobuf.AddressEntry toProtoMessage() {
        AddressEntry.Builder builder = protobuf.AddressEntry.newBuilder().setPubKey(ByteString.copyFrom(this.pubKey)).setPubKeyHash(ByteString.copyFrom(this.pubKeyHash)).setContext(AddressEntry.Context.valueOf(this.context.name())).setCoinLockedInMultiSig(this.coinLockedInMultiSig).setSegwit(this.segwit);
        Optional.ofNullable(this.offerId).ifPresent(builder::setOfferId);
        return builder.build();
    }

    public void setDeterministicKey(DeterministicKey deterministicKey) {
        this.keyPair = deterministicKey;
    }

    @NotNull
    public DeterministicKey getKeyPair() {
        Preconditions.checkNotNull(this.keyPair, "keyPair must not be null. If we got the addressEntry created from PB we need to have setDeterministicKey got called before any access with getKeyPair().");
        return this.keyPair;
    }

    @Nullable
    public String getShortOfferId() {
        return this.offerId != null ? Utilities.getShortId(this.offerId) : null;
    }

    @Nullable
    public String getAddressString() {
        if (this.addressString == null && this.getAddress() != null) {
            this.addressString = this.getAddress().toString();
        }
        return this.addressString;
    }

    @Nullable
    public Address getAddress() {
        if (this.address == null && this.keyPair != null) {
            this.address = Address.fromKey(Config.baseCurrencyNetworkParameters(), this.keyPair, this.segwit ? Script.ScriptType.P2WPKH : Script.ScriptType.P2PKH);
        }
        if (this.address == null) {
            log.warn("Address is null at getAddress(). keyPair={}", (Object)this.keyPair);
        }
        return this.address;
    }

    public boolean isAddressNull() {
        return this.address == null;
    }

    public boolean isOpenOffer() {
        return this.context == Context.OFFER_FUNDING || this.context == Context.RESERVED_FOR_TRADE;
    }

    public boolean isTrade() {
        return this.context == Context.MULTI_SIG || this.context == Context.TRADE_PAYOUT;
    }

    public Coin getCoinLockedInMultiSigAsCoin() {
        return Coin.valueOf(this.coinLockedInMultiSig);
    }

    public String toString() {
        return "AddressEntry{address=" + String.valueOf(this.getAddress()) + ", context=" + String.valueOf((Object)this.context) + ", offerId='" + this.offerId + "', coinLockedInMultiSig=" + this.coinLockedInMultiSig + ", segwit=" + this.segwit + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressEntry)) {
            return false;
        }
        AddressEntry other = (AddressEntry)o;
        if (this.getCoinLockedInMultiSig() != other.getCoinLockedInMultiSig()) {
            return false;
        }
        if (this.isSegwit() != other.isSegwit()) {
            return false;
        }
        String this$offerId = this.getOfferId();
        String other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !this$offerId.equals(other$offerId)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)((Object)this$context)).equals((Object)other$context)) {
            return false;
        }
        if (!Arrays.equals(this.getPubKey(), other.getPubKey())) {
            return false;
        }
        return Arrays.equals(this.getPubKeyHash(), other.getPubKeyHash());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $coinLockedInMultiSig = this.getCoinLockedInMultiSig();
        result = result * 59 + (int)($coinLockedInMultiSig >>> 32 ^ $coinLockedInMultiSig);
        result = result * 59 + (this.isSegwit() ? 79 : 97);
        String $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : $offerId.hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)((Object)$context)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPubKey());
        result = result * 59 + Arrays.hashCode(this.getPubKeyHash());
        return result;
    }

    @Nullable
    public String getOfferId() {
        return this.offerId;
    }

    public Context getContext() {
        return this.context;
    }

    public byte[] getPubKey() {
        return this.pubKey;
    }

    public byte[] getPubKeyHash() {
        return this.pubKeyHash;
    }

    public long getCoinLockedInMultiSig() {
        return this.coinLockedInMultiSig;
    }

    public boolean isSegwit() {
        return this.segwit;
    }

    public static enum Context {
        ARBITRATOR,
        AVAILABLE,
        OFFER_FUNDING,
        RESERVED_FOR_TRADE,
        MULTI_SIG,
        TRADE_PAYOUT;

    }
}

