/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.protobuf.Message;
import haveno.common.config.Config;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.xmr.model.AddressEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.SegwitAddress;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.script.Script;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AddressEntryList
implements PersistableEnvelope,
PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(AddressEntryList.class);
    private transient PersistenceManager<AddressEntryList> persistenceManager;
    private transient Wallet wallet;
    private final Set<AddressEntry> entrySet = new CopyOnWriteArraySet<AddressEntry>();

    @Inject
    public AddressEntryList(PersistenceManager<AddressEntryList> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this, PersistenceManager.Source.PRIVATE);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            this.entrySet.clear();
            this.entrySet.addAll(persisted.entrySet);
            completeHandler.run();
        }, completeHandler);
    }

    private AddressEntryList(Set<AddressEntry> entrySet) {
        this.entrySet.addAll(entrySet);
    }

    public static AddressEntryList fromProto(protobuf.AddressEntryList proto) {
        Set<AddressEntry> entrySet = proto.getAddressEntryList().stream().map(AddressEntry::fromProto).collect(Collectors.toSet());
        return new AddressEntryList(entrySet);
    }

    @Override
    public Message toProtoMessage() {
        Set addressEntries = this.entrySet.stream().map(AddressEntry::toProtoMessage).collect(Collectors.toSet());
        return protobuf.PersistableEnvelope.newBuilder().setAddressEntryList(protobuf.AddressEntryList.newBuilder().addAllAddressEntry(addressEntries)).build();
    }

    public void onWalletReady(Wallet wallet) {
        this.wallet = wallet;
        if (!this.entrySet.isEmpty()) {
            HashSet toBeRemoved = new HashSet();
            this.entrySet.forEach(addressEntry -> {
                Script.ScriptType scriptType = addressEntry.isSegwit() ? Script.ScriptType.P2WPKH : Script.ScriptType.P2PKH;
                DeterministicKey keyFromPubHash = (DeterministicKey)wallet.findKeyFromPubKeyHash(addressEntry.getPubKeyHash(), scriptType);
                if (keyFromPubHash != null) {
                    Address addressFromKey = Address.fromKey(Config.baseCurrencyNetworkParameters(), keyFromPubHash, scriptType);
                    if (addressEntry.isAddressNull() || addressFromKey.equals(addressEntry.getAddress())) {
                        addressEntry.setDeterministicKey(keyFromPubHash);
                    } else {
                        log.error("We found an address entry without key but cannot apply the key as the address is not matching. We remove that entry as it seems it is not compatible with our wallet. addressFromKey={}, addressEntry.getAddress()={}", (Object)addressFromKey, (Object)addressEntry.getAddress());
                        toBeRemoved.add(addressEntry);
                    }
                } else {
                    log.error("Key from addressEntry {} not found in that wallet. We remove that entry. This is expected at restore from seeds.", (Object)addressEntry.toString());
                    toBeRemoved.add(addressEntry);
                }
            });
            toBeRemoved.forEach(this.entrySet::remove);
        } else {
            DeterministicKey key = (DeterministicKey)wallet.findKeyFromAddress(wallet.freshReceiveAddress(Script.ScriptType.P2PKH));
            this.entrySet.add(new AddressEntry(key, AddressEntry.Context.ARBITRATOR, false));
        }
        if (wallet.getBalance().isPositive()) {
            wallet.getIssuedReceiveAddresses().stream().filter(this::isAddressNotInEntries).forEach(address -> {
                DeterministicKey key = (DeterministicKey)wallet.findKeyFromAddress((Address)address);
                if (key != null) {
                    log.info("Create AddressEntry for IssuedReceiveAddress. address={}", (Object)address.toString());
                    this.entrySet.add(new AddressEntry(key, AddressEntry.Context.AVAILABLE, address instanceof SegwitAddress));
                } else {
                    log.warn("DeterministicKey for address {} is null", address);
                }
            });
        }
        wallet.addCoinsReceivedEventListener((wallet1, tx, prevBalance, newBalance) -> this.maybeAddNewAddressEntry(tx));
        wallet.addCoinsSentEventListener((wallet1, tx, prevBalance, newBalance) -> this.maybeAddNewAddressEntry(tx));
        this.requestPersistence();
    }

    public ImmutableList<AddressEntry> getAddressEntriesAsListImmutable() {
        return ImmutableList.copyOf(this.entrySet);
    }

    public void addAddressEntry(AddressEntry addressEntry) {
        boolean entryWithSameOfferIdAndContextAlreadyExist = this.entrySet.stream().anyMatch(e -> {
            if (addressEntry.getOfferId() != null) {
                return addressEntry.getOfferId().equals(e.getOfferId()) && addressEntry.getContext() == e.getContext();
            }
            return false;
        });
        if (entryWithSameOfferIdAndContextAlreadyExist) {
            log.error("We have an address entry with the same offer ID and context. We do not add the new one. addressEntry={}, entrySet={}", (Object)addressEntry, (Object)this.entrySet);
            return;
        }
        log.info("addAddressEntry: add new AddressEntry {}", (Object)addressEntry);
        boolean setChangedByAdd = this.entrySet.add(addressEntry);
        if (setChangedByAdd) {
            this.requestPersistence();
        }
    }

    public void swapToAvailable(AddressEntry addressEntry) {
        if (addressEntry.getContext() == AddressEntry.Context.MULTI_SIG) {
            log.error("swapToAvailable called with an addressEntry with MULTI_SIG context. This in not permitted as we must not reuse those address entries and there are no redeemable funds on those addresses. Only the keys are used for creating the Multisig address. addressEntry={}", (Object)addressEntry);
            return;
        }
        log.info("swapToAvailable addressEntry to swap={}", (Object)addressEntry);
        boolean setChangedByRemove = this.entrySet.remove(addressEntry);
        boolean setChangedByAdd = this.entrySet.add(new AddressEntry(addressEntry.getKeyPair(), AddressEntry.Context.AVAILABLE, addressEntry.isSegwit()));
        if (setChangedByRemove || setChangedByAdd) {
            this.requestPersistence();
        }
    }

    public AddressEntry swapAvailableToAddressEntryWithOfferId(AddressEntry addressEntry, AddressEntry.Context context, String offerId) {
        boolean setChangedByRemove = this.entrySet.remove(addressEntry);
        AddressEntry newAddressEntry = new AddressEntry(addressEntry.getKeyPair(), context, offerId, addressEntry.isSegwit());
        log.info("swapAvailableToAddressEntryWithOfferId newAddressEntry={}", (Object)newAddressEntry);
        boolean setChangedByAdd = this.entrySet.add(newAddressEntry);
        if (setChangedByRemove || setChangedByAdd) {
            this.requestPersistence();
        }
        return newAddressEntry;
    }

    public void setCoinLockedInMultiSigAddressEntry(AddressEntry addressEntry, long value) {
        if (addressEntry.getContext() != AddressEntry.Context.MULTI_SIG) {
            log.error("setCoinLockedInMultiSigAddressEntry must be called only on MULTI_SIG entries");
            return;
        }
        log.info("setCoinLockedInMultiSigAddressEntry addressEntry={}, value={}", (Object)addressEntry, (Object)value);
        boolean setChangedByRemove = this.entrySet.remove(addressEntry);
        AddressEntry entry = new AddressEntry(addressEntry.getKeyPair(), addressEntry.getContext(), addressEntry.getOfferId(), value, addressEntry.isSegwit());
        boolean setChangedByAdd = this.entrySet.add(entry);
        if (setChangedByRemove || setChangedByAdd) {
            this.requestPersistence();
        }
    }

    public void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    private void maybeAddNewAddressEntry(Transaction tx) {
        tx.getOutputs().stream().filter(output -> output.isMine(this.wallet)).map(output -> output.getScriptPubKey().getToAddress(this.wallet.getNetworkParameters())).filter(Objects::nonNull).filter(this::isAddressNotInEntries).map(address -> Pair.of(address, (DeterministicKey)this.wallet.findKeyFromAddress((Address)address))).filter(pair -> pair.getRight() != null).map(pair -> new AddressEntry((DeterministicKey)pair.getRight(), AddressEntry.Context.AVAILABLE, pair.getLeft() instanceof SegwitAddress)).forEach(this::addAddressEntry);
    }

    private boolean isAddressNotInEntries(Address address) {
        return this.entrySet.stream().noneMatch(e -> address.equals(e.getAddress()));
    }

    public String toString() {
        return "AddressEntryList{,\n     entrySet=" + String.valueOf(this.entrySet) + "\n}";
    }
}

