/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import com.google.inject.Inject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.ScryptUtil;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.api.CoreAccountService;
import haveno.core.api.model.EncryptedConnection;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.NonNull;
import monero.common.MoneroRpcConnection;
import org.bitcoinj.crypto.KeyCrypterScrypt;

public class EncryptedConnectionList
implements PersistableEnvelope,
PersistedDataHost {
    private static final int MIN_FAKE_PASSWORD_LENGTH = 5;
    private static final int MAX_FAKE_PASSWORD_LENGTH = 32;
    private static final int SALT_LENGTH = 16;
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();
    private final transient Lock readLock = this.lock.readLock();
    private final transient Lock writeLock = this.lock.writeLock();
    private final transient SecureRandom random = new SecureRandom();
    private transient KeyCrypterScrypt keyCrypterScrypt;
    private transient SecretKey encryptionKey;
    private transient CoreAccountService accountService;
    private transient PersistenceManager<EncryptedConnectionList> persistenceManager;
    private final Map<String, EncryptedConnection> items = new HashMap<String, EncryptedConnection>();
    @NonNull
    private String currentConnectionUrl = "";
    private long refreshPeriod;
    private boolean autoSwitch = true;

    @Inject
    public EncryptedConnectionList(PersistenceManager<EncryptedConnectionList> persistenceManager, CoreAccountService accountService) {
        this.accountService = accountService;
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this, "EncryptedConnectionList", PersistenceManager.Source.PRIVATE);
    }

    private EncryptedConnectionList(byte[] salt, List<EncryptedConnection> items, @NonNull String currentConnectionUrl, long refreshPeriod, boolean autoSwitch) {
        if (currentConnectionUrl == null) {
            throw new NullPointerException("currentConnectionUrl is marked non-null but is null");
        }
        this.keyCrypterScrypt = ScryptUtil.getKeyCrypterScrypt(salt);
        this.items.putAll(items.stream().collect(Collectors.toMap(EncryptedConnection::getUrl, Function.identity())));
        this.currentConnectionUrl = currentConnectionUrl;
        this.refreshPeriod = refreshPeriod;
        this.autoSwitch = autoSwitch;
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persistedEncryptedConnectionList -> {
            this.writeLock.lock();
            try {
                this.initializeEncryption(persistedEncryptedConnectionList.keyCrypterScrypt);
                this.items.clear();
                this.items.putAll(persistedEncryptedConnectionList.items);
                this.currentConnectionUrl = persistedEncryptedConnectionList.currentConnectionUrl;
                this.refreshPeriod = persistedEncryptedConnectionList.refreshPeriod;
                this.autoSwitch = persistedEncryptedConnectionList.autoSwitch;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.writeLock.unlock();
            }
            completeHandler.run();
        }, () -> {
            this.writeLock.lock();
            try {
                this.initializeEncryption(ScryptUtil.getKeyCrypterScrypt());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.writeLock.unlock();
            }
            completeHandler.run();
        });
    }

    private void initializeEncryption(KeyCrypterScrypt keyCrypterScrypt) {
        this.keyCrypterScrypt = keyCrypterScrypt;
        this.encryptionKey = this.toSecretKey(this.accountService.getPassword());
    }

    public List<MoneroRpcConnection> getConnections() {
        this.readLock.lock();
        try {
            List<MoneroRpcConnection> list = this.items.values().stream().map(this::toMoneroRpcConnection).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasConnection(String connection) {
        this.readLock.lock();
        try {
            boolean bl = this.items.containsKey(connection);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(MoneroRpcConnection connection) {
        EncryptedConnection currentValue;
        this.writeLock.lock();
        try {
            EncryptedConnection encryptedConnection = this.toEncryptedConnection(connection);
            currentValue = this.items.putIfAbsent(connection.getUri(), encryptedConnection);
        }
        finally {
            this.writeLock.unlock();
        }
        if (currentValue != null) {
            throw new IllegalStateException(String.format("There exists already a connection for \"%s\"", connection.getUri()));
        }
        this.requestPersistence();
    }

    public void removeConnection(String connection) {
        this.writeLock.lock();
        try {
            this.items.remove(connection);
        }
        finally {
            this.writeLock.unlock();
        }
        this.requestPersistence();
    }

    public void setAutoSwitch(boolean autoSwitch) {
        boolean changed;
        this.writeLock.lock();
        try {
            this.autoSwitch = autoSwitch;
            changed = this.autoSwitch != this.autoSwitch;
        }
        finally {
            this.writeLock.unlock();
        }
        if (changed) {
            this.requestPersistence();
        }
    }

    public boolean getAutoSwitch() {
        this.readLock.lock();
        try {
            boolean bl = this.autoSwitch;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setRefreshPeriod(Long refreshPeriod) {
        boolean changed;
        this.writeLock.lock();
        try {
            this.refreshPeriod = refreshPeriod == null ? 0L : refreshPeriod;
            changed = this.refreshPeriod != this.refreshPeriod;
        }
        finally {
            this.writeLock.unlock();
        }
        if (changed) {
            this.requestPersistence();
        }
    }

    public long getRefreshPeriod() {
        this.readLock.lock();
        try {
            long l = this.refreshPeriod;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCurrentConnectionUri(String currentConnectionUrl) {
        boolean changed;
        this.writeLock.lock();
        try {
            this.currentConnectionUrl = currentConnectionUrl == null ? "" : currentConnectionUrl;
            changed = !this.currentConnectionUrl.equals(this.currentConnectionUrl);
        }
        finally {
            this.writeLock.unlock();
        }
        if (changed) {
            this.requestPersistence();
        }
    }

    public Optional<String> getCurrentConnectionUri() {
        this.readLock.lock();
        try {
            Optional<String> optional = Optional.of(this.currentConnectionUrl).filter(s2 -> !s2.isEmpty());
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toProtoMessage() {
        long refreshPeriod;
        boolean autoSwitchEnabled;
        String currentConnectionUrl;
        ByteString saltString;
        List connections;
        this.readLock.lock();
        try {
            connections = this.items.values().stream().map(EncryptedConnection::toProtoMessage).collect(Collectors.toList());
            saltString = this.keyCrypterScrypt.getScryptParameters().getSalt();
            currentConnectionUrl = this.currentConnectionUrl;
            autoSwitchEnabled = this.autoSwitch;
            refreshPeriod = this.refreshPeriod;
        }
        finally {
            this.readLock.unlock();
        }
        return protobuf.PersistableEnvelope.newBuilder().setEncryptedConnectionList(protobuf.EncryptedConnectionList.newBuilder().setSalt(saltString).addAllItems(connections).setCurrentConnectionUrl(currentConnectionUrl).setRefreshPeriod(refreshPeriod).setAutoSwitch(autoSwitchEnabled)).build();
    }

    public static EncryptedConnectionList fromProto(protobuf.EncryptedConnectionList proto) {
        List<EncryptedConnection> items = proto.getItemsList().stream().map(EncryptedConnection::fromProto).collect(Collectors.toList());
        return new EncryptedConnectionList(proto.getSalt().toByteArray(), items, proto.getCurrentConnectionUrl(), proto.getRefreshPeriod(), proto.getAutoSwitch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPassword, String newPassword) {
        this.writeLock.lock();
        try {
            SecretKey oldSecret = this.encryptionKey;
            assert (Objects.equals(oldSecret, this.toSecretKey(oldPassword))) : "Old secret does not match old password";
            this.encryptionKey = this.toSecretKey(newPassword);
            this.items.replaceAll((key, connection) -> EncryptedConnectionList.reEncrypt(connection, oldSecret, this.encryptionKey));
        }
        finally {
            this.writeLock.unlock();
        }
        this.requestPersistence();
    }

    private SecretKey toSecretKey(String password) {
        if (password == null) {
            return null;
        }
        return Encryption.getSecretKeyFromBytes(this.keyCrypterScrypt.deriveKey(password).getKey());
    }

    private static EncryptedConnection reEncrypt(EncryptedConnection connection, SecretKey oldSecret, SecretKey newSecret) {
        return connection.toBuilder().encryptedPassword(EncryptedConnectionList.reEncrypt(connection.getEncryptedPassword(), oldSecret, newSecret)).build();
    }

    private static byte[] reEncrypt(byte[] value, SecretKey oldSecret, SecretKey newSecret) {
        byte[] decrypted = oldSecret == null ? value : EncryptedConnectionList.decrypt(value, oldSecret);
        return newSecret == null ? decrypted : EncryptedConnectionList.encrypt(decrypted, newSecret);
    }

    private static byte[] decrypt(byte[] encrypted, SecretKey secret) {
        if (secret == null) {
            return encrypted;
        }
        try {
            return Encryption.decrypt(encrypted, secret);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("Incorrect password", e);
        }
    }

    private static byte[] encrypt(byte[] unencrypted, SecretKey secretKey) {
        if (secretKey == null) {
            return unencrypted;
        }
        try {
            return Encryption.encrypt(unencrypted, secretKey);
        }
        catch (CryptoException e) {
            throw new RuntimeException("Could not encrypt data with the provided secret", e);
        }
    }

    private EncryptedConnection toEncryptedConnection(MoneroRpcConnection connection) {
        String password = connection.getPassword();
        byte[] passwordBytes = password == null ? null : password.getBytes(StandardCharsets.UTF_8);
        byte[] passwordSalt = this.generateSalt(passwordBytes);
        byte[] encryptedPassword = this.encryptPassword(passwordBytes, passwordSalt);
        return EncryptedConnection.builder().url(connection.getUri()).username(connection.getUsername() == null ? "" : connection.getUsername()).encryptedPassword(encryptedPassword).encryptionSalt(passwordSalt).priority(connection.getPriority()).build();
    }

    private MoneroRpcConnection toMoneroRpcConnection(EncryptedConnection connection) {
        byte[] decryptedPasswordBytes = this.decryptPassword(connection.getEncryptedPassword(), connection.getEncryptionSalt());
        String password = decryptedPasswordBytes == null ? null : new String(decryptedPasswordBytes, StandardCharsets.UTF_8);
        String username = connection.getUsername().isEmpty() ? null : connection.getUsername();
        MoneroRpcConnection moneroRpcConnection = new MoneroRpcConnection(connection.getUrl(), username, password);
        moneroRpcConnection.setPriority(connection.getPriority());
        return moneroRpcConnection;
    }

    private byte[] encryptPassword(byte[] password, byte[] salt) {
        byte[] saltedPassword;
        if (password == null) {
            int fakePasswordLength = this.random.nextInt(28) + 5;
            byte[] fakePassword = new byte[fakePasswordLength];
            this.random.nextBytes(fakePassword);
            saltedPassword = new byte[salt.length + fakePasswordLength];
            System.arraycopy(salt, 0, saltedPassword, 0, salt.length);
            System.arraycopy(fakePassword, 0, saltedPassword, salt.length, fakePassword.length);
        } else {
            saltedPassword = new byte[password.length + salt.length];
            System.arraycopy(password, 0, saltedPassword, 0, password.length);
            System.arraycopy(salt, 0, saltedPassword, password.length, salt.length);
        }
        return EncryptedConnectionList.encrypt(saltedPassword, this.encryptionKey);
    }

    private byte[] decryptPassword(byte[] encryptedSaltedPassword, byte[] salt) {
        byte[] decryptedSaltedPassword = EncryptedConnectionList.decrypt(encryptedSaltedPassword, this.encryptionKey);
        if (EncryptedConnectionList.arrayStartsWith(decryptedSaltedPassword, salt)) {
            return null;
        }
        byte[] decryptedPassword = new byte[decryptedSaltedPassword.length - salt.length];
        System.arraycopy(decryptedSaltedPassword, 0, decryptedPassword, 0, decryptedPassword.length);
        return decryptedPassword;
    }

    private byte[] generateSalt(byte[] password) {
        byte[] salt = new byte[16];
        do {
            this.random.nextBytes(salt);
        } while (password != null && EncryptedConnectionList.arrayStartsWith(password, salt));
        return salt;
    }

    private static boolean arrayStartsWith(byte[] container, byte[] prefix) {
        if (container.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (container[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }
}

