/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import com.google.protobuf.ByteString;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.Utilities;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RawTransactionInput
implements NetworkPayload,
PersistablePayload {
    public final long index;
    public final byte[] parentTransaction;
    public final long value;

    public RawTransactionInput(long index, byte[] parentTransaction, long value) {
        this.index = index;
        this.parentTransaction = parentTransaction;
        this.value = value;
    }

    @Override
    public protobuf.RawTransactionInput toProtoMessage() {
        return protobuf.RawTransactionInput.newBuilder().setIndex(this.index).setParentTransaction(ByteString.copyFrom(this.parentTransaction)).setValue(this.value).build();
    }

    public static RawTransactionInput fromProto(protobuf.RawTransactionInput proto) {
        return new RawTransactionInput(proto.getIndex(), proto.getParentTransaction().toByteArray(), proto.getValue());
    }

    public String toString() {
        return "RawTransactionInput{index=" + this.index + ", parentTransaction as HEX " + Utilities.bytesAsHexString(this.parentTransaction) + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawTransactionInput)) {
            return false;
        }
        RawTransactionInput other = (RawTransactionInput)o;
        if (this.index != other.index) {
            return false;
        }
        if (this.value != other.value) {
            return false;
        }
        return Arrays.equals(this.parentTransaction, other.parentTransaction);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $index = this.index;
        result = result * 59 + (int)($index >>> 32 ^ $index);
        long $value = this.value;
        result = result * 59 + (int)($value >>> 32 ^ $value);
        result = result * 59 + Arrays.hashCode(this.parentTransaction);
        return result;
    }
}

