/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.Utilities;
import java.util.Optional;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.XmrAddressEntry;

public final class XmrAddressEntry
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(XmrAddressEntry.class);
    @Nullable
    private final String offerId;
    private final Context context;
    private final int subaddressIndex;
    private final String addressString;
    private long coinLockedInMultiSig;

    public XmrAddressEntry(int subaddressIndex, String address, Context context) {
        this(subaddressIndex, address, context, null, null);
    }

    public XmrAddressEntry(int subaddressIndex, String address, Context context, @Nullable String offerId, Coin coinLockedInMultiSig) {
        this.subaddressIndex = subaddressIndex;
        this.addressString = address;
        this.offerId = offerId;
        this.context = context;
        if (coinLockedInMultiSig != null) {
            this.coinLockedInMultiSig = coinLockedInMultiSig.value;
        }
    }

    public static XmrAddressEntry fromProto(protobuf.XmrAddressEntry proto) {
        return new XmrAddressEntry(proto.getSubaddressIndex(), ProtoUtil.stringOrNullFromProto(proto.getAddressString()), ProtoUtil.enumFromProto(Context.class, proto.getContext().name()), ProtoUtil.stringOrNullFromProto(proto.getOfferId()), Coin.valueOf(proto.getCoinLockedInMultiSig()));
    }

    @Override
    public protobuf.XmrAddressEntry toProtoMessage() {
        XmrAddressEntry.Builder builder = protobuf.XmrAddressEntry.newBuilder().setSubaddressIndex(this.subaddressIndex).setAddressString(this.addressString).setContext(XmrAddressEntry.Context.valueOf(this.context.name())).setCoinLockedInMultiSig(this.coinLockedInMultiSig);
        Optional.ofNullable(this.offerId).ifPresent(builder::setOfferId);
        return builder.build();
    }

    public void setCoinLockedInMultiSig(@NotNull Coin coinLockedInMultiSig) {
        this.coinLockedInMultiSig = coinLockedInMultiSig.value;
    }

    @Nullable
    public String getShortOfferId() {
        return this.offerId != null ? Utilities.getShortId(this.offerId) : null;
    }

    public boolean isOpenOffer() {
        return this.context == Context.OFFER_FUNDING;
    }

    public boolean isTradePayout() {
        return this.context == Context.TRADE_PAYOUT;
    }

    public boolean isTradable() {
        return this.isOpenOffer() || this.isTradePayout();
    }

    public Coin getCoinLockedInMultiSig() {
        return Coin.valueOf(this.coinLockedInMultiSig);
    }

    public String toString() {
        return "XmrAddressEntry{offerId='" + this.getOfferId() + "', context=" + String.valueOf((Object)this.context) + ", subaddressIndex=" + this.getSubaddressIndex() + ", address=" + this.getAddressString() + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmrAddressEntry)) {
            return false;
        }
        XmrAddressEntry other = (XmrAddressEntry)o;
        if (this.getSubaddressIndex() != other.getSubaddressIndex()) {
            return false;
        }
        Coin this$coinLockedInMultiSig = this.getCoinLockedInMultiSig();
        Coin other$coinLockedInMultiSig = other.getCoinLockedInMultiSig();
        if (this$coinLockedInMultiSig == null ? other$coinLockedInMultiSig != null : !((Object)this$coinLockedInMultiSig).equals(other$coinLockedInMultiSig)) {
            return false;
        }
        String this$offerId = this.getOfferId();
        String other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !this$offerId.equals(other$offerId)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)((Object)this$context)).equals((Object)other$context)) {
            return false;
        }
        String this$addressString = this.getAddressString();
        String other$addressString = other.getAddressString();
        return !(this$addressString == null ? other$addressString != null : !this$addressString.equals(other$addressString));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubaddressIndex();
        Coin $coinLockedInMultiSig = this.getCoinLockedInMultiSig();
        result = result * 59 + ($coinLockedInMultiSig == null ? 43 : ((Object)$coinLockedInMultiSig).hashCode());
        String $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : $offerId.hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)((Object)$context)).hashCode());
        String $addressString = this.getAddressString();
        result = result * 59 + ($addressString == null ? 43 : $addressString.hashCode());
        return result;
    }

    @Nullable
    public String getOfferId() {
        return this.offerId;
    }

    public Context getContext() {
        return this.context;
    }

    public int getSubaddressIndex() {
        return this.subaddressIndex;
    }

    public String getAddressString() {
        return this.addressString;
    }

    public static enum Context {
        ARBITRATOR,
        BASE_ADDRESS,
        AVAILABLE,
        OFFER_FUNDING,
        TRADE_PAYOUT;

    }
}

