/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.model;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.protobuf.Message;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.xmr.model.XmrAddressEntry;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmrAddressEntryList
implements PersistableEnvelope,
PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(XmrAddressEntryList.class);
    private transient PersistenceManager<XmrAddressEntryList> persistenceManager;
    private final Set<XmrAddressEntry> entrySet = new CopyOnWriteArraySet<XmrAddressEntry>();

    @Inject
    public XmrAddressEntryList(PersistenceManager<XmrAddressEntryList> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this, PersistenceManager.Source.PRIVATE);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            this.entrySet.clear();
            this.entrySet.addAll(persisted.entrySet);
            completeHandler.run();
        }, completeHandler);
    }

    private XmrAddressEntryList(Set<XmrAddressEntry> entrySet) {
        this.entrySet.addAll(entrySet);
    }

    public static XmrAddressEntryList fromProto(protobuf.XmrAddressEntryList proto) {
        Set<XmrAddressEntry> entrySet = proto.getXmrAddressEntryList().stream().map(XmrAddressEntry::fromProto).collect(Collectors.toSet());
        return new XmrAddressEntryList(entrySet);
    }

    @Override
    public Message toProtoMessage() {
        Set addressEntries = this.entrySet.stream().map(XmrAddressEntry::toProtoMessage).collect(Collectors.toSet());
        return protobuf.PersistableEnvelope.newBuilder().setXmrAddressEntryList(protobuf.XmrAddressEntryList.newBuilder().addAllXmrAddressEntry(addressEntries)).build();
    }

    public ImmutableList<XmrAddressEntry> getAddressEntriesAsListImmutable() {
        return ImmutableList.copyOf(this.entrySet);
    }

    public boolean addAddressEntry(XmrAddressEntry addressEntry) {
        boolean entryWithSameOfferIdAndContextAlreadyExist = this.entrySet.stream().anyMatch(e -> {
            if (addressEntry.getOfferId() != null) {
                return addressEntry.getOfferId().equals(e.getOfferId()) && addressEntry.getContext() == e.getContext();
            }
            return false;
        });
        if (entryWithSameOfferIdAndContextAlreadyExist) {
            throw new IllegalArgumentException("We have an address entry with the same offer ID and context. We do not add the new one. addressEntry=" + String.valueOf(addressEntry));
        }
        boolean setChangedByAdd = this.entrySet.add(addressEntry);
        if (setChangedByAdd) {
            this.requestPersistence();
        }
        return setChangedByAdd;
    }

    public void swapToAvailable(XmrAddressEntry addressEntry) {
        boolean entryWithSameContextStillExists;
        log.info("swapToAvailable addressEntry to swap={}", (Object)addressEntry);
        if (this.entrySet.remove(addressEntry)) {
            this.requestPersistence();
        }
        if (entryWithSameContextStillExists = this.entrySet.stream().anyMatch(entry -> {
            if (addressEntry.getAddressString() != null) {
                return addressEntry.getAddressString().equals(entry.getAddressString()) && addressEntry.getContext() == entry.getContext();
            }
            return false;
        })) {
            return;
        }
        if (this.entrySet.add(new XmrAddressEntry(addressEntry.getSubaddressIndex(), addressEntry.getAddressString(), XmrAddressEntry.Context.AVAILABLE))) {
            this.requestPersistence();
        }
    }

    public XmrAddressEntry swapAvailableToAddressEntryWithOfferId(XmrAddressEntry addressEntry, XmrAddressEntry.Context context, String offerId) {
        boolean setChangedByRemove = this.entrySet.remove(addressEntry);
        XmrAddressEntry newAddressEntry = new XmrAddressEntry(addressEntry.getSubaddressIndex(), addressEntry.getAddressString(), context, offerId, null);
        boolean setChangedByAdd = false;
        try {
            setChangedByAdd = this.addAddressEntry(newAddressEntry);
        }
        catch (Exception e) {
            this.entrySet.add(addressEntry);
            throw e;
        }
        if (setChangedByRemove || setChangedByAdd) {
            this.requestPersistence();
        }
        return newAddressEntry;
    }

    public void clear() {
        this.entrySet.clear();
        this.requestPersistence();
    }

    public void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    public String toString() {
        return "XmrAddressEntryList{,\n     entrySet=" + String.valueOf(this.entrySet) + "\n}";
    }
}

