/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.config.Config;
import haveno.core.xmr.setup.WalletConfig;
import haveno.network.Socks5MultiDiscovery;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.params.MainNetParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrNetworkConfig {
    private static final Logger log = LoggerFactory.getLogger(XmrNetworkConfig.class);
    @Nullable
    private final Socks5Proxy proxy;
    private final WalletConfig delegate;
    private final NetworkParameters parameters;
    private final int socks5DiscoverMode;

    public XmrNetworkConfig(WalletConfig delegate, NetworkParameters parameters, int socks5DiscoverMode, @Nullable Socks5Proxy proxy) {
        this.delegate = delegate;
        this.parameters = parameters;
        this.socks5DiscoverMode = socks5DiscoverMode;
        this.proxy = proxy;
    }

    public void proposePeers(List<PeerAddress> peers) {
        if (!peers.isEmpty()) {
            log.info("You connect with peerAddresses: {}", (Object)peers);
            PeerAddress[] peerAddresses = peers.toArray(new PeerAddress[peers.size()]);
            this.delegate.setPeerNodes(peerAddresses);
        } else if (this.proxy != null) {
            MainNetParams mainNetParams;
            if (log.isWarnEnabled() && this.parameters.equals(mainNetParams = MainNetParams.get())) {
                log.warn("You use the public Bitcoin network and are exposed to privacy issues caused by the broken bloom filters. See https://haveno.exchange/blog/privacy-in-bitsquare/ for more info. It is recommended to use the provided nodes.");
            }
            this.delegate.setDiscovery(new Socks5MultiDiscovery(this.proxy, this.parameters, this.socks5DiscoverMode));
        } else if (Config.baseCurrencyNetwork().isMainnet()) {
            log.warn("You don't use tor and use the public Bitcoin network and are exposed to privacy issues caused by the broken bloom filters. See https://haveno.exchange/blog/privacy-in-bitsquare/ for more info. It is recommended to use Tor and the provided nodes.");
        }
    }
}

