/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import com.google.common.base.Preconditions;
import haveno.common.config.Config;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.nodes.XmrNodesSetupPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrNodes {
    private static final Logger log = LoggerFactory.getLogger(XmrNodes.class);

    public List<XmrNode> selectPreferredNodes(XmrNodesSetupPreferences xmrNodesSetupPreferences) {
        return xmrNodesSetupPreferences.selectPreferredNodes(this);
    }

    public List<XmrNode> getAllXmrNodes() {
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return Arrays.asList(new XmrNode(MoneroNodesOption.PROVIDED, null, null, "127.0.0.1", 28081, 1, "@local"));
            }
            case XMR_STAGENET: {
                return Arrays.asList(new XmrNode(MoneroNodesOption.PROVIDED, null, null, "127.0.0.1", 38081, 1, "@local"), new XmrNode(MoneroNodesOption.PROVIDED, null, null, "127.0.0.1", 39081, 1, "@local"), new XmrNode(MoneroNodesOption.PROVIDED, null, null, "45.63.8.26", 38081, 2, "@haveno"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "node.sethforprivacy.com", 38089, 3, null), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "node2.sethforprivacy.com", 38089, 3, null), new XmrNode(MoneroNodesOption.PUBLIC, null, "plowsof3t5hogddwabaeiyrno25efmzfxyro2vligremt7sxpsclfaid.onion", null, 38089, 3, null));
            }
            case XMR_MAINNET: {
                return Arrays.asList(new XmrNode(MoneroNodesOption.PUBLIC, null, null, "127.0.0.1", 18081, 1, "@local"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "xmr-node.cakewallet.com", 18081, 2, "@cakewallet"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "nodes.hashvault.pro", 18080, 2, "@HashVault"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "p2pmd.xmrvsbeast.com", 18080, 2, "@xmrvsbeast"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "node.monerodevs.org", 18089, 2, "@monerodevs.org"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "nodex.monerujo.io", 18081, 2, "@monerujo.io"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "rucknium.me", 18081, 2, "@Rucknium"), new XmrNode(MoneroNodesOption.PUBLIC, null, null, "node.sethforprivacy.com", 18089, 2, "@sethforprivacy"));
            }
        }
        throw new IllegalStateException("Unexpected base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    public List<XmrNode> getProvidedXmrNodes() {
        return this.getXmrNodes(MoneroNodesOption.PROVIDED);
    }

    public List<XmrNode> getPublicXmrNodes() {
        return this.getXmrNodes(MoneroNodesOption.PUBLIC);
    }

    public List<XmrNode> getCustomXmrNodes() {
        return this.getXmrNodes(MoneroNodesOption.CUSTOM);
    }

    private List<XmrNode> getXmrNodes(MoneroNodesOption type) {
        ArrayList<XmrNode> nodes = new ArrayList<XmrNode>();
        for (XmrNode node : this.getAllXmrNodes()) {
            if (node.getType() != type) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List<XmrNode> toCustomXmrNodesList(Collection<String> nodes) {
        return nodes.stream().filter(e -> !e.isEmpty()).map(XmrNode::fromFullAddress).collect(Collectors.toList());
    }

    public static class XmrNode {
        private final MoneroNodesOption type;
        @Nullable
        private final String onionAddress;
        @Nullable
        private final String hostName;
        @Nullable
        private final String operator;
        @Nullable
        private final String address;
        private int port = HavenoUtils.getDefaultMoneroPort();
        private int priority = 0;

        public static XmrNode fromFullAddress(String fullAddress) {
            String[] parts = fullAddress.split("]");
            Preconditions.checkArgument(parts.length > 0);
            Object host = "";
            int port = HavenoUtils.getDefaultMoneroPort();
            if (parts[0].contains("[") && parts[0].contains(":")) {
                host = parts[0] + "]";
                if (parts.length == 2) {
                    port = Integer.parseInt(parts[1].replace(":", ""));
                }
            } else if (parts[0].contains(":") && !parts[0].contains(".")) {
                host = parts[0];
            } else if (parts[0].contains(".")) {
                parts = fullAddress.split(":");
                Preconditions.checkArgument(parts.length > 0);
                host = parts[0];
                if (parts.length == 2) {
                    port = Integer.parseInt(parts[1]);
                }
            }
            Preconditions.checkArgument(((String)host).length() > 0, "XmrNode address format not recognised");
            return ((String)host).contains(".onion") ? new XmrNode(MoneroNodesOption.CUSTOM, null, (String)host, null, port, null, null) : new XmrNode(MoneroNodesOption.CUSTOM, null, null, (String)host, port, null, null);
        }

        public XmrNode(MoneroNodesOption type, @Nullable String hostName, @Nullable String onionAddress, @Nullable String address, int port, Integer priority, @Nullable String operator) {
            this.type = type;
            this.hostName = hostName;
            this.onionAddress = onionAddress;
            this.address = address;
            this.port = port;
            this.priority = priority == null ? 0 : priority;
            this.operator = operator;
        }

        public String getHostNameOrAddress() {
            if (this.hostName != null) {
                return this.hostName;
            }
            return this.address;
        }

        public boolean hasOnionAddress() {
            return this.onionAddress != null;
        }

        public boolean hasClearNetAddress() {
            return this.hostName != null || this.address != null;
        }

        public String getClearNetUri() {
            if (!this.hasClearNetAddress()) {
                throw new IllegalStateException("XmrNode does not have clearnet address");
            }
            return "http://" + this.getHostNameOrAddress() + ":" + this.port;
        }

        public String toString() {
            return "onionAddress='" + this.onionAddress + "', hostName='" + this.hostName + "', address='" + this.address + "', port='" + this.port + "', priority='" + this.priority + "', operator='" + this.operator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmrNode)) {
                return false;
            }
            XmrNode other = (XmrNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            MoneroNodesOption this$type = this.getType();
            MoneroNodesOption other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$onionAddress = this.getOnionAddress();
            String other$onionAddress = other.getOnionAddress();
            if (this$onionAddress == null ? other$onionAddress != null : !this$onionAddress.equals(other$onionAddress)) {
                return false;
            }
            String this$hostName = this.getHostName();
            String other$hostName = other.getHostName();
            if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XmrNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            result = result * 59 + this.getPriority();
            MoneroNodesOption $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $onionAddress = this.getOnionAddress();
            result = result * 59 + ($onionAddress == null ? 43 : $onionAddress.hashCode());
            String $hostName = this.getHostName();
            result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        public MoneroNodesOption getType() {
            return this.type;
        }

        @Nullable
        public String getOnionAddress() {
            return this.onionAddress;
        }

        @Nullable
        public String getHostName() {
            return this.hostName;
        }

        @Nullable
        public String getOperator() {
            return this.operator;
        }

        @Nullable
        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static enum MoneroNodesOption {
        PROVIDED,
        CUSTOM,
        PUBLIC;

    }
}

