/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.core.xmr.nodes.XmrNodeConverter;
import haveno.core.xmr.nodes.XmrNodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bitcoinj.core.PeerAddress;

public class XmrNodesRepository {
    private final XmrNodeConverter converter;
    private final List<XmrNodes.XmrNode> nodes;

    public XmrNodesRepository(List<XmrNodes.XmrNode> nodes) {
        this(new XmrNodeConverter(), nodes);
    }

    public XmrNodesRepository(XmrNodeConverter converter, List<XmrNodes.XmrNode> nodes) {
        this.converter = converter;
        this.nodes = nodes;
    }

    public List<PeerAddress> getPeerAddresses(@Nullable Socks5Proxy proxy, boolean isUseClearNodesWithProxies) {
        List<PeerAddress> result;
        if (proxy != null) {
            List<PeerAddress> onionHosts = this.getOnionHosts();
            result = new ArrayList<PeerAddress>(onionHosts);
            if (isUseClearNodesWithProxies) {
                List<PeerAddress> torAddresses = this.getClearNodesBehindProxy(proxy);
                result.addAll(torAddresses);
            }
        } else {
            result = this.getClearNodes();
        }
        return result;
    }

    private List<PeerAddress> getClearNodes() {
        return this.nodes.stream().filter(XmrNodes.XmrNode::hasClearNetAddress).flatMap(node -> XmrNodesRepository.nullableAsStream(this.converter.convertClearNode((XmrNodes.XmrNode)node))).collect(Collectors.toList());
    }

    private List<PeerAddress> getOnionHosts() {
        return this.nodes.stream().filter(XmrNodes.XmrNode::hasOnionAddress).flatMap(node -> XmrNodesRepository.nullableAsStream(this.converter.convertOnionHost((XmrNodes.XmrNode)node))).collect(Collectors.toList());
    }

    private List<PeerAddress> getClearNodesBehindProxy(Socks5Proxy proxy) {
        return this.nodes.stream().filter(XmrNodes.XmrNode::hasClearNetAddress).flatMap(node -> XmrNodesRepository.nullableAsStream(this.converter.convertWithTor((XmrNodes.XmrNode)node, proxy))).collect(Collectors.toList());
    }

    private static <T> Stream<T> nullableAsStream(@Nullable T item) {
        return Optional.ofNullable(item).stream();
    }
}

