/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.nodes;

import haveno.common.util.Utilities;
import haveno.core.user.Preferences;
import haveno.core.xmr.nodes.XmrNodes;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrNodesSetupPreferences {
    private static final Logger log = LoggerFactory.getLogger(XmrNodesSetupPreferences.class);
    private final Preferences preferences;

    public XmrNodesSetupPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public List<XmrNodes.XmrNode> selectPreferredNodes(XmrNodes nodes) {
        List<XmrNodes.XmrNode> result;
        XmrNodes.MoneroNodesOption nodesOption = XmrNodes.MoneroNodesOption.values()[this.preferences.getMoneroNodesOptionOrdinal()];
        switch (nodesOption) {
            case CUSTOM: {
                String moneroNodes = this.preferences.getMoneroNodes();
                Set<String> distinctNodes = Utilities.commaSeparatedListToSet(moneroNodes, false);
                result = XmrNodes.toCustomXmrNodesList(distinctNodes);
                if (!result.isEmpty()) break;
                log.warn("Custom nodes is set but no valid nodes are provided. We fall back to provided nodes option.");
                this.preferences.setMoneroNodesOptionOrdinal(XmrNodes.MoneroNodesOption.PROVIDED.ordinal());
                result = nodes.getProvidedXmrNodes();
                break;
            }
            case PUBLIC: {
                result = nodes.getAllXmrNodes();
                break;
            }
            default: {
                result = nodes.getProvidedXmrNodes();
            }
        }
        return result;
    }

    public boolean isUseCustomNodes() {
        return XmrNodes.MoneroNodesOption.CUSTOM.ordinal() == this.preferences.getMoneroNodesOptionOrdinal();
    }

    public int calculateMinBroadcastConnections(List<XmrNodes.XmrNode> nodes) {
        XmrNodes.MoneroNodesOption nodesOption = XmrNodes.MoneroNodesOption.values()[this.preferences.getMoneroNodesOptionOrdinal()];
        return switch (nodesOption) {
            case XmrNodes.MoneroNodesOption.CUSTOM -> (int)Math.ceil((double)nodes.size() * 0.5);
            case XmrNodes.MoneroNodesOption.PUBLIC -> (int)Math.floor(7.2);
            default -> 4;
        };
    }
}

