/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.setup;

import com.google.common.io.Closeables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.util.Preconditions;
import haveno.core.api.XmrLocalNode;
import haveno.core.xmr.setup.HavenoKeyChainGroupStructure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.Nullable;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.script.Script;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.SPVBlockStore;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletConfig
extends AbstractIdleService {
    protected static final Logger log = LoggerFactory.getLogger(WalletConfig.class);
    protected final NetworkParameters params;
    protected final String filePrefix;
    protected volatile BlockChain vChain;
    protected volatile SPVBlockStore vStore;
    protected volatile Wallet vBtcWallet;
    protected volatile PeerGroup vPeerGroup;
    protected final File directory;
    protected volatile File vXmrWalletFile;
    protected volatile File vBtcWalletFile;
    protected PeerAddress[] peerAddresses;
    protected InputStream checkpoints;
    protected String userAgent;
    protected String version;
    @Nullable
    protected DeterministicSeed restoreFromSeed;
    @Nullable
    protected PeerDiscovery discovery;
    protected volatile Context context;
    protected Config config;
    protected XmrLocalNode xmrLocalNode;
    protected Socks5Proxy socks5Proxy;
    protected int numConnectionsForBtc;
    private int minBroadcastConnections;
    private BooleanProperty migratedWalletToSegwit = new SimpleBooleanProperty(false);

    public WalletConfig(NetworkParameters params, File directory, String filePrefix) {
        this(new Context(params), directory, filePrefix);
    }

    private WalletConfig(Context context, File directory, String filePrefix) {
        this.context = context;
        this.params = com.google.common.base.Preconditions.checkNotNull(context.getParams());
        this.directory = Preconditions.checkDir(directory);
        this.filePrefix = com.google.common.base.Preconditions.checkNotNull(filePrefix);
    }

    public WalletConfig setSocks5Proxy(Socks5Proxy socks5Proxy) {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.NEW, "Cannot call after startup");
        this.socks5Proxy = socks5Proxy;
        return this;
    }

    public WalletConfig setConfig(Config config) {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.NEW, "Cannot call after startup");
        this.config = config;
        return this;
    }

    public WalletConfig setXmrLocalNode(XmrLocalNode xmrLocalNode) {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.NEW, "Cannot call after startup");
        this.xmrLocalNode = xmrLocalNode;
        return this;
    }

    public WalletConfig setNumConnectionsForBtc(int numConnectionsForBtc) {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.NEW, "Cannot call after startup");
        this.numConnectionsForBtc = numConnectionsForBtc;
        return this;
    }

    public WalletConfig setPeerNodes(PeerAddress ... addresses) {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.NEW, "Cannot call after startup");
        this.peerAddresses = addresses;
        return this;
    }

    public WalletConfig connectToLocalHost() {
        InetAddress localHost = InetAddress.getLoopbackAddress();
        return this.setPeerNodes(new PeerAddress(this.params, localHost, this.params.getPort()));
    }

    public WalletConfig setCheckpoints(InputStream checkpoints) {
        if (this.checkpoints != null) {
            Closeables.closeQuietly(checkpoints);
        }
        this.checkpoints = com.google.common.base.Preconditions.checkNotNull(checkpoints);
        return this;
    }

    public WalletConfig setUserAgent(String userAgent, String version) {
        this.userAgent = com.google.common.base.Preconditions.checkNotNull(userAgent);
        this.version = com.google.common.base.Preconditions.checkNotNull(version);
        return this;
    }

    public WalletConfig restoreWalletFromSeed(DeterministicSeed seed) {
        this.restoreFromSeed = seed;
        return this;
    }

    public WalletConfig setDiscovery(@Nullable PeerDiscovery discovery) {
        this.discovery = discovery;
        return this;
    }

    protected void onSetupCompleted() {
    }

    @Override
    protected void startUp() throws Exception {
        this.onSetupCompleted();
    }

    protected void setupAutoSave(Wallet wallet, File walletFile) {
        wallet.autosaveToFile(walletFile, 5L, TimeUnit.SECONDS, null);
    }

    @Override
    protected void shutDown() throws Exception {
    }

    public NetworkParameters params() {
        return this.params;
    }

    public BlockChain chain() {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, "Cannot call until startup is complete");
        return this.vChain;
    }

    public BlockStore store() {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, "Cannot call until startup is complete");
        return this.vStore;
    }

    public Wallet btcWallet() {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, "Cannot call until startup is complete");
        return this.vBtcWallet;
    }

    public PeerGroup peerGroup() {
        com.google.common.base.Preconditions.checkState(this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING, "Cannot call until startup is complete");
        return this.vPeerGroup;
    }

    public File directory() {
        return this.directory;
    }

    public void maybeAddSegwitKeychain(Wallet wallet, KeyParameter aesKey) {
        if (HavenoKeyChainGroupStructure.BIP44_BTC_NON_SEGWIT_ACCOUNT_PATH.equals(wallet.getActiveKeyChain().getAccountPath())) {
            if (wallet.isEncrypted() && aesKey == null) {
                return;
            }
            File backup = new File(this.directory, "pre_segwit_haveno_BTC.wallet.backup");
            try {
                FileUtil.copyFile(new File(this.directory, "haveno_BTC.wallet"), backup);
            }
            catch (IOException e) {
                log.error(e.toString(), e);
            }
            DeterministicSeed seed = wallet.getKeyChainSeed();
            if (aesKey != null) {
                KeyCrypter keyCrypter = wallet.getKeyCrypter();
                seed = seed.decrypt(keyCrypter, "", aesKey);
            }
            DeterministicKeyChain nativeSegwitKeyChain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(Script.ScriptType.P2WPKH)).accountPath(new HavenoKeyChainGroupStructure().accountPathFor(Script.ScriptType.P2WPKH))).build();
            if (aesKey != null) {
                KeyCrypter keyCrypter = wallet.getKeyCrypter();
                nativeSegwitKeyChain = nativeSegwitKeyChain.toEncrypted(keyCrypter, aesKey);
            }
            wallet.addAndActivateHDChain(nativeSegwitKeyChain);
        }
        this.migratedWalletToSegwit.set(true);
    }

    public boolean stateStartingOrRunning() {
        return this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING;
    }

    public int getMinBroadcastConnections() {
        return this.minBroadcastConnections;
    }

    public void setMinBroadcastConnections(int minBroadcastConnections) {
        this.minBroadcastConnections = minBroadcastConnections;
    }

    public BooleanProperty getMigratedWalletToSegwit() {
        return this.migratedWalletToSegwit;
    }
}

