/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.setup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.handlers.ExceptionHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.api.XmrLocalNode;
import haveno.core.user.Preferences;
import haveno.core.xmr.exceptions.InvalidHostException;
import haveno.core.xmr.model.AddressEntry;
import haveno.core.xmr.model.AddressEntryList;
import haveno.core.xmr.nodes.XmrNetworkConfig;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.nodes.XmrNodesRepository;
import haveno.core.xmr.nodes.XmrNodesSetupPreferences;
import haveno.core.xmr.setup.RegTestHost;
import haveno.core.xmr.setup.WalletConfig;
import haveno.network.Socks5ProxyProvider;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.Wallet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletsSetup {
    private static final Logger log = LoggerFactory.getLogger(WalletsSetup.class);
    public static final String PRE_SEGWIT_WALLET_BACKUP = "pre_segwit_haveno_BTC.wallet.backup";
    private static final int MIN_BROADCAST_CONNECTIONS = 0;
    public final BooleanProperty walletsSetupFailed = new SimpleBooleanProperty();
    private static final long STARTUP_TIMEOUT_SECONDS = 3600L;
    private static final String SPV_CHAIN_FILE_NAME = "haveno.spvchain";
    private final RegTestHost regTestHost;
    private final AddressEntryList addressEntryList;
    private final Preferences preferences;
    private final Socks5ProxyProvider socks5ProxyProvider;
    private final Config config;
    private final XmrLocalNode xmrLocalNode;
    private final XmrNodes xmrNodes;
    private final int numConnectionsForBtc;
    private final String userAgent;
    private final NetworkParameters params;
    private final File walletDir;
    private final int socks5DiscoverMode;
    private final List<Runnable> setupTaskHandlers = new ArrayList<Runnable>();
    private final List<Runnable> setupCompletedHandlers = new ArrayList<Runnable>();
    public final BooleanProperty shutDownComplete = new SimpleBooleanProperty();
    private final boolean useAllProvidedNodes;
    private WalletConfig walletConfig;

    @Inject
    public WalletsSetup(RegTestHost regTestHost, AddressEntryList addressEntryList, Preferences preferences, Socks5ProxyProvider socks5ProxyProvider, Config config, XmrLocalNode xmrLocalNode, XmrNodes xmrNodes, @Named(value="userAgent") String userAgent, @Named(value="walletDir") File walletDir, @Named(value="useAllProvidedNodes") boolean useAllProvidedNodes, @Named(value="numConnectionsForBtc") int numConnectionsForBtc, @Named(value="socks5DiscoverMode") String socks5DiscoverModeString) {
        this.regTestHost = regTestHost;
        this.addressEntryList = addressEntryList;
        this.preferences = preferences;
        this.socks5ProxyProvider = socks5ProxyProvider;
        this.config = config;
        this.xmrLocalNode = xmrLocalNode;
        this.xmrNodes = xmrNodes;
        this.numConnectionsForBtc = numConnectionsForBtc;
        this.useAllProvidedNodes = useAllProvidedNodes;
        this.userAgent = userAgent;
        this.socks5DiscoverMode = this.evaluateMode(socks5DiscoverModeString);
        this.walletDir = walletDir;
        this.params = Config.baseCurrencyNetworkParameters();
        PeerGroup.setIgnoreHttpSeeds(true);
    }

    public void initialize(@Nullable DeterministicSeed seed, final ResultHandler resultHandler, final ExceptionHandler exceptionHandler) {
        Threading.USER_THREAD = UserThread.getExecutor();
        final Timer timeoutTimer = UserThread.runAfter(() -> exceptionHandler.handleException(new TimeoutException("Wallet did not initialize in 3600 seconds.")), 3600L);
        this.backupWallets();
        Socks5Proxy socks5Proxy = this.socks5ProxyProvider.getSocks5Proxy();
        log.info("Using Socks5Proxy: " + String.valueOf(socks5Proxy));
        this.walletConfig = new WalletConfig(this.params, this.walletDir, "haveno"){

            @Override
            protected void onSetupCompleted() {
                super.onSetupCompleted();
                WalletsSetup.this.setupTaskHandlers.forEach(Runnable::run);
                UserThread.execute(() -> {
                    timeoutTimer.stop();
                    WalletsSetup.this.setupCompletedHandlers.forEach(Runnable::run);
                });
                UserThread.runAfter(resultHandler::handleResult, 100L, TimeUnit.MILLISECONDS);
            }
        };
        this.walletConfig.setSocks5Proxy(socks5Proxy);
        this.walletConfig.setConfig(this.config);
        this.walletConfig.setXmrLocalNode(this.xmrLocalNode);
        this.walletConfig.setUserAgent(this.userAgent, "1.1.1");
        this.walletConfig.setNumConnectionsForBtc(this.numConnectionsForBtc);
        String checkpointsPath = null;
        if (this.params.getId().equals("org.bitcoin.production")) {
            checkpointsPath = "/wallet/checkpoints.txt";
        } else if (this.params.getId().equals("org.bitcoin.test")) {
            checkpointsPath = "/wallet/checkpoints.testnet.txt";
        }
        if (checkpointsPath != null) {
            this.walletConfig.setCheckpoints(this.getClass().getResourceAsStream(checkpointsPath));
        }
        if (this.params.getId().equals("org.bitcoin.regtest")) {
            this.walletConfig.setMinBroadcastConnections(1);
            if (this.regTestHost == RegTestHost.LOCALHOST) {
                this.walletConfig.connectToLocalHost();
            } else if (this.regTestHost == RegTestHost.REMOTE_HOST) {
                this.configPeerNodesForRegTestServer();
            } else {
                try {
                    this.configPeerNodes(socks5Proxy);
                }
                catch (IllegalArgumentException e) {
                    timeoutTimer.stop();
                    this.walletsSetupFailed.set(true);
                    exceptionHandler.handleException(new InvalidHostException(e.getMessage()));
                    return;
                }
            }
        } else if (this.xmrLocalNode.shouldBeUsed()) {
            this.walletConfig.setMinBroadcastConnections(1);
            this.walletConfig.connectToLocalHost();
        } else {
            try {
                this.configPeerNodes(socks5Proxy);
            }
            catch (IllegalArgumentException e) {
                timeoutTimer.stop();
                this.walletsSetupFailed.set(true);
                exceptionHandler.handleException(new InvalidHostException(e.getMessage()));
                return;
            }
        }
        if (seed != null) {
            this.walletConfig.restoreWalletFromSeed(seed);
        }
        this.walletConfig.addListener(new Service.Listener(){

            @Override
            public void failed(@NotNull Service.State from, @NotNull Throwable failure) {
                WalletsSetup.this.walletConfig = null;
                log.error("Service failure from state: {}; failure={}", (Object)from, (Object)failure);
                timeoutTimer.stop();
                UserThread.execute(() -> exceptionHandler.handleException(failure));
            }
        }, Threading.USER_THREAD);
        this.walletConfig.startAsync();
    }

    public void shutDown() {
        if (this.walletConfig != null) {
            try {
                log.info("walletConfig shutDown started");
                this.walletConfig.stopAsync();
                this.walletConfig.awaitTerminated(1L, TimeUnit.SECONDS);
                log.info("walletConfig shutDown completed");
            }
            catch (Throwable ignore) {
                log.info("walletConfig shutDown interrupted by timeout");
            }
        }
        this.shutDownComplete.set(true);
    }

    public void reSyncSPVChain() throws IOException {
        FileUtil.deleteFileIfExists(new File(this.walletDir, SPV_CHAIN_FILE_NAME));
    }

    @VisibleForTesting
    private int evaluateMode(String socks5DiscoverModeString) {
        String[] socks5DiscoverModes = StringUtils.deleteWhitespace(socks5DiscoverModeString).split(",");
        int mode = 0;
        String[] stringArray = socks5DiscoverModes;
        int n = stringArray.length;
        block11: for (int i = 0; i < n; ++i) {
            String socks5DiscoverMode;
            switch (socks5DiscoverMode = stringArray[i]) {
                case "ADDR": {
                    mode |= 1;
                    continue block11;
                }
                case "DNS": {
                    mode |= 0x10;
                    continue block11;
                }
                case "ONION": {
                    mode |= 0x100;
                    continue block11;
                }
                default: {
                    mode |= 0x1111;
                }
            }
        }
        return mode;
    }

    private void configPeerNodesForRegTestServer() {
        try {
            if (RegTestHost.HOST.endsWith(".onion")) {
                this.walletConfig.setPeerNodes(new PeerAddress(RegTestHost.HOST, this.params.getPort()));
            } else {
                this.walletConfig.setPeerNodes(new PeerAddress(this.params, InetAddress.getByName(RegTestHost.HOST), this.params.getPort()));
            }
        }
        catch (UnknownHostException e) {
            log.error(e.toString());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void configPeerNodes(@Nullable Socks5Proxy proxy) {
        this.walletConfig.setMinBroadcastConnections(0);
        XmrNodesSetupPreferences xmrNodesSetupPreferences = new XmrNodesSetupPreferences(this.preferences);
        List<XmrNodes.XmrNode> nodes = xmrNodesSetupPreferences.selectPreferredNodes(this.xmrNodes);
        XmrNodesRepository repository = new XmrNodesRepository(nodes);
        boolean isUseClearNodesWithProxies = this.useAllProvidedNodes || xmrNodesSetupPreferences.isUseCustomNodes();
        List<PeerAddress> peers = repository.getPeerAddresses(proxy, isUseClearNodesWithProxies);
        XmrNetworkConfig networkConfig = new XmrNetworkConfig(this.walletConfig, this.params, this.socks5DiscoverMode, proxy);
        networkConfig.proposePeers(peers);
    }

    public void backupWallets() {
    }

    public void clearBackups() {
        try {
            FileUtil.deleteDirectory(new File(Paths.get(this.walletDir.getAbsolutePath(), "backup").toString()));
        }
        catch (IOException e) {
            log.error("Could not delete directory " + e.getMessage());
            e.printStackTrace();
        }
        File segwitBackup = new File(this.walletDir, PRE_SEGWIT_WALLET_BACKUP);
        try {
            FileUtil.deleteFileIfExists(segwitBackup);
        }
        catch (IOException e) {
            log.error(e.toString(), e);
        }
    }

    public void restoreSeedWords(@Nullable DeterministicSeed seed, ResultHandler resultHandler, ExceptionHandler exceptionHandler) {
        Preconditions.checkNotNull(seed, "Seed must be not be null.");
        this.backupWallets();
        Context ctx = Context.get();
        new Thread(() -> {
            try {
                Context.propagate(ctx);
                this.walletConfig.stopAsync();
                this.walletConfig.awaitTerminated();
                this.initialize(seed, resultHandler, exceptionHandler);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                log.error("Executing task failed. " + t2.getMessage());
            }
        }, "RestoreBTCWallet-%d").start();
    }

    public void addSetupTaskHandler(Runnable handler) {
        this.setupTaskHandlers.add(handler);
    }

    public void addSetupCompletedHandler(Runnable handler) {
        this.setupCompletedHandlers.add(handler);
    }

    public Wallet getBtcWallet() {
        return this.walletConfig.btcWallet();
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    @Nullable
    public BlockChain getChain() {
        return this.walletConfig != null && this.walletConfig.stateStartingOrRunning() ? this.walletConfig.chain() : null;
    }

    public PeerGroup getPeerGroup() {
        return this.walletConfig.peerGroup();
    }

    public WalletConfig getWalletConfig() {
        return this.walletConfig;
    }

    public Set<Address> getAddressesByContext(AddressEntry.Context context) {
        return this.addressEntryList.getAddressEntriesAsListImmutable().stream().filter(addressEntry -> addressEntry.getContext() == context).map(AddressEntry::getAddress).collect(Collectors.toSet());
    }

    public Set<Address> getAddressesFromAddressEntries(Set<AddressEntry> addressEntries) {
        return addressEntries.stream().map(AddressEntry::getAddress).collect(Collectors.toSet());
    }

    public int getMinBroadcastConnections() {
        return this.walletConfig.getMinBroadcastConnections();
    }

    public BooleanProperty getWalletsSetupFailed() {
        return this.walletsSetupFailed;
    }
}

