/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.common.collect.Sets;
import haveno.core.xmr.wallet.HavenoDefaultCoinSelector;
import haveno.core.xmr.wallet.WalletService;
import java.util.Set;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.TransactionOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BtcCoinSelector
extends HavenoDefaultCoinSelector {
    private static final Logger log = LoggerFactory.getLogger(BtcCoinSelector.class);
    private final Set<Address> addresses;
    private final long ignoreDustThreshold;

    private BtcCoinSelector(Set<Address> addresses, long ignoreDustThreshold, boolean permitForeignPendingTx) {
        super(permitForeignPendingTx);
        this.addresses = addresses;
        this.ignoreDustThreshold = ignoreDustThreshold;
    }

    BtcCoinSelector(Set<Address> addresses, long ignoreDustThreshold) {
        this(addresses, ignoreDustThreshold, true);
    }

    BtcCoinSelector(Address address, long ignoreDustThreshold, boolean permitForeignPendingTx) {
        this(Sets.newHashSet(address), ignoreDustThreshold, permitForeignPendingTx);
    }

    BtcCoinSelector(Address address, long ignoreDustThreshold) {
        this(Sets.newHashSet(address), ignoreDustThreshold, true);
    }

    @Override
    protected boolean isTxOutputSpendable(TransactionOutput output) {
        if (WalletService.isOutputScriptConvertibleToAddress(output)) {
            Address address = WalletService.getAddressFromOutput(output);
            return this.addresses.contains(address);
        }
        log.warn("transactionOutput.getScriptPubKey() is not P2PKH nor P2SH nor P2WH");
        return false;
    }

    @Override
    protected boolean isDustAttackUtxo(TransactionOutput output) {
        return output.getValue().value < this.ignoreDustThreshold;
    }
}

