/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.inject.Inject;
import haveno.core.user.Preferences;
import haveno.core.xmr.wallet.HavenoDefaultCoinSelector;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBsqCoinSelector
extends HavenoDefaultCoinSelector {
    private static final Logger log = LoggerFactory.getLogger(NonBsqCoinSelector.class);
    private Preferences preferences;

    @Inject
    public NonBsqCoinSelector() {
        super(false);
    }

    @Override
    protected boolean isTxOutputSpendable(TransactionOutput output) {
        Transaction parentTransaction = output.getParentTransaction();
        if (parentTransaction == null) {
            return false;
        }
        return parentTransaction.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING;
    }

    @Override
    protected boolean isDustAttackUtxo(TransactionOutput output) {
        return output.getValue().value < (long)this.preferences.getIgnoreDustThreshold();
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

