/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.common.config.Config;
import haveno.core.trade.HavenoUtils;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;

public class Restrictions {
    public static final double MIN_SECURITY_DEPOSIT_PCT = 0.15;
    public static final double MAX_SECURITY_DEPOSIT_PCT = 0.5;
    public static BigInteger MIN_TRADE_AMOUNT = HavenoUtils.xmrToAtomicUnits(0.1);
    public static BigInteger MIN_SECURITY_DEPOSIT = HavenoUtils.xmrToAtomicUnits(0.1);
    public static int MAX_EXTRA_INFO_LENGTH = 1500;
    public static int MAX_OFFERS_WITH_SHARED_FUNDS = 10;
    private static BigInteger MIN_REFUND_AT_MEDIATED_DISPUTE;
    private static Coin minNonDustOutput;

    public static Coin getMinNonDustOutput() {
        if (minNonDustOutput == null) {
            minNonDustOutput = Config.baseCurrencyNetwork().getParameters().getMinNonDustOutput();
        }
        return minNonDustOutput;
    }

    public static boolean isAboveDust(Coin amount) {
        return amount.compareTo(Restrictions.getMinNonDustOutput()) >= 0;
    }

    public static boolean isDust(Coin amount) {
        return !Restrictions.isAboveDust(amount);
    }

    public static BigInteger getMinTradeAmount() {
        return MIN_TRADE_AMOUNT;
    }

    public static double getDefaultSecurityDepositAsPercent() {
        return 0.15;
    }

    public static double getMinSecurityDepositAsPercent() {
        return 0.15;
    }

    public static double getMaxSecurityDepositAsPercent() {
        return 0.5;
    }

    public static BigInteger getMinSecurityDeposit() {
        return MIN_SECURITY_DEPOSIT;
    }

    public static BigInteger getMinRefundAtMediatedDispute() {
        if (MIN_REFUND_AT_MEDIATED_DISPUTE == null) {
            MIN_REFUND_AT_MEDIATED_DISPUTE = HavenoUtils.xmrToAtomicUnits(5.0E-4);
        }
        return MIN_REFUND_AT_MEDIATED_DISPUTE;
    }

    public static int getLockTime(boolean isAsset) {
        return isAsset ? 1440 : 2880;
    }
}

