/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.inject.Inject;
import haveno.common.crypto.ScryptUtil;
import haveno.common.handlers.ExceptionHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.locale.Res;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import javax.annotation.Nullable;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletsManager {
    private static final Logger log = LoggerFactory.getLogger(WalletsManager.class);
    private final BtcWalletService btcWalletService;
    private final XmrWalletService xmrWalletService;
    private final TradeWalletService tradeWalletService;
    private final WalletsSetup walletsSetup;

    @Inject
    public WalletsManager(BtcWalletService btcWalletService, XmrWalletService xmrWalletService, TradeWalletService tradeWalletService, WalletsSetup walletsSetup) {
        this.btcWalletService = btcWalletService;
        this.xmrWalletService = xmrWalletService;
        this.tradeWalletService = tradeWalletService;
        this.walletsSetup = walletsSetup;
    }

    public void decryptWallets(KeyParameter aesKey) {
        this.btcWalletService.decryptWallet(aesKey);
        this.tradeWalletService.setAesKey(null);
    }

    public void encryptWallets(KeyCrypterScrypt keyCrypterScrypt, KeyParameter aesKey) {
        try {
            this.btcWalletService.encryptWallet(keyCrypterScrypt, aesKey);
            this.tradeWalletService.setAesKey(aesKey);
        }
        catch (Throwable t2) {
            log.error(t2.toString());
            throw t2;
        }
    }

    public String getWalletsAsString(boolean includePrivKeys) {
        String baseCurrencyWalletDetails = Res.getBaseCurrencyCode() + " Wallet:\n" + this.btcWalletService.getWalletAsString(includePrivKeys);
        return baseCurrencyWalletDetails;
    }

    public void restoreSeedWords(@Nullable DeterministicSeed seed, ResultHandler resultHandler, ExceptionHandler exceptionHandler) {
        this.walletsSetup.restoreSeedWords(seed, resultHandler, exceptionHandler);
    }

    public void backupWallets() {
        this.walletsSetup.backupWallets();
    }

    public void clearBackup() {
        this.walletsSetup.clearBackups();
    }

    public boolean areWalletsEncrypted() {
        return this.xmrWalletService.isWalletEncrypted();
    }

    public boolean areWalletsAvailable() {
        return this.xmrWalletService.isWalletAvailable();
    }

    public KeyCrypterScrypt getKeyCrypterScrypt() {
        if (this.areWalletsEncrypted() && this.btcWalletService.getKeyCrypter() != null) {
            return (KeyCrypterScrypt)this.btcWalletService.getKeyCrypter();
        }
        return ScryptUtil.getKeyCrypterScrypt();
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        return this.btcWalletService.checkAESKey(aesKey);
    }

    public long getChainSeedCreationTimeSeconds() {
        return this.btcWalletService.getKeyChainSeed().getCreationTimeSeconds();
    }

    public boolean hasPositiveBalance() {
        return this.btcWalletService.getBalance(Wallet.BalanceType.AVAILABLE).isPositive();
    }

    public void setAesKey(KeyParameter aesKey) {
        this.btcWalletService.setAesKey(aesKey);
        this.tradeWalletService.setAesKey(aesKey);
    }

    public DeterministicSeed getDecryptedSeed(KeyParameter aesKey, DeterministicSeed keyChainSeed, KeyCrypter keyCrypter) {
        if (keyCrypter != null) {
            return keyChainSeed.decrypt(keyCrypter, "", aesKey);
        }
        log.warn("keyCrypter is null");
        return null;
    }
}

