/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.core.xmr.wallet.XmrKeyImageListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import monero.common.MoneroError;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemon;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrKeyImagePoller {
    private static final Logger log = LoggerFactory.getLogger(XmrKeyImagePoller.class);
    private MoneroDaemon daemon;
    private long refreshPeriodMs;
    private Map<String, Set<String>> keyImageGroups = new HashMap<String, Set<String>>();
    private Set<XmrKeyImageListener> listeners = new HashSet<XmrKeyImageListener>();
    private TaskLooper looper;
    private Map<String, MoneroKeyImageSpentStatus> lastStatuses = new HashMap<String, MoneroKeyImageSpentStatus>();
    private boolean isPolling = false;
    private Long lastLogPollErrorTimestamp;

    public XmrKeyImagePoller() {
        this.looper = new TaskLooper(() -> this.poll());
    }

    public XmrKeyImagePoller(MoneroDaemon daemon, long refreshPeriodMs) {
        this.looper = new TaskLooper(() -> this.poll());
        this.setDaemon(daemon);
        this.setRefreshPeriodMs(refreshPeriodMs);
    }

    public void addListener(XmrKeyImageListener listener) {
        this.listeners.add(listener);
        this.refreshPolling();
    }

    public void removeListener(XmrKeyImageListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new MoneroError("Listener is not registered");
        }
        this.listeners.remove(listener);
        this.refreshPolling();
    }

    public void setDaemon(MoneroDaemon daemon) {
        this.daemon = daemon;
    }

    public MoneroDaemon getDaemon() {
        return this.daemon;
    }

    public void setRefreshPeriodMs(long refreshPeriodMs) {
        this.refreshPeriodMs = refreshPeriodMs;
    }

    public long getRefreshPeriodMs() {
        return this.refreshPeriodMs;
    }

    public void addKeyImage(String keyImage, String groupId) {
        this.addKeyImages(Arrays.asList(keyImage), groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyImages(Collection<String> keyImages, String groupId) {
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            if (!this.keyImageGroups.containsKey(groupId)) {
                this.keyImageGroups.put(groupId, new HashSet());
            }
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            keyImagesGroup.addAll(keyImages);
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyImages(Collection<String> keyImages, String groupId) {
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            if (keyImagesGroup == null) {
                return;
            }
            keyImagesGroup.removeAll(keyImages);
            if (keyImagesGroup.isEmpty()) {
                this.keyImageGroups.remove(groupId);
            }
            Set<String> allKeyImages = this.getKeyImages();
            Map<String, MoneroKeyImageSpentStatus> map2 = this.lastStatuses;
            synchronized (map2) {
                for (String keyImage : keyImages) {
                    if (!this.lastStatuses.containsKey(keyImage) || allKeyImages.contains(keyImage)) continue;
                    this.lastStatuses.remove(keyImage);
                }
            }
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyImages(String groupId) {
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            Set<String> keyImagesGroup = this.keyImageGroups.get(groupId);
            if (keyImagesGroup == null) {
                return;
            }
            this.keyImageGroups.remove(groupId);
            Set<String> allKeyImages = this.getKeyImages();
            Map<String, MoneroKeyImageSpentStatus> map2 = this.lastStatuses;
            synchronized (map2) {
                for (String keyImage : keyImagesGroup) {
                    if (!this.lastStatuses.containsKey(keyImage) || allKeyImages.contains(keyImage)) continue;
                    this.lastStatuses.remove(keyImage);
                }
            }
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyImages() {
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            this.keyImageGroups.clear();
            Map<String, MoneroKeyImageSpentStatus> map2 = this.lastStatuses;
            synchronized (map2) {
                this.lastStatuses.clear();
            }
            this.refreshPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isSpent(String keyImage) {
        Map<String, MoneroKeyImageSpentStatus> map = this.lastStatuses;
        synchronized (map) {
            if (!this.lastStatuses.containsKey(keyImage)) {
                return null;
            }
            return XmrKeyImagePoller.isSpent(this.lastStatuses.get(keyImage));
        }
    }

    public static boolean isSpent(MoneroKeyImageSpentStatus status) {
        return status != MoneroKeyImageSpentStatus.NOT_SPENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroKeyImageSpentStatus getLastSpentStatus(String keyImage) {
        Map<String, MoneroKeyImageSpentStatus> map = this.lastStatuses;
        synchronized (map) {
            return this.lastStatuses.get(keyImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        if (this.daemon == null) {
            log.warn("Cannot poll key images because daemon is null");
            return;
        }
        List<Object> spentStatuses = null;
        ArrayList<String> keyImages = new ArrayList<String>(this.getKeyImages());
        try {
            spentStatuses = keyImages.isEmpty() ? new ArrayList() : this.daemon.getKeyImageSpentStatuses(keyImages);
        }
        catch (Exception e) {
            if (this.lastLogPollErrorTimestamp == null || System.currentTimeMillis() - this.lastLogPollErrorTimestamp > 240000L) {
                log.warn("Error polling spent status of key images: " + e.getMessage());
                this.lastLogPollErrorTimestamp = System.currentTimeMillis();
            }
            return;
        }
        HashMap<String, MoneroKeyImageSpentStatus> changedStatuses = new HashMap<String, MoneroKeyImageSpentStatus>();
        Map<String, MoneroKeyImageSpentStatus> map = this.lastStatuses;
        synchronized (map) {
            for (int i = 0; i < spentStatuses.size(); ++i) {
                if (spentStatuses.get(i) == this.lastStatuses.get(keyImages.get(i))) continue;
                this.lastStatuses.put((String)keyImages.get(i), (MoneroKeyImageSpentStatus)((Object)spentStatuses.get(i)));
                changedStatuses.put((String)keyImages.get(i), (MoneroKeyImageSpentStatus)((Object)spentStatuses.get(i)));
            }
        }
        if (!changedStatuses.isEmpty()) {
            for (XmrKeyImageListener listener : new ArrayList<XmrKeyImageListener>(this.listeners)) {
                listener.onSpentStatusChanged(changedStatuses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPolling() {
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            this.setIsPolling(!this.getKeyImages().isEmpty() && this.listeners.size() > 0);
        }
    }

    private synchronized void setIsPolling(boolean enabled) {
        if (enabled) {
            if (!this.isPolling) {
                this.isPolling = true;
                this.looper.start(this.refreshPeriodMs);
            }
        } else {
            this.isPolling = false;
            this.looper.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKeyImages() {
        HashSet<String> allKeyImages = new HashSet<String>();
        Map<String, Set<String>> map = this.keyImageGroups;
        synchronized (map) {
            for (Set<String> keyImagesGroup : this.keyImageGroups.values()) {
                allKeyImages.addAll(keyImagesGroup);
            }
        }
        return allKeyImages;
    }
}

