/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.core.api.XmrConnectionService;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.setup.DownloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.MoneroWalletFull;
import monero.wallet.model.MoneroWalletListener;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmrWalletBase {
    private static final Logger log = LoggerFactory.getLogger(XmrWalletBase.class);
    public static final int SYNC_PROGRESS_TIMEOUT_SECONDS = 120;
    public static final int DIRECT_SYNC_WITHIN_BLOCKS = 100;
    public static final int SAVE_WALLET_DELAY_SECONDS = 300;
    protected MoneroWallet wallet;
    protected final Object walletLock = new Object();
    protected Timer saveWalletDelayTimer;
    protected XmrConnectionService xmrConnectionService;
    protected boolean wasWalletSynced;
    protected final Map<String, Optional<MoneroTx>> txCache = new HashMap<String, Optional<MoneroTx>>();
    protected boolean isClosingWallet;
    protected boolean isSyncingWithProgress;
    protected Long syncStartHeight;
    protected TaskLooper syncProgressLooper;
    protected CountDownLatch syncProgressLatch;
    protected Exception syncProgressError;
    protected Timer syncProgressTimeout;
    protected final DownloadListener downloadListener = new DownloadListener();
    protected final LongProperty walletHeight = new SimpleLongProperty(0L);
    protected boolean isShutDownStarted;
    protected boolean isShutDown;
    private boolean testReconnectOnStartup = false;
    private String testReconnectMonerod1 = "http://xmr-node.cakewallet.com:18081";
    private String testReconnectMonerod2 = "http://nodex.monerujo.io:18081";

    public XmrWalletBase() {
        this.xmrConnectionService = HavenoUtils.xmrConnectionService;
    }

    public void syncWithProgress() {
        this.syncWithProgress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncWithProgress(final boolean repeatSyncToLatestHeight) {
        Object object = this.walletLock;
        synchronized (object) {
            this.isSyncingWithProgress = true;
            this.syncProgressError = null;
            final long targetHeightAtStart = this.xmrConnectionService.getTargetHeight();
            this.syncStartHeight = this.walletHeight.get();
            this.updateSyncProgress(this.syncStartHeight, targetHeightAtStart);
            if (this.testReconnectOnStartup) {
                UserThread.runAfter(() -> {
                    log.warn("Testing connection change on startup before wallet synced");
                    if (this.xmrConnectionService.getConnection().getUri().equals(this.testReconnectMonerod1)) {
                        this.xmrConnectionService.setConnection(this.testReconnectMonerod2);
                    } else {
                        this.xmrConnectionService.setConnection(this.testReconnectMonerod1);
                    }
                }, 1L);
                this.testReconnectOnStartup = false;
            }
            if (this.wallet instanceof MoneroWalletFull) {
                if (this.testReconnectOnStartup) {
                    HavenoUtils.waitFor(1000L);
                }
                this.wallet.sync(new MoneroWalletListener(){

                    @Override
                    public void onSyncProgress(long height, long startHeight, long endHeight, double percentDone, String message) {
                        long appliedTargetHeight = repeatSyncToLatestHeight ? XmrWalletBase.this.xmrConnectionService.getTargetHeight() : targetHeightAtStart;
                        XmrWalletBase.this.updateSyncProgress(height, appliedTargetHeight);
                    }
                });
                this.setWalletSyncedWithProgress();
                return;
            }
            this.syncProgressLatch = new CountDownLatch(1);
            this.syncProgressLooper = new TaskLooper(() -> {
                long height;
                try {
                    height = this.wallet.getHeight();
                }
                catch (Exception e) {
                    if (this.wallet != null && !this.isShutDownStarted) {
                        log.warn("Error getting wallet height while syncing with progress: " + e.getMessage());
                        log.warn(ExceptionUtils.getStackTrace(e));
                    }
                    this.syncProgressError = e;
                    this.syncProgressLatch.countDown();
                    return;
                }
                long appliedTargetHeight = repeatSyncToLatestHeight ? this.xmrConnectionService.getTargetHeight() : targetHeightAtStart;
                this.updateSyncProgress(height, appliedTargetHeight);
                if (height >= appliedTargetHeight) {
                    this.setWalletSyncedWithProgress();
                    this.syncProgressLatch.countDown();
                }
            });
            this.wallet.startSyncing(this.xmrConnectionService.getRefreshPeriodMs());
            this.syncProgressLooper.start(1000L);
            HavenoUtils.awaitLatch(this.syncProgressLatch);
            this.syncProgressLooper.stop();
            this.syncProgressTimeout.stop();
            if (this.wallet != null) {
                this.wallet.stopSyncing();
            }
            this.isSyncingWithProgress = false;
            if (this.syncProgressError != null) {
                throw new RuntimeException(this.syncProgressError);
            }
        }
    }

    public boolean requestSwitchToNextBestConnection(MoneroRpcConnection sourceConnection) {
        if (this.xmrConnectionService.requestSwitchToNextBestConnection(sourceConnection)) {
            this.onConnectionChanged(this.xmrConnectionService.getConnection());
            return true;
        }
        return false;
    }

    public void saveWalletWithDelay() {
        if (this.saveWalletDelayTimer == null) {
            this.saveWalletDelayTimer = UserThread.runAfter(() -> {
                this.requestSaveWallet();
                UserThread.execute(() -> {
                    this.saveWalletDelayTimer = null;
                });
            }, 300L, TimeUnit.SECONDS);
        }
    }

    public abstract void saveWallet();

    public abstract void requestSaveWallet();

    protected abstract void onConnectionChanged(MoneroRpcConnection var1);

    private void updateSyncProgress(long height, long targetHeight) {
        this.resetSyncProgressTimeout();
        UserThread.execute(() -> {
            this.walletHeight.set(height);
            if (height == 1L) {
                this.downloadListener.progress(0.0, targetHeight - height, null);
                return;
            }
            long blocksLeft = targetHeight - this.walletHeight.get();
            if (this.syncStartHeight == null) {
                this.syncStartHeight = this.walletHeight.get();
            }
            double percent = Math.min(1.0, targetHeight == this.syncStartHeight ? 1.0 : ((double)this.walletHeight.get() - (double)this.syncStartHeight.longValue()) / (double)(targetHeight - this.syncStartHeight));
            this.downloadListener.progress(percent, blocksLeft, null);
        });
    }

    private synchronized void resetSyncProgressTimeout() {
        if (this.syncProgressTimeout != null) {
            this.syncProgressTimeout.stop();
        }
        this.syncProgressTimeout = UserThread.runAfter(() -> {
            if (this.isShutDownStarted) {
                return;
            }
            this.syncProgressError = new RuntimeException("Sync progress timeout called");
            this.syncProgressLatch.countDown();
        }, 120L, TimeUnit.SECONDS);
    }

    private void setWalletSyncedWithProgress() {
        this.wasWalletSynced = true;
        this.isSyncingWithProgress = false;
        this.syncProgressTimeout.stop();
    }

    public Object getWalletLock() {
        return this.walletLock;
    }

    public XmrConnectionService getXmrConnectionService() {
        return this.xmrConnectionService;
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }
}

