/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.xmr.wallet;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import common.utils.JsonUtils;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.util.Utilities;
import haveno.core.api.AccountServiceListener;
import haveno.core.api.CoreAccountService;
import haveno.core.api.XmrConnectionService;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.xmr.listeners.XmrBalanceListener;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.model.XmrAddressEntryList;
import haveno.core.xmr.setup.MoneroWalletRpcManager;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.XmrWalletBase;
import java.io.File;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.MoneroRpcError;
import monero.common.MoneroUtils;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemonRpc;
import monero.daemon.model.MoneroDaemonInfo;
import monero.daemon.model.MoneroFeeEstimate;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroNetworkType;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroSubmitTxResult;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.MoneroWalletFull;
import monero.wallet.MoneroWalletRpc;
import monero.wallet.model.MoneroCheckTx;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxPriority;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletConfig;
import monero.wallet.model.MoneroWalletListenerI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmrWalletService
extends XmrWalletBase {
    private static final Logger log = LoggerFactory.getLogger(XmrWalletService.class);
    public static final int NUM_BLOCKS_UNLOCK = 10;
    public static final String MONERO_BINS_DIR = Config.appDataDir().getAbsolutePath();
    public static final String MONERO_WALLET_RPC_NAME = Utilities.isWindows() ? "monero-wallet-rpc.exe" : "monero-wallet-rpc";
    public static final String MONERO_WALLET_RPC_PATH = MONERO_BINS_DIR + File.separator + MONERO_WALLET_RPC_NAME;
    public static final MoneroTxPriority PROTOCOL_FEE_PRIORITY = MoneroTxPriority.DEFAULT;
    public static final int MONERO_LOG_LEVEL = -1;
    private static final MoneroNetworkType MONERO_NETWORK_TYPE = XmrWalletService.getMoneroNetworkType();
    private static final MoneroWalletRpcManager MONERO_WALLET_RPC_MANAGER = new MoneroWalletRpcManager();
    private static final String MONERO_WALLET_RPC_USERNAME = "haveno_user";
    private static final String MONERO_WALLET_RPC_DEFAULT_PASSWORD = "password";
    private static final String MONERO_WALLET_NAME = "haveno_XMR";
    private static final String KEYS_FILE_POSTFIX = ".keys";
    private static final String ADDRESS_FILE_POSTFIX = ".address.txt";
    private static final int NUM_MAX_WALLET_BACKUPS = 2;
    private static final int MAX_SYNC_ATTEMPTS = 3;
    private static final boolean PRINT_RPC_STACK_TRACE = false;
    private static final String THREAD_ID = XmrWalletService.class.getSimpleName();
    private static final long SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final long NUM_BLOCKS_BEHIND_TOLERANCE = 5L;
    private static final long POLL_TXS_TOLERANCE_MS = 180000L;
    private final User user;
    private final Preferences preferences;
    private final CoreAccountService accountService;
    private final XmrAddressEntryList xmrAddressEntryList;
    private final WalletsSetup walletsSetup;
    private final File walletDir;
    private final int rpcBindPort;
    private final boolean useNativeXmrWallet;
    protected final CopyOnWriteArraySet<XmrBalanceListener> balanceListeners = new CopyOnWriteArraySet();
    protected final CopyOnWriteArraySet<MoneroWalletListenerI> walletListeners = new CopyOnWriteArraySet();
    private ChangeListener<? super Number> walletInitListener;
    private TradeManager tradeManager;
    private ExecutorService syncWalletThreadPool = Executors.newFixedThreadPool(10);
    private final Object lock = new Object();
    private TaskLooper pollLooper;
    private boolean pollInProgress;
    private Long pollPeriodMs;
    private long lastLogDaemonNotSyncedTimestamp;
    private long lastLogPollErrorTimestamp;
    private long lastPollTxsTimestamp;
    private final Object pollLock = new Object();
    private Long cachedHeight;
    private BigInteger cachedBalance;
    private BigInteger cachedAvailableBalance = null;
    private List<MoneroSubaddress> cachedSubaddresses;
    private List<MoneroOutputWallet> cachedOutputs;
    private List<MoneroTxWallet> cachedTxs;

    @Inject
    XmrWalletService(User user, Preferences preferences, CoreAccountService accountService, XmrConnectionService xmrConnectionService, WalletsSetup walletsSetup, XmrAddressEntryList xmrAddressEntryList, @Named(value="walletDir") File walletDir, @Named(value="walletRpcBindPort") int rpcBindPort, @Named(value="useNativeXmrWallet") boolean useNativeXmrWallet) {
        this.user = user;
        this.preferences = preferences;
        this.accountService = accountService;
        this.walletsSetup = walletsSetup;
        this.xmrAddressEntryList = xmrAddressEntryList;
        this.walletDir = walletDir;
        this.rpcBindPort = rpcBindPort;
        this.useNativeXmrWallet = useNativeXmrWallet;
        HavenoUtils.xmrWalletService = this;
        HavenoUtils.xmrConnectionService = xmrConnectionService;
        this.xmrConnectionService = xmrConnectionService;
        walletsSetup.addSetupTaskHandler(() -> {
            this.initialize();
            accountService.addListener(new AccountServiceListener(){

                @Override
                public void onAccountCreated() {
                    log.info("onAccountCreated()");
                    XmrWalletService.this.initialize();
                }

                @Override
                public void onAccountOpened() {
                    log.info("onAccountOpened()");
                    XmrWalletService.this.initialize();
                }

                @Override
                public void onAccountClosed() {
                    log.info("onAccountClosed()");
                    XmrWalletService.this.closeMainWallet(true);
                }

                @Override
                public void onPasswordChanged(String oldPassword, String newPassword) {
                    log.info(String.valueOf(this.getClass()) + "accountservice.onPasswordChanged()");
                    if (oldPassword == null || oldPassword.isEmpty()) {
                        oldPassword = XmrWalletService.MONERO_WALLET_RPC_DEFAULT_PASSWORD;
                    }
                    if (newPassword == null || newPassword.isEmpty()) {
                        newPassword = XmrWalletService.MONERO_WALLET_RPC_DEFAULT_PASSWORD;
                    }
                    XmrWalletService.this.changeWalletPasswords(oldPassword, newPassword);
                }
            });
        });
    }

    public void setTradeManager(TradeManager tradeManager) {
        this.tradeManager = tradeManager;
    }

    public MoneroWallet getWallet() {
        Service.State state = this.walletsSetup.getWalletConfig().state();
        Preconditions.checkState(state == Service.State.STARTING || state == Service.State.RUNNING, "Cannot call until startup is complete and running, but state is: " + String.valueOf((Object)state));
        return this.wallet;
    }

    public long getWalletCreationDate() {
        return this.user.getWalletCreationDate();
    }

    @Override
    public void saveWallet() {
        this.saveWallet(this.shouldBackup(this.wallet));
    }

    private boolean shouldBackup(MoneroWallet wallet) {
        return wallet != null && !Utilities.isWindows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWallet(boolean backup) {
        Object object = this.walletLock;
        synchronized (object) {
            this.saveWallet(this.getWallet(), backup);
        }
    }

    @Override
    public void requestSaveWallet() {
        ThreadUtils.submitToPool(() -> this.saveWallet());
    }

    public boolean isWalletAvailable() {
        try {
            return this.getWallet() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isWalletEncrypted() {
        return this.accountService.getPassword() != null;
    }

    public ReadOnlyDoubleProperty downloadPercentageProperty() {
        return this.downloadListener.percentageProperty();
    }

    private void doneDownload() {
        this.downloadListener.doneDownload();
    }

    public boolean isDownloadComplete() {
        return this.downloadPercentageProperty().get() == 1.0;
    }

    public LongProperty walletHeightProperty() {
        return this.walletHeight;
    }

    public boolean isSyncedWithinTolerance() {
        if (!this.xmrConnectionService.isSyncedWithinTolerance()) {
            return false;
        }
        Long targetHeight = this.xmrConnectionService.getTargetHeight();
        if (targetHeight == null) {
            return false;
        }
        return targetHeight - this.walletHeight.get() <= 5L;
    }

    public MoneroDaemonRpc getDaemon() {
        return this.xmrConnectionService.getDaemon();
    }

    public boolean isProxyApplied() {
        return this.isProxyApplied(this.wasWalletSynced);
    }

    public boolean isProxyApplied(boolean wasWalletSynced) {
        return this.preferences.isProxyApplied(wasWalletSynced) && this.xmrConnectionService.isProxyApplied();
    }

    public String getWalletPassword() {
        return this.accountService.getPassword() == null ? MONERO_WALLET_RPC_DEFAULT_PASSWORD : this.accountService.getPassword();
    }

    public boolean walletExists(String walletName) {
        String path = this.walletDir.toString() + File.separator + walletName;
        return new File(path + KEYS_FILE_POSTFIX).exists();
    }

    public MoneroWallet createWallet(String walletName) {
        return this.createWallet(walletName, null);
    }

    public MoneroWallet createWallet(String walletName, Integer walletRpcPort) {
        log.info("{}.createWallet({})", (Object)this.getClass().getSimpleName(), (Object)walletName);
        if (this.isShutDownStarted) {
            throw new IllegalStateException("Cannot create wallet because shutting down");
        }
        MoneroWalletConfig config = this.getWalletConfig(walletName);
        return this.isNativeLibraryApplied() ? this.createWalletFull(config) : this.createWalletRpc(config, walletRpcPort);
    }

    public MoneroWallet openWallet(String walletName, boolean applyProxyUri) {
        return this.openWallet(walletName, null, applyProxyUri);
    }

    public MoneroWallet openWallet(String walletName, Integer walletRpcPort, boolean applyProxyUri) {
        log.info("{}.openWallet({})", (Object)this.getClass().getSimpleName(), (Object)walletName);
        if (this.isShutDownStarted) {
            throw new IllegalStateException("Cannot open wallet because shutting down");
        }
        MoneroWalletConfig config = this.getWalletConfig(walletName);
        return this.isNativeLibraryApplied() ? this.openWalletFull(config, applyProxyUri) : this.openWalletRpc(config, walletRpcPort, applyProxyUri);
    }

    private MoneroWalletConfig getWalletConfig(String walletName) {
        MoneroWalletConfig config = new MoneroWalletConfig().setPath(this.getWalletPath(walletName)).setPassword(this.getWalletPassword());
        if (this.isNativeLibraryApplied()) {
            config.setNetworkType(XmrWalletService.getMoneroNetworkType());
        }
        return config;
    }

    private String getWalletPath(String walletName) {
        return (String)(this.isNativeLibraryApplied() ? this.walletDir.getPath() + File.separator : "") + walletName;
    }

    private static String getWalletName(String walletPath) {
        return walletPath.substring(walletPath.lastIndexOf(File.separator) + 1);
    }

    private boolean isNativeLibraryApplied() {
        return this.useNativeXmrWallet && MoneroUtils.isNativeLibraryLoaded();
    }

    public MoneroSyncResult syncWallet(MoneroWallet wallet) {
        Object object = HavenoUtils.getDaemonLock();
        synchronized (object) {
            Callable<MoneroSyncResult> task = () -> wallet.sync();
            Future<MoneroSyncResult> future = this.syncWalletThreadPool.submit(task);
            try {
                return future.get();
            }
            catch (Exception e) {
                throw new MoneroError(e.getMessage());
            }
        }
    }

    public void saveWallet(MoneroWallet wallet) {
        this.saveWallet(wallet, false);
    }

    public void saveWallet(MoneroWallet wallet, boolean backup) {
        if (backup) {
            this.backupWallet(XmrWalletService.getWalletName(wallet.getPath()));
        }
        wallet.save();
    }

    public void closeWallet(MoneroWallet wallet, boolean save) {
        log.info("{}.closeWallet({}, {})", this.getClass().getSimpleName(), wallet.getPath(), save);
        MoneroError err = null;
        String path = wallet.getPath();
        try {
            if (save) {
                this.saveWallet(wallet, this.shouldBackup(wallet));
            }
            wallet.close();
        }
        catch (MoneroError e) {
            err = e;
        }
        if (wallet instanceof MoneroWalletRpc) {
            MONERO_WALLET_RPC_MANAGER.stopInstance((MoneroWalletRpc)wallet, path, false);
        }
        if (err != null) {
            throw err;
        }
    }

    public void forceCloseWallet(MoneroWallet wallet, String path) {
        if (wallet == null) {
            log.warn("Ignoring force close wallet because wallet is null, path={}", (Object)path);
            return;
        }
        if (wallet instanceof MoneroWalletRpc) {
            MONERO_WALLET_RPC_MANAGER.stopInstance((MoneroWalletRpc)wallet, path, true);
        } else {
            wallet.close(false);
        }
    }

    public void deleteWallet(String walletName) {
        XmrWalletService.assertNotPath(walletName);
        log.info("{}.deleteWallet({})", (Object)this.getClass().getSimpleName(), (Object)walletName);
        if (!this.walletExists(walletName)) {
            throw new RuntimeException("Wallet does not exist at path: " + walletName);
        }
        String path = this.walletDir.toString() + File.separator + walletName;
        if (!new File(path).delete()) {
            throw new RuntimeException("Failed to delete wallet cache file: " + path);
        }
        if (!new File(path + KEYS_FILE_POSTFIX).delete()) {
            throw new RuntimeException("Failed to delete wallet keys file: " + path + KEYS_FILE_POSTFIX);
        }
        if (!new File(path + ADDRESS_FILE_POSTFIX).delete() && !Config.baseCurrencyNetwork().isMainnet()) {
            throw new RuntimeException("Failed to delete wallet address file: " + path + ADDRESS_FILE_POSTFIX);
        }
    }

    public void backupWallet(String walletName) {
        XmrWalletService.assertNotPath(walletName);
        FileUtil.rollingBackup(this.walletDir, walletName, 2);
        FileUtil.rollingBackup(this.walletDir, walletName + KEYS_FILE_POSTFIX, 2);
        FileUtil.rollingBackup(this.walletDir, walletName + ADDRESS_FILE_POSTFIX, 2);
    }

    public void deleteWalletBackups(String walletName) {
        XmrWalletService.assertNotPath(walletName);
        FileUtil.deleteRollingBackup(this.walletDir, walletName);
        FileUtil.deleteRollingBackup(this.walletDir, walletName + KEYS_FILE_POSTFIX);
        FileUtil.deleteRollingBackup(this.walletDir, walletName + ADDRESS_FILE_POSTFIX);
    }

    private static void assertNotPath(String name) {
        if (name.contains(File.separator)) {
            throw new IllegalArgumentException("Path not expected: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroTxWallet createTx(MoneroTxConfig txConfig) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                MoneroTxWallet tx = this.wallet.createTx(txConfig);
                if (Boolean.TRUE.equals(txConfig.getRelay())) {
                    this.cachedTxs.add(0, tx);
                    this.cacheWalletInfo();
                    this.requestSaveWallet();
                }
                return tx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String relayTx(String metadata) {
        Object object = this.walletLock;
        synchronized (object) {
            String txId = this.wallet.relayTx(metadata);
            this.requestSaveWallet();
            return txId;
        }
    }

    public MoneroTxWallet createTx(List<MoneroDestination> destinations) {
        MoneroTxWallet tx = this.createTx(new MoneroTxConfig().setAccountIndex(0).setDestinations(destinations).setRelay(false).setCanSplit(false));
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixReservedOutputs() {
        Object object = this.walletLock;
        synchronized (object) {
            HashSet<String> reservedKeyImages = new HashSet<String>();
            for (Trade trade : this.tradeManager.getOpenTrades()) {
                if (trade.getSelf().getReserveTxKeyImages() == null) continue;
                reservedKeyImages.addAll(trade.getSelf().getReserveTxKeyImages());
            }
            for (OpenOffer openOffer : this.tradeManager.getOpenOfferManager().getOpenOffers()) {
                if (openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() == null) continue;
                reservedKeyImages.addAll(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages());
            }
            this.freezeReservedOutputs(reservedKeyImages);
            this.thawUnreservedOutputs(reservedKeyImages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeReservedOutputs(Set<String> reservedKeyImages) {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                log.warn("Cannot freeze reserved outputs because wallet not open");
                return;
            }
            Set<String> reservedUnfrozenKeyImages = this.getOutputs(new MoneroOutputQuery().setIsFrozen(false).setIsSpent(false)).stream().map(output -> output.getKeyImage().getHex()).collect(Collectors.toSet());
            reservedUnfrozenKeyImages.retainAll(reservedKeyImages);
            if (!reservedUnfrozenKeyImages.isEmpty()) {
                log.warn("Freezing unfrozen outputs which are reserved for offer or trade: " + String.valueOf(reservedUnfrozenKeyImages));
                this.freezeOutputs(reservedUnfrozenKeyImages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thawUnreservedOutputs(Set<String> reservedKeyImages) {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                log.warn("Cannot thaw unreserved outputs because wallet not open");
                return;
            }
            Set<String> unreservedFrozenKeyImages = this.getOutputs(new MoneroOutputQuery().setIsFrozen(true).setIsSpent(false)).stream().map(output -> output.getKeyImage().getHex()).collect(Collectors.toSet());
            unreservedFrozenKeyImages.removeAll(reservedKeyImages);
            if (!unreservedFrozenKeyImages.isEmpty()) {
                log.warn("Thawing frozen outputs which are not reserved for offer or trade: " + String.valueOf(unreservedFrozenKeyImages));
                this.thawOutputs(unreservedFrozenKeyImages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeOutputs(Collection<String> keyImages) {
        if (keyImages == null || keyImages.isEmpty()) {
            return;
        }
        Object object = this.walletLock;
        synchronized (object) {
            List unfrozenKeyImages = this.getOutputs(new MoneroOutputQuery().setIsFrozen(false).setIsSpent(false)).stream().map(output -> output.getKeyImage().getHex()).collect(Collectors.toList());
            unfrozenKeyImages.retainAll(keyImages);
            for (String keyImage : unfrozenKeyImages) {
                this.wallet.freezeOutput(keyImage);
            }
            this.cacheWalletInfo();
            this.requestSaveWallet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void thawOutputs(Collection<String> keyImages) {
        if (keyImages == null || keyImages.isEmpty()) {
            return;
        }
        Object object = this.walletLock;
        synchronized (object) {
            List frozenKeyImages = this.getOutputs(new MoneroOutputQuery().setIsFrozen(true).setIsSpent(false)).stream().map(output -> output.getKeyImage().getHex()).collect(Collectors.toList());
            frozenKeyImages.retainAll(keyImages);
            for (String keyImage : frozenKeyImages) {
                this.wallet.thawOutput(keyImage);
            }
            this.cacheWalletInfo();
            this.requestSaveWallet();
        }
    }

    private List<Integer> getSubaddressesWithExactInput(BigInteger amount) {
        List<MoneroOutputWallet> exactOutputs = this.getOutputs(new MoneroOutputQuery().setAmount(amount).setIsSpent(false).setIsFrozen(false).setTxQuery(new MoneroTxQuery().setIsLocked(false)));
        TreeSet<Integer> subaddressIndices = new TreeSet<Integer>();
        for (MoneroOutputWallet output : exactOutputs) {
            subaddressIndices.add(output.getSubaddressIndex());
        }
        return new ArrayList<Integer>(subaddressIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroTxWallet createReserveTx(BigInteger penaltyFee, BigInteger tradeFee, BigInteger sendTradeAmount, BigInteger securityDeposit, String returnAddress, boolean reserveExactAmount, Integer preferredSubaddressIndex) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                log.info("Creating reserve tx with preferred subaddress index={}, return address={}", (Object)preferredSubaddressIndex, (Object)returnAddress);
                long time = System.currentTimeMillis();
                BigInteger sendAmount = sendTradeAmount.add(securityDeposit).add(tradeFee).subtract(penaltyFee);
                MoneroTxWallet reserveTx = this.createTradeTx(penaltyFee, HavenoUtils.getBurnAddress(), sendAmount, returnAddress, reserveExactAmount, preferredSubaddressIndex);
                log.info("Done creating reserve tx in {} ms", (Object)(System.currentTimeMillis() - time));
                return reserveTx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroTxWallet createDepositTx(Trade trade, boolean reserveExactAmount, Integer preferredSubaddressIndex) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                BigInteger feeAmount = trade instanceof MakerTrade ? trade.getMakerFee() : trade.getTakerFee();
                String feeAddress = trade.getProcessModel().getTradeFeeAddress();
                BigInteger sendTradeAmount = trade instanceof BuyerTrade ? BigInteger.ZERO : trade.getAmount();
                BigInteger securityDeposit = trade instanceof BuyerTrade ? trade.getBuyerSecurityDepositBeforeMiningFee() : trade.getSellerSecurityDepositBeforeMiningFee();
                BigInteger sendAmount = sendTradeAmount.add(securityDeposit);
                String multisigAddress = trade.getProcessModel().getMultisigAddress();
                long time = System.currentTimeMillis();
                log.info("Creating deposit tx for trade {} {} with multisig address={}", trade.getClass().getSimpleName(), trade.getShortId(), multisigAddress);
                MoneroTxWallet depositTx = this.createTradeTx(feeAmount, feeAddress, sendAmount, multisigAddress, reserveExactAmount, preferredSubaddressIndex);
                log.info("Done creating deposit tx for trade {} {} in {} ms", trade.getClass().getSimpleName(), trade.getShortId(), System.currentTimeMillis() - time);
                return depositTx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoneroTxWallet createTradeTx(BigInteger feeAmount, String feeAddress, BigInteger sendAmount, String sendAddress, boolean reserveExactAmount, Integer preferredSubaddressIndex) {
        Object object = this.walletLock;
        synchronized (object) {
            MoneroWallet wallet = this.getWallet();
            ArrayList<Integer> subaddressIndices = new ArrayList<Integer>();
            if (reserveExactAmount) {
                BigInteger exactInputAmount = feeAmount.add(sendAmount);
                List<Integer> subaddressIndicesWithExactInput = this.getSubaddressesWithExactInput(exactInputAmount);
                if (preferredSubaddressIndex != null) {
                    subaddressIndicesWithExactInput.remove(preferredSubaddressIndex);
                }
                Collections.sort(subaddressIndicesWithExactInput);
                Collections.reverse(subaddressIndicesWithExactInput);
                subaddressIndices.addAll(subaddressIndicesWithExactInput);
            }
            if (preferredSubaddressIndex != null) {
                if (wallet.getBalance(0, preferredSubaddressIndex).compareTo(BigInteger.ZERO) > 0) {
                    subaddressIndices.add(0, preferredSubaddressIndex);
                } else if (reserveExactAmount) {
                    subaddressIndices.add(preferredSubaddressIndex);
                }
            }
            for (int i = 0; i < subaddressIndices.size(); ++i) {
                try {
                    return this.createTradeTxFromSubaddress(feeAmount, feeAddress, sendAmount, sendAddress, (Integer)subaddressIndices.get(i));
                }
                catch (Exception e) {
                    log.info("Cannot create trade tx from preferred subaddress index " + String.valueOf(subaddressIndices.get(i)) + ": " + e.getMessage());
                    continue;
                }
            }
            if (!subaddressIndices.isEmpty()) {
                log.info("Could not create trade tx from preferred subaddresses, trying any subaddress");
            }
            return this.createTradeTxFromSubaddress(feeAmount, feeAddress, sendAmount, sendAddress, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoneroTxWallet createTradeTxFromSubaddress(BigInteger feeAmount, String feeAddress, BigInteger sendAmount, String sendAddress, Integer subaddressIndex) {
        Object object = this.walletLock;
        synchronized (object) {
            MoneroTxConfig txConfig = new MoneroTxConfig().setAccountIndex(0).setSubaddressIndices(subaddressIndex).addDestination(sendAddress, sendAmount).setSubtractFeeFrom(0).setPriority(PROTOCOL_FEE_PRIORITY);
            if (!BigInteger.valueOf(0L).equals(feeAmount)) {
                txConfig.addDestination(feeAddress, feeAmount);
            }
            MoneroTxWallet tradeTx = this.createTx(txConfig);
            ArrayList<String> keyImages = new ArrayList<String>();
            for (MoneroOutput input : tradeTx.getInputs()) {
                keyImages.add(input.getKeyImage().getHex());
            }
            this.freezeOutputs(keyImages);
            return tradeTx;
        }
    }

    public MoneroTx verifyReserveTx(String offerId, BigInteger penaltyFee, BigInteger tradeFee, BigInteger sendTradeAmount, BigInteger securityDeposit, String returnAddress, String txHash, String txHex, String txKey, List<String> keyImages) {
        BigInteger sendAmount = sendTradeAmount.add(securityDeposit).add(tradeFee).subtract(penaltyFee);
        return this.verifyTradeTx(offerId, penaltyFee, HavenoUtils.getBurnAddress(), sendAmount, returnAddress, txHash, txHex, txKey, keyImages);
    }

    public MoneroTx verifyDepositTx(String offerId, BigInteger feeAmount, String feeAddress, BigInteger sendTradeAmount, BigInteger securityDeposit, String multisigAddress, String txHash, String txHex, String txKey, List<String> keyImages) {
        BigInteger sendAmount = sendTradeAmount.add(securityDeposit);
        return this.verifyTradeTx(offerId, feeAmount, feeAddress, sendAmount, multisigAddress, txHash, txHex, txKey, keyImages);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MoneroTx verifyTradeTx(String offerId, BigInteger tradeFeeAmount, String feeAddress, BigInteger sendAmount, String sendAddress, String txHash, String txHex, String txKey, List<String> keyImages) {
        if (txHash == null) {
            throw new IllegalArgumentException("Cannot verify trade tx with null id");
        }
        MoneroDaemonRpc daemon = this.getDaemon();
        MoneroWallet wallet = this.getWallet();
        MoneroTx tx = null;
        Object object = this.lock;
        synchronized (object) {
            MoneroTx moneroTx;
            try {
                BigInteger expectedSendAmount;
                void var16_22;
                MoneroCheckTx transferCheck;
                tx = daemon.getTx(txHash);
                if (tx != null) {
                    throw new RuntimeException("Tx is already submitted");
                }
                MoneroSubmitTxResult result = daemon.submitTxHex(txHex, true);
                if (!result.isGood().booleanValue()) {
                    throw new RuntimeException("Failed to submit tx to daemon: " + JsonUtils.serialize(result));
                }
                for (MoneroTx moneroTx2 : daemon.getTxPool()) {
                    if (!moneroTx2.getHash().equals(txHash)) continue;
                    tx = moneroTx2;
                }
                if (tx == null) {
                    throw new RuntimeException("Tx is not in pool after being submitted");
                }
                if (keyImages != null) {
                    HashSet<String> txKeyImages = new HashSet<String>();
                    for (MoneroOutput input : tx.getInputs()) {
                        txKeyImages.add(input.getKeyImage().getHex());
                    }
                    if (!txKeyImages.equals(new HashSet<String>(keyImages))) {
                        throw new RuntimeException("Tx inputs do not match claimed key images");
                    }
                }
                if (!BigInteger.ZERO.equals(tx.getUnlockTime())) {
                    throw new RuntimeException("Unlock height must be 0");
                }
                BigInteger minerFeeEstimate = this.getFeeEstimate(tx.getWeight());
                HavenoUtils.verifyMinerFee(minerFeeEstimate, tx.getFee());
                log.info("Trade miner fee {} is within tolerance");
                BigInteger bigInteger = BigInteger.ZERO;
                if (tradeFeeAmount.compareTo(BigInteger.ZERO) > 0) {
                    MoneroCheckTx tradeFeeCheck = wallet.checkTxKey(txHash, txKey, feeAddress);
                    if (!tradeFeeCheck.isGood().booleanValue()) {
                        throw new RuntimeException("Invalid proof to trade fee address");
                    }
                    BigInteger bigInteger2 = tradeFeeCheck.getReceivedAmount();
                }
                if (!(transferCheck = wallet.checkTxKey(txHash, txKey, sendAddress)).isGood().booleanValue()) {
                    throw new RuntimeException("Invalid proof to transfer address");
                }
                BigInteger actualSendAmount = transferCheck.getReceivedAmount();
                if (!var16_22.equals(tradeFeeAmount)) {
                    if (!XmrWalletService.equalsWithinFractionError((BigInteger)var16_22, tradeFeeAmount)) throw new RuntimeException("Invalid trade fee amount, expected " + String.valueOf(tradeFeeAmount) + " but was " + String.valueOf(var16_22));
                    log.warn("Trade fee amount is within fraction error, expected " + String.valueOf(tradeFeeAmount) + " but was " + String.valueOf(var16_22));
                }
                if (!actualSendAmount.equals(expectedSendAmount = sendAmount.subtract(tx.getFee()))) {
                    if (!XmrWalletService.equalsWithinFractionError(actualSendAmount, expectedSendAmount)) throw new RuntimeException("Invalid send amount, expected " + String.valueOf(expectedSendAmount) + " but was " + String.valueOf(actualSendAmount) + " with tx fee " + String.valueOf(tx.getFee()));
                    log.warn("Trade tx send amount is within fraction error, expected " + String.valueOf(expectedSendAmount) + " but was " + String.valueOf(actualSendAmount) + " with tx fee " + String.valueOf(tx.getFee()));
                }
                moneroTx = tx;
            }
            catch (Exception e) {
                try {
                    log.warn("Error verifying trade tx with offer id=" + offerId + (String)(tx == null ? "" : ", tx=\n" + String.valueOf(tx)) + ": " + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        daemon.flushTxPool(txHash);
                        throw throwable;
                    }
                    catch (MoneroRpcError err) {
                        RuntimeException runtimeException;
                        System.out.println(daemon.getRpcConnection());
                        if (err.getCode().equals(-32601)) {
                            runtimeException = new RuntimeException("Failed to flush tx from pool. Arbitrator must use trusted, unrestricted daemon");
                            throw runtimeException;
                        }
                        runtimeException = err;
                        throw runtimeException;
                    }
                }
            }
            try {
                daemon.flushTxPool(txHash);
            }
            catch (MoneroRpcError err) {
                RuntimeException runtimeException;
                System.out.println(daemon.getRpcConnection());
                if (err.getCode().equals(-32601)) {
                    runtimeException = new RuntimeException("Failed to flush tx from pool. Arbitrator must use trusted, unrestricted daemon");
                    throw runtimeException;
                }
                runtimeException = err;
                throw runtimeException;
            }
            return moneroTx;
        }
    }

    private static boolean equalsWithinFractionError(BigInteger a, BigInteger b) {
        return a.subtract(b).abs().compareTo(new BigInteger("1")) <= 0;
    }

    private BigInteger getFeeEstimate(long txWeight) {
        MoneroTxPriority priority = PROTOCOL_FEE_PRIORITY == MoneroTxPriority.DEFAULT ? this.wallet.getDefaultFeePriority() : PROTOCOL_FEE_PRIORITY;
        MoneroFeeEstimate feeEstimates = this.getDaemon().getFeeEstimate();
        BigInteger baseFeeEstimate = feeEstimates.getFees().get(priority.ordinal() - 1);
        BigInteger qmask = feeEstimates.getQuantizationMask();
        log.info("Monero base fee estimate={}, qmask={}", (Object)baseFeeEstimate, (Object)qmask);
        BigInteger baseFee = baseFeeEstimate.multiply(BigInteger.valueOf(txWeight));
        BigInteger[] quotientAndRemainder = baseFee.divideAndRemainder(qmask);
        BigInteger feeEstimate = qmask.multiply(quotientAndRemainder[0]);
        if (quotientAndRemainder[1].compareTo(BigInteger.ZERO) > 0) {
            feeEstimate = feeEstimate.add(qmask);
        }
        return feeEstimate;
    }

    public MoneroTx getDaemonTx(String txHash) {
        List<MoneroTx> txs = this.getDaemonTxs(Arrays.asList(txHash));
        return txs.isEmpty() ? null : txs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MoneroTx> getDaemonTxs(List<String> txHashes) {
        Map map = this.txCache;
        synchronized (map) {
            if (this.getDaemon() == null) {
                this.xmrConnectionService.verifyConnection();
            }
            List<MoneroTx> txs = this.getDaemon().getTxs(txHashes, true);
            for (MoneroTx tx : txs) {
                this.txCache.put(tx.getHash(), Optional.of(tx));
            }
            UserThread.runAfter(() -> {
                Map map = this.txCache;
                synchronized (map) {
                    for (MoneroTx tx : txs) {
                        this.txCache.remove(tx.getHash());
                    }
                }
            }, this.xmrConnectionService.getRefreshPeriodMs() / 1000L);
            return txs;
        }
    }

    public MoneroTx getDaemonTxWithCache(String txHash) {
        List<MoneroTx> cachedTxs = this.getDaemonTxsWithCache(Arrays.asList(txHash));
        return cachedTxs.isEmpty() ? null : cachedTxs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MoneroTx> getDaemonTxsWithCache(List<String> txHashes) {
        Map map = this.txCache;
        synchronized (map) {
            try {
                ArrayList<MoneroTx> cachedTxs = new ArrayList<MoneroTx>();
                ArrayList<String> uncachedTxHashes = new ArrayList<String>();
                for (int i = 0; i < txHashes.size(); ++i) {
                    if (this.txCache.containsKey(txHashes.get(i))) {
                        cachedTxs.add(((Optional)this.txCache.get(txHashes.get(i))).orElse(null));
                        continue;
                    }
                    uncachedTxHashes.add(txHashes.get(i));
                }
                return uncachedTxHashes.isEmpty() ? cachedTxs : this.getDaemonTxs(txHashes);
            }
            catch (Exception e) {
                if (!this.isShutDownStarted) {
                    throw e;
                }
                return null;
            }
        }
    }

    public void onShutDownStarted() {
        log.info("XmrWalletService.onShutDownStarted()");
        this.isShutDownStarted = true;
    }

    public void shutDown() {
        log.info("Shutting down {}", (Object)this.getClass().getSimpleName());
        Runnable shutDownTask = () -> {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.wallet != null) {
                    for (MoneroWalletListenerI listener : new HashSet<MoneroWalletListenerI>(this.wallet.getListeners())) {
                        this.wallet.removeListener(listener);
                    }
                }
                this.walletListeners.clear();
            }
            object = this.lock;
            synchronized (object) {
                ArrayList<Runnable> shutDownThreads = new ArrayList<Runnable>();
                shutDownThreads.add(() -> ThreadUtils.shutDown(THREAD_ID));
                ThreadUtils.awaitTasks(shutDownThreads);
            }
            if (this.wallet != null) {
                try {
                    this.closeMainWallet(true);
                }
                catch (Exception e) {
                    log.warn("Error closing main wallet: {}. Was Haveno stopped manually with ctrl+c?", (Object)e.getMessage());
                }
            }
        };
        try {
            ThreadUtils.awaitTask(shutDownTask, 60000L);
        }
        catch (Exception e) {
            log.warn("Error shutting down {}: {}\n", this.getClass().getSimpleName(), e.getMessage(), e);
            this.forceCloseMainWallet();
        }
        log.info("Done shutting down {}", (Object)this.getClass().getSimpleName());
    }

    public synchronized XmrAddressEntry getNewAddressEntry() {
        return this.getNewAddressEntryAux(null, XmrAddressEntry.Context.AVAILABLE);
    }

    public synchronized XmrAddressEntry getNewAddressEntry(String offerId, XmrAddressEntry.Context context) {
        try {
            List<XmrAddressEntry> unusedAddressEntries = this.getUnusedAddressEntries();
            if (!unusedAddressEntries.isEmpty()) {
                return this.xmrAddressEntryList.swapAvailableToAddressEntryWithOfferId(unusedAddressEntries.get(0), context, offerId);
            }
        }
        catch (Exception e) {
            log.warn("Error getting new address entry based on incoming transactions: {}\n", (Object)e.getMessage(), (Object)e);
        }
        return this.getNewAddressEntryAux(offerId, context);
    }

    private XmrAddressEntry getNewAddressEntryAux(String offerId, XmrAddressEntry.Context context) {
        MoneroSubaddress subaddress = this.wallet.createSubaddress(0);
        XmrAddressEntry entry = new XmrAddressEntry(subaddress.getIndex(), subaddress.getAddress(), context, offerId, null);
        log.info("Add new XmrAddressEntry {}", (Object)entry);
        this.xmrAddressEntryList.addAddressEntry(entry);
        return entry;
    }

    public synchronized XmrAddressEntry getFreshAddressEntry() {
        List<XmrAddressEntry> unusedAddressEntries = this.getUnusedAddressEntries();
        if (unusedAddressEntries.isEmpty()) {
            return this.getNewAddressEntry();
        }
        return unusedAddressEntries.get(0);
    }

    public synchronized XmrAddressEntry recoverAddressEntry(String offerId, String address, XmrAddressEntry.Context context) {
        Optional<XmrAddressEntry> available = this.findAddressEntry(address, XmrAddressEntry.Context.AVAILABLE);
        if (!available.isPresent()) {
            return null;
        }
        return this.xmrAddressEntryList.swapAvailableToAddressEntryWithOfferId(available.get(), context, offerId);
    }

    public synchronized XmrAddressEntry getOrCreateAddressEntry(String offerId, XmrAddressEntry.Context context) {
        Optional<XmrAddressEntry> addressEntry = this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).findAny();
        if (addressEntry.isPresent()) {
            return addressEntry.get();
        }
        return this.getNewAddressEntry(offerId, context);
    }

    public synchronized Optional<XmrAddressEntry> getAddressEntry(String offerId, XmrAddressEntry.Context context) {
        List entries = this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).collect(Collectors.toList());
        if (entries.size() > 1) {
            throw new RuntimeException("Multiple address entries exist with offer ID " + offerId + " and context " + String.valueOf((Object)context) + ". That should never happen.");
        }
        return entries.isEmpty() ? Optional.empty() : Optional.of((XmrAddressEntry)entries.get(0));
    }

    public synchronized void swapAddressEntryToAvailable(String offerId, XmrAddressEntry.Context context) {
        Optional<XmrAddressEntry> addressEntryOptional = this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).filter(e -> context == e.getContext()).findAny();
        addressEntryOptional.ifPresent(e -> {
            this.xmrAddressEntryList.swapToAvailable((XmrAddressEntry)e);
            this.saveAddressEntryList();
        });
    }

    public synchronized void cloneAddressEntries(String offerId, String cloneOfferId) {
        List entries = this.getAddressEntryListAsImmutableList().stream().filter(e -> offerId.equals(e.getOfferId())).collect(Collectors.toList());
        for (XmrAddressEntry entry : entries) {
            XmrAddressEntry clonedEntry = new XmrAddressEntry(entry.getSubaddressIndex(), entry.getAddressString(), entry.getContext(), cloneOfferId, null);
            Optional<XmrAddressEntry> existingEntry = this.getAddressEntry(clonedEntry.getOfferId(), clonedEntry.getContext());
            if (existingEntry.isPresent()) continue;
            this.xmrAddressEntryList.addAddressEntry(clonedEntry);
        }
    }

    public synchronized void resetAddressEntriesForOpenOffer(String offerId) {
        log.info("resetAddressEntriesForOpenOffer offerId={}", (Object)offerId);
        if (this.tradeManager.hasFailedScheduledTrade(offerId)) {
            log.warn("Refusing to reset address entries because trade is scheduled for deletion with offerId={}", (Object)offerId);
            return;
        }
        this.swapAddressEntryToAvailable(offerId, XmrAddressEntry.Context.OFFER_FUNDING);
        if (this.tradeManager == null) {
            return;
        }
        Trade trade = this.tradeManager.getTrade(offerId);
        if (trade == null || trade.isPayoutUnlocked()) {
            this.swapAddressEntryToAvailable(offerId, XmrAddressEntry.Context.TRADE_PAYOUT);
        }
    }

    public synchronized void swapPayoutAddressEntryToAvailable(String offerId) {
        this.swapAddressEntryToAvailable(offerId, XmrAddressEntry.Context.TRADE_PAYOUT);
    }

    private Optional<XmrAddressEntry> findAddressEntry(String address, XmrAddressEntry.Context context) {
        return this.getAddressEntryListAsImmutableList().stream().filter(e -> address.equals(e.getAddressString())).filter(e -> context == e.getContext()).findAny();
    }

    public List<XmrAddressEntry> getAddressEntries() {
        return this.getAddressEntryListAsImmutableList().stream().collect(Collectors.toList());
    }

    public List<XmrAddressEntry> getAvailableAddressEntries() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> XmrAddressEntry.Context.AVAILABLE == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<XmrAddressEntry> getAddressEntriesForOpenOffer() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> XmrAddressEntry.Context.OFFER_FUNDING == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<XmrAddressEntry> getAddressEntriesForTrade() {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> XmrAddressEntry.Context.TRADE_PAYOUT == addressEntry.getContext()).collect(Collectors.toList());
    }

    public List<XmrAddressEntry> getAddressEntries(XmrAddressEntry.Context context) {
        return this.getAddressEntryListAsImmutableList().stream().filter(addressEntry -> context == addressEntry.getContext()).collect(Collectors.toList());
    }

    public XmrAddressEntry getBaseAddressEntry() {
        return this.getAddressEntryListAsImmutableList().stream().filter(e -> e.getContext() == XmrAddressEntry.Context.BASE_ADDRESS).findAny().orElse(null);
    }

    public List<XmrAddressEntry> getFundedAvailableAddressEntries() {
        return this.getAvailableAddressEntries().stream().filter(addressEntry -> this.getBalanceForSubaddress(addressEntry.getSubaddressIndex()).compareTo(BigInteger.ZERO) > 0).collect(Collectors.toList());
    }

    public List<XmrAddressEntry> getAddressEntryListAsImmutableList() {
        for (MoneroSubaddress subaddress : this.cachedSubaddresses) {
            boolean exists = this.xmrAddressEntryList.getAddressEntriesAsListImmutable().stream().filter(addressEntry -> addressEntry.getAddressString().equals(subaddress.getAddress())).findAny().isPresent();
            if (exists) continue;
            XmrAddressEntry entry = new XmrAddressEntry(subaddress.getIndex(), subaddress.getAddress(), subaddress.getIndex() == 0 ? XmrAddressEntry.Context.BASE_ADDRESS : XmrAddressEntry.Context.AVAILABLE, null, null);
            this.xmrAddressEntryList.addAddressEntry(entry);
        }
        return this.xmrAddressEntryList.getAddressEntriesAsListImmutable();
    }

    public List<XmrAddressEntry> getUnusedAddressEntries() {
        return this.getAvailableAddressEntries().stream().filter(e -> e.getContext() == XmrAddressEntry.Context.AVAILABLE && !this.subaddressHasIncomingTransfers(e.getSubaddressIndex())).collect(Collectors.toList());
    }

    public boolean subaddressHasIncomingTransfers(int subaddressIndex) {
        return this.getNumOutputsForSubaddress(subaddressIndex) > 0;
    }

    public int getNumOutputsForSubaddress(int subaddressIndex) {
        boolean positiveBalance;
        int numUnspentOutputs = 0;
        for (MoneroTxWallet tx : this.cachedTxs) {
            numUnspentOutputs += tx.getOutputsWallet(new MoneroOutputQuery().setAccountIndex(0).setSubaddressIndex(subaddressIndex)).size();
        }
        boolean bl = positiveBalance = this.getBalanceForSubaddress(subaddressIndex).compareTo(BigInteger.ZERO) > 0;
        if (positiveBalance && numUnspentOutputs == 0) {
            return 1;
        }
        return numUnspentOutputs;
    }

    private MoneroSubaddress getSubaddress(int subaddressIndex) {
        for (MoneroSubaddress subaddress : this.cachedSubaddresses) {
            if (subaddress.getIndex() != subaddressIndex) continue;
            return subaddress;
        }
        return null;
    }

    public int getNumTxsWithIncomingOutputs(int subaddressIndex) {
        List<MoneroTxWallet> txsWithIncomingOutputs = this.getTxsWithIncomingOutputs(subaddressIndex);
        if (txsWithIncomingOutputs.isEmpty() && this.subaddressHasIncomingTransfers(subaddressIndex)) {
            return 1;
        }
        return txsWithIncomingOutputs.size();
    }

    public List<MoneroTxWallet> getTxsWithIncomingOutputs() {
        return this.getTxsWithIncomingOutputs(null);
    }

    public List<MoneroTxWallet> getTxsWithIncomingOutputs(Integer subaddressIndex) {
        ArrayList<MoneroTxWallet> incomingTxs = new ArrayList<MoneroTxWallet>();
        for (MoneroTxWallet tx : this.cachedTxs) {
            boolean isIncoming = false;
            if (tx.getIncomingTransfers() != null) {
                for (MoneroIncomingTransfer transfer : tx.getIncomingTransfers()) {
                    if (!transfer.getAccountIndex().equals(0) || subaddressIndex != null && !transfer.getSubaddressIndex().equals(subaddressIndex)) continue;
                    isIncoming = true;
                    break;
                }
            }
            if (tx.getOutputs() != null && !isIncoming) {
                for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                    if (!output.getAccountIndex().equals(0) || subaddressIndex != null && !output.getSubaddressIndex().equals(subaddressIndex)) continue;
                    isIncoming = true;
                    break;
                }
            }
            if (!isIncoming) continue;
            incomingTxs.add(tx);
        }
        return incomingTxs;
    }

    public BigInteger getBalanceForAddress(String address) {
        return this.getBalanceForSubaddress(this.wallet.getAddressIndex(address).getIndex());
    }

    public BigInteger getBalanceForSubaddress(int subaddressIndex) {
        MoneroSubaddress subaddress = this.getSubaddress(subaddressIndex);
        return subaddress == null ? BigInteger.ZERO : subaddress.getBalance();
    }

    public BigInteger getBalanceForSubaddress(int subaddressIndex, boolean includeFrozen) {
        return this.getBalanceForSubaddress(subaddressIndex).add(includeFrozen ? this.getFrozenBalanceForSubaddress(subaddressIndex) : BigInteger.ZERO);
    }

    public BigInteger getFrozenBalanceForSubaddress(int subaddressIndex) {
        List<MoneroOutputWallet> outputs = this.getOutputs(new MoneroOutputQuery().setIsFrozen(true).setIsSpent(false).setAccountIndex(0).setSubaddressIndex(subaddressIndex));
        return outputs.stream().map(output -> output.getAmount()).reduce(BigInteger.ZERO, BigInteger::add);
    }

    public BigInteger getAvailableBalanceForSubaddress(int subaddressIndex) {
        MoneroSubaddress subaddress = this.getSubaddress(subaddressIndex);
        return subaddress == null ? BigInteger.ZERO : subaddress.getUnlockedBalance();
    }

    public Stream<XmrAddressEntry> getAddressEntriesForAvailableBalanceStream() {
        Stream<Object> available = this.getFundedAvailableAddressEntries().stream();
        available = Stream.concat(available, this.getAddressEntries(XmrAddressEntry.Context.ARBITRATOR).stream());
        available = Stream.concat(available, this.getAddressEntries(XmrAddressEntry.Context.OFFER_FUNDING).stream().filter(entry -> !this.tradeManager.getOpenOfferManager().getOpenOffer(entry.getOfferId()).isPresent()));
        available = Stream.concat(available, this.getAddressEntries(XmrAddressEntry.Context.TRADE_PAYOUT).stream().filter(entry -> this.tradeManager.getTrade(entry.getOfferId()) == null || this.tradeManager.getTrade(entry.getOfferId()).isPayoutUnlocked()));
        return available.filter(addressEntry -> this.getBalanceForSubaddress(addressEntry.getSubaddressIndex()).compareTo(BigInteger.ZERO) > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWalletListener(MoneroWalletListenerI listener) {
        CopyOnWriteArraySet<MoneroWalletListenerI> copyOnWriteArraySet = this.walletListeners;
        synchronized (copyOnWriteArraySet) {
            this.walletListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWalletListener(MoneroWalletListenerI listener) {
        CopyOnWriteArraySet<MoneroWalletListenerI> copyOnWriteArraySet = this.walletListeners;
        synchronized (copyOnWriteArraySet) {
            if (!this.walletListeners.contains(listener)) {
                throw new RuntimeException("Listener is not registered with wallet");
            }
            this.walletListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBalanceListener(XmrBalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null balance listener");
        }
        CopyOnWriteArraySet<XmrBalanceListener> copyOnWriteArraySet = this.balanceListeners;
        synchronized (copyOnWriteArraySet) {
            if (!this.balanceListeners.contains(listener)) {
                this.balanceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBalanceListener(XmrBalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null balance listener");
        }
        CopyOnWriteArraySet<XmrBalanceListener> copyOnWriteArraySet = this.balanceListeners;
        synchronized (copyOnWriteArraySet) {
            this.balanceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBalanceListeners() {
        BigInteger availableBalance = this.getAvailableBalance();
        CopyOnWriteArraySet<XmrBalanceListener> copyOnWriteArraySet = this.balanceListeners;
        synchronized (copyOnWriteArraySet) {
            for (XmrBalanceListener balanceListener : this.balanceListeners) {
                BigInteger balance = balanceListener.getSubaddressIndex() != null && balanceListener.getSubaddressIndex() != 0 ? this.getBalanceForSubaddress(balanceListener.getSubaddressIndex()) : availableBalance;
                ThreadUtils.submitToPool(() -> {
                    try {
                        balanceListener.onBalanceChanged(balance);
                    }
                    catch (Exception e) {
                        log.warn("Failed to notify balance listener of change: {}\n", (Object)e.getMessage(), (Object)e);
                    }
                });
            }
        }
    }

    public void saveAddressEntryList() {
        this.xmrAddressEntryList.requestPersistence();
    }

    public long getHeight() {
        return this.walletHeight.get();
    }

    public List<MoneroTxWallet> getTxs(boolean includeFailed) {
        List<MoneroTxWallet> txs = this.getTxs();
        if (includeFailed) {
            return txs;
        }
        return txs.stream().filter(tx -> tx.isFailed() == false).collect(Collectors.toList());
    }

    public List<MoneroTxWallet> getTxs() {
        return this.getTxs(new MoneroTxQuery().setIncludeOutputs(true));
    }

    public List<MoneroTxWallet> getTxs(MoneroTxQuery query) {
        if (this.cachedTxs == null) {
            log.warn("Transactions not cached, fetching from wallet");
            this.cachedTxs = this.wallet.getTxs(new MoneroTxQuery().setIncludeOutputs(true));
        }
        return this.cachedTxs.stream().filter(tx -> query.meetsCriteria((MoneroTxWallet)tx)).collect(Collectors.toList());
    }

    public List<MoneroTxWallet> getTxs(List<String> txIds) {
        return this.getTxs(new MoneroTxQuery().setHashes(txIds));
    }

    public MoneroTxWallet getTx(String txId) {
        List<MoneroTxWallet> txs = this.getTxs(new MoneroTxQuery().setHash(txId));
        return txs.isEmpty() ? null : txs.get(0);
    }

    public BigInteger getBalance() {
        return this.cachedBalance;
    }

    public BigInteger getAvailableBalance() {
        return this.cachedAvailableBalance;
    }

    public boolean hasAddress(String address) {
        for (MoneroSubaddress subaddress : this.getSubaddresses()) {
            if (!subaddress.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    public List<MoneroSubaddress> getSubaddresses() {
        return this.cachedSubaddresses;
    }

    public BigInteger getAmountSentToSelf(MoneroTxWallet tx) {
        BigInteger sentToSelfAmount = BigInteger.ZERO;
        if (tx.getOutgoingTransfer() != null && tx.getOutgoingTransfer().getDestinations() != null) {
            for (MoneroDestination destination : tx.getOutgoingTransfer().getDestinations()) {
                if (!this.hasAddress(destination.getAddress())) continue;
                sentToSelfAmount = sentToSelfAmount.add(destination.getAmount());
            }
        }
        return sentToSelfAmount;
    }

    public List<MoneroOutputWallet> getOutputs(MoneroOutputQuery query) {
        ArrayList<MoneroOutputWallet> filteredOutputs = new ArrayList<MoneroOutputWallet>();
        for (MoneroOutputWallet output : this.cachedOutputs) {
            if (query != null && !query.meetsCriteria(output)) continue;
            filteredOutputs.add(output);
        }
        return filteredOutputs;
    }

    public List<MoneroOutputWallet> getOutputs(Collection<String> keyImages) {
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        for (String keyImage : keyImages) {
            List<MoneroOutputWallet> outputList = this.getOutputs(new MoneroOutputQuery().setIsSpent(false).setKeyImage(new MoneroKeyImage(keyImage)));
            if (outputList.isEmpty()) continue;
            outputs.add(outputList.get(0));
        }
        return outputs;
    }

    public BigInteger getOutputsAmount(Collection<String> keyImages) {
        return this.getOutputs(keyImages).stream().map(output -> output.getAmount()).reduce(BigInteger.ZERO, BigInteger::add);
    }

    public static MoneroNetworkType getMoneroNetworkType() {
        switch (Config.baseCurrencyNetwork()) {
            case XMR_LOCAL: {
                return MoneroNetworkType.TESTNET;
            }
            case XMR_STAGENET: {
                return MoneroNetworkType.STAGENET;
            }
            case XMR_MAINNET: {
                return MoneroNetworkType.MAINNET;
            }
        }
        throw new RuntimeException("Unhandled base currency network: " + String.valueOf((Object)Config.baseCurrencyNetwork()));
    }

    public static void printTxs(String tracePrefix, MoneroTxWallet ... txs) {
        StringBuilder sb = new StringBuilder();
        for (MoneroTxWallet tx : txs) {
            sb.append("\n" + tx.toString());
        }
        log.info("\n" + tracePrefix + ":" + sb.toString());
    }

    private void initialize() {
        if (this.useNativeXmrWallet && !MoneroUtils.isNativeLibraryLoaded()) {
            try {
                MoneroUtils.loadNativeLibrary();
            }
            catch (Exception | UnsatisfiedLinkError e) {
                log.warn("Failed to load Monero native libraries: " + e.getMessage());
            }
        }
        String appliedMsg = "Monero native libraries applied: " + this.isNativeLibraryApplied();
        if (this.useNativeXmrWallet && !this.isNativeLibraryApplied()) {
            log.warn(appliedMsg);
        } else {
            log.info(appliedMsg);
        }
        this.xmrConnectionService.addConnectionListener(connection -> {
            if (this.wasWalletSynced && !this.isSyncingWithProgress) {
                ThreadUtils.execute(() -> this.onConnectionChanged(connection), THREAD_ID);
            } else {
                if (this.wallet == null || this.isShutDownStarted) {
                    return;
                }
                if (HavenoUtils.connectionConfigsEqual(connection, this.wallet.getDaemonConnection())) {
                    this.updatePollPeriod();
                    return;
                }
                log.warn("Force restarting main wallet because connection changed while syncing");
                this.forceRestartMainWallet();
            }
        });
        this.walletInitListener = (obs, oldVal, newVal) -> this.initMainWalletIfConnected();
        this.xmrConnectionService.downloadPercentageProperty().addListener(this.walletInitListener);
        this.initMainWalletIfConnected();
    }

    private void initMainWalletIfConnected() {
        if (this.wallet == null && this.xmrConnectionService.downloadPercentageProperty().get() == 1.0 && !this.isShutDownStarted) {
            this.maybeInitMainWallet(true);
        }
    }

    private void maybeInitMainWallet(boolean sync) {
        this.maybeInitMainWallet(sync, 3);
    }

    private void maybeInitMainWallet(boolean sync, int numSyncAttempts) {
        ThreadUtils.execute(() -> {
            try {
                this.doMaybeInitMainWallet(sync, 3);
            }
            catch (Exception e) {
                if (this.isShutDownStarted) {
                    return;
                }
                log.warn("Error initializing main wallet: {}\n", (Object)e.getMessage(), (Object)e);
                HavenoUtils.setTopError(e.getMessage());
                throw e;
            }
        }, THREAD_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaybeInitMainWallet(boolean sync, int numSyncAttempts) {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isShutDownStarted) {
                return;
            }
            if (this.wallet == null) {
                MoneroDaemonRpc daemon = this.xmrConnectionService.getDaemon();
                log.info("Initializing main wallet with monerod=" + (daemon == null ? "null" : daemon.getRpcConnection().getUri()));
                if (this.walletExists(MONERO_WALLET_NAME)) {
                    this.wallet = this.openWallet(MONERO_WALLET_NAME, this.rpcBindPort, this.isProxyApplied(this.wasWalletSynced));
                } else if (Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
                    this.wallet = this.createWallet(MONERO_WALLET_NAME, this.rpcBindPort);
                    LocalDateTime localDateTime = LocalDate.now().atStartOfDay().minusDays(1L);
                    long date = localDateTime.toEpochSecond(ZoneOffset.UTC);
                    this.user.setWalletCreationDate(date);
                }
                this.walletHeight.set(this.wallet.getHeight());
                this.isClosingWallet = false;
            }
            if (this.wallet != null && !this.isShutDownStarted) {
                log.info("Monero wallet path={}", (Object)this.wallet.getPath());
                if (sync && numSyncAttempts > 0) {
                    try {
                        if (!this.wallet.isConnectedToDaemon()) {
                            log.warn("Switching connection before syncing with progress because disconnected");
                            if (this.requestSwitchToNextBestConnection()) {
                                return;
                            }
                        }
                        log.info("Syncing main wallet");
                        long time = System.currentTimeMillis();
                        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                        try {
                            this.syncWithProgress(true);
                        }
                        catch (Exception e) {
                            if (this.wallet != null) {
                                log.warn("Error syncing wallet with progress on startup: " + e.getMessage());
                            }
                            this.forceCloseMainWallet();
                            this.requestSwitchToNextBestConnection(sourceConnection);
                            this.maybeInitMainWallet(true, numSyncAttempts - 1);
                            return;
                        }
                        log.info("Done syncing main wallet in " + (System.currentTimeMillis() - time) + " ms");
                        this.doPollWallet(true);
                        if (this.walletInitListener != null) {
                            this.xmrConnectionService.downloadPercentageProperty().removeListener(this.walletInitListener);
                        }
                        if (XmrWalletService.getMoneroNetworkType() != MoneroNetworkType.MAINNET) {
                            BigInteger balance = this.getBalance();
                            BigInteger unlockedBalance = this.getAvailableBalance();
                            log.info("Monero wallet unlocked balance={}, pending balance={}, total balance={}", unlockedBalance, balance.subtract(unlockedBalance), balance);
                        }
                        this.onConnectionChanged(this.xmrConnectionService.getConnection());
                        this.resetIfWalletChanged();
                        this.doneDownload();
                        HavenoUtils.havenoSetup.getWalletInitialized().set(true);
                        this.saveWallet(false);
                    }
                    catch (Exception e) {
                        if (this.isClosingWallet || this.isShutDownStarted || HavenoUtils.havenoSetup.getWalletInitialized().get()) {
                            return;
                        }
                        log.warn("Error initially syncing main wallet: {}", (Object)e.getMessage());
                        if (numSyncAttempts <= 1) {
                            log.warn("Failed to sync main wallet. Opening app without syncing", (Object)numSyncAttempts);
                            HavenoUtils.havenoSetup.getWalletInitialized().set(true);
                            this.saveWallet(false);
                            UserThread.runAfter(() -> this.maybeInitMainWallet(true, 3), this.xmrConnectionService.getRefreshPeriodMs() / 1000L);
                        }
                        log.warn("Trying again in {} seconds", (Object)(this.xmrConnectionService.getRefreshPeriodMs() / 1000L));
                        UserThread.runAfter(() -> this.maybeInitMainWallet(true, numSyncAttempts - 1), this.xmrConnectionService.getRefreshPeriodMs() / 1000L);
                    }
                }
                this.startPolling();
            }
        }
    }

    private void resetIfWalletChanged() {
        this.getAddressEntryListAsImmutableList();
        List<XmrAddressEntry> baseAddresses = this.getAddressEntries(XmrAddressEntry.Context.BASE_ADDRESS);
        if (baseAddresses.size() > 1 || baseAddresses.size() == 1 && !baseAddresses.get(0).getAddressString().equals(this.wallet.getPrimaryAddress())) {
            Object warningMsg = "New Monero wallet detected. Resetting internal state.";
            if (!this.tradeManager.getOpenTrades().isEmpty()) {
                warningMsg = (String)warningMsg + "\n\nWARNING: Your open trades will settle to the payout address in the OLD wallet!";
            }
            HavenoUtils.setTopError((String)warningMsg);
            this.xmrAddressEntryList.clear();
            this.getAddressEntryListAsImmutableList();
            this.tradeManager.getOpenOfferManager().removeAllOpenOffers(null);
        }
    }

    private MoneroWalletFull createWalletFull(MoneroWalletConfig config) {
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            throw new RuntimeException("Must be connected to daemon before creating wallet");
        }
        MoneroWalletFull walletFull = null;
        try {
            MoneroRpcConnection connection = this.xmrConnectionService.getConnection();
            log.info("Creating full wallet " + config.getPath() + " connected to monerod=" + connection.getUri());
            long time = System.currentTimeMillis();
            config.setServer(connection);
            walletFull = MoneroWalletFull.createWallet(config);
            walletFull.getDaemonConnection().setPrintStackTrace(false);
            log.info("Done creating full wallet " + config.getPath() + " in " + (System.currentTimeMillis() - time) + " ms");
            return walletFull;
        }
        catch (Exception e) {
            String errorMsg = "Could not create wallet '" + config.getPath() + "': " + e.getMessage();
            log.warn(errorMsg + "\n", e);
            if (walletFull != null) {
                this.forceCloseWallet(walletFull, config.getPath());
            }
            throw new IllegalStateException(errorMsg);
        }
    }

    private MoneroWalletFull openWalletFull(MoneroWalletConfig config, boolean applyProxyUri) {
        MoneroWalletFull walletFull = null;
        try {
            MoneroRpcConnection connection = new MoneroRpcConnection(this.xmrConnectionService.getConnection());
            if (!applyProxyUri) {
                connection.setProxyUri(null);
            }
            config.setNetworkType(XmrWalletService.getMoneroNetworkType());
            config.setServer(connection);
            log.info("Opening full wallet '{}' with monerod={}, proxyUri={}", config.getPath(), connection.getUri(), connection.getProxyUri());
            try {
                walletFull = MoneroWalletFull.openWallet(config);
            }
            catch (Exception e) {
                if (this.isShutDownStarted) {
                    throw e;
                }
                log.warn("Failed to open full wallet '{}', attempting to use backup cache files, error={}", (Object)config.getPath(), (Object)e.getMessage());
                boolean retrySuccessful = false;
                try {
                    String cachePath = this.walletDir.toString() + File.separator + XmrWalletService.getWalletName(config.getPath());
                    File originalCacheFile = new File(cachePath);
                    if (originalCacheFile.exists()) {
                        originalCacheFile.renameTo(new File(cachePath + ".backup"));
                    }
                    List<File> backupCacheFiles = FileUtil.getBackupFiles(this.walletDir, XmrWalletService.getWalletName(config.getPath()));
                    Collections.reverse(backupCacheFiles);
                    for (File backupCacheFile : backupCacheFiles) {
                        try {
                            FileUtil.copyFile(backupCacheFile, new File(cachePath));
                            walletFull = MoneroWalletFull.openWallet(config);
                            log.warn("Successfully opened full wallet using backup cache");
                            retrySuccessful = true;
                            break;
                        }
                        catch (Exception e2) {
                            File unportableCacheFile;
                            File cacheFile = new File(cachePath);
                            if (cacheFile.exists()) {
                                cacheFile.delete();
                            }
                            if (!(unportableCacheFile = new File(cachePath + ".unportable")).exists()) continue;
                            unportableCacheFile.delete();
                        }
                    }
                    File originalCacheBackup = new File(cachePath + ".backup");
                    if (retrySuccessful) {
                        if (originalCacheBackup.exists()) {
                            originalCacheBackup.delete();
                        }
                    }
                    try {
                        log.warn("Failed to open full wallet '{}' using backup cache files, retrying with cache deleted", (Object)config.getPath());
                        walletFull = MoneroWalletFull.openWallet(config);
                        log.warn("Successfully opened full wallet after cache deleted");
                        retrySuccessful = true;
                    }
                    catch (Exception backupCacheFile) {
                        // empty catch block
                    }
                    if (retrySuccessful) {
                        if (originalCacheBackup.exists()) {
                            originalCacheBackup.delete();
                        }
                    }
                    log.warn("Failed to open full wallet '{}' after deleting cache, restoring original cache", (Object)config.getPath());
                    File cacheFile = new File(cachePath);
                    if (cacheFile.exists()) {
                        cacheFile.delete();
                    }
                    if (originalCacheBackup.exists()) {
                        originalCacheBackup.renameTo(new File(cachePath));
                    }
                    throw e;
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            if (walletFull.getDaemonConnection() != null) {
                walletFull.getDaemonConnection().setPrintStackTrace(false);
            }
            log.info("Done opening full wallet " + config.getPath());
            return walletFull;
        }
        catch (Exception e) {
            String errorMsg = "Could not open full wallet '" + config.getPath() + "': " + e.getMessage();
            log.warn(errorMsg + "\n", e);
            if (walletFull != null) {
                this.forceCloseWallet(walletFull, config.getPath());
            }
            throw new IllegalStateException(errorMsg);
        }
    }

    private MoneroWalletRpc createWalletRpc(MoneroWalletConfig config, Integer port) {
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            throw new RuntimeException("Must be connected to daemon before creating wallet");
        }
        MoneroWalletRpc walletRpc = null;
        try {
            walletRpc = this.startWalletRpcInstance(port, this.isProxyApplied(false));
            walletRpc.getRpcConnection().setPrintStackTrace(false);
            walletRpc.stopSyncing();
            if (this.isShutDownStarted) {
                throw new IllegalStateException("Cannot create wallet '" + config.getPath() + "' because shutdown is started");
            }
            MoneroRpcConnection connection = this.xmrConnectionService.getConnection();
            log.info("Creating RPC wallet " + config.getPath() + " connected to monerod=" + connection.getUri());
            long time = System.currentTimeMillis();
            config.setServer(connection);
            walletRpc.createWallet(config);
            walletRpc.getDaemonConnection().setPrintStackTrace(false);
            log.info("Done creating RPC wallet " + config.getPath() + " in " + (System.currentTimeMillis() - time) + " ms");
            return walletRpc;
        }
        catch (Exception e) {
            if (walletRpc != null) {
                this.forceCloseWallet(walletRpc, config.getPath());
            }
            throw new IllegalStateException("Could not create wallet '" + config.getPath() + "'. Please close Haveno, stop all monero-wallet-rpc processes in your task manager, and restart Haveno.\n\nError message: " + e.getMessage());
        }
    }

    private MoneroWalletRpc openWalletRpc(MoneroWalletConfig config, Integer port, boolean applyProxyUri) {
        MoneroWalletRpc walletRpc = null;
        try {
            walletRpc = this.startWalletRpcInstance(port, applyProxyUri);
            walletRpc.getRpcConnection().setPrintStackTrace(false);
            walletRpc.stopSyncing();
            MoneroRpcConnection connection = new MoneroRpcConnection(this.xmrConnectionService.getConnection());
            if (!applyProxyUri) {
                connection.setProxyUri(null);
            }
            if (this.isShutDownStarted) {
                throw new IllegalStateException("Cannot open wallet '" + config.getPath() + "' because shutdown is started");
            }
            log.info("Opening RPC wallet '{}' with monerod={}, proxyUri={}", config.getPath(), connection.getUri(), connection.getProxyUri());
            config.setServer(connection);
            try {
                walletRpc.openWallet(config);
            }
            catch (Exception e) {
                if (this.isShutDownStarted) {
                    throw e;
                }
                log.warn("Failed to open RPC wallet '{}', attempting to use backup cache files, error={}", (Object)config.getPath(), (Object)e.getMessage());
                boolean retrySuccessful = false;
                try {
                    String cachePath = this.walletDir.toString() + File.separator + config.getPath();
                    File originalCacheFile = new File(cachePath);
                    if (originalCacheFile.exists()) {
                        originalCacheFile.renameTo(new File(cachePath + ".backup"));
                    }
                    List<File> backupCacheFiles = FileUtil.getBackupFiles(this.walletDir, config.getPath());
                    Collections.reverse(backupCacheFiles);
                    for (File backupCacheFile : backupCacheFiles) {
                        try {
                            FileUtil.copyFile(backupCacheFile, new File(cachePath));
                            walletRpc.openWallet(config);
                            log.warn("Successfully opened RPC wallet using backup cache");
                            retrySuccessful = true;
                            break;
                        }
                        catch (Exception e2) {
                            File unportableCacheFile;
                            File cacheFile = new File(cachePath);
                            if (cacheFile.exists()) {
                                cacheFile.delete();
                            }
                            if (!(unportableCacheFile = new File(cachePath + ".unportable")).exists()) continue;
                            unportableCacheFile.delete();
                        }
                    }
                    File originalCacheBackup = new File(cachePath + ".backup");
                    if (retrySuccessful) {
                        if (originalCacheBackup.exists()) {
                            originalCacheBackup.delete();
                        }
                    }
                    try {
                        log.warn("Failed to open RPC wallet '{}' using backup cache files, retrying with cache deleted", (Object)config.getPath());
                        walletRpc.openWallet(config);
                        log.warn("Successfully opened RPC wallet after cache deleted");
                        retrySuccessful = true;
                    }
                    catch (Exception backupCacheFile) {
                        // empty catch block
                    }
                    if (retrySuccessful) {
                        if (originalCacheBackup.exists()) {
                            originalCacheBackup.delete();
                        }
                    }
                    log.warn("Failed to open RPC wallet '{}' after deleting cache, restoring original cache", (Object)config.getPath());
                    File cacheFile = new File(cachePath);
                    if (cacheFile.exists()) {
                        cacheFile.delete();
                    }
                    if (originalCacheBackup.exists()) {
                        originalCacheBackup.renameTo(new File(cachePath));
                    }
                    throw e;
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            if (walletRpc.getDaemonConnection() != null) {
                walletRpc.getDaemonConnection().setPrintStackTrace(false);
            }
            log.info("Done opening RPC wallet " + config.getPath());
            return walletRpc;
        }
        catch (Exception e) {
            if (walletRpc != null) {
                this.forceCloseWallet(walletRpc, config.getPath());
            }
            throw new IllegalStateException("Could not open wallet '" + config.getPath() + "'. Please close Haveno, stop all monero-wallet-rpc processes in your task manager, and restart Haveno.\n\nError message: " + e.getMessage());
        }
    }

    private MoneroWalletRpc startWalletRpcInstance(Integer port, boolean applyProxyUri) {
        MoneroRpcConnection connection;
        if (!new File(MONERO_WALLET_RPC_PATH).exists()) {
            throw new RuntimeException("monero-wallet-rpc executable doesn't exist at path " + MONERO_WALLET_RPC_PATH + "; copy monero-wallet-rpc to the project root or set WalletConfig.java MONERO_WALLET_RPC_PATH for your system");
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(MONERO_WALLET_RPC_PATH, "--rpc-login", "haveno_user:password", "--wallet-dir", this.walletDir.toString()));
        if (MONERO_NETWORK_TYPE != MoneroNetworkType.MAINNET) {
            cmd.add("--" + MONERO_NETWORK_TYPE.toString().toLowerCase());
        }
        if ((connection = this.xmrConnectionService.getConnection()) != null) {
            cmd.add("--daemon-address");
            cmd.add(connection.getUri());
            if (applyProxyUri && connection.getProxyUri() != null) {
                cmd.add("--proxy");
                cmd.add(connection.getProxyUri());
                if (!connection.isOnion()) {
                    cmd.add("--daemon-ssl-allow-any-cert");
                }
            }
            if (connection.getUsername() != null) {
                cmd.add("--daemon-login");
                cmd.add(connection.getUsername() + ":" + connection.getPassword());
            }
        }
        if (port != null && port > 0) {
            cmd.add("--rpc-bind-port");
            cmd.add(Integer.toString(port));
        }
        return MONERO_WALLET_RPC_MANAGER.startInstance(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onConnectionChanged(MoneroRpcConnection connection) {
        Object object = this.walletLock;
        synchronized (object) {
            connection = this.xmrConnectionService.getConnection();
            if (this.wallet == null) return;
            if (this.isShutDownStarted) {
                return;
            }
            if (HavenoUtils.connectionConfigsEqual(connection, this.wallet.getDaemonConnection())) {
                this.updatePollPeriod();
                return;
            }
            String oldProxyUri = this.wallet == null || this.wallet.getDaemonConnection() == null ? null : this.wallet.getDaemonConnection().getProxyUri();
            String newProxyUri = connection == null ? null : connection.getProxyUri();
            log.info("Setting daemon connection for main wallet, monerod={}, proxyUri={}", (Object)(connection == null ? null : connection.getUri()), (Object)newProxyUri);
            if (this.wallet instanceof MoneroWalletRpc) {
                if (!StringUtils.equals(oldProxyUri, newProxyUri)) {
                    log.info("Restarting main wallet because proxy URI has changed, old={}, new={}", (Object)oldProxyUri, (Object)newProxyUri);
                    this.closeMainWallet(true);
                    this.doMaybeInitMainWallet(false, 3);
                    return;
                }
                this.wallet.setDaemonConnection(connection);
            } else {
                this.wallet.setDaemonConnection(connection);
                this.wallet.setProxyUri(connection.getProxyUri());
            }
            if (Boolean.TRUE.equals(connection.isConnected() != false && !this.wallet.isConnectedToDaemon())) {
                log.warn("Switching to next best connection because main wallet is disconnected");
                if (this.requestSwitchToNextBestConnection()) {
                    return;
                }
            }
            if (connection != null && !this.isShutDownStarted) {
                this.wallet.getDaemonConnection().setPrintStackTrace(false);
                this.updatePollPeriod();
            }
            log.info("Done setting daemon connection for main wallet, monerod=" + (this.wallet.getDaemonConnection() == null ? null : this.wallet.getDaemonConnection().getUri()));
            return;
        }
    }

    private void changeWalletPasswords(String oldPassword, String newPassword) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(() -> {
            try {
                this.wallet.changePassword(oldPassword, newPassword);
                this.saveWallet();
            }
            catch (Exception e) {
                log.warn("Error changing main wallet password: " + e.getMessage() + "\n", e);
                throw e;
            }
        });
        List<Trade> trades = this.tradeManager.getAllTrades();
        for (Trade trade : trades) {
            tasks.add(() -> {
                if (trade.walletExists()) {
                    trade.changeWalletPassword(oldPassword, newPassword);
                }
            });
        }
        ThreadUtils.awaitTasks(tasks, Math.min(10, 1 + trades.size()));
        log.info("Done changing all wallet passwords");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMainWallet(boolean save) {
        this.stopPolling();
        Object object = this.walletLock;
        synchronized (object) {
            try {
                if (this.wallet != null) {
                    this.isClosingWallet = true;
                    this.closeWallet(this.wallet, true);
                    this.wallet = null;
                }
            }
            catch (Exception e) {
                log.warn("Error closing main wallet: {}. Was Haveno stopped manually with ctrl+c?", (Object)e.getMessage());
            }
        }
    }

    private void forceCloseMainWallet() {
        this.stopPolling();
        if (this.wallet != null && !this.isClosingWallet) {
            this.isClosingWallet = true;
            this.forceCloseWallet(this.wallet, this.getWalletPath(MONERO_WALLET_NAME));
            this.wallet = null;
        }
    }

    public void forceRestartMainWallet() {
        log.warn("Force restarting main wallet");
        if (this.isClosingWallet) {
            return;
        }
        this.forceCloseMainWallet();
        this.doMaybeInitMainWallet(true, 3);
    }

    public void handleWalletError(Exception e, MoneroRpcConnection sourceConnection) {
        if (HavenoUtils.isUnresponsive(e)) {
            this.forceCloseMainWallet();
        }
        this.requestSwitchToNextBestConnection(sourceConnection);
        if (this.wallet == null) {
            this.doMaybeInitMainWallet(true, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPolling() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isShutDownStarted || this.isPolling()) {
                return;
            }
            this.updatePollPeriod();
            this.pollLooper = new TaskLooper(() -> this.pollWallet());
            this.pollLooper.start(this.pollPeriodMs);
        }
    }

    private void stopPolling() {
        if (this.isPolling()) {
            this.pollLooper.stop();
            this.pollLooper = null;
        }
    }

    private boolean isPolling() {
        return this.pollLooper != null;
    }

    public void updatePollPeriod() {
        if (this.isShutDownStarted) {
            return;
        }
        this.setPollPeriodMs(this.getPollPeriodMs());
    }

    private long getPollPeriodMs() {
        return this.xmrConnectionService.getRefreshPeriodMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollPeriodMs(long pollPeriodMs) {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isShutDownStarted) {
                return;
            }
            if (this.pollPeriodMs != null && this.pollPeriodMs == pollPeriodMs) {
                return;
            }
            this.pollPeriodMs = pollPeriodMs;
            if (this.isPolling()) {
                this.stopPolling();
                this.startPolling();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWallet() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.pollInProgress) {
                return;
            }
        }
        this.doPollWallet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollWallet(boolean updateTxs) {
        block84: {
            if (this.isShutDownStarted) {
                return;
            }
            boolean pollInProgressSet = false;
            Object object = this.pollLock;
            synchronized (object) {
                if (!this.pollInProgress) {
                    pollInProgressSet = true;
                }
                this.pollInProgress = true;
            }
            try {
                Object object2;
                MoneroDaemonInfo lastInfo = this.xmrConnectionService.getLastInfo();
                if (lastInfo == null) {
                    log.warn("Last daemon info is null");
                    return;
                }
                if (!this.xmrConnectionService.isSyncedWithinTolerance()) {
                    if (System.currentTimeMillis() - this.lastLogDaemonNotSyncedTimestamp > 30000L) {
                        log.warn("Monero daemon is not synced within tolerance, height={}, targetHeight={}, monerod={}", this.xmrConnectionService.chainHeightProperty().get(), this.xmrConnectionService.getTargetHeight(), this.xmrConnectionService.getConnection() == null ? null : this.xmrConnectionService.getConnection().getUri());
                        this.lastLogDaemonNotSyncedTimestamp = System.currentTimeMillis();
                    }
                    return;
                }
                if (this.walletHeight.get() < this.xmrConnectionService.getTargetHeight()) {
                    object2 = this.walletLock;
                    synchronized (object2) {
                        if (this.xmrConnectionService.getTargetHeight() - this.walletHeight.get() < 100L) {
                            this.syncMainWallet();
                        } else {
                            this.syncWithProgress();
                        }
                    }
                }
                if (!updateTxs) break block84;
                object2 = this.walletLock;
                synchronized (object2) {
                    Object e = HavenoUtils.getDaemonLock();
                    synchronized (e) {
                        block85: {
                            MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                            try {
                                this.cachedTxs = this.wallet.getTxs(new MoneroTxQuery().setIncludeOutputs(true));
                                this.lastPollTxsTimestamp = System.currentTimeMillis();
                            }
                            catch (Exception e2) {
                                if (this.isShutDownStarted || System.currentTimeMillis() - this.lastLogPollErrorTimestamp <= 240000L) break block85;
                                log.warn("Error polling main wallet's transactions from the pool: {}", (Object)e2.getMessage());
                                this.lastLogPollErrorTimestamp = System.currentTimeMillis();
                                if (System.currentTimeMillis() - this.lastPollTxsTimestamp <= 180000L) break block85;
                                this.requestSwitchToNextBestConnection(sourceConnection);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.wallet == null || this.isShutDownStarted) {
                    return;
                }
                if (HavenoUtils.isUnresponsive(e)) {
                    this.forceRestartMainWallet();
                } else if (this.isWalletConnectedToDaemon()) {
                    log.warn("Error polling main wallet, errorMessage={}. Monerod={}", (Object)e.getMessage(), (Object)this.getXmrConnectionService().getConnection());
                }
            }
            finally {
                Object e;
                if (pollInProgressSet) {
                    e = this.pollLock;
                    synchronized (e) {
                        this.pollInProgress = false;
                    }
                }
                e = this.walletLock;
                synchronized (e) {
                    if (this.wallet != null && !this.isShutDownStarted) {
                        try {
                            this.cacheWalletInfo();
                            this.saveWalletWithDelay();
                        }
                        catch (Exception e3) {
                            log.warn("Error caching wallet info: " + e3.getMessage() + "\n", e3);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoneroSyncResult syncMainWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            MoneroSyncResult result = this.syncWallet(this.wallet);
            this.walletHeight.set(this.wallet.getHeight());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWalletConnectedToDaemon() {
        Object object = this.walletLock;
        synchronized (object) {
            try {
                if (this.wallet == null) {
                    return false;
                }
                return this.wallet.isConnectedToDaemon();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private boolean requestSwitchToNextBestConnection() {
        return this.requestSwitchToNextBestConnection(null);
    }

    private void onNewBlock(long height) {
        UserThread.execute(() -> {
            this.walletHeight.set(height);
            for (MoneroWalletListenerI listener : this.walletListeners) {
                ThreadUtils.submitToPool(() -> listener.onNewBlock(height));
            }
        });
    }

    private void cacheWalletInfo() {
        long height = this.wallet.getHeight();
        BigInteger balance = this.wallet.getBalance();
        BigInteger unlockedBalance = this.wallet.getUnlockedBalance();
        this.cachedSubaddresses = this.wallet.getSubaddresses(0);
        this.cachedOutputs = this.wallet.getOutputs();
        if (this.cachedHeight == null) {
            this.cachedHeight = height;
            this.cachedBalance = balance;
            this.cachedAvailableBalance = unlockedBalance;
            this.onNewBlock(height);
            this.onBalancesChanged(balance, unlockedBalance);
        } else {
            boolean heightChanged = height != this.cachedHeight;
            boolean balancesChanged = !balance.equals(this.cachedBalance) || !unlockedBalance.equals(this.cachedAvailableBalance);
            this.cachedHeight = height;
            this.cachedBalance = balance;
            this.cachedAvailableBalance = unlockedBalance;
            if (heightChanged) {
                this.onNewBlock(height);
            }
            if (balancesChanged) {
                this.onBalancesChanged(balance, unlockedBalance);
            }
        }
    }

    private void onBalancesChanged(BigInteger newBalance, BigInteger newUnlockedBalance) {
        this.updateBalanceListeners();
        for (MoneroWalletListenerI listener : this.walletListeners) {
            ThreadUtils.submitToPool(() -> listener.onBalancesChanged(newBalance, newUnlockedBalance));
        }
    }
}

