/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.protobuf.ByteString;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.core.api.CoreApi;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.AccountExistsReply;
import haveno.proto.grpc.AccountExistsRequest;
import haveno.proto.grpc.AccountGrpc;
import haveno.proto.grpc.BackupAccountReply;
import haveno.proto.grpc.BackupAccountRequest;
import haveno.proto.grpc.ChangePasswordReply;
import haveno.proto.grpc.ChangePasswordRequest;
import haveno.proto.grpc.CloseAccountReply;
import haveno.proto.grpc.CloseAccountRequest;
import haveno.proto.grpc.CreateAccountReply;
import haveno.proto.grpc.CreateAccountRequest;
import haveno.proto.grpc.DeleteAccountReply;
import haveno.proto.grpc.DeleteAccountRequest;
import haveno.proto.grpc.IsAccountOpenReply;
import haveno.proto.grpc.IsAccountOpenRequest;
import haveno.proto.grpc.IsAppInitializedReply;
import haveno.proto.grpc.IsAppInitializedRequest;
import haveno.proto.grpc.OpenAccountReply;
import haveno.proto.grpc.OpenAccountRequest;
import haveno.proto.grpc.RestoreAccountReply;
import haveno.proto.grpc.RestoreAccountRequest;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class GrpcAccountService
extends AccountGrpc.AccountImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcAccountService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;
    private ByteArrayOutputStream restoreStream;

    @Inject
    public GrpcAccountService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void accountExists(AccountExistsRequest req, StreamObserver<AccountExistsReply> responseObserver) {
        try {
            AccountExistsReply reply = AccountExistsReply.newBuilder().setAccountExists(this.coreApi.accountExists()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void isAccountOpen(IsAccountOpenRequest req, StreamObserver<IsAccountOpenReply> responseObserver) {
        try {
            IsAccountOpenReply reply = IsAccountOpenReply.newBuilder().setIsAccountOpen(this.coreApi.isAccountOpen()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void createAccount(CreateAccountRequest req, StreamObserver<CreateAccountReply> responseObserver) {
        try {
            this.coreApi.createAccount(req.getPassword());
            CreateAccountReply reply = CreateAccountReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void openAccount(OpenAccountRequest req, StreamObserver<OpenAccountReply> responseObserver) {
        try {
            this.coreApi.openAccount(req.getPassword());
            OpenAccountReply reply = OpenAccountReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause2) {
            IllegalStateException cause2;
            if (cause2 instanceof IncorrectPasswordException) {
                cause2 = new IllegalStateException(cause2);
            }
            this.exceptionHandler.handleException(log, cause2, responseObserver);
        }
    }

    @Override
    public void isAppInitialized(IsAppInitializedRequest req, StreamObserver<IsAppInitializedReply> responseObserver) {
        try {
            IsAppInitializedReply reply = IsAppInitializedReply.newBuilder().setIsAppInitialized(this.coreApi.isAppInitialized()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void changePassword(ChangePasswordRequest req, StreamObserver<ChangePasswordReply> responseObserver) {
        try {
            this.coreApi.changePassword(req.getOldPassword(), req.getNewPassword());
            ChangePasswordReply reply = ChangePasswordReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void closeAccount(CloseAccountRequest req, StreamObserver<CloseAccountReply> responseObserver) {
        try {
            this.coreApi.closeAccount();
            CloseAccountReply reply = CloseAccountReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void deleteAccount(DeleteAccountRequest req, StreamObserver<DeleteAccountReply> responseObserver) {
        try {
            this.coreApi.deleteAccount(() -> {
                DeleteAccountReply reply = DeleteAccountReply.newBuilder().build();
                responseObserver.onNext(reply);
                responseObserver.onCompleted();
            });
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void backupAccount(BackupAccountRequest req, StreamObserver<BackupAccountReply> responseObserver) {
        try {
            int bufferSize = 0x800000;
            this.coreApi.backupAccount(bufferSize, stream -> {
                try {
                    int length;
                    log.info("Sending bytes in chunks of: " + bufferSize);
                    byte[] buffer = new byte[bufferSize];
                    int total = 0;
                    while ((length = stream.read(buffer, 0, bufferSize)) != -1) {
                        total += length;
                        BackupAccountReply reply = BackupAccountReply.newBuilder().setZipBytes(ByteString.copyFrom(buffer, 0, length)).build();
                        responseObserver.onNext(reply);
                    }
                    log.info("Completed backup account total sent: " + total);
                    stream.close();
                    responseObserver.onCompleted();
                }
                catch (Exception ex) {
                    this.exceptionHandler.handleException(log, ex, responseObserver);
                }
            }, ex -> this.exceptionHandler.handleException(log, (Throwable)ex, responseObserver));
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void restoreAccount(RestoreAccountRequest req, StreamObserver<RestoreAccountReply> responseObserver) {
        try {
            if (this.coreApi.accountExists()) {
                throw new IllegalStateException("Cannot restore account if there is an existing account");
            }
            if (!req.getHasMore() && req.getOffset() == 0L) {
                InputStream inputStream = req.getZipBytes().newInput();
                this.coreApi.restoreAccount(inputStream, 65536, () -> {
                    RestoreAccountReply reply = RestoreAccountReply.newBuilder().build();
                    responseObserver.onNext(reply);
                    responseObserver.onCompleted();
                });
            } else {
                if (req.getOffset() == 0L) {
                    log.info("RestoreAccount starting new chunked zip");
                    this.restoreStream = new ByteArrayOutputStream((int)req.getTotalLength());
                }
                if ((long)this.restoreStream.size() != req.getOffset()) {
                    log.warn("Stream offset doesn't match current position");
                    IllegalStateException cause = new IllegalStateException("Stream offset doesn't match current position");
                    this.exceptionHandler.handleException(log, cause, responseObserver);
                } else {
                    log.info("RestoreAccount writing chunk size " + req.getZipBytes().size());
                    req.getZipBytes().writeTo(this.restoreStream);
                }
                if (!req.getHasMore()) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(this.restoreStream.toByteArray());
                    this.restoreStream.close();
                    this.restoreStream = null;
                    this.coreApi.restoreAccount(inputStream, 65536, () -> {
                        RestoreAccountReply reply = RestoreAccountReply.newBuilder().build();
                        responseObserver.onNext(reply);
                        responseObserver.onCompleted();
                    });
                } else {
                    RestoreAccountReply reply = RestoreAccountReply.newBuilder().build();
                    responseObserver.onNext(reply);
                    responseObserver.onCompleted();
                }
            }
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, this.getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(AccountGrpc.getAccountExistsMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getBackupAccountMethod().getFullMethodName(), new GrpcCallRateMeter(5, TimeUnit.SECONDS));
                this.put(AccountGrpc.getChangePasswordMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getCloseAccountMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getCreateAccountMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getDeleteAccountMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getIsAccountOpenMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getOpenAccountMethod().getFullMethodName(), new GrpcCallRateMeter(10, TimeUnit.SECONDS));
                this.put(AccountGrpc.getRestoreAccountMethod().getFullMethodName(), new GrpcCallRateMeter(5, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$6() {
        return new ServerInterceptor[0];
    }
}

